//--------------------------------------------------------------------------//
// iq . 2007 . kindernoiser 4k intro demo by RGBA                           //
//--------------------------------------------------------------------------//
//#define USEDSOUND

#define ERRORMSG            // activa printado mensajes de error
#define LOADING             // activa pintado "wait while loading..."
#define AUTOCENTER          // activa centrado de la ventana

#define WIN32_LEAN_AND_MEAN
#define WIN32_EXTRA_LEAN
#include <windows.h>
#include <windowsx.h>
#include <mmsystem.h>
#include <GL/gl.h>
//typedef unsigned long * DWORD_PTR;
#ifdef USEDSOUND
//#include <d3d9.h>
#include <dsound.h>
#endif

#include <string.h>
#include <stdio.h>
#include <math.h>
#include "../../intro.h"
#include "../../mzk.h"
#include "../../intro.h"
#include "../../main.h"

//----------------------------------------------------------------------------

typedef struct
{
    //---------------
    HINSTANCE   hInstance;
    HDC         hDC;
    HGLRC       hRC;
    HWND        hWnd;
    //---------------
    int         full;
    //---------------
    char        wndclass[4];	// window class and title :)
    //---------------
}WININFO;

static PIXELFORMATDESCRIPTOR pfd =
{
    sizeof(PIXELFORMATDESCRIPTOR),
    1,
    PFD_DRAW_TO_WINDOW|PFD_SUPPORT_OPENGL|PFD_DOUBLEBUFFER,
    PFD_TYPE_RGBA,
    32,
    0, 0, 0, 0, 0, 0, 8, 0,
    0, 0, 0, 0, 0,  // accum
    32,             // zbuffer
    0,              // stencil!
    0,              // aux
    PFD_MAIN_PLANE,
    0, 0, 0, 0
};

static WININFO wininfo = { 0,0,0,0,0, {'i','q','_',0} };

#ifdef LOADING
static char fnt_wait[6]    = "arial";
static char msg_wait[22]   = "wait while loading...";
#endif
#ifdef ERRORMSG
static char msg_error[207] = "kinderplomber";
static char tlt_error[6]   = "error";
#endif

#ifdef USEDSOUND
const GUID myguid = { 0x6825a449, 0x7524, 0x4d82, 0x92, 0x0f, 0x50, 0xe3, 0x6a, 0xb3, 0xab, 0x1e };
static DSEFFECTDESC ffx = { sizeof(DSEFFECTDESC), 0, {0xefe6629c, 0x81f7, 0x4281, 0xbd, 0x91, 0xc9, 0xd6, 0x04, 0xa9, 0x5a, 0xf6}, 0, 0 };
static WAVEFORMATEX format={WAVE_FORMAT_PCM, 1, MZK_RATE, MZK_RATE*2, 2, 16};       
static DSBUFFERDESC bufferDesc1={sizeof(DSBUFFERDESC), DSBCAPS_PRIMARYBUFFER, 0, 0, 0, 0 };
static DSBUFFERDESC bufferDesc2={sizeof(DSBUFFERDESC), DSBCAPS_GETCURRENTPOSITION2|DSBCAPS_GLOBALFOCUS, MZK_NUMSAMPLES*sizeof(short), NULL, &format, NULL };
#else
short myMuzik[(MZK_DURATION+4)*MZK_RATE*MZK_NUMCHANNELS];
static WAVEFORMATEX wavinfo = {
    WAVE_FORMAT_PCM,					    // format type
    MZK_NUMCHANNELS,					    // number of channels
    MZK_RATE,						        // sample rate 
    MZK_RATE*MZK_NUMCHANNELS*sizeof(short),	// for buffer estimation = rate*"block size of data"
    MZK_NUMCHANNELS*sizeof(short),			// block size of data = 4 bytes = 2*16bit
    sizeof(short)*8,						// number of bits per sample of mono data
    0 };
static WAVEHDR  wav = { (LPSTR)myMuzik, MZK_DURATION*MZK_RATE*MZK_NUMCHANNELS*sizeof(short), 0, 0, 0, 0, 0, 0 };
#endif
//==============================================================================================


int mKeys[256];
static LRESULT CALLBACK WndProc( HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam )
{
	// salvapantallas
	if( uMsg==WM_SYSCOMMAND && (wParam==SC_SCREENSAVE || wParam==SC_MONITORPOWER) )
		return( 0 );

	// boton x o pulsacion de escape
	if( uMsg==WM_CLOSE || uMsg==WM_DESTROY || (uMsg==WM_KEYDOWN && wParam==VK_ESCAPE) )
	{
		PostQuitMessage(0);
        return( 0 );
	}

    if( uMsg==WM_SIZE )
    {
        glViewport( 0, 0, lParam&65535, lParam>>16 );
    }

    if( uMsg==WM_CHAR || uMsg==WM_KEYDOWN)
    {
        if( wParam==VK_ESCAPE )
        {
            PostQuitMessage(0);
            return( 0 );
        }
        mKeys[wParam&255] = 1;
    }

    if( uMsg==WM_KEYUP)
    {
        mKeys[wParam&255] = 0;
    }

    return( DefWindowProc(hWnd,uMsg,wParam,lParam) );
}


static void window_end( WININFO *info )
{
    if( info->hRC )
    {
        wglMakeCurrent( 0, 0 );
        wglDeleteContext( info->hRC );
    }

    if( info->hDC  ) ReleaseDC( info->hWnd, info->hDC );
    if( info->hWnd ) DestroyWindow( info->hWnd );

    UnregisterClass( info->wndclass, info->hInstance );

    if( info->full )
    {
        ChangeDisplaySettings( 0, 0 );
		while( ShowCursor( 1 )<0 ); // show cursor
    }
}

static int window_init( WININFO *info )
{
	unsigned int	PixelFormat;
    DWORD			dwExStyle, dwStyle;
    DEVMODE			dmScreenSettings;
    RECT			rec;

    WNDCLASS		wc;

    ZeroMemory( &wc, sizeof(WNDCLASS) );
    wc.style         = CS_OWNDC|CS_HREDRAW|CS_VREDRAW;
    wc.lpfnWndProc   = WndProc;
    wc.hInstance     = info->hInstance;
    wc.lpszClassName = info->wndclass;
    wc.hbrBackground=(HBRUSH)CreateSolidBrush(0x00785838);
	
    if( !RegisterClass(&wc) )
        return( 0 );

    if( info->full )
    {
        dmScreenSettings.dmSize       = sizeof(DEVMODE);
        dmScreenSettings.dmFields     = DM_BITSPERPEL|DM_PELSWIDTH|DM_PELSHEIGHT;
        dmScreenSettings.dmBitsPerPel = 32;
        dmScreenSettings.dmPelsWidth  = XRES;
        dmScreenSettings.dmPelsHeight = YRES;

        if( ChangeDisplaySettings(&dmScreenSettings,CDS_FULLSCREEN)!=DISP_CHANGE_SUCCESSFUL)
            return( 0 );

        dwExStyle = WS_EX_APPWINDOW;
        dwStyle   = WS_VISIBLE | WS_POPUP;// | WS_CLIPSIBLINGS | WS_CLIPCHILDREN;

		while( ShowCursor( 0 )>=0 );	// hide cursor
    }
    else
    {
        dwExStyle = WS_EX_APPWINDOW | WS_EX_WINDOWEDGE;
        dwStyle   = WS_VISIBLE | WS_CAPTION | WS_CLIPSIBLINGS | WS_CLIPCHILDREN | WS_SYSMENU | WS_MAXIMIZEBOX;
    }

    rec.left   = 0;
    rec.top    = 0;
    rec.right  = XRES;
    rec.bottom = YRES;

    AdjustWindowRect( &rec, dwStyle, 0 );

    #ifdef AUTOCENTER
        info->hWnd = CreateWindowEx( dwExStyle, wc.lpszClassName, wc.lpszClassName, dwStyle,
                                   (GetSystemMetrics(SM_CXSCREEN)-rec.right+rec.left)>>1,
                                   (GetSystemMetrics(SM_CYSCREEN)-rec.bottom+rec.top)>>1,
                                   rec.right-rec.left, rec.bottom-rec.top, 0, 0, info->hInstance, 0 );
    #else
        info->hWnd = CreateWindowEx( dwExStyle, wc.lpszClassName, wc.lpszClassName, dwStyle,
                                   0, 0, rec.right-rec.left, rec.bottom-rec.top,
                                   0, 0, info->hInstance, 0 );
    #endif

    if( !info->hWnd )
        return( 0 );

    if( !(info->hDC=GetDC(info->hWnd)) )
        return( 0 );

    if( !(PixelFormat=ChoosePixelFormat(info->hDC,&pfd)) )
        return( 0 );

    if( !SetPixelFormat(info->hDC,PixelFormat,&pfd) )
        return( 0 );

    if( !(info->hRC=wglCreateContext(info->hDC)) )
        return( 0 );

    if( !wglMakeCurrent(info->hDC,info->hRC) )
        return( 0 );
    
    //SetForegroundWindow( info->hWnd );    // slightly higher priority
    //SetFocus( info->hWnd );               // sets keyboard focus to the window
    
    return( 1 );
}

//==============================================================================================

static void DrawTime( WININFO *info, float t )
{
    static int      frame=0;
    static float    to=0.0f;
    static float    fps=0.0f;

    if( t<0.0f) return;
    if( info->full ) return;

    frame++;
    const float dt = t-to;
    if( dt>1.0f )
    {
        fps = (float)frame/dt;
        to = t;
        frame = 0;
    }

    if( !(frame&3) )
    {
        const int m = (int)floorf( t/60.0f );
        const int s = (int)floorf( t-60.0f*(float)m );
        char str[64];
        sprintf( str, "%.1f fps, %02d:%02d", fps, m, s );
        SetWindowText( info->hWnd, str );
    }
}

//==============================================================================================

float rout[4096];
float iout[4096];

#include "../../fft.h"

int WINAPI WinMain( HINSTANCE instance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow )
{
    MSG         msg;
    int         done=0;
    WININFO     *info = &wininfo;

    info->hInstance = GetModuleHandle( 0 );
    //if( MessageBox( 0, "fullscreen?", info->wndclass, MB_YESNO|MB_ICONQUESTION)==IDYES ) info->full++;

    if( !window_init(info) )
    {
        window_end( info );
        #ifdef ERRORMSG
        MessageBox( 0, "window_init()!",tlt_error,MB_OK|MB_ICONEXCLAMATION );
        #endif
        return 0;
    }

    // draw background
    SelectObject( wininfo.hDC, CreateSolidBrush(0x0045302c) );
    Rectangle( wininfo.hDC, 0, 0, XRES, YRES );
    // draw text
    SetBkMode( wininfo.hDC, TRANSPARENT );
    SetTextColor( wininfo.hDC, 0x00ffffff );
    SelectObject( wininfo.hDC, CreateFont( 44,0,0,0,0,0,0,0,0,0,0,ANTIALIASED_QUALITY,0,"tahoma") );
    TextOut( info->hDC, (XRES-318)>>1, (YRES-38)>>1, "rgba :: kinderplomber", 21 );

    if( !intro_init() )
		return 0;

    #ifdef USEDSOUND
    short *myMuzik;
    unsigned long        length;
    IDirectSound        *m_pDS;
    IDirectSoundBuffer  *m_pSecondary;
    IDirectSoundBuffer  *m_pPrimary;
    DirectSoundCreate(0, &m_pDS, 0);
    m_pDS->SetCooperativeLevel(wininfo.hWnd,DSSCL_PRIORITY);
    m_pDS->CreateSoundBuffer(&bufferDesc1,&m_pPrimary, NULL);
    HRESULT hr = m_pDS->CreateSoundBuffer(&bufferDesc2,&m_pSecondary,NULL);
    m_pSecondary->Lock(0,MZK_NUMSAMPLES*sizeof(short),(void**)&myMuzik,&length,NULL,NULL,NULL);
    #endif

    mzk_init( myMuzik );

    #ifdef USEDSOUND
    m_pSecondary->Unlock(myMuzik,length,NULL,NULL);
    m_pSecondary->Play(0,0,0);
    #else
    HWAVEOUT    h;
    if( waveOutOpen( &h, WAVE_MAPPER, &wavinfo, 0, 0, 0) ) return( 0 );
    waveOutPrepareHeader( h, &wav, sizeof(WAVEHDR) );
    waveOutWrite( h, &wav, sizeof(WAVEHDR) );
    #endif

    int eframe = 0;
    long to = timeGetTime();
    while( !done )
    {
        #ifdef USEDSOUND
        unsigned long pos;
        m_pSecondary->GetCurrentPosition(&pos,NULL);
        unsigned long t = MZK_START*1000 + 10*pos/882;
        #else
		MMTIME  mmt;
		mmt.wType = TIME_MS;
		waveOutGetPosition( h, &mmt, sizeof(MMTIME) );
        const unsigned long pos = mmt.u.cb/(sizeof(short)*MZK_NUMCHANNELS);
        const float t = float(pos)/float(MZK_RATE);
        #endif

        iqsft12( rout, myMuzik+MZK_NUMCHANNELS*pos+2048 );
   
        while( PeekMessage(&msg,0,0,0,PM_REMOVE) )
        {
            if( msg.message==WM_QUIT ) done=1;
		    TranslateMessage( &msg );
            DispatchMessage( &msg );
        }

        intro_do( rout, t, eframe++ );

        if( t>float(MZK_DURATION) ) done = 1;

        SwapBuffers( info->hDC );

        DrawTime( info, t );
    }

    #ifdef USEDSOUND
    #else
    waveOutClose( h );
    #endif

    window_end( info );

    return 0;
}



