//--------------------------------------------------------------------------//
// iq . 2003 . code for the Paradise 64 kb intro by RGBA                    //
//--------------------------------------------------------------------------//

#define ERRORMSG            // activa printado mensajes de error
#define LOADING             // activa pintado "wait while loading..."
#define AUTOCENTER          // activa centrado de la ventana

#define WIN32_LEAN_AND_MEAN
#define WIN32_EXTRA_LEAN
#include <windows.h>
#include <mmsystem.h>
#include <malloc.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <GL/gl.h>
#include "../../intro.h"
#include "../../mzk.h"
#include "../../fft.h"

//----------------------------------------------------------------------------

typedef struct
{
    //---------------
    HINSTANCE   hInstance;
    HDC         hDC;
    HGLRC       hRC;
    HWND        hWnd;
    //---------------
    int         full;
    //---------------
    char        wndclass[14];	// window class and title :)
    //---------------
}WININFO;


static PIXELFORMATDESCRIPTOR pfd =
    {
    sizeof(PIXELFORMATDESCRIPTOR),
    1,
    PFD_DRAW_TO_WINDOW|PFD_SUPPORT_OPENGL|PFD_DOUBLEBUFFER,
    PFD_TYPE_RGBA,
    32,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0,  // accum
    32,             // zbuffer
    8,              // stencil!
    0,              // aux
    PFD_MAIN_PLANE,
    0, 0, 0, 0
    };

static WININFO wininfo = {  0,0,0,0,0,
							{'r','g','b','a','_','p','a','r','a','d','i','s','e',0}
                            };
#ifdef LOADING
static char fnt_wait[6]    = "arial";
static char msg_wait[22]   = "wait while loading...";
#endif
#ifdef ERRORMSG
static char msg_error[207] = "intro_init()!\n\n"\
                             "  no memory?\n"\
                             "  no music?\n"\
                             "  no GL_ARB_multitexture?\n"\
                             "  no GL_ARB_vertex_program?\n"\
                             "  no GL_ARB_fragment_program?\n"\
							 "  no GL_EXT_texture_lod_bias?\n"\
                             "  no GL_EXT_texture3D?\n"\
                             "  no GL_SGIS_generate_mipmap?";

static char tlt_error[6]   = "error";
#endif

static short myMuzik[MZK_DURATION*MZK_RATE*MZK_NUMCHANNELS];
static float rout[4096];
static float iout[4096];

static int wavHeader[11] = {
    0x46464952, 
    MZK_DURATION*MZK_RATE*MZK_NUMCHANNELS*2+36, 
    0x45564157, 
    0x20746D66, 
    16, 
    WAVE_FORMAT_PCM|(MZK_NUMCHANNELS<<16), 
    MZK_RATE, 
    MZK_RATE*MZK_NUMCHANNELS*sizeof(short), 
    (MZK_NUMCHANNELS*sizeof(short))|((8*sizeof(short))<<16),
    0x61746164, 
    MZK_DURATION*MZK_RATE*MZK_NUMCHANNELS*sizeof(short)
    };

//----------------------------------------------------------------------------


int kkinfo;
#ifdef LOADBAR
// n = [0..224]
void loadbar( int  n )
{
    WININFO *info = &wininfo;

    int     xo = 16*(XRES)>>8;
    int     y1 = (240*YRES)>>8;
    int     yo = y1-8;

    // draw background
    SelectObject( wininfo.hDC, CreateSolidBrush(0x0045302c) );
    Rectangle( wininfo.hDC, 0, 0, XRES, YRES );

    // draw text
    SetBkMode( wininfo.hDC, TRANSPARENT );
    SetTextColor( wininfo.hDC, 0x00ffffff );
    SelectObject( wininfo.hDC, CreateFont( 44,0,0,0,0,0,0,0,0,0,0,ANTIALIASED_QUALITY,0,fnt_wait) );
    TextOut( wininfo.hDC, (XRES-318)>>1, (YRES-38)>>1, msg_wait, 21 );
    //DrawText( info->hDC, msg_wait, 21, &rec, DT_CENTER|DT_VCENTER|DT_SINGLELINE );

    // draw bar
    SelectObject( wininfo.hDC, CreateSolidBrush(0x00705030) );
    Rectangle( wininfo.hDC, xo, yo, (240*XRES)>>8, y1 );
    SelectObject( wininfo.hDC, CreateSolidBrush(0x00f0d0b0) );
    Rectangle( wininfo.hDC, xo, yo, ((16+n)*XRES)>>8, y1 );
}
#endif


//----------------------------------------------------------------------------

static LRESULT CALLBACK WndProc( HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam )
{
	// salvapantallas
	if( uMsg==WM_SYSCOMMAND && (wParam==SC_SCREENSAVE || wParam==SC_MONITORPOWER) )
		return( 0 );

	// boton x o pulsacion de escape
	if( uMsg==WM_CLOSE || (uMsg==WM_KEYDOWN && wParam==VK_ESCAPE) )
		{
		PostQuitMessage(0);
        return( 0 );
		}

    return( DefWindowProc(hWnd,uMsg,wParam,lParam) );
}

static void window_end( WININFO *info )
{
    if( info->hRC )
        {
        wglMakeCurrent( 0, 0 );
        wglDeleteContext( info->hRC );
        }

    if( info->hDC  ) ReleaseDC( info->hWnd, info->hDC );
    if( info->hWnd ) DestroyWindow( info->hWnd );

    UnregisterClass( info->wndclass, info->hInstance );

    if( info->full )
        {
        ChangeDisplaySettings( 0, 0 );
		while( ShowCursor( 1 )<0 ); // show cursor
        }
}

static int window_init( WININFO *info )
{
	unsigned int	PixelFormat;
    DWORD			dwExStyle, dwStyle;
    DEVMODE			dmScreenSettings;
    WNDCLASS		wc;
    RECT			rec;

    memset( &wc, 0, sizeof(WNDCLASS) );
    wc.style         = CS_OWNDC|CS_HREDRAW|CS_VREDRAW;
    wc.lpfnWndProc   = WndProc;
    wc.hInstance     = info->hInstance;
    wc.lpszClassName = info->wndclass;
    //wc.hbrBackground=(HBRUSH)CreateSolidBrush(0x00785838);
	
    if( !RegisterClass(&wc) )
        return( 0 );

    if( info->full )
        {
        memset( &dmScreenSettings,0,sizeof(DEVMODE) );
        dmScreenSettings.dmSize       = sizeof(DEVMODE);
        dmScreenSettings.dmFields     = DM_BITSPERPEL|DM_PELSWIDTH|DM_PELSHEIGHT;
        dmScreenSettings.dmBitsPerPel = 32;
        dmScreenSettings.dmPelsWidth  = XRES;
        dmScreenSettings.dmPelsHeight = YRES;

        if( ChangeDisplaySettings(&dmScreenSettings,CDS_FULLSCREEN)!=DISP_CHANGE_SUCCESSFUL)
            return( 0 );

        dwExStyle = WS_EX_APPWINDOW;
        dwStyle   = WS_VISIBLE | WS_POPUP | WS_CLIPSIBLINGS | WS_CLIPCHILDREN;

		while( ShowCursor( 0 )>=0 );	// hide cursor
        }
    else
        {
        dwExStyle = WS_EX_APPWINDOW | WS_EX_WINDOWEDGE;
        dwStyle   = WS_VISIBLE | WS_CAPTION | WS_CLIPSIBLINGS | WS_CLIPCHILDREN | WS_SYSMENU;
        }

    rec.left   = 0;
    rec.top    = 0;
    rec.right  = XRES;
    rec.bottom = YRES;

    AdjustWindowRect( &rec, dwStyle, 0 );

    #ifdef AUTOCENTER
        info->hWnd = CreateWindowEx( dwExStyle, wc.lpszClassName, wc.lpszClassName, dwStyle,
		//info->hWnd = CreateWindowEx( dwExStyle, "EDIT", wc.lpszClassName, dwStyle,
                                   (GetSystemMetrics(SM_CXSCREEN)-rec.right+rec.left)>>1,
                                   (GetSystemMetrics(SM_CYSCREEN)-rec.bottom+rec.top)>>1,
                                   rec.right-rec.left, rec.bottom-rec.top, 0, 0, info->hInstance, 0 );
    #else
        info->hWnd = CreateWindowEx( dwExStyle, wc.lpszClassName, wc.lpszClassName, dwStyle,
                                   0, 0, rec.right-rec.left, rec.bottom-rec.top,
                                   0, 0, info->hInstance, 0 );
    #endif

    if( !info->hWnd )
        return( 0 );

    if( !(info->hDC=GetDC(info->hWnd)) )
        return( 0 );

    if( !(PixelFormat=ChoosePixelFormat(info->hDC,&pfd)) )
        return( 0 );

    if( !SetPixelFormat(info->hDC,PixelFormat,&pfd) )
        return( 0 );

    if( !(info->hRC=wglCreateContext(info->hDC)) )
        return( 0 );

    if( !wglMakeCurrent(info->hDC,info->hRC) )
        return( 0 );
    
    //SetForegroundWindow( info->hWnd );    // slightly higher priority
    //SetFocus( info->hWnd );               // sets keyboard focus to the window
    
    return( 1 );
}

//----------------------------------------------------------------------------


static unsigned char bmpheader[54] = {
// Header = 14 bytes
0x42, 0x4D,              //  0: signature = BM
0x00, 0x00, 0x00, 0x00,  //  2: [size]
0x00, 0x00,              //  6: reserved
0x00, 0x00,              //  8: reserved
0x36, 0x00, 0x00, 0x00,  // 10: offset to pixels = 54 = sizeof(Header) + sizeof(Info)

// Info = 40 bytes
0x28, 0x00, 0x00, 0x00,  // 14: header size = 40
0x00, 0x00, 0x00, 0x00,  // 18: [xres]
0x00, 0x00, 0x00, 0x00,  // 22: [yres]
0x01, 0x00,              // 26: bit planes = 1
0x18, 0x00,              // 28: bits per pixel = 24
0x00, 0x00, 0x00, 0x00,  // 30: compression:  0=none, 1=8bit RLE, 2=4bit RLE, 3=RGB with mask
0x00, 0x00, 0x00, 0x00,  // 34: [image size]
0xC3, 0x0E, 0x00, 0x00,  // 38: Pixels per meter X (3779)
0xC3, 0x0E, 0x00, 0x00,  // 42: Pixels per meter Y
0x00, 0x00, 0x00, 0x00,  // 46: number of colors (pallette)
0x00, 0x00, 0x00, 0x00   // 50: important colors (pallette)
};

static bool BMP_Salva32To24( const char *name, unsigned char *buffer, int xres, int yres )
{
    HANDLE h = CreateFile(name, GENERIC_WRITE, FILE_SHARE_READ, NULL, CREATE_ALWAYS, 0, NULL);
    if( h == INVALID_HANDLE_VALUE )
		return false;

    *((int*)(bmpheader+ 2)) = xres*yres*3 + 54;
    *((int*)(bmpheader+18)) = xres;
    *((int*)(bmpheader+22)) = yres;
    *((int*)(bmpheader+34)) = xres*yres*3;

    DWORD written = 0;
    WriteFile(h, bmpheader, 54, &written, nullptr);

    unsigned char tmp[3*XRES];
    for( int j=0; j<yres; j++ )
    {
        for( int i=0; i<xres; i++ )
        {
            const unsigned char *ptr = buffer + 4*(xres*(yres-1-j)+i);
            tmp[3*i+0] = ptr[2];
            tmp[3*i+1] = ptr[1];
            tmp[3*i+2] = ptr[0];
        }
        WriteFile(h, tmp, 3*xres, &written, nullptr);
    }


	CloseHandle(h);

    return true;
}

static long buffer[XRES*YRES] = {0};
//----------------------------------------------------------------------------

int WINAPI WinMain( HINSTANCE instance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow )
{
    int         done=0;
    WININFO     *info = &wininfo;

    info->hInstance = GetModuleHandle( 0 );


    if( !window_init(info) )
        {
        window_end( info );
        #ifdef ERRORMSG
        MessageBox( 0, "window_init()!",tlt_error,MB_OK|MB_ICONEXCLAMATION );
        #endif
        return( 0 );
        }

    if( !intro_init() )
        {
        window_end( info );
        #ifdef ERRORMSG
        MessageBox( 0, msg_error, tlt_error, MB_OK|MB_ICONEXCLAMATION );
        #endif
        return( 0 );
        }

    mzk_init( myMuzik+22 );

    memcpy( myMuzik, wavHeader, 44 );

    FILE *fp = fopen( "out/mzk.wav", "wb" );
    if( !fp )
        return( 0 );
    fwrite( &myMuzik, 2, MZK_DURATION*MZK_RATE*MZK_NUMCHANNELS+22, fp );
    fclose( fp );

    char fileName[] = "out/00000.bmp";
    const int duration = MZK_DURATION;
    const int fps = 60;
    const int numFrames = duration * fps;
    for( int i=0; i<numFrames; i++ )
    {
    
	    const float t = float(i)/float(fps);

        unsigned long pos = (unsigned long)(t*44100.0f);
        iqsft12( rout, myMuzik+MZK_NUMCHANNELS*pos+2048 );
    
	    intro_do( rout, t, i );

        MSG				msg;
	    int				done = 0;
        if( t>(MZK_DURATION*1000) )
            done = 1;

        glReadPixels( 0, 0, XRES, YRES, GL_RGBA, GL_UNSIGNED_BYTE, buffer );

        fileName[8] = '0' + (i/1)%10;
        fileName[7] = '0' + (i/10)%10;
        fileName[6] = '0' + (i/100)%10;
        fileName[5] = '0' + (i/1000)%10;
        fileName[4] = '0' + (i/10000)%10;
        if( !BMP_Salva32To24( fileName, (unsigned char*)buffer, XRES, YRES ) )
            break;

        //---------------------------------

        while( PeekMessage(&msg, wininfo.hWnd, 0, 0, PM_REMOVE) )
        {
		    if( msg.message==WM_QUIT ) done=1;
            //TranslateMessage(&msg);
            DispatchMessage(&msg);
        }

        SwapBuffers( wininfo.hDC );
    }



    //intro_end();

    window_end( info );

    return( 0 );
}
