; ZX81 AY PLAYER
;
; MODIFIED FROM THE SOUNDTRACKER PLAYBACK MODULE
;
; 13/8/2011
;
; ANDY REA
;
; It is a little ocercommented, but considering that i started
; off with a raw disasembly had had only the entry points
; to go from, i needed to comment, and re-comment sections
; as and when i discovered there purpose/function.
;

#define db .byte ; TASM cross-assembler definitions
#define DB .byte
#define dw .word
#define DW .word
#define ds .block
#define DS .block
#define org .org
#define ORG .org
#define end .end
#define END .end
#define equ .equ
#define EQU .equ

;		ORG 8192

L8000: ;213C84    
;		LD      HL,$8000								;START OF SONG DATA
L8003: ;C30980    
;;		JP      INITALISE
L8006: ;C34481    
;		JP      PLAY_SOUND								;THIS IS THE CALL POINT
													;FOR INTTERUPT DRIVEN
													;SOUND EVERY 1/50TH SECOND
						
INITALISE_STC:  

;HL IS ADDRESS OF STC FILE IN MEMORY ON ENTRY 
      
		DI      
		LD      A,(HL)									;GET DELAY VALUE
		LD      (DELAY_VALUE),A							;STORE IT
		LD      (SONG_START_BASE_ADDRESS),HL				;STORE START OF SONG DATA
													
        
		INC     HL									;POINT TO NEXT BYTE IN SONG DATA
													;THIS SHOULD POINT TO POSITIONS MAP 
		CALL    GET_NEXT_WORD_AND_ADD_BASE					;GET A WORD + OFFSET INTO DE, RETURNS POINTER TO
													;ACTUAL BYTE. I.E. START OF SONG (BASE) + OFFSET
													;ON ENTRY HL = ADRRESS OF LOW BYTE
													;ON EXIT HL = (ENTRY HL+2)
													;DE = WORD fetched
													
		LD      A,(DE)									;GET NUMBER OF PATTERNS IN SONG
													;THIS IS COUNT FROM ZERO, so A VALUE OF 1 MEANS 2 PATTERNS LONG
													;A VALUE OF 2 MEANS 3 PATTERNS LONG AND SO ON...
													
		INC     DE									;POINT TO NEXT BYTE IN POSITIONS MAP
		INC     A										;SEE ABOVE, A NOW HOLDS TRUE NUMBER OF PATTERNS
		
		LD      (NUMBER_OF_PATTERNS_IN_SONG),A					;SAVE NUMBER OF PATTERNS
		LD      (PTR_POSITIONS_DATA),DE					;SAVE POINTER TO POSITIONS DATA
		CALL    GET_NEXT_WORD_AND_ADD_BASE					;GET A WORD + OFFSET INTO DE
													;THIS SHOULD POINT TO THE ORNAMENTS
		LD      (PTR_COMPILED_ORNAMENTS),DE				;STORE POINTER TO COMPILED ORNAMENTS
	
		PUSH    DE									;TEMP SAVE THAT POINTER VALUE
		
		CALL    GET_NEXT_WORD_AND_ADD_BASE					;GET A WORD OFFSET
													;THIS SHOULD POINT TO THE PATTERN DATA				
						
		LD      (PTR_PATTERNS_DATA),DE					;SAVE POINTER TO PATTERNS DATA
		LD      HL,$001B								;OFFSET TO COMPILED SAMPLES
													;THEY ALWAYS START AT OFFSET $001B
													
													;THERE IS SOME TEXT IN THE STC FILE
													;THIS SKIPS OVER THE TEXT FIELD
    
		CALL    ADD_BASE_ADDRESS							;ADDS HL TO THE BASE ADDRESS OF 
													;THE SONG DATA
													;RETURND WITH ADDRESS TO SAMPLE IN DE
													;OLD DE IN HL
        
		EX      DE,HL									;SWAP DE AND HL BACK
		LD      (PTR_SAMPLES_DATA),HL						;SAVE POINTER TO SAMPLES


;=====================
;THE FOLLOWING CODE CLEARS (SET TO 0) THE CHANNEL PROGRAM DATA STORES
;AND ALSO CLEARS (SET TO 0) THE AY_DATA

;TOODO WORK OUT WHAT EXTRA BYTE IS FOR

; I THINK IT MAY BE JUST TO CAUSE THE CHANNEL PHARSER TO THINK THAT THE
; END OF THE PATTERN DATA HAS BEEN REACHED, AND TO GO TO THE NEXT PATTERN.
; THE BYTE IT POINTS TO IS $FF
; PATTERN DATA IS TERMINATED WITH $FF

		LD      HL,EXTRA_UNKNOWN_BYTE						;??? NOT KNOWN YET
		
		LD      (PTR_CHANNEL_A_PATTERN_DATA),HL				;POINT CHANNEL A TO BYTE $FF 
													
													
		LD      HL,CHANNEL_1_PROG_STORE_MINUS_2				
		LD      DE,CHANNEL_1_PROG_STORE_MINUS_1	
		LD      BC,$002C								;44 BYTES
		LD      (HL),B									;LOAD $00 INTO FIRST BYTE
		LDIR    										;FILL THE REST OF THE CHANNEL CONTROL VARS AND DATA TO SEDN TO AY WITH ZERO

		POP     HL									;RETRIEVE POINTER TO COMPILED ORNAMENTS...
													
		LD      BC,$0021								;EACH COMPILED ORNAMENT IS 33 BYTES LONG
													;BYTE 1 = ORNAMENT NUMBER
													;NEXT 32 = ORNAMENT DATA
													;POSITIVE NUMBERS = NORMAL
													;NEGATIVE NUMBERS = 2'S COMPLIMENT !
        
		XOR     A										;ZERO A REGISTER
   
		CALL    MATCH_PTRHL_WITH_A_STPBC					;LOOKS FOR A ZERO AT ORNAMENT NUMBER
													;AND RETURNS WITH HL POINTING THERE
													;NOT SURE WHY BECAUSE IF I HAVE READ
													;THE STRUCTURE OF THE STC FILE CORRECTLY
													;THE FIRST ORNAMENT IS ALWAYS ZERO
													; BUT IT SEEMS THAT DIFFERENT COMPILERS CAN PUT THEM IN ANY ORDER....
													
						
       
		DEC     A										; MAKE A = 255	   
		LD      (CHANNEL_1_PROG_STORE_PLUS_7),A				;ENTRY IN CHANNEL 1 PROG DATA
		LD      (CHANNEL_2_PROG_STORE_PLUS_7),A				;ENTRY IN CHANNEL 2 PROG DATA
		LD      (CHANNEL_3_PROG_STORE_PLUS_7),A				;ENTRY IN CHANNEL 3 PROG DATA
													;DEFAULT START VALUES
      
		LD      A,$01									;INITIAL VALUE FOR DELAY COUNT
		LD      (DELAY_COUNT),A							;WHEN PLAY_SONG IS FIRST CALLED 
													;WILL MAKE IT START AT A NEW LINE.
       
		INC     HL									;SHOULD BE POINTING TO ORNAMENT 0, SO MAKE IT PONT TO ORNAMENT 0 DATA
		LD      (CHANNEL_1_PROG_STORE_PLUS_5),HL			;ENTRY IN CHANNEL 1 PROG DATA
		LD      (CHANNEL_2_PROG_STORE_PLUS_5),HL			;ENTRY IN CHANNEL 2 PROG DATA
		LD      (CHANNEL_3_PROG_STORE_PLUS_5),HL			;ENTRY IN CHANNEL 3 PROG DATA
													;ALL CHANNELS POINT TO ORNAMENT ZERO (EMPTY ORNAMENT, ALL ZEROS)
		
		CALL    SEND_DATA_TO_AY							;PROG REGISTERS
													;ALL AY DATA SET TO ZERO
													;SHOULD SILENCE IT.
		EI      										;INITIALIZZE COMPLETE
		RET	    										;YEAH
		
;=============
; PLAY CONTROL VARS
;=============

PTR_POSITIONS_DATA:
		DW	$0000
PTR_COMPILED_ORNAMENTS:
		DW	$0000
PTR_PATTERNS_DATA:
		DW	$0000
PTR_SAMPLES_DATA:
		DW	$0000
DELAY_VALUE:	
		DB	$00
DELAY_COUNT:
		DB	$01
NUMBER_OF_PATTERNS_IN_SONG:
		DB	$01
		

PTR_CHANNEL_A_PATTERN_DATA:
		DW $E745
		
PTR_CHANNEL_B_PATTERN_DATA:
		DW $678C
		
PTR_CHANNEL_C_PATTERN_DATA:
		DW $67D8
		
EXTRA_UNKNOWN_BYTE:       
		DB	$FF

CHANNEL_1_PROG_STORE_MINUS_2:
	DB	0							;SOME KIND OF FLAG, $00 = ORNANMENT , $01 = AY_ENVELOPE , $02 = USE NOISE
									;THINK IT IS TO SAY WHAT LAST BYTE OF PATTERN DATA IS USED FOR.
CHANNEL_1_PROG_STORE_MINUS_1:
	DB	0							;could be dual purpose...
									;but one use is to hold the NUMBER OF BLANK LINES, USED TO RESET THE BLANK LINES COUNTER
									; I THINK IT ALSO HOLDS THE REPEAT COUNTER FOR THE SAMPLES
		   
CHANNEL_1_PROG_STORE_BASE: 

;TOODO	WORK OUT WHAT +$00 IS ?

	DB	0							;??? CURRENT SAMPLE/ORNAMENT STEP ???
	DB	0							;??? NOTE VALUE ???
	DB	0							;BLANK LINES COUNTER
CHANNEL_1_PROG_STORE_PLUS_3:   
	DB	0							;POINTS TO SAMPLE DATA FOR CHANNEL
	DB	0 
CHANNEL_1_PROG_STORE_PLUS_5: 
	DB	0							;POINTS TO ORNAMEWNT DATA FOR CHANNEL
	DB	0
CHANNEL_1_PROG_STORE_PLUS_7:
	DB	0							;REPEAT LENGTH
									;COUNTS DOWN
									;RESET TO 32 WHEN A NEW NOTE STARTS

CHANNEL_2_PROG_STORE_MINUS_2
	DB	0
CHANNEL_2_PROG_STORE_MINUS_1     
	DB	0 
		
CHANNEL_2_PROG_STORE_BASE: 
	DB	0
	DB	0
	DB	0
CHANNEL_2_PROG_STORE_PLUS_3:   
	DB	0							;POINTS TO SAMPLE DATA FOR CHANNEL
	DB	0
CHANNEL_2_PROG_STORE_PLUS_5: 
	DB	0
	DB	0
CHANNEL_2_PROG_STORE_PLUS_7:
	DB	0
		
CHANNEL_3_PROG_STORE_MINUS_2
L8096:
	DB	0     
CHANNEL_3_PROG_STORE_MINUS_1
L8097:
	DB	0  

CHANNEL_3_PROG_STORE_BASE: 
	DB	0
	DB	0
	DB	0
CHANNEL_3_PROG_STORE_PLUS_3:   
	DB	0							;POINTS TO SAMPLE DATA FOR CHANNEL
	DB	0 
CHANNEL_3_PROG_STORE_PLUS_5: 
	DB	0
	DB	0
CHANNEL_3_PROG_STORE_PLUS_7:
	DB	0
	
		
CURRENT_POSITION:
 
	DB	0 

DATA_TO_SEND_TO_AY:  
	
AY_DATA_TONE_CHAN_A:
AY_REG0:				;TONE CHANNEL A, FINE
	DB	0
AY_REG1:				;TONE CHANNEL A, COARSE	(LOWER 4 BITS, HIGH BYTE)
	DB	0
	
AY_DATA_TONE_CHAN_B:
AY_REG2:				;TONE CHANNEL B, FINE
	DB	0
AY_REG3:				;TONE CHANNEL B, COARSE	(LOWER 4 BITS, HIGH BYTE)
	DB	0
	
AY_DATA_TONE_CHAN_C:
AY_REG4:				;TONE CHANNEL C, FINE
	DB	0
AY_REG5:				;TONE CHANNEL C, COARSE	(LOWER 4 BITS, HIGH BYTE)
	DB	0
	
AY_DATA_NOISE_FREQ:
AY_REG6:				;NOISE GEN CONTROL (LOWER 5 BITS ONLY)
	DB	0
AY_DATA_MIXER:
AY_REG7:				;MIXER CONTOLR, b6,b7 io control, b5,b4,b3 = NOISE C,B,A, b2,b1,b0 = TONE C,B,A - A ZERO = ON.
	DB	0
AY_DATA_AMP_A:
AY_REG8:				;APPLITUDE CONTROL CHANNEL A, b7,b6,b5 NOT USED, b4 = AMPLITUDE 'MODE', b3,b2,b1,b0 = AMPLITUDE
	DB	0
AY_DATA_AMP_B:
AY_REG9:				;APPLITUDE CONTROL CHANNEL B, SEE ABOVE
	DB	0
AY_DATA_AMP_C:
AY_REG10:				;APPLITUDE CONTROL CHANNEL C, SEE ABOVE
	DB	0
AY_DATA_ENV_FREQ:		;THE CODE ONLY SEEMS TO EVER CHANGE THE FINE, COARSE REMAINS AT 0
AY_REG11:				;ENVELOPE FREQUENCY FINE
	DB	0	
AY_REG12:				;ENVELOPE FREQUECY	COARSE
	DB	0
	

END_DATA_TO_SEND_TO_AY:
AY_DATA_ENV_SHAPE:
AY_REG13:
	DB	0			;ENVELOPE SHAPE (EFFECT)   
			

;==============		    
;= tests for a match
;= between contents of memory pointed to by HL
;= with contents of A. if a match is found returns imediatly
;=
;= else hl incremented by BC and the new location is retested
;=
;= preserved DE, BC, A
;= altered HL, points to address of match
;==============

MATCH_PTRHL_WITH_A_STPBC		
        
		CP      (HL)		;TEST BYTE POINTED TO BY HL WITH A
		RET     Z			;RETURN IF EQUAL
		ADD     HL,BC		;ELSE ADD BC
		JP      MATCH_PTRHL_WITH_A_STPBC		;AND LOOP ROUND
		
;==============		    
;=            =
;= SUBROUTINE =
;=            =
;= gets the word pointed to by HL
;= adds contents of (SONG_START_BASE_ADDRESS) tot hat word
;= and returns result in DE
;=
;= preserved a
;= borked BC, HOLDS BASE ADDRESS
;= altered DE = new address
;= altered HL = HL + 2
;==============		
	
GET_NEXT_WORD_AND_ADD_BASE:	
       
		LD      E,(HL)        
		INC     HL       
		LD      D,(HL)        
		INC     HL       
		EX      DE,HL
		
SONG_START_BASE_ADDRESS: EQU $+1
ADD_BASE_ADDRESS:    
		LD      BC,$0000	;SELF MODIFING CODE !
						      
		ADD     HL,BC       
		EX      DE,HL       
		RET 

;==============
;=            =
;= SUBROUTINE =
;=            =
;==============

; ON ENTRY IY POINTS TO SAMPLE DATA FOR THE CHANNEL
; IB ENTRY A = CURENT STEP
;
; ON EXIT
;
; H = NOISE VALUE FOR CURRENT STEP
; L = ENV VALUE
; DE = EFFECT VALUE (BIT 4 OF D IS SIGN, VALUE IS 3 NIBBLES)
;
; B = 2 FOR TONE, 0 FOR NO TONE
; C = 16 FOR NOISE, 0 FOR NO NOISE


PROCESS_SAMPLE_DATA:    
		LD      D,$00
		LD      E,A				; DE = A
		ADD     A,A				; A = A *2
		ADD     A,E				; A = A * 3
		LD      E,A				; DE = A * 3
		ADD     IY,DE				; IY NOW POINTS TO CURRENT SAMPLE DATA, FOR THIS STEP
		LD      A,(IY+$01)			; b7 NOISE MASK, b6 ENV MASK, b5 SIGN FOR EFFECT, b4-0 NOISE VAL
		BIT     7,A				; TEST BIT 7, NOISE MASK
		LD      C,$10				; PREPARE C = 16
		JP      NZ,KEEP_C			; 
		LD      C,D				; ELSE C = ZERO
KEEP_C:
		BIT     6,A				; TEST BIT 6, TONE MASK
		LD      B,$02				; PREPARE B = 2
		JP      NZ,KEEP_B
		LD      B,D				; ELSE B =0
KEEP_B:
		AND     $1F				; NOISE VAL ONLY
		LD      H,A				; KEEP IT IN H
		LD      E,(IY+$02)			; LOW BYET EFFECT 
		LD      A,(IY+$00)			; b7-4 HIGH PART OF EFFECT. b3-0 ENV VOL
		PUSH    AF				; TEMP SAVE
		AND     $F0				; HIGH PART OF EFFECT
		RRCA    
		RRCA    
		RRCA    
		RRCA    
		LD      D,A				; HIGH PART OF EFFECT, DE NOW HOLDS EFFECT
		POP     AF				; RETRIEVE PREVIOUS 
		AND     $0F				; ENV VOL ONLY
		LD      L,A				; ENV VOLUME
								; SO H HOLDS NOISE VAL, L HOLDS ENV VAL
								
		BIT     5,(IY+$01)			; TEST SIGN OF EFFECT
		RET     Z					; RETURN IF ZERO. FOR ADDITION
      
		SET     4,D				; ELSE SET BIT 4 IN D, FOR SUBTRACTION
		RET   
		
;==============
;=            =
;= SUBROUTINE = 
;=            =
;=====================================
;=                                   =
;= SETS THE NEXT PATTERN TO PLAY     =
;=                                   =
;=====================================

NEXT_PATTERN:
   
		LD      A,(CURRENT_POSITION)				;CURRENT POSITION 
											;FIRST RUN POSITION = 0
		LD      C,A
		LD      HL,NUMBER_OF_PATTERNS_IN_SONG		;POINT TO NUMBER OF PATTERNS
											
											
		CP      (HL)							;A - (HL) CARRY SET IF (HL) > A
    
		JP      C,NEXT_POSITION					;JP IF (HL) > A, MORE POSITIONS TO GO
		
		;ELSE BACK TO POSITION 1.
		XOR     A								;RESET CURRENT POSITION
		LD      C,A							
        
NEXT_POSITION:
		INC     A								; A = 1 IF RESET CURREN POSITION
											; OR A = A+1 (NEXT POSITION) 
											
		LD      (CURRENT_POSITION),A				; STORE NEW CURRENT POSITION.
		 
		LD      L,C							; CURRENT POSITION NUMBER LESS ONE !
		LD      H,$00							; INTO HL
		ADD     HL,HL							; DOUBLE IT (INDEX TO ,2 BYTES PER VALUE, TABLE
		LD      DE,(PTR_POSITIONS_DATA)			; GET THE START OF THE POSITIONS TABLE )
		ADD     HL,DE							; ADD THE INDEX INTO TABLE
		LD      C,(HL)							; GET VALUES FROM THE POSITIONS MAP
		INC     HL							;
		LD      A,(HL)							; C (LOW BYTE [PATTERN TO USE]) AND A (HEIGTH OF PATTERN)
		LD      (CURRENT_HEIGHT),A				; SAVE HEIGHT BYTE
		LD      A,C							; PATTERN NUMBER INTO A
		LD      HL,(PTR_PATTERNS_DATA)			; GET POINTER TO PATTERNS DATA TABLE
											;
											; THIS IS A TABLE WITH 7 BYTES PER ENTRY
											; BYTE 1 = PATTERN NUMBER
											; BYTES 2/3 = OFFSET TO CHANNEL A PATTERN DATA
											; BYTES 4/5 = OFFSET TO CHANNEL B PATTERN DATA
											; BYTES 6/7 = OFFSET TO CHANNEL C PATTERN DATA
							
    
		LD      BC,$0007						; USE AS INCREMENT WHEN STEPPING THROUGH PATTERN DATA TABLE
		CALL    MATCH_PTRHL_WITH_A_STPBC			; STEP THROUGH PATTERNS DATA UNTIL A MATCH IS FOUND
		INC     HL							; ROUTINE ABOVE LEAVES HL POINTING AT THE PATTERN NUMBER THAT MATCHED
											; INC HL SO IT POINTS TO NEXT BYTE IN PATTERN DATA TABLE
   
		CALL    GET_NEXT_WORD_AND_ADD_BASE			; GET THE POINTER TO CHANNEL A PATTERN
		LD      (PTR_CHANNEL_A_PATTERN_DATA),DE		; STORE IT
		CALL    GET_NEXT_WORD_AND_ADD_BASE			; CHANNEL B
		LD      (PTR_CHANNEL_B_PATTERN_DATA),DE		; STORE IT
		CALL    GET_NEXT_WORD_AND_ADD_BASE			; CHANNEL C
		LD      (PTR_CHANNEL_C_PATTERN_DATA),DE		; AND STORE IT
		RET 
		
;==============
;=            =
;= SUBROUTINE =
;=            =
;==============

DECREMENT_COUNTER:	    
		DEC     (IY+$02)		;DECREMENT THE CURRENT CHANNELS BLANK LINE COUNTER.      
		RET     P				;RETURN IF BIT 7 RESET SET ABOVE
		
							;AS THAT MEMORY LOCATION HOLDS ZERO ON FIRST RUN, THIS OPERATION WILL ALWAYS CONTINUE HERE
							; BUT THE VALUES ARE STILL MEANINGLESS (ON FIRST RUN)
							
		LD      A,(IY-$01)		;ELSE GET RESET VALUE    
		LD      (IY+$02),A		;AND RESET IT      
		RET 
		
;==================
;=                =
;= MAIN PLAY LOOP =
;=                =
;=============================
;=                           =
;= CALL EVERY 1/50 TH SECOND =
;=                           =
;=============================
		
PLAY_SOUND:    
   
		LD      A,(DELAY_COUNT)					;GET CURRENT DELAY COUNT       
		DEC     A								;DECREMENT IT
		LD      (DELAY_COUNT),A					;AND SAVE NEW VALUE	
		JP      NZ,PROCESS_CHANNELS				;JP IF DELAY COUNT HAS NOT REACHED ZERO
											;IN OTHER WORDS
											;CONRINUE TO POST PROCESS THE CHANNELS
											;STILL DOING SAME LINE IN PATTERN
											
;ON FIRST CALL TO PLAY_SOUND (AFTER INITALISE) THE DELAY COUNT WAS SET TO 1
;SO WE WILL ALWAYS ARRIVE HERE...
		
DELAY_COUNTDOWN_REACHED_ZERO:   
		LD      A,(DELAY_VALUE)					;GET THE DELAY VALUE FOR THIS SONG.    
		LD      (DELAY_COUNT),A					;RESET DELAY COUNTER  
		
		
		LD      IY,CHANNEL_1_PROG_STORE_BASE		;SET UP INDEX REGISTER FOR CHANNEL 1
		CALL    DECREMENT_COUNTER				;DECREMENT BLANK LINE COUNTER
											;AND RESETS IT WHEN IT REACHES 0
											;READY FOR NEXT DATA ???  
											
											
											;IF BLANK LINE COUNTER WAS RESET THEN WE
											;WILL SKIP THE FOLLOWING JUMP AND
											;PROCESS THE NEXT PATTERN DATA BYTE FOR 
											;CHANNEL 1
											
											 
		JP      P,NEW_DATA_CHANNEL_2				;IF STILL POSITIVE (SUB CALLED ABOVE)
											;THEN JUMP (SKIP CHANNEL)
											
;ON FIRST RUN WE WILL END UP HERE...

NEW_DATA_CHANNEL_1:

;===============
;IF WE ARE HERE THEN THERE SHOULD BE NEW DATA IN THE PATTERN DATA FOR CHANNEL 1					
   
		LD      HL,(PTR_CHANNEL_A_PATTERN_DATA)		;POINTS TO CHANNEL DATA IN CURRENT PATTERN ?
											;
											;ON FIRST RUN THIS IS POINTING TO $FF (FROM THE INITALISE ROUTINE)
											
											;PATTERN DATA TERMINATED WITH $FF 
		LD      A,(HL)							;GET THE BYTE POINTED TO
		INC     A								;IS IT THE TERMINATOR ?
		CALL    Z,NEXT_PATTERN					;THEN GET THE NEXT PATTERN FOR ALL CHANNELS	
											;NOTICE THIS IS A "CALL..."
											
		;SO WHEN WE RETURN HERE, THE PATTERN DATA POINTER FOR EACH OF THE CHANNELS ARE SET
		;AND POINT TO THE MATCHING PATTERNS FOR POSITION 1.
											
		LD      HL,(PTR_CHANNEL_A_PATTERN_DATA)		;POINTS TO CHANNEL DATA 
											;IY STILL POINTING TO CHANNEL_1_PROG_STORE_BASE
		CALL    PROCESS_CHANNEL_DATA				;PROCESS CHANNEL DATA
											;RETURNS WITH HL POINTING TO THE 
											;NEXT UN-PROCESSED BYTE IN THAT CHANNEL
		LD      (PTR_CHANNEL_A_PATTERN_DATA),HL
		
		
NEW_DATA_CHANNEL_2:	
		LD      IY,CHANNEL_2_PROG_STORE_BASE		;INDEX FOR CHANNEL 2   
		CALL    DECREMENT_COUNTER
		JP      P,NEW_DATA_CHANNEL_3
		
		LD      HL,(PTR_CHANNEL_B_PATTERN_DATA)
		CALL    PROCESS_CHANNEL_DATA
		LD      (PTR_CHANNEL_B_PATTERN_DATA),HL
		
NEW_DATA_CHANNEL_3:
  
		LD      IY,CHANNEL_3_PROG_STORE_BASE		;INDEX FOR CHANNEL 3
		CALL    DECREMENT_COUNTER
		JP      P,PROCESS_CHANNELS
  
		LD      HL,(PTR_CHANNEL_C_PATTERN_DATA)
		CALL    PROCESS_CHANNEL_DATA
		LD      (PTR_CHANNEL_C_PATTERN_DATA),HL
		JP      PROCESS_CHANNELS					;CHANNEL PROCESSING DONE
											;NOW LETS TURN THAT INTO AY DATA
		
		
;==============
;=            =
;= SUBROUTINE =
;=            =
;==============
;
; THIS ROUTINE DOES NOT RETURN TO CALLING CODE
; DIRECTLY, BUT RETURNS FROM ONE OF THE 
; SECTIONS OF CODE JUMPED TO
; ACCORDING TO THE DATA BYTE VALUE

PROCESS_CHANNEL_DATA:
        
		LD      A,(HL)							;GET NEXT BYTE OF PATTERN DATA FOR CHANNEL
		CP      $60							;A < $60 THEN IS NOTE DATA.
		JP      C,NOTE_DATA						;A = $0 THRU $5F ~ BITS 0-4 = NOTE IN SEMITONES $00 = C-1
     
		CP      $70							;A => $60 < $70 ?
		JP      C,SAMPLE_NUMBER					;A = $60 THRU $6F ~ BITS 0-4 = SAMPLE NUMBER      
		CP      $80							;A => $70 < $80 ?
		JP      C,ORNAMENT_NUMBER						;A = $70 THRU $7F ~ BITS 0-4 = ORNAMENT NUMBER
		JP      Z,REST							;A = $80 ~ REST (STOP CHANNEL)
		CP      $81							;A = $81 ?
		JP      Z,EMPTY_LOCATION					;A = $81 ~ EMPTY LOCATION ???
		CP      $82							;A = $82
		JP      Z,ORNAMENT_ZERO					;A = $82 ~ SELECTS ORNAMENT 0
		CP      $8F							;A => $83 < $8F
		JP      C,EFFECT_NUMBER					; A = $83 < $8E ~ SELECTS EFFECT
		SUB     $A1							; ELSE SUBRACT 161 FROM A
    
		LD      (IY+$02),A						; COUNTER FOR NUMBER OF BLANK LINES 
		LD      (IY-$01),A						; AND ERM ???
		INC     HL							; POINT TO NEXT BYTE
		JP      PROCESS_CHANNEL_DATA				; AND LOOP ROUND TO PROCESS NEXT BYTE
		
		
		
;===============
;=             =
;= ROUTINE	=
;=             =
;=================================
;=                               =
;= DEALS WITH SEMITONE NOTE DATA =
;=                               =
;=================================

NOTE_DATA:
		LD      (IY+$01),A						; STORE THE NOTE DATA BYTE (IN SEMITONES)
		LD      (IY+$00),$00					; NEW NOTE STARTS AT STEP 0
		LD      (IY+$07),$20					; AND 32 STEPS
		
;= THIS POINT IS JUMPED OT FOR AN EMPTY LOCATION

EMPTY_LOCATION:
		INC     HL							; POINT OT NEXT BYTE
		RET     								; DONE
		
;===============
;=             =
;= ROUTINE	=
;=             =
;=================================
;=                               =
;= DEALS WITH SAMPLE NUMBER DATA =
;=                               =
;=================================

SAMPLE_NUMBER:
	             
		SUB     $60							; SUBTRACT $60 TO GET A 0 TO 15 NUMBER
		PUSH    HL							; TEMP SAVE CHANNEL DATA POINTER 
		LD      BC,$0063						; SAMPLE ARE 99 BYTES LONG
		LD      HL,(PTR_SAMPLES_DATA)				; BASE ADDRESS OF SAMPLES DATA
		CALL    MATCH_PTRHL_WITH_A_STPBC			; STEP THROUGH SAMPLES DATA
											; UNTIL SAMPLE NUMBER IS FOUND 
		INC     HL							; POINT TO FIRST BYTE OF SAMPLE
		LD      (IY+$03),L
		LD      (IY+$04),H						; SAVE PTR TO SAMPLE IN CHANNEL PROG DATA
		POP     HL							;RETRIEVE CHANNEL DATA POINTER
		INC     HL							;POINT TO NEXT BYTE
		JP      PROCESS_CHANNEL_DATA				;LOOP BACK AND DEAL WITH NEXT BYTE
		
;===============
;=             =
;=  ROUTINE	=
;=             =
;=================================
;=                               =
;= TURNS OFF CHANNEL             =
;=                               =
;=================================		
		
REST:        
		INC     HL						;POINT TO NEXT BYTE IN CHANNEL DATA
REST_2:  
		LD      (IY+$07),$FF				; CODE FOR OFF (NO SOUND FROM CHANNEL)
										; THAT LOCATION IS THE SAMPLE/ORN STEP
		RET  							;DONE
		
		
;===========
;=         =
;= ROUTINE =  
;=         =
;=====================
;=                   =
;= SELECT ORNAMENT 0 =
;=                   =
;=====================

ORNAMENT_ZERO:        
		XOR     A	
		JR      ORNAMENT_ZERO_2				;JUMP TO ORNAMENT SELECT ROUTINE, BUT JUMP OVER NORMALIZE SUB
		
;===========
;=         =
;= ROUTINE =  
;=         =
;=====================
;=                   =
;= SELECT ORNAMENT   =
;=                   =
;=====================		
ORNAMENT_NUMBER:		
		SUB     $70 						; SUBTRACT $70 TO GIVE A 0 TO 15 VALUE
ORNAMENT_ZERO_2:
		PUSH    HL						; SAVE CHANNEL DATA POINTER
    
		LD      BC,$0021					; ORNAMENTS ARE 33 BYTES LONG (1 BYTE, NUMBER + 32 BYTES, DATA)
		LD      HL,(PTR_COMPILED_ORNAMENTS)  	; ORNAMENTS BASE ADDRESS
		CALL    MATCH_PTRHL_WITH_A_STPBC		; STEP OVER ORNAMENST UNTIL A MATCH IS FOUND
		INC     HL						; POINT TO FIRST BYTE OF ORNAMENT DATA
		LD      (IY+$05),L					; 
		LD      (IY+$06),H					; SAVE ADDRESS OF ORNAMENT IN CHANNEL PROG DATA
		LD      (IY-$02),00					; AND SET FLAG TO SAY ORNAMENT IN USE
		POP     HL						; RETRIEVE CHANNEL DATA POINTER
		INC     HL						; POINT TO NEXT BYTE
		JP      PROCESS_CHANNEL_DATA			; LOOP BACK AND PROCESS NEXT BYTE
		
;===============
;=             =
;= ROUTINE	=
;=             =
;=================================
;=                               =
;= SELECT AN EFFECT              =
;=                               =
;=================================	
		
EFFECT_NUMBER:      
		SUB     $80						; SUBTRACT $80
		LD      (AY_DATA_ENV_SHAPE),A			; STORE IN the DATA TO SEND TO AY TABLE
		INC     HL						; POINT TO NEXT BYTE IN CHANNEL DATA
		LD      A,(HL)						; NEXT BYTE IS ENV FREQ VALUE.
		INC     HL						; POINT TO NEXT BYTE IN THE CHANNEL DATA
		LD      (AY_DATA_ENV_FREQ),A			; STORE IN the DATA TO SEND TO AY TABLE
		LD      (IY-$02),$01				; SET THE FLAG TO AY_ENV_SHAPE IN USE
		PUSH    HL						; TEMP SAVE CHANNEL DATA POINTER

;WHEN USING AN EFFECT ORNAMENT IS SET TO ZERO
        
		XOR     A
		LD      BC,$0021					; 33 BYTES IN EACH ORNAMENT
		LD      HL,(PTR_COMPILED_ORNAMENTS) 	; COMPILED ORNAMENTS BASE ADDRESS
		CALL    MATCH_PTRHL_WITH_A_STPBC		; STEP OVER EACH ORNAMENT TILL
										; A MATCH IS FOUND
		INC     HL						;POINT TO FIRST BYTE OF ORNAMENT DATA
		LD      (IY+$05),L
		LD      (IY+$06),H					; STORE ORNAMENT PTR IN CHANNEL_PROG STORE
		POP     HL						; RETRIEVE CHANNEL DATA POINTER
		JP      PROCESS_CHANNEL_DATA			; LOOP BACK AND PROCESS NEXT BYTE
		
		
;==============
;=            =
;= SUBROUTINE =
;=            =
;==============
		
DO_REPEAT:		
		LD      A,(IY+$07)					; GET CURRENT REPEAT COUNTDOWN ? 
		INC     A
		RET     Z							; RETURN IF A WAS $FF (NOW $00), CHANNEL STAY MUTED TILL NEW NOTE
		
		DEC     A							; RESTORE A TO PREVIOUS VALUE	
		DEC     A							; AND DECREMENT COUNTER
		
		;	!!! ZERO FLAG USED BELOW !!!
		
		LD      (IY+$07),A					; STORE NEW COUNT DOWN VALUE 
		PUSH    AF						; TEMP SAVE NEW COUNT VALUE AND FLAGS !!!
		
		LD      A,(IY+$00)					; GET SAMPLE/ORN STEP
		LD      C,A						; PUT IT IN C
		INC     A							; INCREMENT IT
		AND     $1F						; KEEP ONLY LOWEST 5 BITS
		LD      (IY+$00),A					; STORE IT
		POP     AF						; RETRIEVE PREVIOUS A AND FLAGS !!!
		
		RET     P						; RETURN IF DOUBLE DEC A ABOVE RESULT WAS < 0
    
		LD      E,(IY+$03)					; ELSE 
		LD      D,(IY+$04)					; RETRIEVE THE SAMPLE PTR FOR THIS CHANNEL
		LD      HL,$0060
		ADD     HL,DE						; ADD $0060 TO THE SAMPLE PTR (POINTS TO REPEAT VALUE)
		LD      A,(HL)						; 
		DEC     A							; IF REPEAT VALUE IS 0 THEN PLAY ONLY ONCE.
		
		JP      M,REST_2					; JUMP IF REAPEAT COUNT ROLLS FROM 255 TO 0
										; TO SILENCE CHANNEL, STORES $FF IN REPEAT COUNTER AND RET'S TO CALLING CODE
        
		LD      C,A						; REPEAT - 1 INTO C
		INC     A							; RESTORE PREVIOUS VALUE
		AND     $1F						; KEEP LOWEST 5 BITS ( 0 TO 31 )
		LD      (IY+$00),A					; STORE START STEP FOR REPEAT
		
		INC     HL						; POINT TO REAPEAT LENGTH
		LD      A,(HL)						; GET REPEAT LENGTH
		INC     A							; +1 BEFORE STORING
		LD      (IY+$07),A					; STORE IT
		
		RET     
		
;==============
;=            =
;= SUBROUTINE =
;=            =
;==============
	
SET_NOISE_FREQ:       
		LD      A,C
		OR      A							; IS A = 0
		RET     NZ						; NOPE LEAVE NOISE FREQ AS IS
		LD      A,H						; ELSE H HOLDS NOISE FREQ TO USE
		LD      (AY_DATA_NOISE_FREQ),A
		RET  
		
;==============
;=            =
;= SUBROUTINE =
;=            =
;==============

CLEAR_AY_ENV_SHAPE:    
		LD      A,(IY+$07)
		INC     A							; MUTE CHANNEL ?
		RET     Z							; YES LEAVE AY ENEVLOPE ALONE
		
		LD      A,(IY-$02)
		OR      A							; ELSE TEST FLAG BYTE
		RET     Z							; ORNAMENT IN USE
		
		CP      $02						; TEST FOR NOISE IN USE
		JP      Z,AY_ENV_ZERO				; IF NOISE IN USE THEN SET AY_ENV_SHAPE TO ZERO
		
		LD      (IY-$02),$02				; ?? SET NOISE IN USE.
		JP      AY_ENV_SKIP
AY_ENV_ZERO:        
		XOR     A
		LD      (AY_DATA_ENV_SHAPE),A
AY_ENV_SKIP:      
		SET     4,(HL)						; SET THE AY_AMPLITUDE_MODE BIT FOR THIS CHANNEL
										; IE. USE SAMPLE ENVELOPE VALUE FOR VOLUME
										; INSTEAD OF AY_ENVELOPE
		RET   
		
;==============
;=
;= ROUTINE CONTINUES FROM CHANNEL PROCESSOR
;=
;==============

;PROCESS CHANNEL 1
PROCESS_CHANNELS:
 
		LD      IY,CHANNEL_1_PROG_STORE_BASE			; PROCCESS CHANNEL 1 
		CALL    DO_REPEAT							; DO REPEATS ECT ?
												; RETURNS CURRENT STEP VALUE IN C ???
		LD      A,C								;
		
		LD      (ORNAMENT_STEP_NUMBER),A				; STORE IT (MAYBE SELF MODIFING CODE AGAIN)
		LD      IY,(CHANNEL_1_PROG_STORE_PLUS_3)		;
		CALL    PROCESS_SAMPLE_DATA					; ON EXIT
												;
												; H = NOISE VALUE FOR CURRENT STEP
												; L = ENV VALUE
												; DE = EFFECT VALUE (BIT 4 OF D IS SIGN, VALUE IS 3 NIBBLES)
												;
												; B = 0 FOR TONE, 2 FOR NO TONE
												; C = 0 FOR NOISE, 16 FOR NO NOISE 
		LD      A,C
		OR      B									; MIX THE NOISE AND TONE MASKS
		RRCA    									; MOVE INTO CORRECT POSITION
		LD      (AY_DATA_MIXER),A					; AND STORE IT
  
		LD      IY,CHANNEL_1_PROG_STORE_BASE			; INDEX REGISTER BACK TO CHANNEL PROG STORE
		LD      A,(IY+$07)							; TEST FOR TUNE OFF CHANNEL $FF MEANS TURN OFF CHANNEL
		INC     A
		JP      Z,CHANNEL_1_VOL_ZERO					; 
    												; 
		CALL    SET_NOISE_FREQ						; ELSE DO NOISE FREQ
		CALL    GET_NOTE_FREQUENCY
		LD      (AY_DATA_TONE_CHAN_A),HL				; STORE FREQUENCY FOR THIS CHANNEL
CHANNEL_1_VOL_ZERO:
		LD      HL,AY_DATA_AMP_A
		LD      (HL),A								; IS EITHER SAMPLE ENVELOPE VALUE OR ZERO
		CALL    CLEAR_AY_ENV_SHAPE
		
;PROCESS CHANNEL 2
		LD      IY,CHANNEL_2_PROG_STORE_BASE
		CALL    DO_REPEAT
		
		LD      A,(IY+$07)
		INC     A
		JP      Z,CHANNEL_2_VOL_ZERO
		LD      A,C								; SAMPLW/ORN STEP
		LD      (ORNAMENT_STEP_NUMBER),A
		LD      IY,(CHANNEL_2_PROG_STORE_PLUS_3)
		CALL    PROCESS_SAMPLE_DATA
		LD      A,(AY_DATA_MIXER)					; GET CHANNEL 1 AY_MIXER VALUE
		OR      C
		OR      B									; MIX IN CHANNEL 2 MASKS
		LD      (AY_DATA_MIXER),A					; STORE NEW MIXER VALUE
		CALL    SET_NOISE_FREQ
		LD      IY,CHANNEL_2_PROG_STORE_BASE
		CALL    GET_NOTE_FREQUENCY
		LD      (AY_DATA_TONE_CHAN_B),HL
CHANNEL_2_VOL_ZERO:     
		LD      HL,AY_DATA_AMP_B
		LD      (HL),A
		CALL    CLEAR_AY_ENV_SHAPE
		
;PROCESS CHANNEL 3
		LD      IY,CHANNEL_3_PROG_STORE_BASE
		CALL    DO_REPEAT
		LD      A,(IY+$07)
		INC     A
		JP      Z,CHANNEL_3_VOL_ZERO
		LD      A,C
		LD      (ORNAMENT_STEP_NUMBER),A
		LD      IY,(CHANNEL_3_PROG_STORE_PLUS_3)
		CALL    PROCESS_SAMPLE_DATA
		LD      A,(AY_DATA_MIXER)
		RLC     C
		RLC     B
		OR      B
		OR      C									;MIX CHANNEL 3 MASKS
		LD      (AY_DATA_MIXER),A
		CALL    SET_NOISE_FREQ
		LD      IY,CHANNEL_3_PROG_STORE_BASE
		CALL    GET_NOTE_FREQUENCY
		LD      (AY_DATA_TONE_CHAN_C),HL
CHANNEL_3_VOL_ZERO:    
		LD      HL,AY_DATA_AMP_C
		LD      (HL),A
		CALL    CLEAR_AY_ENV_SHAPE
		JP      SEND_DATA_TO_AY			;PROCESSIGN DONE SET THE REGISTERS
		

;==============
;=            =
;= SUBROUTINE =
;=            =
;==============

GET_NOTE_FREQUENCY:			
		LD      A,L					
		PUSH    AF					; SAVE SAMPLE ENV VALUE
		PUSH    DE					; SAVE EFFECT VALUE
		LD      L,(IY+$05)
		LD      H,(IY+$06)				; HL POINTS TO ORNAMENT DATA
ORNAMENT_STEP_NUMBER: EQU $+1   			; LOW BYTE OF ld de,$nnnn ONLY
		LD      DE,$0005				; SELF MODIFYING CODE, ADDED TO BASE ADDRESS IN HL
		ADD     HL,DE					; HL NOW POINTS TO THE CORRECT STEP IN ORNAMENT
		LD      A,(IY+$01)				; GET THE CURRENT NOTE 
		ADD     A,(HL)					; ADD THE ORNAMENT VALUE (SINGLE BYTE SIGNED, SO CAN SUBTRACT TOO)
		
CURRENT_HEIGHT: EQU $+1
		ADD     A,$00					; ADD THE PATTERN HEIGHT
        
		ADD     A,A					; DOUBLE A (TONE TABLE IS WORDS)
		LD      E,A
		LD      D,$00					; DE IS OFFSET INTO TONE TABLE
									; NO BOUNDS CHECKING ???
		LD      HL,TONE_TABLE			; BASE ADDRESS OF TONE TABLE
		ADD     HL,DE					; HL NOW POINTS TO WORD FOR TONE DATA
		LD      E,(HL)
		INC     HL
		LD      D,(HL)					; PICK UP TONE DATA
		EX      DE,HL					; HL HOLDS TONE DATA
		POP     DE					; RETRIEVE ADDITIONAL EFFECT (FROM SAMPLE DATA)
		POP     AF					; RETRIEVE ENV VALUE
		BIT     4,D					; TEST SIGN BIT IN EFFECT VAL (IT'S NOT REALLY A SIGNED VALUE)
									; BUIT HAS A BIT TO SAY WETHER WE ADD OR SUB THE VALUE
   							
		; THIS LOOKS BACK TO FRONT, BUT...
		; A HIHGER VALUE FOR TONE RESULTS IN A LOWER FREQUENCY
		; IN SOUND OUTPUT
		;
		; SO AN ADDITIONAL EFFECT (HIGHER IN FREQUENCY OUTPUT)
		; MUST BE SUBTRACTED FROM TONE DATA.
		;
		; AND THE OPOSITE IS TRUE FOR LOWER FREQUENCY
									  
		JR      Z,SUB_EFFECT
		RES     4,D					; CLEAR BIT BEFORE ADDING EFFECT VALUE
		ADD     HL,DE					; ELSE ADD EFFECT (LOWER FREQUENCY)		|
		RET  			
						
SUB_EFFECT:
		AND     A						; CLEAR CARRY IN PREP FOR SUBRACTION
									; DOES NOT AFFECT SAMPLE ENV VALUE
		SBC     HL,DE					; SUBTRACT EFFECT (HIGHER FREQUENCY)
		RET
		
		
;==============
;=
;= TONE TABLE 
;=
;============
 
TONE_TABLE:
	DW	$0EF8, $0E10, $0D60, $0C80, $0BD8, $0B28, $0A88, $09F0, $0960, $08E0, $0858, $07E0
	DW	$077C, $0708, $06B0, $0640, $05EC, $0594, $0544, $04F8, $04B0, $0470, $042C, $03F0
	DW	$03BE, $0384, $0358, $0320, $02F6, $02CA, $02A2, $027C, $0258, $0238, $0216, $01F8
	DW	$01DF, $01C2, $01AC, $0190, $017B, $0165, $0151, $013E, $012C, $011C, $010B, $00FC
	DW	$00EF, $00E1, $00D6, $00C8, $00BD, $00B2, $00A8, $009F, $0096, $008E, $0085, $007E
	DW	$0077, $0070, $006B, $0064, $005E, $0059, $0054, $004F, $004B, $0047, $0042, $003F
	DW	$003B, $0038, $0035, $0032, $002F, $002C, $002A, $0027, $0025, $0023, $0021, $001F
	DW	$001D, $001C, $001A, $0019, $0017, $0016, $0015, $0013, $0012, $0011, $0010, $000F     
 

;==============		
;=            =		
;= SUBROUTINE =
;=            =
;====================
;=                  =
;= SET AY REGISTERS =
;=                  =
;====================	

SEND_DATA_TO_AY:
	   
		LD      HL,END_DATA_TO_SEND_TO_AY			;POINTS TO END OF DATA TO SEND, env shape working backwards
		XOR     A								;ZERO A
		OR      (HL)							;TEST env shape
		LD      A,0DH							;LOAD A WITH 13, WILL LOOP 14 TIMES
											;LOOP ENDS WHEN A ROLLS ROUND FROM 0 TO 255 
      
		JR      NZ,SEND_AY_DATA					;IF env shape = 0 THEN ONLY SEND NEW CHANNEL DATA
											;ELSE CONTINUE (TAKE THE JR) WITH NEW EFFECT DATA ALSO
      
		SUB     $03							;ELSE SEND ONLY 11 BYTES, START AT amplitude FOR CHANNEL C
		DEC     HL			 
		DEC     HL							; 
		DEC     HL							; SKIP 3 BYTES IN DATA
		
SEND_AY_DATA:
L842D: ;0EFD      
;		LD      C,$FD							;LOW BYTE PORT ADDRESS (SPECTRUM)
											;REGISTER SELECT
		
		LD	   B,$FF							;HIGH BYTE PORT ADDRESS (ZX81)
											;REGISTER SELECT
AY_WRITE_LOOP:
L842F: ;06FF      
;		LD      B,$FF							;HIGH BYTE PORT ADDRESS (SPECTRUM)
											;REGISTER SELECT
						
		LD	   C,$DF							;LOW BYTE PORT ADDRESS (ZX81)
											;REGISTER SELECT
											;NEEDED TO SWAP ORDER AS ITS INSIDE A LOOP
     
		OUT     (C),A							;SELECT THE REGISTER TO WRITE TO
      
;		LD      B,$BF							;HIGH BYTE PORT ADDRESS (SPECTRUM)
											;DATA PORT
		
		LD	   C,$1F							;LOW BYTE PORT ADREESS (ZX81)
		OUTD    								;OUTPUT CONTENTS OF (HL) TO PORT (BC)
											;AND DECREMENT HL
		DEC     A								;DECREMENT REGISTER SELECTOR / COUNTER
		JP      P,AY_WRITE_LOOP					;IF NOT MINUS (HAS NOT ROLLED ROUND TO $ff, THEN GO ROUND AGAIN      
		RET     								;DONE FOR NOW

		

	.END