#include "main.h"

OamEntry oamShadow[128];

void VSync()
{
	while(REG_DISPSTAT & VBL_MASK);
	while(!(REG_DISPSTAT & VBL_MASK));
}

void MemSet(void *dest, u32 src, u16 size)
{
	u16 i;

	for(i = 0; i < (size >> 2); i++)
		*((u32*)dest++) = src;
	for(i = i << 2; i < size; i++)
		*((u8*)dest++) = (u8)src;
}

void Dma3(void *dest, const void *src, u32 count, u16 flags)
{
	REG_DM3SAD = (u32)src;
	REG_DM3DAD = (u32)dest;
	REG_DM3CNT_L = count;
	REG_DM3CNT_H = flags;
}

void CopyOAM()
{
	REG_DM0SAD = (u32)oamShadow;
	REG_DM0DAD = (u32)OAM_DATA;
	REG_DM0CNT_L = 256;
	REG_DM0CNT_H = DMA_MEMCPY;
}

void UnCompRLE(u16 *dest, u8 *src)
{
	u16 i, j, size = 0;
	u8 *dTemp = (u8*)0x2020000;

	for(i = 0; src[i] != 0; i++)
		for(j = 0; j < (src[i] >> 4); j++, size++)
			dTemp[size] = src[i] & 15;
	size >>= 2;
	for(i = 0; i < size; i++)
		dest[i] = (dTemp[i << 2] & 15) | 
			((dTemp[(i << 2) + 1] & 15) << 4) | 
			((dTemp[(i << 2) + 2] & 15) << 8) | 
			((dTemp[(i << 2) + 3] & 15) << 12);
}
