#    RiscLua84

-- local constants
local execute <const> in os
local name <const>, zero <const> = "^(.-)(%d+)$", "0"
local pad <const> = \ (s, n) local k <const> = #s
 => n > k and (zero:rep (n-k) .. s) or s end
local padz <const> = \ (x, n) =>
 (x:gsub (name,
  \(u, v) => u .. pad (v, n) end
 )) end
local here <const> = (arg[0]):gsub ("%.[^%.]+$", "")
local path <const> = here .. "."
local push <const> = \ (a, x) a[1 + #a] = x end
local run <const> = \ (a)
 for _,x in ipairs (a) do execute (x) end
 end
local list <const> = { push = push, run = run }
local cmd <const> = "rename %s %s"
local msg <const> = "%d name(s) padded."

-- main program
io.write [[Pad suffixes of filenames with leading zeros;
To what width (1 - 8)?]]
local n
repeat n = io.read "*n" until n > 0 and n <= 9
for leaf,_ in riscos.dir (here) do
  local newleaf = padz (leaf, n)
  if newleaf ~= leaf then
   list:push (cmd:format (path .. leaf, path .. newleaf))
  end
end
list:run ( )
print (msg:format (#list))
-- end main