; ------------------------------------------------------------------
; Toxic Bubbles
; Written by hitchhikr/Rebels
; ------------------------------------------------------------------

; ------------------------------------------------------------------
_LVOClearScreen         equ     -48
_LVODrawEllipse         equ     -180
_LVOInitRastPort        equ     -198
_LVOBltPattern          equ     -312

bitmap                  equ     0
rastport                equ     bitmap+48
ptr_bitmap              equ     rastport+4

; ------------------------------------------------------------------
                        section prog,code_c

; ------------------------------------------------------------------
start:
                        lea     $7000(a3),a4                    ; (a bit messy but it works)
                        lea		(a2),a3

                        move.l  4.w,a6
                        move.l  156(a6),a6
                        lea		(a3),a1
                        jsr     _LVOInitRastPort(a6)
                        ; (trashes a1)
                        lea		(a3),a1
                        lea     copperlist(pc),a2
                        move.l  a4,-(a7)                        ; frame buffer
                        swap    d4                              ; d4 is always 1
                        move.l  d4,-(a7)                        ; 1 bp
                        move.l  nasty-copperlist(a2),-(a7)      ; 48*386
                        move.l  a7,ptr_bitmap-rastport(a1)

                        jsr		_LVOClearScreen(a6)             ; (also clears the bubble pic)
                        moveq   #16,d0
                        move.w  #300+16,d1
                        move.w  d0,d2
                        move.w  d2,d3
                        jsr     _LVODrawEllipse(a6)

                        move.w  (a2),2(a7)                      ; change the size to 264 rows
                        moveq   #24-1,d7
                        moveq   #0,d1
set_bubbles_coords:
                        lea     $dff007,a5
                        add.b   (a5),d1
                        add.b   -(a5),d3
                        move.w  d3,-(a7)                        ; x
                        move.w  d1,-(a7)                        ; y
                        move.w  d1,-(a7)                        ; speed
                        dbf     d7,set_bubbles_coords

                        move.l  a2,$80-6(a5)
                        moveq   #384/8,d4                       ; 48

; ------------------------------------------------------------------
main_loop:
                        cmp.b   (a5),d4
                        bne.b   main_loop

                        move.l	8+(24*6)(a7),d0
                        add.w   #(4*48)-2,d0
                        move.l  d0,$e0-6(a5)
                        eor.w   #1,8+(24*6)(a7)                 ; ~$10000

                        jsr		_LVOClearScreen(a6)

                        lea     (a7),a2
                        moveq   #24-1,d7
display_bubbles:
                        ; speed/y/x
                        movem.w (a2)+,d0/d1/d2
                        and.w   #7,d0
                        addq.w  #1,d0
                        sub.w   d0,d1
                        cmp.w   #-32,d1
                        bgt.b   reset_bubble
                        lsr.w   #8,d1                           ; $00ff
reset_bubble:
                        move.w  d1,-4(a2)

                        lea     (48*300)(a4),a0                 ; bubble picture
                        move.w  d2,d0
                        add.w   #32+16,d2
                        move.w  d1,d3
                        add.w   #32,d3
                        jsr     _LVOBltPattern(a6)
                        ; (trashes a1)
                        lea		(a3),a1
                        dbf     d7,display_bubbles

                        bra.b   main_loop

; ------------------------------------------------------------------
copperlist:
                        ; 264
                        dc.w    $108,8
                        dc.w    $9a,$7fff,$96,$20
                        dc.w    $8e,$2c81,$90,$2cc1
                        dc.w    $92,$38,$94,$d0
                        dc.w    $1fc,0
                        dc.w    $100,$1200
                        dc.w    $180
                        ;48*386
nasty:                  dc.w    $030,$182
                        dc.w    $5c9
                        dc.w    -1
