/*
 * Decompiled with CFR 0.152.
 */
package k2dp;

import javax.microedition.lcdui.Graphics;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Light;
import javax.microedition.m3g.Loader;
import javax.microedition.m3g.Mesh;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.World;
import k2dp.Const;
import k2dp.Effect3D;
import k2dp.MiniFontPlotter;

public class Donut
implements Effect3D {
    public float circadd = -0.05f;
    public float crotadd = 1.23f;
    public float rotCubeadd = 2.2f;
    public float rotStaradd = -1.8f;
    public float intensity = 1.3f;
    public float fadeAim = 0.3f;
    public float fadeFac = 0.01f;
    Transform camTx = new Transform();
    Transform lightTx = new Transform();
    Transform starTx = new Transform();
    Transform cubeTx = new Transform();
    World world;
    Camera cam;
    Light light;
    Mesh star;
    Mesh cube;
    MiniFontPlotter miniFont;
    float circ = 0.0f;
    float left;
    float crot = 0.0f;
    float starScale = 0.0f;
    float rotCube = 0.0f;
    float rotStar = 0.0f;

    public Donut(int width, int height, MiniFontPlotter miniFont) throws Exception {
        this.miniFont = miniFont;
        this.world = (World)Loader.load((String)"/donut.m3g")[0];
        this.cam = this.world.getActiveCamera();
        this.light = (Light)this.world.find(3);
        this.star = (Mesh)this.world.find(11);
        this.cube = (Mesh)this.world.find(10);
        this.cam.getTransform(this.camTx);
        Const.printTx(this.camTx);
        this.world.removeChild((Node)this.cube);
        this.world.removeChild((Node)this.star);
        this.cam = new Camera();
        this.cam.setPerspective(60.0f, (float)width / (float)height, 0.1f, 100.0f);
        Const.printTx(this.camTx);
        this.world.addChild((Node)this.cam);
        this.world.setActiveCamera(this.cam);
    }

    public void paint(Graphics3D g3d) {
        if (this.intensity > this.fadeAim) {
            this.intensity -= this.fadeFac;
        }
        if (this.intensity < this.fadeAim) {
            this.intensity += this.fadeFac;
        }
        this.left = 100.0f - this.circ / Const.PI * 180.0f;
        this.camTx.setIdentity();
        this.camTx.postTranslate((float)Math.sin(this.circ) * 3.5f, (float)Math.cos(this.circ) * 3.5f, 0.0f);
        this.camTx.postRotate(90.0f, 1.0f, 0.0f, 0.0f);
        this.camTx.postRotate(this.left, 0.0f, 1.0f, 0.0f);
        this.camTx.postRotate(this.crot, 0.0f, 0.0f, 1.0f);
        this.cam.setTransform(this.camTx);
        this.cubeTx.setIdentity();
        this.cubeTx.postTranslate((float)Math.sin((double)this.circ - 0.45) * 3.5f, (float)Math.cos((double)this.circ - 0.45) * 3.5f, 0.0f);
        this.cubeTx.postRotate(this.rotCube, 0.5f, 0.7f, 0.3f);
        this.cube.setTransform(this.cubeTx);
        this.starTx.setIdentity();
        this.starTx.postTranslate((float)Math.sin((double)this.circ - 0.45) * 3.5f, (float)Math.cos((double)this.circ - 0.45) * 3.5f, 0.0f);
        this.cubeTx.postRotate(this.rotStar, 0.5f, 0.7f, 0.3f);
        this.starTx.postScale(this.starScale, this.starScale, this.starScale);
        this.star.setTransform(this.starTx);
        this.lightTx.setIdentity();
        this.lightTx.postTranslate((float)Math.sin((double)this.circ - 0.05) * 3.5f, (float)Math.cos((double)this.circ - 0.05) * 3.5f, 0.0f);
        this.light.setTransform(this.lightTx);
        this.light.setIntensity(this.intensity);
        this.circ += this.circadd;
        this.crot += this.crotadd;
        this.rotCube += this.rotCubeadd;
        this.rotStar += this.rotStar;
        this.starScale = ((float)Math.sin(this.circ) + 1.0f) / 2.0f;
        g3d.render(this.world);
    }

    public void paint2D(Graphics g) {
        this.miniFont.paint2D(g);
    }

    public void setEffect(int i) {
        switch (i) {
            case -1: {
                this.circadd = 0.0f;
                this.crotadd = 1.23f;
                this.rotCubeadd = 2.2f;
                this.rotStaradd = -1.8f;
                this.intensity = 1.3f;
                this.fadeAim = 0.3f;
                this.fadeFac = 0.01f;
                break;
            }
            case 0: {
                this.circadd = 0.0f;
                this.crotadd = 0.0f;
                this.rotCubeadd = 0.0f;
                this.rotStaradd = 0.0f;
                this.intensity = 0.3f;
                this.fadeAim = 0.3f;
                break;
            }
            case 1: {
                this.circadd = -0.05f;
                this.fadeAim = 0.1f;
                this.fadeFac = 0.01f;
                break;
            }
            case 2: {
                this.world.addChild((Node)this.star);
                this.world.addChild((Node)this.cube);
                this.circadd = -0.05f;
                this.fadeAim = 0.3f;
                this.fadeFac = 0.01f;
                break;
            }
            case 3: {
                this.circadd = -0.05f;
                this.fadeAim = 1.0f;
                this.fadeFac = 0.01f;
            }
        }
    }
}

