float4x4 matWorldViewProjection;
float4x4 matWorld; 

float3 CameraPosition = {0.f, 0.f, 0.f};
float alpha = 1.f;
texture tex0; 

sampler2D diffuse = sampler_state
{
	texture = (tex0);
	MipFilter = Linear; MagFilter = Linear; MinFilter = Linear;
	AddressU = Wrap; AddressV = Wrap; 
};

void vs_bumpgrid(in float4 ipos : POSITION,
				 in float3 inorm : NORMAL,
				 in float2 itex : TEXCOORD0,
				 out float4 opos : POSITION,
				 out float3 onorm : TEXCOORD0,
				 out float2 otex : TEXCOORD1,
				 out float3 lightvec : TEXCOORD2)
{
	opos = mul(ipos, matWorldViewProjection);
	float3 pos = mul(float4(ipos.xyz, 1.f), matWorld);
	lightvec = normalize( CameraPosition - pos); 
	otex = itex; 
	onorm = inorm;
};

float4 ps_bumpgrid(in float3 norm : TEXCOORD0,
				   in float2 tex : TEXCOORD1,
				   in float3 lightvec : TEXCOORD2) : COLOR0
{

	float ndotl = abs(dot(norm, lightvec));
	
	//return float4(norm.rgb, 1.f);
	float4 a = tex2D(diffuse, tex); 
	return float4(ndotl*a.rgb,alpha); 
};

technique bumpgrid
{
	pass ndotla
	{
		VertexShader = compile vs_2_0 vs_bumpgrid();
		PixelShader  = compile ps_2_0 ps_bumpgrid(); 
	}
};