float4x4 matWorldViewProjection; 

float3 LightPosition = {0.f, 0.f, 0.f};
texture tex0; 
float fade = 1.f; 

sampler2D ao = sampler_state
{
	texture = (tex0);
	MipFilter = Linear; MagFilter = Linear; MinFilter = Linear;
	AddressU = Wrap; AddressV = Wrap;
};

void vs_plain(in float4 ipos : POSITION,
			  in float3 inorm : NORMAL,
			  in float2 itex : TEXCOORD0,
			  out float4 opos : POSITION,
			  out float3 onorm : TEXCOORD0,
			  out float2 otex : TEXCOORD1,
			  out float3 ligthvec : TEXCOORD2)
{
	opos = mul(ipos, matWorldViewProjection);
	otex = itex;
	onorm = inorm; 
	ligthvec = normalize(LightPosition - ipos.xyz); 
};

float4 ps_plain() : COLOR0
{
	return float4(0.f, 0.f, 0.f, 0.f);
};

float4 ps_ao_diffuse(in float3 norm : TEXCOORD0,
					 in float2 tex : TEXCOORD1,
					 in float3 light : TEXCOORD2) : COLOR0
{
	float4 ao = tex2D(ao, tex);
	float ndotl = dot(norm, light);
	return ao*ndotl*fade; 
};

technique ao_diff
{
	pass plain 
	{
		vertexshader  = compile vs_2_0 vs_plain();
		pixelshader   = compile ps_2_0 ps_plain();
	}

	pass ao_diff
	{
		vertexshader = compile vs_2_0 vs_plain();
		pixelshader  = compile ps_2_0 ps_ao_diffuse();
	}
}

