float4x4 matWorldViewProjection; 
float alpha = 1.f;

texture tex0; 
sampler2D base = sampler_state
{
	texture = (tex0);
	MipFilter = Linear; MagFilter = Linear; MinFilter = Linear;
	AddressU = Wrap; AddressV = Wrap;
};

void vs_sky(in float4 ipos : POSITION,
			in float2 itex : TEXCOORD0,
			out float4 opos : POSITION,
			out float2 otex : TEXCOORD0)
{
	opos = mul(ipos, matWorldViewProjection);
	otex = itex; 
}

float4 ps_sky(in float2 tex : TEXCOORD0) : COLOR0
{
	float4 a = tex2D(base, tex);
	return float4(a.rgb, 1.f-a.r);
};

technique sky
{
	pass base
	{
		VertexShader = compile vs_2_0 vs_sky();
		PixelShader  = compile ps_2_0 ps_sky();
	}
}