/*
 * Decompiled with CFR 0.152.
 */
package RMI;

import RMI.playerRMIIF;
import common.timer;
import java.net.InetAddress;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;

public class RMIClient {
    Registry registry;
    playerRMIIF rmiServer = null;

    public void connect() {
        if (this.rmiServer == null) {
            return;
        }
        try {
            this.rmiServer.connect();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void disconnect() {
        if (this.rmiServer == null) {
            return;
        }
        try {
            this.rmiServer.disconnect();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setScene(int which) {
        if (this.rmiServer == null) {
            return;
        }
        timer mytimer = new timer();
        mytimer.getTime();
        System.out.println("RMI setting scene:" + which);
        try {
            this.rmiServer.setScene(which);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("time:" + mytimer.getTime());
    }

    public int addLayer(String name) {
        if (this.rmiServer == null) {
            return -1;
        }
        timer mytimer = new timer();
        System.out.println("time:" + mytimer.getTime());
        System.out.println("RMI adding layer:" + name);
        int r = -1;
        try {
            r = this.rmiServer.addLayer(name);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("RMI layer got id:" + r);
        System.out.println("time:" + mytimer.getTime());
        return r;
    }

    public void removeLayerID(int which) {
        if (this.rmiServer == null) {
            return;
        }
        timer mytimer = new timer();
        System.out.println("time:" + mytimer.getTime());
        System.out.println("RMI removing layer:" + which);
        try {
            this.rmiServer.removeLayerID(which);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("time:" + mytimer.getTime());
    }

    public void moveLayer(int which, int newpos) {
        if (this.rmiServer == null) {
            return;
        }
        timer mytimer = new timer();
        System.out.println("time:" + mytimer.getTime());
        System.out.println("RMI moving layer:" + which + " to " + newpos);
        try {
            this.rmiServer.moveLayer(which, newpos);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("time:" + mytimer.getTime());
    }

    public String getMyNet() {
        String ipPrefix = "127.0.0.1";
        try {
            InetAddress localaddr = InetAddress.getLocalHost();
            System.out.println("main Local IP Address : " + localaddr.getHostAddress());
            System.out.println("main Local hostname   : " + localaddr.getHostName());
            System.out.println();
            String localip = localaddr.getHostAddress();
            int p = localip.lastIndexOf(".");
            ipPrefix = localip.substring(0, p + 1);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return ipPrefix;
    }

    public void connect(String host) {
        int port = 1111;
        try {
            this.registry = LocateRegistry.getRegistry(host, port);
            this.rmiServer = (playerRMIIF)this.registry.lookup("playerRMI");
            this.rmiServer.connect();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }
}

