/*
 * Decompiled with CFR 0.152.
 */
package g3d;

import g3d.g3d_loading;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import opengl.common;
import org.lwjgl.opengl.GL11;

public final class g3d_globals {
    public static long currentTime = 0L;
    public static int screenheight = 384;
    public static int screenWidth = 512;
    public static boolean running = true;
    public static int multisampling = 2;
    public static boolean drawDebugShit = false;
    private static int frames = 0;
    public static int fps = 0;
    private static long fpsStart = 0L;

    public static void nextFrame() {
        currentTime = common.getCurrentTimeMillis();
        if (currentTime > fpsStart + 1000L || fpsStart == 0L) {
            fps = frames;
            fpsStart = currentTime;
            frames = 0;
        }
        ++frames;
    }

    public static boolean loadFileHttp(String filename) {
        g3d_loading loadProcess = new g3d_loading(3, 2);
        try {
            int i;
            URL url = new URL("http://oslo068.server4you.de/3dworld/" + filename);
            URLConnection connection2 = url.openConnection();
            int fileLengthb = Integer.parseInt(connection2.getHeaderField("Content-Length"));
            InputStream stream = connection2.getInputStream();
            BufferedInputStream in = new BufferedInputStream(stream);
            FileOutputStream file = new FileOutputStream("data/" + filename);
            BufferedOutputStream out = new BufferedOutputStream(file);
            long start = common.getCurrentTimeMillis();
            int count = 0;
            while ((i = in.read()) != -1) {
                if (++count % 1000 == 0) {
                    loadProcess.draw((float)count / (float)fileLengthb);
                }
                out.write(i);
            }
            out.flush();
            int filelengthkb = fileLengthb / 1024;
            float downloadtime = (float)(common.getCurrentTimeMillis() - start) / 1000.0f;
            float kbs = (float)filelengthkb / downloadtime;
        }
        catch (Exception e) {
            System.out.println(e);
            System.out.println("(" + filename + ") could not download file...!!");
        }
        return true;
    }

    public static String checkForFile(String fn) {
        boolean exists = new File("data").exists();
        if (!exists) {
            System.out.println("no data dir... trying to create data dir...");
            boolean success = new File("data").mkdirs();
            if (!success) {
                System.out.println("creating data dir FAILED...");
            }
        }
        if (!(exists = new File("data/" + fn).exists())) {
            System.out.println("(" + fn + ") file does not exits, trying download...");
            g3d_globals.loadFileHttp(fn);
        }
        return "data/" + fn;
    }

    public static int createTexture(int size) {
        IntBuffer buf = ByteBuffer.allocateDirect(4).order(ByteOrder.nativeOrder()).asIntBuffer();
        GL11.glGenTextures(buf);
        GL11.glBindTexture(3553, buf.get(0));
        ByteBuffer bb = ByteBuffer.allocateDirect(size * size * 4);
        GL11.glTexParameteri(3553, 10241, 9729);
        GL11.glTexParameteri(3553, 10240, 9729);
        GL11.glTexImage2D(3553, 0, 6408, size, size, 0, 6408, 5121, bb);
        return buf.get(0);
    }
}

