/*
 * Decompiled with CFR 0.152.
 */
package opengl;

import gui.guilayer;
import gui.mainwindow;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import javax.imageio.ImageIO;
import opengl.openglfont;
import org.lwjgl.Sys;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.Pbuffer;
import org.lwjgl.opengl.glu.GLU;
import resource.resource_pbuffer;
import resource.resource_texture;
import resource.resourcemanager;
import scene.layerIF;
import scene.sceneIF;

public class common {
    public static float currentTime = 0.0f;
    public static boolean guimode = false;
    public static resourcemanager resman = new resourcemanager();
    public static int currentContextHeight = 384;
    public static int currentContextWidth = 512;
    public static int currentscene = 0;
    public static int pBufferWidth = 512;
    public static int pBufferHeight = 512;
    public static float fakeMS = 1.5f;
    public static int multisampling = 4;
    public static int bpp = 24;
    public static int alpha = 8;
    public static int depth = 16;
    public static int stencil = 8;
    public static int numScenes = 32;
    public static sceneIF[] scenes = null;
    public static layerIF controlPlug = null;
    public static Pbuffer pbuffer;
    public static boolean synchtoTimeline;
    public static boolean rendertoImages;
    public static openglfont font;
    private static final Color OPAQUE_WHITE;
    private static final Color OPAQUE_VSYS;
    private static final Color TRANSPARENT_BLACK;

    static {
        synchtoTimeline = true;
        rendertoImages = false;
        font = null;
        OPAQUE_WHITE = new Color(-1, true);
        OPAQUE_VSYS = new Color(-39424, true);
        TRANSPARENT_BLACK = new Color(0, true);
    }

    public static void initTextures() {
        font = new openglfont();
    }

    public static long getCurrentTimeMillis() {
        if (currentTime <= 0.0f) {
            return 0L;
        }
        if (synchtoTimeline) {
            return (long)(currentTime * 1000.0f);
        }
        return Sys.getTime();
    }

    public static void makeDisplayCurrent() {
        try {
            if (guimode) {
                mainwindow.canvas1.makeCurrent();
            } else {
                Display.makeCurrent();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setControlPlug(layerIF l) {
        if (guimode) {
            mainwindow.mycontrolpanel.setLayer((guilayer)l);
        }
        controlPlug = l;
    }

    public static void setControlPlug(String plugname) {
        controlPlug = new guilayer(plugname, plugname, true);
        if (guimode) {
            mainwindow.mycontrolpanel.setLayer((guilayer)controlPlug);
        }
    }

    public static int createTexture(int width, int height, boolean rgba) {
        int bytepp = 4;
        if (!rgba) {
            bytepp = 3;
        }
        IntBuffer buf = ByteBuffer.allocateDirect(4).order(ByteOrder.nativeOrder()).asIntBuffer();
        GL11.glGenTextures(buf);
        GL11.glBindTexture(34037, buf.get(0));
        ByteBuffer bb = ByteBuffer.allocateDirect(width * height * bytepp);
        GL11.glTexParameteri(34037, 10241, 9729);
        GL11.glTexParameteri(34037, 10240, 9729);
        int rgbamode = 6408;
        if (!rgba) {
            rgbamode = 6407;
        }
        GL11.glTexImage2D(34037, 0, rgbamode, width, height, 0, 6408, 5121, bb);
        return buf.get(0);
    }

    public static void init() {
        resman.add(new resource_pbuffer("pbuffer", (int)((float)currentContextWidth * fakeMS), (int)((float)currentContextHeight * fakeMS), true));
        resman.add(new resource_pbuffer("pbuffer2", (int)((float)currentContextWidth * fakeMS), (int)((float)currentContextHeight * fakeMS), true));
        resman.add(new resource_pbuffer("pbuffer3", (int)((float)currentContextWidth * fakeMS), (int)((float)currentContextHeight * fakeMS), true));
        resman.add(new resource_pbuffer("pbuffer4", 64, 16, true));
    }

    public static void switchTo2d() {
        common.switchTo2d(currentContextWidth, currentContextHeight);
    }

    public static void switchTo2d(int width, int height) {
        GL11.glMatrixMode(5889);
        GL11.glPushMatrix();
        GLU.gluPerspective(45.0f, (float)width / (float)width, 0.1f, 100000.0f);
        GL11.glLoadIdentity();
        GLU.gluOrtho2D(0.0f, width, 0.0f, height);
        GL11.glMatrixMode(5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
    }

    public static void switchTo2dd() {
        common.switchTo2dd(currentContextWidth, currentContextHeight);
    }

    public static void switchTo2dd(int width, int height) {
        GL11.glMatrixMode(5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GLU.gluOrtho2D(0.0f, width, height, 0.0f);
        GL11.glMatrixMode(5888);
        GL11.glPushMatrix();
    }

    public static void switchTo3d() {
        GL11.glDisable(3553);
        GL11.glDisable(3042);
        GL11.glMatrixMode(5889);
        GL11.glPopMatrix();
        GL11.glMatrixMode(5888);
        GL11.glPopMatrix();
        GL11.glEnable(2929);
    }

    public static void glInit(int width, int height) {
        GL11.glEnable(3553);
        GL11.glShadeModel(7425);
        GL11.glClearDepth(11.0);
        GL11.glEnable(2929);
        GL11.glDepthFunc(515);
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        GLU.gluPerspective(45.0f, (float)width / (float)height, 0.1111f, 100000.0f);
        GL11.glMatrixMode(5888);
        GL11.glHint(3152, 4354);
    }

    public static void drawquad(float x, float y, float width, float height) {
        float xc = (float)currentContextWidth / 1024.0f;
        float yc = (float)currentContextHeight / 768.0f;
        int cx = (int)(x * xc);
        int cy = (int)(y * yc);
        width *= xc;
        GL11.glBegin(7);
        GL11.glTexCoord2f(0.0f, 1.0f);
        GL11.glVertex2f(cx, cy);
        GL11.glTexCoord2f(0.0f, 0.0f);
        GL11.glVertex2f(cx, (float)cy + (height *= xc));
        GL11.glTexCoord2f(1.0f, 0.0f);
        GL11.glVertex2f((float)cx + width, (float)cy + height);
        GL11.glTexCoord2f(1.0f, 1.0f);
        GL11.glVertex2f((float)cx + width, cy);
        GL11.glEnd();
    }

    public static void screenShot(int width, int height) {
        System.out.println("width:" + width);
        ByteBuffer fb = ByteBuffer.allocateDirect(width * height * 3);
        int[] pixels = new int[width * height];
        GL11.glReadPixels(0, 0, width, height, 6407, 5121, fb);
        int i = 0;
        while (i < pixels.length) {
            int bindex = i * 3;
            pixels[i] = (fb.get(bindex) << 16) + (fb.get(bindex + 1) << 8) + (fb.get(bindex + 2) << 0);
            ++i;
        }
        try {
            BufferedImage image = new BufferedImage(width, height, 1);
            image.setRGB(0, 0, width, height, pixels, 0, width);
            image = common.flipImage(image);
            String filename = String.valueOf(System.getProperty("user.home")) + "/bla" + System.currentTimeMillis() + ".png";
            System.out.println("screenshot: " + filename);
            ImageIO.write((RenderedImage)image, "png", new File(filename));
        }
        catch (Exception e) {
            System.out.println("ScreenShot() exception: " + e);
        }
    }

    public static BufferedImage flipImage(BufferedImage bi) {
        AffineTransform tx = AffineTransform.getScaleInstance(1.0, -1.0);
        tx.translate(0.0, -bi.getHeight());
        AffineTransformOp op = new AffineTransformOp(tx, 1);
        bi = op.filter(bi, null);
        return bi;
    }

    public static void createEmptyTexture() {
        Font myfont = new Font("Verdana", 0, 90);
        BufferedImage fontImage = new BufferedImage(256, 256, 6);
        Graphics2D g = (Graphics2D)fontImage.getGraphics();
        g.setFont(myfont);
        g.setColor(OPAQUE_WHITE);
        g.setBackground(TRANSPARENT_BLACK);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        FontMetrics fm = g.getFontMetrics();
        g.fillRoundRect(0, 0, fontImage.getWidth() - 1, fontImage.getHeight() - 1, 30, 30);
        g.setColor(OPAQUE_VSYS);
        g.drawString("vsys", 20, 100);
        ByteBuffer scratch = ByteBuffer.allocateDirect(4 * fontImage.getWidth() * fontImage.getHeight());
        byte[] data = (byte[])fontImage.getRaster().getDataElements(0, 0, fontImage.getWidth(), fontImage.getHeight(), null);
        scratch.clear();
        scratch.put(data);
        scratch.rewind();
        IntBuffer buf = ByteBuffer.allocateDirect(4).order(ByteOrder.nativeOrder()).asIntBuffer();
        GL11.glGenTextures(buf);
        GL11.glBindTexture(3553, buf.get(0));
        GL11.glTexParameteri(3553, 10241, 9729);
        GL11.glTexParameteri(3553, 10240, 9729);
        GL11.glTexImage2D(3553, 0, 6408, fontImage.getWidth(), fontImage.getHeight(), 0, 6408, 5121, scratch);
        resource_texture r = new resource_texture("_vsys_emptytexture", fontImage.getWidth(), fontImage.getHeight(), true);
        r.setID(buf.get(0));
        r.setFilename("_vsys_emptytexture");
        resman.add(r);
    }

    public static String getShaderDir() {
        return "c:/demo/shader/";
    }
}

