/*
 * Decompiled with CFR 0.152.
 */
package opengl;

import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

public class fbo {
    int frameBuffer;
    public int texture;
    public int texture2;
    int colorAttachment = -1;
    boolean _attachTexture = false;

    public fbo(int which, boolean attachTexture) {
        this._attachTexture = attachTexture;
        this.colorAttachment = which;
        IntBuffer ib_fb = BufferUtils.createIntBuffer(1);
        IntBuffer ib_tex = BufferUtils.createIntBuffer(1);
        IntBuffer ib_tex2 = BufferUtils.createIntBuffer(1);
        EXTFramebufferObject.glGenFramebuffersEXT(ib_fb);
        if (this._attachTexture) {
            GL11.glGenTextures(ib_tex);
        }
        if (this._attachTexture) {
            GL11.glGenTextures(ib_tex2);
        }
        this.frameBuffer = ib_fb.get(0);
        this.texture = ib_tex.get(0);
        this.texture2 = ib_tex2.get(0);
        if (this._attachTexture) {
            GL11.glBindTexture(3553, this.texture);
            GL11.glTexParameteri(3553, 10241, 9729);
            GL11.glTexParameteri(3553, 10240, 9729);
            GL11.glTexImage2D(3553, 0, 6408, 1024, 1024, 0, 6408, 5121, null);
            GL11.glBindTexture(3553, 0);
            GL11.glBindTexture(3553, this.texture2);
            GL11.glTexParameteri(3553, 10241, 9729);
            GL11.glTexParameteri(3553, 10240, 9729);
            GL11.glTexImage2D(3553, 0, 6408, 1024, 1024, 0, 6408, 5121, null);
            GL11.glBindTexture(3553, 0);
        }
        this.bind();
        this.checkFrameBufferStatus();
        this.unbind();
    }

    void checkFrameBufferStatus() {
        int er = EXTFramebufferObject.glCheckFramebufferStatusEXT(36160);
        switch (er) {
            case 36053: {
                System.out.println("framebuffer complete...");
                break;
            }
            case 36054: {
                throw new RuntimeException("FrameBuffer: " + this.frameBuffer + ", has caused a GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT exception");
            }
            case 36055: {
                throw new RuntimeException("FrameBuffer: " + this.frameBuffer + ", has caused a GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT exception");
            }
            case 36057: {
                throw new RuntimeException("FrameBuffer: " + this.frameBuffer + ", has caused a GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT exception");
            }
            case 36059: {
                throw new RuntimeException("FrameBuffer: " + this.frameBuffer + ", has caused a GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT exception");
            }
            case 36058: {
                throw new RuntimeException("FrameBuffer: " + this.frameBuffer + ", has caused a GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT exception");
            }
            case 36060: {
                throw new RuntimeException("FrameBuffer: " + this.frameBuffer + ", has caused a GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT exception");
            }
            default: {
                throw new RuntimeException("Unexpected reply from glCheckFramebufferStatusEXT: " + er);
            }
        }
    }

    public void bind() {
        EXTFramebufferObject.glBindFramebufferEXT(36160, this.frameBuffer);
        if (this._attachTexture) {
            EXTFramebufferObject.glFramebufferTexture2DEXT(36160, 36064, 3553, this.texture, 0);
            EXTFramebufferObject.glFramebufferTexture2DEXT(36160, 36065, 3553, this.texture2, 0);
        }
        GL11.glPushAttrib(2048);
        GL11.glViewport(0, 0, 1024, 1024);
        GL11.glClear(16384);
        IntBuffer ib = BufferUtils.createIntBuffer(2);
        ib.put(0, 36064);
        ib.put(1, 36065);
        GL20.glDrawBuffers(ib);
    }

    public void unbind() {
        EXTFramebufferObject.glBindFramebufferEXT(36160, 0);
        GL11.glPopAttrib();
    }
}

