/*
 * Decompiled with CFR 0.152.
 */
package opengl;

import common.timer;
import g3d.g3d_loading;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Vector;
import opengl.common;
import org.lwjgl.input.Cursor;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.PixelFormat;
import resource.resourceIF;
import scene.scene;

public class lwjglwindow {
    static DisplayMode[] modes;
    DisplayMode mode;
    int screenWidth = 0;
    int screenHeight = 0;
    public String infotxt = "";
    boolean vsynch = false;
    boolean fullscreen = false;
    int frames = 0;
    int fps = -1;
    long fpsstart;
    int hz = 60;
    int multis = 0;
    public boolean showcursor = false;
    long lastSpace = 0L;
    g3d_loading load = new g3d_loading();
    timer mytime = new timer();
    boolean pause = false;
    public boolean displayInfo = false;
    static int mem;
    public static int mouseX;
    public static int mouseY;

    static {
        mem = 0;
        mouseX = 0;
        mouseY = 0;
    }

    public lwjglwindow(int m, boolean _fullscreen, int ms, boolean _vsynch) {
        try {
            this.mode = Display.getAvailableDisplayModes()[m];
            Display.setDisplayMode(this.mode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.multis = ms;
        this.screenWidth = this.mode.getWidth();
        this.screenHeight = this.mode.getHeight();
        common.currentContextHeight = this.mode.getHeight();
        common.currentContextWidth = this.mode.getWidth();
        this.hz = this.mode.getFrequency();
        this.vsynch = _vsynch;
        this.fullscreen = _fullscreen;
        System.out.println("screenHeight" + this.screenHeight);
        System.out.println("screenWidth" + this.screenWidth);
    }

    public lwjglwindow(int _screenWidth, int _screenHeight, boolean _vsynch, boolean _fullscreen) {
        this.screenWidth = _screenWidth;
        this.screenHeight = _screenHeight;
        this.fullscreen = _fullscreen;
        this.vsynch = _vsynch;
    }

    public boolean renderScene(scene s) {
        mouseX = Mouse.getX();
        mouseY = Mouse.getY();
        if (!common.resman.allloaded) {
            System.out.println("NOT LOADED RESOURCES");
            Vector l = common.resman.getAllResources();
            int i = 0;
            while (i < l.size()) {
                resourceIF r = (resourceIF)l.get(i);
                if (!r.loaded()) {
                    System.out.println(String.valueOf(r.getTitle()));
                    r.load();
                    float f = (float)i / (float)l.size();
                    GL11.glClear(16640);
                    this.load.draw(f);
                    Display.update();
                }
                ++i;
            }
            common.resman.allloaded = true;
            System.gc();
        }
        if (Display.isCloseRequested()) {
            return false;
        }
        if (Keyboard.isKeyDown(1)) {
            return false;
        }
        common.glInit(common.currentContextWidth, common.currentContextHeight);
        GL11.glClearDepth(111.0);
        GL11.glClear(16640);
        GL11.glEnable(2929);
        GL11.glDisable(3042);
        GL11.glDisable(3553);
        GL11.glLoadIdentity();
        s.render();
        this.displayInfo = true;
        ++this.frames;
        if (System.currentTimeMillis() > this.fpsstart + 1000L) {
            this.fpsstart = System.currentTimeMillis();
            this.fps = this.frames;
            this.frames = 0;
            System.out.println("fps:" + this.fps);
            if (this.displayInfo) {
                mem = (int)((Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L);
            }
        }
        if (this.displayInfo) {
            GL11.glLoadIdentity();
            GL11.glClear(256);
            common.switchTo2dd();
            GL11.glLoadIdentity();
            GL11.glDisable(2884);
            GL11.glDisable(2896);
            GL11.glDisable(2929);
            GL11.glDisable(3553);
            GL11.glDisable(2903);
            GL11.glEnable(3042);
            GL11.glBlendFunc(770, 771);
            int posx = 0;
            int posy = common.currentContextHeight - 45;
            int width = common.currentContextWidth;
            int height = 50;
            GL11.glBegin(7);
            GL11.glColor4f(0.0f, 0.0f, 0.0f, 0.7f);
            GL11.glVertex2i(posx, posy);
            GL11.glVertex2i(posx + width, posy);
            GL11.glVertex2i(posx + width, posy + height);
            GL11.glVertex2i(posx, posy + height);
            GL11.glEnd();
            GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            if (common.font == null) {
                common.initTextures();
            }
            common.font.print(10, common.currentContextHeight - 20, String.valueOf(this.fps) + " fps      time: " + common.currentTime + " ");
            common.font.print(10, common.currentContextHeight - 40, this.infotxt);
            common.font.print(200, common.currentContextHeight - 40, "" + mem);
            common.switchTo3d();
        }
        Display.update();
        return true;
    }

    public void open() {
        try {
            Display.setVSyncEnabled(this.vsynch);
            Display.create(new PixelFormat(32, 8, 16, 8, this.multis));
            this.mode = lwjglwindow.findDisplayMode(this.screenWidth, this.screenHeight, 24, this.hz);
            if (this.mode == null) {
                System.out.println("no displaymode found");
                System.exit(1);
            }
            common.glInit(this.screenWidth, this.screenHeight);
            Display.setFullscreen(this.fullscreen);
            common.currentContextWidth = this.mode.getWidth();
            common.currentContextHeight = this.mode.getHeight();
            Keyboard.create();
            Mouse.create();
            if (!this.showcursor) {
                IntBuffer ibuf = ByteBuffer.allocateDirect(4).asIntBuffer();
                Cursor cursor = new Cursor(1, 1, 0, 0, 1, ibuf, null);
                Mouse.setNativeCursor(cursor);
            }
            System.out.println("Display version: " + Display.getVersion());
            System.out.println("Display adapter: " + Display.getAdapter());
            Display.setTitle(String.valueOf(Display.getDisplayMode().getWidth()) + "x" + Display.getDisplayMode().getHeight() + " " + Display.getDisplayMode().getBitsPerPixel() + "bpp " + " / vsynch: " + this.vsynch + " / aa: " + this.multis + "x ");
        }
        catch (Exception e) {
            System.out.println("exeption: " + e);
            e.printStackTrace();
        }
    }

    public void close() {
        try {
            Display.destroy();
        }
        catch (Exception e) {
            System.out.println("exeption: " + e);
            e.printStackTrace();
        }
    }

    public static DisplayMode findDisplayMode(int width, int height, int bpp, int hz) {
        try {
            modes = Display.getAvailableDisplayModes();
            Display.setTitle("demo");
            int i = 0;
            while (i < modes.length) {
                if (modes[i].getWidth() == width && modes[i].getHeight() == height && modes[i].getBitsPerPixel() >= bpp && modes[i].getFrequency() == hz) {
                    try {
                        Display.setDisplayMode(modes[i]);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return modes[i];
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return null;
    }
}

