/*
 * Decompiled with CFR 0.152.
 */
package plugins.boid_lines;

import java.util.ArrayList;
import java.util.Random;
import plugins.boid_lines.boid;
import vsysTypes.vBool;
import vsysTypes.vKFFloat;

public class flock {
    ArrayList<boid> boids = new ArrayList();
    public boolean destroy;
    public float velo_limit;
    public float radius;
    float[] target = new float[3];

    flock(int num) {
        int i = 0;
        while (i < num) {
            this.boids.add(i, new boid(i));
            ++i;
        }
        Random r = new Random();
        this.target[0] = r.nextFloat();
        this.target[0] = r.nextFloat();
        this.target[0] = r.nextFloat();
    }

    public void setVelocity(vKFFloat velocity) {
        this.velo_limit = velocity.getKeyframedFloatValue() / 10.0f;
    }

    public void setRadius(vKFFloat radius) {
        this.radius = radius.getKeyframedFloatValue() * 10.0f;
    }

    public void update(vBool destroy, vBool turn) {
        float m1 = 1.0f;
        float m2 = 1.0f;
        float m3 = 1.0f;
        if (destroy.getValue()) {
            m1 = -1000.0f;
        }
        if (turn.getValue()) {
            this.setNewRandomTarget();
            turn.setValue(false);
        }
        int i = 0;
        while (i < this.boids.size()) {
            boid b = this.boids.get(i);
            float[] velo = new float[3];
            if ((velo = b.vectorAdd(velo, b.vectorMultiply(b.moveTowards(this), m1))) == this.getCenter()) {
                this.setNewRandomTarget();
            }
            velo = b.vectorAdd(velo, b.vectorMultiply(b.moveAway(this), m2));
            velo = b.vectorAdd(velo, b.vectorMultiply(b.matchSpeed(this), m3));
            velo = b.vectorAdd(velo, b.getVelocity());
            velo = b.vectorAdd(velo, b.moveToTarget(this.target));
            b.setVelocity(velo, this.velo_limit);
            b.setPosition(b.vectorAdd(b.getPosition(), b.getVelocity()));
            ++i;
        }
    }

    public void addBoids(int num) {
        int i = 0;
        while (i < num) {
            this.boids.add(new boid(this.boids.size() + 1));
            ++i;
        }
    }

    public void removeBoids(int num) {
        int i = 0;
        while (i < num) {
            this.boids.remove(this.boids.size() - 1);
            ++i;
        }
    }

    public void setNewRandomTarget() {
        Random r = new Random();
        this.target[0] = r.nextFloat() * 4.0f;
        this.target[1] = r.nextFloat() * 4.0f;
        this.target[2] = r.nextFloat() * 4.0f;
    }

    public float[] getCenter() {
        float[] pc = new float[3];
        int i = 0;
        while (i < this.boids.size()) {
            boid b = this.boids.get(i);
            pc = b.vectorAdd(pc, b.getPosition());
            ++i;
        }
        pc = this.vectorDiv(pc, this.boids.size() - 1);
        return pc;
    }

    public float[] vectorDiv(float[] v1, int div) {
        float[] v = new float[]{v1[0] / (float)div, v1[1] / (float)div, v1[2] / (float)div};
        return v;
    }
}

