/*
 * Decompiled with CFR 0.152.
 */
package plugins.boids;

import org.lwjgl.opengl.GL11;
import plug.plugin;
import plug.pluginIF;
import plugins.boids.boid;
import plugins.boids.flock;
import resource.resource_textureFile;
import vsysTypes.vBool;
import vsysTypes.vKFFloat;
import vsysTypes.vKFInt;
import vsysTypes.vResource;

public class boids
extends plugin
implements pluginIF {
    public vKFFloat translationX;
    public vKFFloat translationY;
    public vKFFloat translationZ;
    public vKFInt number_of_boids;
    public vBool destroy;
    public vBool turn;
    public vKFFloat velocity;
    public vKFFloat radius;
    public vKFFloat size;
    public vBool redraw;
    public vResource whichtexture1;
    public vResource whichtexture2;
    public vResource whichtexture3;
    public vResource whichtexture4;
    public vResource whichtexture5;
    public vKFFloat blend;
    public vBool alpha;
    public flock flock;
    resource_textureFile text1 = null;
    resource_textureFile text2 = null;
    resource_textureFile text3 = null;
    resource_textureFile text4 = null;
    resource_textureFile text5 = null;

    @Override
    public String getAuthor() {
        return "steam";
    }

    @Override
    public String getName() {
        return "boids";
    }

    @Override
    public float getVersion() {
        return 1.0f;
    }

    @Override
    public void init() {
        this.number_of_boids.setValue(60);
        this.velocity.setValue(1.0f);
        this.radius.setValue(0.15f);
        this.destroy.setValue(false);
        this.size.setValue(0.2f);
        this.translationX.setValue(0.45f);
        this.translationY.setValue(0.45f);
        this.translationZ.setValue(0.5f);
        this.alpha.setValue(true);
        this.newFlock();
        this.whichtexture1.setResourceType(new resource_textureFile());
        this.whichtexture2.setResourceType(new resource_textureFile());
        this.whichtexture3.setResourceType(new resource_textureFile());
        this.whichtexture4.setResourceType(new resource_textureFile());
        this.whichtexture5.setResourceType(new resource_textureFile());
    }

    public void newFlock() {
        this.flock = new flock(this.number_of_boids.getKeyframedValue());
    }

    public void update() {
        if (this.redraw.getValue()) {
            this.newFlock();
            this.redraw.setValue(false);
        }
        if (this.number_of_boids.getChanged()) {
            if (this.flock.boids.size() > this.number_of_boids.getKeyframedValue()) {
                this.flock.removeBoids(this.flock.boids.size() - this.number_of_boids.getKeyframedValue());
            } else if (this.flock.boids.size() < this.number_of_boids.getKeyframedValue()) {
                this.flock.addBoids(this.number_of_boids.getKeyframedValue() - this.flock.boids.size());
            }
        }
        this.flock.setVelocity(this.velocity);
        this.flock.setRadius(this.radius);
        this.flock.update(this.destroy, this.turn);
    }

    @Override
    public void render() {
        this.update();
        this.initGL();
        this.drawTexture();
    }

    public void initGL() {
        GL11.glLoadIdentity();
        GL11.glTranslatef((this.translationX.getKeyframedFloatValue() - 0.5f) * 6.0f, (this.translationY.getKeyframedFloatValue() - 0.5f) * 6.0f, (this.translationZ.getKeyframedFloatValue() - 0.5f) * 120.0f - 5.0f);
    }

    public void drawTexture() {
        this.changeTextures();
        GL11.glDisable(2884);
        GL11.glDisable(2903);
        GL11.glDisable(2896);
        GL11.glEnable(3553);
        GL11.glDisable(2929);
        GL11.glColor3f(1.0f, 1.0f, 1.0f);
        if (this.alpha.getValue()) {
            GL11.glEnable(3042);
            GL11.glBlendFunc(770, 771);
        } else {
            GL11.glDisable(3042);
        }
        GL11.glRotatef(45.0f, 0.0f, 1.0f, 0.0f);
        int i = 0;
        while (i < this.flock.boids.size()) {
            boid b = this.flock.boids.get(i);
            if (b.texture != null) {
                b.texture.bind();
            }
            float[] texture = this.getTextureCoords(i);
            GL11.glBegin(7);
            GL11.glTexCoord2f(texture[0], texture[2]);
            GL11.glVertex3f(b.getX(), b.getY(), b.getZ());
            GL11.glTexCoord2f(texture[1], texture[2]);
            GL11.glVertex3f(b.getX() + this.size.getKeyframedFloatValue(), b.getY(), b.getZ());
            GL11.glTexCoord2f(texture[1], texture[3]);
            GL11.glVertex3f(b.getX() + this.size.getKeyframedFloatValue(), b.getY() + this.size.getKeyframedFloatValue(), b.getZ());
            GL11.glTexCoord2f(texture[0], texture[3]);
            GL11.glVertex3f(b.getX(), b.getY() + this.size.getKeyframedFloatValue(), b.getZ());
            GL11.glEnd();
            ++i;
        }
        GL11.glEnable(2929);
    }

    public void drawPoints() {
        GL11.glDisable(3553);
        GL11.glColor3f(0.0f, 1.0f, 0.0f);
        GL11.glPointSize(this.size.getKeyframedFloatValue());
        GL11.glBegin(0);
        int i = 0;
        while (i < this.flock.boids.size()) {
            boid b = this.flock.boids.get(i);
            GL11.glVertex3f(b.getX(), b.getY(), b.getZ());
            ++i;
        }
        GL11.glEnd();
    }

    public void changeTextures() {
        if (this.whichtexture1.getResource() != null && this.whichtexture1.wasChanged()) {
            if (this.text1 != null) {
                this.flock.replaceTexture(this.text1, (resource_textureFile)this.whichtexture1.getResource());
            } else {
                this.flock.addTexture((resource_textureFile)this.whichtexture1.getResource());
            }
            this.text1 = (resource_textureFile)this.whichtexture1.getResource();
        }
        if (this.whichtexture2.getResource() != null && this.whichtexture2.wasChanged()) {
            if (this.text2 != null) {
                this.flock.replaceTexture(this.text2, (resource_textureFile)this.whichtexture2.getResource());
            } else {
                this.flock.addTexture((resource_textureFile)this.whichtexture2.getResource());
            }
            this.text2 = (resource_textureFile)this.whichtexture2.getResource();
        }
        if (this.whichtexture3.getResource() != null && this.whichtexture3.wasChanged()) {
            if (this.text3 != null) {
                this.flock.replaceTexture(this.text3, (resource_textureFile)this.whichtexture3.getResource());
            } else {
                this.flock.addTexture((resource_textureFile)this.whichtexture3.getResource());
            }
            this.text3 = (resource_textureFile)this.whichtexture3.getResource();
        }
        if (this.whichtexture4.getResource() != null && this.whichtexture4.wasChanged()) {
            if (this.text4 != null) {
                this.flock.replaceTexture(this.text4, (resource_textureFile)this.whichtexture4.getResource());
            } else {
                this.flock.addTexture((resource_textureFile)this.whichtexture4.getResource());
            }
            this.text4 = (resource_textureFile)this.whichtexture4.getResource();
        }
        if (this.whichtexture5.getResource() != null && this.whichtexture5.wasChanged()) {
            if (this.text5 != null) {
                this.flock.replaceTexture(this.text5, (resource_textureFile)this.whichtexture5.getResource());
            } else {
                this.flock.addTexture((resource_textureFile)this.whichtexture5.getResource());
            }
            this.text5 = (resource_textureFile)this.whichtexture5.getResource();
        }
    }

    public float[] getTextureCoords(int i) {
        float[] coords = new float[]{0.0f, 1.0f, 0.0f, 1.0f};
        if (i % 2 == 0) {
            coords[0] = 0.0f;
            coords[1] = 1.0f;
            coords[2] = 0.0f;
            coords[3] = 1.0f;
        }
        if (i % 5 == 0) {
            coords[0] = 0.0f;
            coords[1] = 1.0f;
            coords[2] = 1.0f;
            coords[3] = 0.0f;
        }
        if (i % 7 == 0) {
            coords[0] = 1.0f;
            coords[1] = 0.0f;
            coords[2] = 0.0f;
            coords[3] = 1.0f;
        }
        return coords;
    }
}

