/*
 * Decompiled with CFR 0.152.
 */
package plugins.shadertest;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import opengl.common;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.Util;
import plug.plugin;
import plug.pluginIF;
import resource.resource_textureFile;
import vsysTypes.v2DPoint;
import vsysTypes.vKFFloat;
import vsysTypes.vKFInt;
import vsysTypes.vResource;

public class shadertest
extends plugin
implements pluginIF {
    public vKFInt x;
    public vKFInt y;
    public v2DPoint mypos;
    public vKFFloat multi;
    public vResource whichtexture;
    int programObject = -1;
    resource_textureFile text = null;
    int location = 0;
    int mlocation = 0;
    ByteBuffer shadebytebuffer = shadertest.getProgramCode("c:/test.fs");

    @Override
    public String getName() {
        return "shadertest";
    }

    @Override
    public String getAuthor() {
        return "pandur";
    }

    @Override
    public float getVersion() {
        return 0.0f;
    }

    @Override
    public void init() {
        this.mypos.setKFInts(this.x, this.y);
        this.whichtexture.setResourceType(new resource_textureFile());
    }

    @Override
    public void render() {
        GL11.glClear(256);
        if (this.whichtexture.getResource() != null && this.whichtexture.wasChanged()) {
            this.text = (resource_textureFile)this.whichtexture.getResource();
            System.out.println("texture changed-...");
        }
        if (this.text == null) {
            return;
        }
        if (this.programObject == -1) {
            try {
                int myshader = ARBShaderObjects.glCreateShaderObjectARB(35632);
                ARBShaderObjects.glShaderSourceARB(myshader, this.shadebytebuffer);
                ARBShaderObjects.glCompileShaderARB(myshader);
                this.programObject = ARBShaderObjects.glCreateProgramObjectARB();
                ARBShaderObjects.glAttachObjectARB(this.programObject, myshader);
                ARBShaderObjects.glLinkProgramARB(this.programObject);
                ARBShaderObjects.glValidateProgramARB(this.programObject);
                this.printLogInfo(this.programObject);
                String mlocationname = "multi\u0000";
                ByteBuffer mname = BufferUtils.createByteBuffer(mlocationname.length());
                mname.put(mlocationname.getBytes());
                this.mlocation = ARBShaderObjects.glGetUniformLocationARB(this.programObject, mname);
                String locationname = "displacementMap\u0000";
                ByteBuffer name = BufferUtils.createByteBuffer(locationname.length());
                name.put(locationname.getBytes());
                this.location = ARBShaderObjects.glGetUniformLocationARB(this.programObject, name);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        GL11.glLoadIdentity();
        GL11.glDisable(2884);
        GL11.glDisable(2903);
        GL11.glDisable(2896);
        GL11.glEnable(3553);
        GL11.glDisable(2929);
        GL11.glColor3f(1.0f, 1.0f, 1.0f);
        ARBShaderObjects.glUseProgramObjectARB(this.programObject);
        this.text.bind();
        ARBShaderObjects.glUniform1iARB(this.location, this.text.getID());
        ARBShaderObjects.glUniform1fARB(this.mlocation, this.multi.getKeyframedFloatValue() + 10.0f);
        this.renderQuad();
        ARBShaderObjects.glUseProgramObjectARB(0);
    }

    private static ByteBuffer getProgramCode(String filename) {
        ClassLoader fileLoader = shadertest.class.getClassLoader();
        InputStream fileInputStream = fileLoader.getResourceAsStream(filename);
        byte[] shaderCode = null;
        try {
            if (fileInputStream == null) {
                fileInputStream = new FileInputStream(filename);
            }
            DataInputStream dataStream = new DataInputStream(fileInputStream);
            shaderCode = new byte[fileInputStream.available()];
            dataStream.readFully(shaderCode);
            fileInputStream.close();
            dataStream.close();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        ByteBuffer shaderPro = BufferUtils.createByteBuffer(shaderCode.length);
        shaderPro.put(shaderCode);
        shaderPro.flip();
        return shaderPro;
    }

    private void printLogInfo(int obj) {
        IntBuffer iVal = BufferUtils.createIntBuffer(1);
        ARBShaderObjects.glGetObjectParameterARB(obj, 35716, iVal);
        int length = iVal.get();
        System.out.println("Info log length:" + length);
        if (length > 0) {
            ByteBuffer infoLog = BufferUtils.createByteBuffer(length);
            iVal.flip();
            ARBShaderObjects.glGetInfoLogARB(obj, iVal, infoLog);
            byte[] infoBytes = new byte[length];
            infoLog.get(infoBytes);
            String out = new String(infoBytes);
            System.out.println("Info log:\n" + out);
        }
        Util.checkGLError();
    }

    public void renderQuad() {
        common.switchTo2d(common.currentContextWidth, common.currentContextHeight);
        GL11.glColor3f(1.0f, 1.0f, 1.0f);
        int x = (int)((float)this.mypos.x.getKeyframedValue() / 512.0f * (float)common.currentContextWidth);
        int y = (int)((float)this.mypos.y.getKeyframedValue() / 384.0f * (float)common.currentContextHeight);
        int width = (int)((float)common.currentContextWidth * 1.0f * 1.0f);
        int height = (int)((float)common.currentContextWidth * 1.0f);
        float f1 = 0.0f;
        float f2 = 1.0f;
        GL11.glBegin(7);
        GL11.glTexCoord2f(0.0f, f1);
        GL11.glVertex2f(x - width / 2, -1 * y + height / 2);
        GL11.glTexCoord2f(0.0f, f2);
        GL11.glVertex2f(x - width / 2, -1 * y - height / 2);
        GL11.glTexCoord2f(1.0f, f2);
        GL11.glVertex2f(x + width / 2, -1 * y - height / 2);
        GL11.glTexCoord2f(1.0f, f1);
        GL11.glVertex2f(x + width / 2, -1 * y + height / 2);
        GL11.glEnd();
        common.switchTo3d();
    }
}

