/*
 * Decompiled with CFR 0.152.
 */
package plugins.superformula;

import common.freeTimer;
import g3d.g3d_material;
import g3d.g3d_normals;
import g3d.g3d_vertex;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import plug.plugin;
import plug.pluginIF;
import resource.resource_textureFile;
import vsysTypes.vKFBoolean;
import vsysTypes.vKFFloat;

public class superformula
extends plugin
implements pluginIF {
    public vKFFloat width;
    public vKFFloat length;
    public vKFFloat zoom;
    public vKFFloat SS1m;
    public vKFFloat SS1a;
    public vKFFloat SS1b;
    public vKFFloat SS1n1;
    public vKFFloat SS1n2;
    public vKFFloat SS1n3;
    public vKFFloat SS2m;
    public vKFFloat SS2a;
    public vKFFloat SS2b;
    public vKFFloat SS2n1;
    public vKFFloat SS2n2;
    public vKFFloat SS2n3;
    public vKFBoolean translate;
    int resolution = 200;
    g3d_vertex[] plane;
    g3d_vertex[] plane_normals;
    int[] startpos;
    g3d_vertex[] cols;
    g3d_vertex col_black = new g3d_vertex();
    public boolean doTranslate = true;
    public boolean doLighting = true;
    int facecount = 0;
    float pi = (float)Math.PI;
    g3d_vertex pa = new g3d_vertex();
    g3d_vertex pb = new g3d_vertex();
    g3d_vertex pc = new g3d_vertex();
    g3d_vertex pd = new g3d_vertex();
    g3d_vertex vab = new g3d_vertex();
    g3d_vertex vcd = new g3d_vertex();
    g3d_vertex vca = new g3d_vertex();
    g3d_vertex vac = new g3d_vertex();
    float r0d;
    float r1d;
    float r2d;
    float r3d;
    float r0;
    float r2;
    float r1;
    float r3;
    freeTimer mytimer = new freeTimer();
    resource_textureFile text = null;
    float[] colblack = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    float[] colwhite = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    float[] colgrey = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    FloatBuffer white = null;
    FloatBuffer black = null;
    FloatBuffer lightpos = null;
    FloatBuffer grey = null;
    float[] lightPosition = new float[]{162.0f, 172.0f, -122.0f, 1.0f};
    g3d_material m;
    int f = 0;
    int laststep = -1;
    float[] mode = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    FloatBuffer mmode;
    freeTimer mytime = new freeTimer();
    float speed = 0.2f;
    boolean firsttime = true;
    FloatBuffer matdiff = null;
    FloatBuffer matambient = null;

    @Override
    public String getName() {
        return "superformular";
    }

    @Override
    public String getAuthor() {
        return "pandur";
    }

    @Override
    public float getVersion() {
        return 1.0f;
    }

    void setcolor(int which, int r, int g, int b) {
        this.cols[which] = new g3d_vertex();
        float m = 0.003921569f;
        this.cols[which].set(m * (float)r, m * (float)g, m * (float)b);
        this.width.setValue(0.25f);
        this.length.setValue(0.25f);
        this.SS1m.setValue(0.275f);
        this.SS1a.setValue(0.25f);
        this.SS1b.setValue(0.25f);
        this.SS1n1.setValue(0.275f);
        this.SS1n2.setValue(0.25f);
        this.SS1n3.setValue(0.25f);
        this.SS2m.setValue(0.257f);
        this.SS2a.setValue(0.25f);
        this.SS2b.setValue(0.25f);
        this.SS2n1.setValue(0.25f);
        this.SS2n2.setValue(0.256f);
        this.SS2n3.setValue(0.253f);
        this.zoom.setValue(1.0f);
    }

    @Override
    public void init() {
        this.cols = new g3d_vertex[5];
        this.setcolor(0, 240, 216, 0);
        this.setcolor(1, 240, 168, 0);
        this.setcolor(2, 240, 120, 0);
        this.setcolor(3, 0, 168, 144);
        this.setcolor(4, 0, 120, 144);
        this.col_black.set(0.0f, 0.0f, 0.0f);
        this.mmode = BufferUtils.createFloatBuffer(4);
        this.mmode.put(this.mode).flip();
        this.startpos = new int[this.resolution];
        int i = 0;
        while (i < this.resolution) {
            this.startpos[i] = (int)(Math.random() * (double)this.resolution);
            ++i;
        }
        this.plane = new g3d_vertex[this.resolution * this.resolution];
        this.plane_normals = new g3d_vertex[this.resolution * this.resolution];
        int xx = 0;
        while (xx < this.resolution * this.resolution) {
            this.plane[xx] = new g3d_vertex();
            this.plane_normals[xx] = new g3d_vertex();
            ++xx;
        }
    }

    public float SS1(float T, float SS1m, float SS1a, float SS1b, float SS1n1, float SS1n2, float SS1n3, float SS2m, float SS2a, float SS2b, float SS2n1, float SS2n2, float SS2n3, float resol) {
        return (float)Math.pow(Math.pow(Math.abs((float)Math.cos(SS1m * T / 4.0f)) / SS1a, SS1n2) + (double)((float)Math.pow(Math.abs((float)Math.sin(SS1m * T / 4.0f)) / SS1b, SS1n3)), 1.0f / SS1n1);
    }

    public float SS2(float T, float SS1m, float SS1a, float SS1b, float SS1n1, float SS1n2, float SS1n3, float SS2m, float SS2a, float SS2b, float SS2n1, float SS2n2, float SS2n3, float resol) {
        return (float)Math.pow((float)Math.pow(Math.abs((float)Math.cos(SS2m * T / 4.0f)) / SS2a, SS2n2) + (float)Math.pow(Math.abs((float)Math.sin(SS2m * T / 4.0f)) / SS2b, SS2n3), 1.0f / SS2n1);
    }

    public void SuperShape(float SS1m, float SS1a, float SS1b, float SS1n1, float SS1n2, float SS1n3, float SS2m, float SS2a, float SS2b, float SS2n1, float SS2n2, float SS2n3, float resol) {
        int x = 0;
        float piresol = 2.0f * this.pi / resol;
        while ((float)x < resol) {
            int y = 0;
            float t1 = -this.pi + (float)x * piresol;
            float t2 = -this.pi + ((float)x + 1.0f) * piresol;
            this.r0 = this.SS1(t1, SS1m, SS1a, SS1b, SS1n1, SS1n2, SS1n3, SS2m, SS2a, SS2b, SS2n1, SS2n2, SS2n3, resol);
            this.r2 = this.SS1(t2, SS1m, SS1a, SS1b, SS1n1, SS1n2, SS1n3, SS2m, SS2a, SS2b, SS2n1, SS2n2, SS2n3, resol);
            while ((float)y < resol / 2.0f) {
                float p1 = -this.pi / 2.0f + (float)y * piresol;
                float p2 = -this.pi / 2.0f + ((float)y + 1.0f) * piresol;
                float zeros = 0.0f;
                if (this.r0 == 0.0f) {
                    zeros += 1.0f;
                }
                this.r1 = this.SS2(p1, SS1m, SS1a, SS1b, SS1n1, SS1n2, SS1n3, SS2m, SS2a, SS2b, SS2n1, SS2n2, SS2n3, resol);
                if (this.r1 == 0.0f) {
                    zeros += 1.0f;
                }
                if (this.r2 == 0.0f) {
                    zeros += 1.0f;
                }
                this.r3 = this.SS2(p2, SS1m, SS1a, SS1b, SS1n1, SS1n2, SS1n3, SS2m, SS2a, SS2b, SS2n1, SS2n2, SS2n3, resol);
                if (this.r3 == 0.0f) {
                    zeros += 1.0f;
                }
                if (zeros != 0.0f) continue;
                this.r0d = 1.0f / this.r0;
                this.r1d = 1.0f / this.r1;
                this.r2d = 1.0f / this.r2;
                this.r3d = 1.0f / this.r3;
                this.pa.set(this.r0d * (float)Math.cos(t1) * this.r1d * (float)Math.cos(p1), this.r0d * (float)Math.sin(t1) * this.r1d * (float)Math.cos(p1), this.r1d * (float)Math.sin(p1));
                this.pb.set(this.r2d * (float)Math.cos(t2) * this.r1d * (float)Math.cos(p1), this.r2d * (float)Math.sin(t2) * this.r1d * (float)Math.cos(p1), this.r1d * (float)Math.sin(p1));
                this.pc.set(this.r2d * (float)Math.cos(t2) * this.r3d * (float)Math.cos(p2), this.r2d * (float)Math.sin(t2) * this.r3d * (float)Math.cos(p2), this.r3d * (float)Math.sin(p2));
                this.pd.set(this.r0d * (float)Math.cos(t1) * this.r3d * (float)Math.cos(p2), this.r0d * (float)Math.sin(t1) * this.r3d * (float)Math.cos(p2), this.r3d * (float)Math.sin(p2));
                this.vab.set(this.pa.posx - this.pb.posx, this.pa.posy - this.pb.posy, this.pa.posz - this.pb.posz);
                this.vac.set(this.pa.posx - this.pc.posx, this.pa.posy - this.pc.posy, this.pa.posz - this.pc.posz);
                float step = 1.0f / resol;
                float current = (float)x * step * 2.0f;
                float next = (float)(x + 1) * step * 2.0f;
                float forw = 0.0f;
                this.plane[x + this.resolution * y].set(this.pa.posx, this.pa.posy, this.pa.posz);
                this.plane[x + 1 + this.resolution * y].set(this.pb.posx, this.pb.posy, this.pb.posz);
                this.plane[x + 1 + this.resolution * (y + 1)].set(this.pc.posx, this.pc.posy, this.pc.posz);
                this.plane[x + this.resolution * (y + 1)].set(this.pc.posx, this.pd.posy, this.pd.posz);
                ++y;
            }
            ++x;
        }
        int xx = 0;
        while (xx < this.resolution) {
            int y = 0;
            while (y < this.resolution) {
                this.plane[xx + this.resolution * y].posx *= 8.0f;
                this.plane[xx + this.resolution * y].posy *= 8.0f;
                this.plane[xx + this.resolution * y].posz *= 8.0f;
                ++y;
            }
            ++xx;
        }
    }

    void test() {
        g3d_vertex v1 = new g3d_vertex(-5.0f, -5.0f, 0.0f);
        g3d_vertex v2 = new g3d_vertex(5.0f, -5.0f, 0.0f);
        g3d_vertex v3 = new g3d_vertex(5.0f, 5.0f, 0.0f);
        g3d_vertex v4 = new g3d_vertex(-5.0f, 5.0f, 0.0f);
        v1 = new g3d_vertex(5.0f, 5.0f, 0.0f);
        v2 = new g3d_vertex(-5.0f, 5.0f, 0.0f);
        v3 = new g3d_vertex(-5.0f, -5.0f, 0.0f);
        v4 = new g3d_vertex(5.0f, -5.0f, 0.0f);
        g3d_vertex va1 = v1;
        g3d_vertex va2 = v2;
        g3d_vertex va3 = v3;
        g3d_vertex va4 = v4;
        v1.posx += (v2.posx - v1.posx) * this.mytime.getTime() * 0.5f;
        v4.posx += (v3.posx - v4.posx) * this.mytime.getTime() * 0.5f;
        GL11.glTranslatef(0.0f, 0.0f, -20.0f);
        GL11.glRotatef(this.mytime.getTime() * 40.0f, 1.0f, 1.0f, 1.0f);
        GL11.glBegin(7);
        va1.glVertex();
        va2.glVertex();
        va3.glVertex();
        va4.glVertex();
        GL11.glEnd();
    }

    @Override
    public void render() {
        GL11.glColor3f(1.0f, 1.0f, 1.0f);
        GL11.glDisable(3553);
        GL11.glDisable(3042);
        this.facecount = 0;
        if (this.white == null) {
            this.white = ByteBuffer.allocateDirect(16).order(ByteOrder.nativeOrder()).asFloatBuffer();
            this.white.put(this.colwhite).flip();
        }
        if (this.grey == null) {
            this.grey = ByteBuffer.allocateDirect(16).order(ByteOrder.nativeOrder()).asFloatBuffer();
            this.grey.put(this.colgrey).flip();
        }
        if (this.black == null) {
            this.black = ByteBuffer.allocateDirect(16).order(ByteOrder.nativeOrder()).asFloatBuffer();
            this.black.put(this.colblack).flip();
        }
        if (this.lightpos == null) {
            this.lightpos = ByteBuffer.allocateDirect(16).order(ByteOrder.nativeOrder()).asFloatBuffer();
        }
        this.lightpos.put(this.lightPosition).flip();
        this.doLighting = true;
        GL11.glLightModeli(2898, 0);
        if (this.doLighting) {
            GL11.glEnable(2896);
            GL11.glShadeModel(7425);
            GL11.glLight(16389, 4608, this.black);
            GL11.glLight(16389, 4609, this.grey);
            GL11.glLight(16389, 4610, this.white);
            GL11.glLight(16389, 4611, this.lightpos);
            GL11.glLightModeli(2898, 0);
            GL11.glEnable(16389);
            GL11.glDisable(16385);
        }
        GL11.glDisable(2884);
        if (this.translate.getKeyframedValue()) {
            GL11.glTranslatef(0.0f, 0.0f, 2.0f + this.zoom.getKeyframedFloatValue() * -50.0f);
        }
        GL11.glTranslatef(0.0f, -6.0f, 0.0f);
        if (this.firsttime || this.SS1m.getChanged() || this.SS1a.getChanged() || this.SS1b.getChanged() || this.SS1n1.getChanged() || this.SS1n2.getChanged() || this.SS1n3.getChanged() || this.SS2m.getChanged() || this.SS2b.getChanged() || this.SS2a.getChanged() || this.SS2n1.getChanged() || this.SS2n2.getChanged() || this.SS2n3.getChanged()) {
            this.drawshape();
            this.calcnormals();
            this.firsttime = false;
            this.SS1m.getChanged();
            this.SS1a.getChanged();
            this.SS1b.getChanged();
            this.SS1n1.getChanged();
            this.SS1n2.getChanged();
            this.SS1n3.getChanged();
            this.SS2m.getChanged();
            this.SS2b.getChanged();
            this.SS2a.getChanged();
            this.SS2n1.getChanged();
            this.SS2n2.getChanged();
            this.SS2n3.getChanged();
            System.out.println("recalc supershape...");
        }
        GL11.glColor3f(1.0f, 1.0f, 1.0f);
        GL11.glEnable(2903);
        GL11.glColorMaterial(1032, 5634);
        GL11.glMaterial(1032, 4610, this.white);
        GL11.glMaterialf(1028, 5633, 0.5f);
        GL11.glDisable(3042);
        GL11.glDisable(3553);
        GL11.glColor3f(1.0f, 1.0f, 1.0f);
        if (this.mytime.getTime() / this.speed > 1.0f) {
            this.mytime.reset();
            this.f += 10;
        }
        int rangey1 = 0;
        int rangey2 = 0;
        int numcol = 0;
        int wid = (int)(this.width.getKeyframedFloatValue() * (float)(this.resolution / 5)) + 1;
        int count = 0;
        GL11.glBegin(7);
        float l100 = 100.0f * this.length.getKeyframedFloatValue();
        int xx = 0;
        while (xx < this.resolution - 2) {
            if (xx % wid == 0) {
                rangey1 = this.vval(this.startpos[xx] + this.f / 10, this.resolution / 2);
                rangey2 = this.vval(this.startpos[xx] + this.f / 10 + (int)l100 + 3, this.resolution / 2);
                if (++numcol >= this.cols.length) {
                    numcol = 0;
                }
                this.cols[numcol].glColor();
            }
            boolean first = false;
            int yy = 1;
            while (yy < this.resolution / 2 - 2) {
                ++count;
                if (yy > rangey1 && yy < rangey2 || rangey1 > rangey2 && yy > rangey1 || rangey1 > rangey2 && yy < rangey2) {
                    if (yy == rangey2 - 1) {
                        this.drawplaneIP(xx, yy - 1, this.mytime.getTime());
                    } else if (yy == rangey1 + 1) {
                        this.drawplaneIP(xx, yy, this.mytime.getTime());
                        first = true;
                    } else {
                        if (numcol >= this.cols.length) {
                            numcol = 0;
                        }
                        this.cols[numcol].glColor();
                        this.drawplane(xx, yy);
                    }
                }
                ++yy;
            }
            ++xx;
        }
        GL11.glEnd();
        GL11.glDisable(16389);
        GL11.glEnable(16385);
    }

    int vval(int n, int max) {
        return n - n / max * max;
    }

    void drawplaneIP(int xx, int yy, float perc) {
        perc /= this.speed;
        g3d_vertex v1 = this.plane[xx + this.resolution * yy];
        g3d_vertex v2 = this.plane[xx + 1 + this.resolution * yy];
        g3d_vertex v3 = this.plane[xx + 1 + this.resolution * (yy + 1)];
        g3d_vertex v4 = this.plane[xx + this.resolution * (yy + 1)];
        g3d_vertex vb1 = this.plane[xx + this.resolution * (yy + 1)];
        g3d_vertex vb2 = this.plane[xx + 1 + this.resolution * (yy + 1)];
        g3d_vertex vb3 = this.plane[xx + 1 + this.resolution * (yy + 2)];
        g3d_vertex vb4 = this.plane[xx + this.resolution * (yy + 2)];
        g3d_vertex vc1 = new g3d_vertex();
        g3d_vertex vc2 = new g3d_vertex();
        g3d_vertex vc3 = new g3d_vertex();
        g3d_vertex vc4 = new g3d_vertex();
        vc1.posx = v1.posx + (vb1.posx - v1.posx) * perc;
        vc1.posy = v1.posy + (vb1.posy - v1.posy) * perc;
        vc1.posz = v1.posz + (vb1.posz - v1.posz) * perc;
        vc2.posx = v2.posx + (vb2.posx - v2.posx) * perc;
        vc2.posy = v2.posy + (vb2.posy - v2.posy) * perc;
        vc2.posz = v2.posz + (vb2.posz - v2.posz) * perc;
        vc3.posx = v3.posx + (vb3.posx - v3.posx) * perc;
        vc3.posy = v3.posy + (vb3.posy - v3.posy) * perc;
        vc3.posz = v3.posz + (vb3.posz - v3.posz) * perc;
        vc4.posx = v4.posx + (vb4.posx - v4.posx) * perc;
        vc4.posy = v4.posy + (vb4.posy - v4.posy) * perc;
        vc4.posz = v4.posz + (vb4.posz - v4.posz) * perc;
        this.plane_normals[xx + this.resolution * yy].glNormal();
        vc1.glVertex();
        this.plane_normals[xx + 1 + this.resolution * yy].glNormal();
        vc2.glVertex();
        this.plane_normals[xx + 1 + this.resolution * (yy + 1)].glNormal();
        vc3.glVertex();
        this.plane_normals[xx + this.resolution * (yy + 1)].glNormal();
        vc4.glVertex();
    }

    void drawplane(int xx, int yy) {
        this.plane_normals[xx + this.resolution * yy].glNormal();
        this.plane[xx + this.resolution * yy].glVertex();
        this.plane_normals[xx + 1 + this.resolution * yy].glNormal();
        this.plane[xx + 1 + this.resolution * yy].glVertex();
        this.plane_normals[xx + 1 + this.resolution * (yy + 1)].glNormal();
        this.plane[xx + 1 + this.resolution * (yy + 1)].glVertex();
        this.plane_normals[xx + this.resolution * (yy + 1)].glNormal();
        this.plane[xx + this.resolution * (yy + 1)].glVertex();
    }

    void calcnormals() {
        int yy;
        int xx = 0;
        while (xx < this.resolution - 2) {
            yy = 0;
            while (yy < this.resolution / 2 - 2) {
                float[] norms = g3d_normals.getFaceNormal(this.plane[xx + this.resolution * yy], this.plane[xx + 1 + this.resolution * yy], this.plane[xx + 1 + this.resolution * (yy + 1)]);
                this.plane_normals[xx + this.resolution * yy].posx += norms[0];
                this.plane_normals[xx + this.resolution * yy].posy += norms[1];
                this.plane_normals[xx + this.resolution * yy].posz += norms[2];
                this.plane_normals[xx + 1 + this.resolution * yy].posx += norms[0];
                this.plane_normals[xx + 1 + this.resolution * yy].posy += norms[1];
                this.plane_normals[xx + 1 + this.resolution * yy].posz += norms[2];
                this.plane_normals[xx + 1 + this.resolution * (yy + 1)].posx += norms[0];
                this.plane_normals[xx + 1 + this.resolution * (yy + 1)].posy += norms[1];
                this.plane_normals[xx + 1 + this.resolution * (yy + 1)].posz += norms[2];
                ++yy;
            }
            ++xx;
        }
        xx = 0;
        while (xx < this.resolution - 2) {
            yy = 0;
            while (yy < this.resolution / 2 - 2) {
                this.plane_normals[xx + this.resolution * yy] = g3d_normals.normalize(this.plane_normals[xx + this.resolution * yy]);
                this.plane_normals[xx + 1 + this.resolution * yy] = g3d_normals.normalize(this.plane_normals[xx + 1 + this.resolution * yy]);
                this.plane_normals[xx + 1 + this.resolution * (yy + 1)] = g3d_normals.normalize(this.plane_normals[xx + 1 + this.resolution * (yy + 1)]);
                ++yy;
            }
            ++xx;
        }
    }

    void drawshape() {
        this.SuperShape(1.0f + this.SS1m.getKeyframedFloatValue() * 20.0f, 1.0f + this.SS1a.getKeyframedFloatValue() * 20.0f, 1.0f + this.SS1b.getKeyframedFloatValue() * 20.0f, 77.0f + this.SS1n1.getKeyframedFloatValue() * 20.0f, 0.81f + this.SS1n2.getKeyframedFloatValue() * 20.0f, 71.7f + this.SS1n3.getKeyframedFloatValue() * 20.0f, 8.0f + this.SS2m.getKeyframedFloatValue() * 20.0f, 1.0f + this.SS2a.getKeyframedFloatValue() * 20.0f, 1.0f + this.SS2b.getKeyframedFloatValue() * 20.0f, 0.63f + this.SS2n1.getKeyframedFloatValue() * 20.0f, 2.92f + this.SS2n2.getKeyframedFloatValue() * 20.0f, 0.24f + this.SS2n3.getKeyframedFloatValue() * 20.0f, this.resolution);
    }
}

