/*
 * Decompiled with CFR 0.152.
 */
package scene;

import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.Vector;
import javax.imageio.ImageIO;
import opengl.common;
import org.lwjgl.opengl.GL11;
import scene.layer;
import scene.layerIF;
import scene.sceneIF;

public class scene
implements sceneIF {
    private Vector layers = new Vector();
    static int screenshotcounter = 1000000;
    static int[] pixels = null;
    static ByteBuffer fb = null;

    public void reDrawGUI() {
    }

    @Override
    public Vector getLayers() {
        return this.layers;
    }

    @Override
    public void setTimingCurrentTime(float f) {
    }

    @Override
    public void setTimingZoom(float f) {
    }

    @Override
    public void setTimingScroll(float f) {
    }

    @Override
    public void setLength(int f) {
    }

    @Override
    public Object getTimingSettings() {
        System.out.println("timingsettings only available at gui");
        return null;
    }

    @Override
    public void render() {
        try {
            long starttime = 0L;
            if (common.rendertoImages) {
                common.currentTime += 0.033333335f;
            }
            if (common.controlPlug != null && common.controlPlug.getPlugin() != null) {
                common.controlPlug.getPlugin().render();
            }
            int i = this.layers.size() - 1;
            while (i >= 0) {
                layer l = (layer)this.layers.get(i);
                starttime = System.currentTimeMillis();
                l.render();
                --i;
            }
            if (common.rendertoImages) {
                scene.screenShot(common.currentContextWidth, common.currentContextHeight);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    @Override
    public void addLayer(layerIF l) {
        this.layers.add(l);
    }

    public void addLayer(String s) {
        layer l = new layer(s);
        this.layers.add(l);
    }

    public void movelayerup(layer l) {
        int which = this.layers.indexOf(l);
        if (which > 0) {
            this.layers.remove(which);
            this.layers.insertElementAt(l, which - 1);
        }
    }

    public void movelayerdown(layer l) {
        int which = this.layers.indexOf(l);
        if (which < this.layers.size() - 1) {
            this.layers.remove(which);
            this.layers.insertElementAt(l, which + 1);
        }
    }

    public void removeLayer(layer l) {
        this.layers.remove(l);
    }

    @Override
    public void removeLayerID(int which) {
        int i = 0;
        while (i < this.layers.size()) {
            layer l = (layer)this.layers.get(i);
            if (l.getID() == which) {
                this.layers.remove(i);
            }
            ++i;
        }
    }

    @Override
    public void moveLayer(int which, int newpos) {
        layer l = (layer)this.layers.get(which);
        this.layers.remove(which);
        this.layers.insertElementAt(l, newpos);
    }

    public static void screenShot(int width, int height) {
        if (fb == null) {
            System.out.println("allocate screenshot buffers...");
            fb = ByteBuffer.allocateDirect(width * height * 4);
            pixels = new int[width * height];
        }
        GL11.glReadPixels(0, 0, width, height, 6407, 5120, fb);
        int i = 0;
        while (i < pixels.length) {
            int bindex = i * 3;
            scene.pixels[i] = (fb.get(bindex) << 16) * 2 + (fb.get(bindex + 1) << 8) * 2 + (fb.get(bindex + 2) << 0) * 2;
            ++i;
        }
        try {
            BufferedImage image = new BufferedImage(width, height, 1);
            image.setRGB(0, 0, width, height, pixels, 0, width);
            image = scene.flipImage(image);
            ImageIO.write((RenderedImage)image, "png", new File("c:/demo/video/video" + screenshotcounter + ".png"));
            ++screenshotcounter;
        }
        catch (Exception e) {
            System.out.println("ScreenShot() exception: " + e);
        }
    }

    public static BufferedImage flipImage(BufferedImage bi) {
        AffineTransform tx = AffineTransform.getScaleInstance(1.0, -1.0);
        tx.translate(0.0, -bi.getHeight());
        AffineTransformOp op = new AffineTransformOp(tx, 1);
        bi = op.filter(bi, null);
        return bi;
    }
}

