
uniform vec3  lights; //[2];
uniform vec4  colors; //[2];
uniform float falloff; //[2];


uniform samplerCube refmap;
//uniform sampler2D   perturbmap;

uniform vec3 eyevec;            
uniform vec3 center;              
uniform float radiussquare;
uniform float oneoverradius;

varying vec3 quad;

const vec4 ambient = vec4(0.65,0.65,0.65,1);

// -------------

uniform vec2 screencenter;
uniform float minalpha;
uniform float radius1;
uniform float radius2;
uniform float oneoverradiusdifference;

void thehole_alpha(vec4 color)
{ 
  float alpha;

  alpha = clamp ( length( gl_FragCoord.xy - screencenter), radius1, radius2 );
  alpha = ( alpha - radius1 ) * oneoverradiusdifference;
  alpha = minalpha + (1.0 - minalpha) * alpha; // pow( alpha , 0.6 ) ; 

  gl_FragColor = vec4( color.rgb , color.a * alpha );
}

// -------------

void main ()
{
  vec4 c;
  vec3 u,v,n,x;
  float z,b,s; 

  v = normalize (eyevec - quad) ;     // eyedir
  u = quad - center;
  b = dot(u,v);                       // B/2 a masodfoku egyenletben
  z = dot(u,u) - radiussquare;        // C   a masodfoku egyenletben.  A = <eyedir,eyedir> = 1
  
  z = b*b - z;  // diszkriminans
  if (z<0.0) discard;
  
  z = sqrt(z);  

  x = u + (- b + z ) * v ;      
  n = x * oneoverradius;    // normal vektor
  x += center;              // raytrace metszes koordinataja

  u = lights - x;
  s = max( 0.0 , dot( u , n ) / length(u) ) ; c = (0.6* pow( s , falloff )) * colors ;  

  u = normalize ( eyevec - x );
  c += textureCube ( refmap , (2.0*dot(u,n)) * n - u ) ;    // a beepitett reflect fuggveny szar...
      
  thehole_alpha ( c + ambient * (n.z * n.z) );

//  u = lights[1] - coord; z = dot( u , n ) / length(u) ; c += pow(x,falloff[1]) * colors[1];  
  
}

