
uniform sampler2D t_color;
uniform vec2 radius;
uniform float bias;
uniform float scale;



const vec2 pixels[13] =
{
    { -6, -6 },
    { -5, -5 },
    { -4, -4 },
    { -3, -3 },
    { -2, -2 },
    { -1, -1 },
    {  0, 0 },
    {  1, 1 },
    {  2, 2 },
    {  3, 3 },
    {  4, 4 },
    {  5, 5 },
    {  6, 6 },
};

const float weights[13] =
{
    0.002216,
    0.008764,
    0.026995,
    0.064759,
    0.120985,
    0.176033,
    0.199471,
    0.176033,
    0.120985,
    0.064759,
    0.026995,
    0.008764,
    0.002216,
};

void main(void) {
	vec2 texcoord = gl_TexCoord[0].xy;
  vec4 col = 0;

  for (int i=0; i<13; i++) {
    col += texture2D(t_color, texcoord+pixels[i]*radius)*weights[i];
  }
  col = clamp((col + bias) * scale, 0, 1);
  gl_FragColor = col;
}



