#include "block_font.h"
#include "crap_png.h"
#include "crap_image.h"
#include "crap_font.h"

Prop_font* _default_blockfont;

#define BLOCK_BL 0
#define BLOCK_TL 1
#define BLOCK_BR 2
#define BLOCK_TR 3
#define BLOCK_FULL 4
#define BLOCK_EMPTY 5
#define BLOCK_UP 6
#define BLOCK_DOWN 7

int default_block_font_encoding[] = {
  //a
  BLOCK_TL,     BLOCK_FULL,       BLOCK_TR, 
  BLOCK_FULL,    BLOCK_EMPTY,     BLOCK_FULL, 
  BLOCK_TL,     BLOCK_FULL,     BLOCK_FULL, 
  BLOCK_FULL,    BLOCK_EMPTY,     BLOCK_FULL, 
  BLOCK_BL,     BLOCK_FULL,     BLOCK_FULL, 
  //b
  BLOCK_FULL,    BLOCK_EMPTY,    BLOCK_EMPTY, 
  BLOCK_FULL,     BLOCK_FULL,       BLOCK_TR, 
  BLOCK_FULL,    BLOCK_EMPTY,     BLOCK_FULL, 
  BLOCK_FULL,    BLOCK_EMPTY,     BLOCK_FULL, 
  BLOCK_FULL,     BLOCK_FULL,       BLOCK_BR, 
  //c
  BLOCK_TL,     BLOCK_FULL,     BLOCK_FULL, 
  BLOCK_FULL,    BLOCK_EMPTY,    BLOCK_EMPTY, 
  BLOCK_FULL,    BLOCK_EMPTY,    BLOCK_EMPTY, 
  BLOCK_FULL,    BLOCK_EMPTY,    BLOCK_EMPTY, 
  BLOCK_BL,     BLOCK_FULL,     BLOCK_FULL, 
  //d
  BLOCK_EMPTY,    BLOCK_EMPTY,     BLOCK_FULL, 
  BLOCK_TL,     BLOCK_FULL,     BLOCK_FULL, 
  BLOCK_FULL,    BLOCK_EMPTY,     BLOCK_FULL, 
  BLOCK_FULL,    BLOCK_EMPTY,     BLOCK_FULL, 
  BLOCK_BL,     BLOCK_FULL,     BLOCK_FULL, 
  //e
  BLOCK_TL,     BLOCK_FULL,       BLOCK_TR, 
  BLOCK_FULL,    BLOCK_EMPTY,     BLOCK_FULL, 
  BLOCK_FULL,     BLOCK_FULL,       BLOCK_BR, 
  BLOCK_FULL,    BLOCK_EMPTY,     BLOCK_FULL, 
  BLOCK_BL,     BLOCK_FULL,       BLOCK_BR, 
  //f
  BLOCK_TL,     BLOCK_FULL,       BLOCK_TR, 
  BLOCK_FULL,    BLOCK_EMPTY,    BLOCK_EMPTY, 
  BLOCK_FULL,     BLOCK_FULL,    BLOCK_EMPTY, 
  BLOCK_FULL,    BLOCK_EMPTY,    BLOCK_EMPTY, 
  BLOCK_FULL,    BLOCK_EMPTY,    BLOCK_EMPTY, 
  //g
  BLOCK_TL,     BLOCK_FULL,       BLOCK_TR, 
  BLOCK_FULL,    BLOCK_EMPTY,     BLOCK_FULL, 
  BLOCK_BL,     BLOCK_FULL,     BLOCK_FULL, 
  BLOCK_FULL,    BLOCK_EMPTY,     BLOCK_FULL, 
  BLOCK_BL,     BLOCK_FULL,       BLOCK_BR, 
  //h
  BLOCK_FULL,    BLOCK_EMPTY,    BLOCK_EMPTY, 
  BLOCK_FULL,     BLOCK_FULL,       BLOCK_TR, 
  BLOCK_FULL,    BLOCK_EMPTY,     BLOCK_FULL, 
  BLOCK_FULL,    BLOCK_EMPTY,     BLOCK_FULL, 
  BLOCK_FULL,    BLOCK_EMPTY,     BLOCK_FULL, 
  //i
  BLOCK_EMPTY,     BLOCK_TL,    BLOCK_EMPTY, 
  BLOCK_EMPTY,     BLOCK_FULL,    BLOCK_EMPTY, 
  BLOCK_EMPTY,     BLOCK_FULL,    BLOCK_EMPTY, 
  BLOCK_EMPTY,     BLOCK_FULL,    BLOCK_EMPTY, 
  BLOCK_EMPTY,     BLOCK_FULL,    BLOCK_EMPTY, 
  //j
  BLOCK_EMPTY,     BLOCK_EMPTY,    BLOCK_FULL, 
  BLOCK_EMPTY,    BLOCK_EMPTY,    BLOCK_FULL, 
  BLOCK_EMPTY,     BLOCK_EMPTY,    BLOCK_FULL, 
  BLOCK_FULL,     BLOCK_EMPTY,    BLOCK_FULL, 
  BLOCK_BL,     BLOCK_FULL,    BLOCK_BR, 
  //k
  BLOCK_FULL,    BLOCK_EMPTY,    BLOCK_EMPTY, 
  BLOCK_FULL,    BLOCK_EMPTY,     BLOCK_FULL, 
  BLOCK_FULL,     BLOCK_FULL,       BLOCK_BR, 
  BLOCK_FULL,    BLOCK_EMPTY,     BLOCK_FULL, 
  BLOCK_FULL,    BLOCK_EMPTY,     BLOCK_FULL, 
  //l
  BLOCK_TR,     BLOCK_EMPTY,    BLOCK_EMPTY, 
  BLOCK_FULL,     BLOCK_EMPTY,    BLOCK_EMPTY, 
  BLOCK_FULL,     BLOCK_EMPTY,    BLOCK_EMPTY, 
  BLOCK_FULL,     BLOCK_EMPTY,    BLOCK_EMPTY, 
  BLOCK_FULL,     BLOCK_FULL,     BLOCK_BR, 
  //m
  BLOCK_TR,    BLOCK_EMPTY,       BLOCK_TL, 
  BLOCK_FULL,     BLOCK_FULL,     BLOCK_FULL, 
  BLOCK_FULL,    BLOCK_EMPTY,     BLOCK_FULL, 
  BLOCK_FULL,    BLOCK_EMPTY,     BLOCK_FULL, 
  BLOCK_FULL,    BLOCK_EMPTY,     BLOCK_FULL, 
  //n
  BLOCK_FULL,     BLOCK_FULL,       BLOCK_TR, 
  BLOCK_FULL,    BLOCK_EMPTY,     BLOCK_FULL, 
  BLOCK_FULL,    BLOCK_EMPTY,     BLOCK_FULL, 
  BLOCK_FULL,    BLOCK_EMPTY,     BLOCK_FULL, 
  BLOCK_FULL,    BLOCK_EMPTY,     BLOCK_FULL, 
  //o
  BLOCK_TL,     BLOCK_FULL,       BLOCK_TR, 
  BLOCK_FULL,    BLOCK_EMPTY,     BLOCK_FULL, 
  BLOCK_FULL,    BLOCK_EMPTY,     BLOCK_FULL, 
  BLOCK_FULL,    BLOCK_EMPTY,     BLOCK_FULL, 
  BLOCK_BL,     BLOCK_FULL,       BLOCK_BR, 
  //p
  BLOCK_FULL,     BLOCK_FULL,       BLOCK_TR, 
  BLOCK_FULL,    BLOCK_EMPTY,     BLOCK_FULL, 
  BLOCK_FULL,    BLOCK_EMPTY,     BLOCK_FULL, 
  BLOCK_FULL,     BLOCK_FULL,       BLOCK_BR, 
  BLOCK_FULL,    BLOCK_EMPTY,    BLOCK_EMPTY, 
  //q
  BLOCK_TL,     BLOCK_FULL,       BLOCK_TR, 
  BLOCK_FULL,    BLOCK_EMPTY,     BLOCK_FULL, 
  BLOCK_FULL,    BLOCK_EMPTY,     BLOCK_FULL, 
  BLOCK_BL,     BLOCK_FULL,     BLOCK_FULL, 
  BLOCK_EMPTY,    BLOCK_EMPTY,     BLOCK_FULL, 
  //r
  BLOCK_FULL,       BLOCK_TL,       BLOCK_TR, 
  BLOCK_FULL,    BLOCK_EMPTY,     BLOCK_FULL, 
  BLOCK_FULL,    BLOCK_EMPTY,    BLOCK_EMPTY, 
  BLOCK_FULL,    BLOCK_EMPTY,    BLOCK_EMPTY, 
  BLOCK_FULL,    BLOCK_EMPTY,    BLOCK_EMPTY, 
  //s
  BLOCK_TL,     BLOCK_FULL,     BLOCK_FULL, 
  BLOCK_FULL,    BLOCK_EMPTY,    BLOCK_EMPTY, 
  BLOCK_BL,     BLOCK_FULL,       BLOCK_TR, 
  BLOCK_EMPTY,    BLOCK_EMPTY,     BLOCK_FULL, 
  BLOCK_FULL,     BLOCK_FULL,       BLOCK_BR, 
  //t
  BLOCK_TL,       BLOCK_FULL,    BLOCK_FULL, 
  BLOCK_EMPTY,    BLOCK_FULL,    BLOCK_EMPTY, 
  BLOCK_EMPTY,    BLOCK_FULL,    BLOCK_EMPTY, 
  BLOCK_EMPTY,    BLOCK_FULL,    BLOCK_EMPTY, 
  BLOCK_EMPTY,    BLOCK_FULL,     BLOCK_EMPTY, 
  //u
  BLOCK_FULL,    BLOCK_EMPTY,     BLOCK_FULL, 
  BLOCK_FULL,    BLOCK_EMPTY,     BLOCK_FULL, 
  BLOCK_FULL,    BLOCK_EMPTY,     BLOCK_FULL, 
  BLOCK_FULL,    BLOCK_EMPTY,     BLOCK_FULL, 
  BLOCK_BL,     BLOCK_FULL,     BLOCK_FULL, 
  //v
  BLOCK_FULL,    BLOCK_EMPTY,     BLOCK_FULL, 
  BLOCK_FULL,    BLOCK_EMPTY,     BLOCK_FULL, 
  BLOCK_FULL,    BLOCK_EMPTY,     BLOCK_FULL, 
  BLOCK_FULL,    BLOCK_EMPTY,     BLOCK_FULL, 
  BLOCK_BL,     BLOCK_FULL,       BLOCK_BR, 
  //w
  BLOCK_FULL,    BLOCK_EMPTY,     BLOCK_FULL, 
  BLOCK_FULL,    BLOCK_EMPTY,     BLOCK_FULL, 
  BLOCK_FULL,    BLOCK_UP,        BLOCK_FULL, 
  BLOCK_FULL,    BLOCK_FULL,      BLOCK_FULL, 
  BLOCK_BR,      BLOCK_DOWN,      BLOCK_BL, 
  //x
  BLOCK_FULL,    BLOCK_EMPTY,     BLOCK_FULL, 
  BLOCK_BL,     BLOCK_FULL,       BLOCK_BR, 
  BLOCK_TL,     BLOCK_FULL,       BLOCK_TR, 
  BLOCK_FULL,    BLOCK_EMPTY,     BLOCK_FULL, 
  BLOCK_FULL,    BLOCK_EMPTY,     BLOCK_FULL, 
  //y
  BLOCK_FULL,    BLOCK_EMPTY,     BLOCK_FULL, 
  BLOCK_FULL,    BLOCK_EMPTY,     BLOCK_FULL, 
  BLOCK_BL,     BLOCK_FULL,     BLOCK_FULL, 
  BLOCK_EMPTY,    BLOCK_EMPTY,     BLOCK_FULL, 
  BLOCK_FULL,     BLOCK_FULL,       BLOCK_BR, 
  //z
  BLOCK_FULL,     BLOCK_FULL,     BLOCK_FULL, 
  BLOCK_EMPTY,    BLOCK_EMPTY,     BLOCK_FULL, 
  BLOCK_TL,     BLOCK_FULL,       BLOCK_BR, 
  BLOCK_FULL,    BLOCK_EMPTY,    BLOCK_EMPTY, 
  BLOCK_FULL,     BLOCK_FULL,     BLOCK_FULL,
  //
  BLOCK_EMPTY,  BLOCK_EMPTY,  BLOCK_EMPTY,
  BLOCK_EMPTY,  BLOCK_EMPTY,  BLOCK_EMPTY,
  BLOCK_EMPTY,  BLOCK_EMPTY,  BLOCK_EMPTY,
  BLOCK_EMPTY,  BLOCK_EMPTY,  BLOCK_EMPTY,
  BLOCK_EMPTY,  BLOCK_EMPTY,  BLOCK_EMPTY
};

void load_block_font ()
{
  Image image;
  Palette p;

  crap_png_load ( &image, &p, "blockfont.png" );
  crap_setpalette ( &p, 0, 256 );
  
  _default_blockfont = crap_blockfont_load ( &image, 8,
					     16, 12,
					     3, 5,
					     27, default_block_font_encoding,
					     "abcdefghijklmnopqrstuvwxyz " );
}

Prop_font* block_font ()
{
  return _default_blockfont;
}
