/* crap_video.c - 
   Copyright (C) 2000 Tijs van Bakel.
   Tijs van Bakel <smoke@casema.net>, 
 
 This file is part of crapstation, a collection of demobuilder tools.

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include "crap_video.h"
#include <stdlib.h>
#include <sys/time.h>
#include <vga.h>
#include <vgakeyboard.h>
#include <unistd.h>
#include <sys/io.h>
#include <sys/perm.h>

Image* _crap_video_root_image;
uint8* _crap_video_buffer;
uint8* _crap_video_dbuf_ptr;

struct timeval _crap_video_start, _crap_video_end, _crap_video_mark;
long _crap_video_frametime;  // in usec;

int _crap_video_width, _crap_video_height, _crap_video_bpp;
int _crap_video_use_dbuf = 0;
int _crap_video_have_dbuf = 0;

int _last_key_press;

uint8 _palette[256*3];
int _update_palette;

int
crap_video_init( uint32 width, uint32 height )
{
  _last_key_press = 0;
  _update_palette = 1;
  memset ( _palette, 0, 256*3 );
  
  iopl(3);
  
  vga_init();
  vga_setlinearaddressing();
  vga_setmode(5);
  
  _crap_video_dbuf_ptr = vga_getgraphmem();
  _crap_video_width = 320;
  _crap_video_height = 200;
  _crap_video_bpp = 8;
  
  memset ( _crap_video_dbuf_ptr, 0, _crap_video_width *_crap_video_height );
  
  _crap_video_buffer = malloc( 320*200 );

  _crap_video_root_image = (Image*) malloc ( sizeof(Image) );
  _crap_video_root_image->width = crap_video_get_width();
  _crap_video_root_image->height = crap_video_get_height();
  _crap_video_root_image->stride = crap_video_get_width();
  _crap_video_root_image->buffer = _crap_video_buffer;
  
  _crap_video_frametime = 1000000/70; // 70Hz   -- warp-tmt@dds.nl
  gettimeofday(&_crap_video_start,NULL);
  gettimeofday(&_crap_video_mark,NULL);

  return 0;
}

Image*
crap_video_root_image()
{
  return _crap_video_root_image;
}

void
crap_video_setcolor ( uint8 color, uint8 r, uint8 g, uint8 b )
{
  _palette[color*3] = r;
  _palette[color*3+1] = g;
  _palette[color*3+2] = b;
  
  _update_palette = 1;
}

void
crap_video_waitretrace()
{
  vga_waitretrace();
}

int
crap_video_keypress()
{
  return ( _last_key_press = vga_getkey() );
}

int
crap_video_getkey()
{
  if ( _last_key_press == 0 )
    _last_key_press = vga_getkey();
  
  if ( _last_key_press == 27 )
    {
      _last_key_press = 0;
      return CRAP_KEY_ESCAPE;
    }

  _last_key_press = 0;
  return CRAP_KEY_NONE;
}

int
crap_video_get_width()
{
  return _crap_video_width;
}

int
crap_video_get_height()
{
  return _crap_video_height;
}

void
crap_video_blit ( Image* i )
{
  uint32* d;
  uint32* s;
  int c;
  int count = 16000;

  d = (uint32*) _crap_video_dbuf_ptr;
  s = (uint32*) i->buffer;

  if ( _update_palette )
    {
      _update_palette = 0;
      outb( 0, 0x3c8 );
      for ( c = 0; c < 768; c++ )
	outb ( _palette[c], 0x3c9 );
    }

  while (count--)
    *d++ = *s++;
/*    memcpy ( d, s, crap_video_get_width() * crap_video_get_height() ); */
}

void
crap_video_done()
{
  vga_setmode(0);
}

/* palette: RGB,RGB,RGB,.. */
void
crap_video_setcolors ( uint8 color, int length, uint8* palette )
{
  int i;

  for ( i = 0; i < length; i++ )
    {
        uint8 r,g,b;
        r = *palette++;
        g = *palette++;
        b = *palette++;
	crap_video_setcolor( i, r,g,b );
    }
}

