/* interference.c - 
   Copyright (C) 2000 Tijs van Bakel and Jorik Blaas.
   Tijs van Bakel <smoke@casema.net>
   Jorik Blaas <jrk@panic.et.tudelft.nl>
 
 This file is part of a silly intro
 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with This program; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include <stdlib.h>
#include <math.h>

#include "interference.h"

#include "crap_lib.h"
#include "crap_mod.h"
#include "crap_font.h"

#define DISPLACEX 160
#define DISPLACEY 100

#define ASPECT_RATIO 1.7

#define CIRCLE_SIZE 18.0
#define DISPLACE_SINE_Y 32

Image* interference_map;
Image dest_image;
int counter = 0;
int xsize, ysize;

void
interference_precalc ( Image* dest0, int nr )
{
  uint8* buf_bl;
  uint8* buf_br;
  uint8* buf_tl;
  uint8* buf_tr;

  float dw,dh;
  int i;
  int x,y;
  float fx1, fy1;
  float fx2, fy2, fy3;
  int strider_long;
  int strider_short;

  buf_tl = dest0->buffer ;
  buf_tr = dest0->buffer + dest0->width-1;
  buf_bl = dest0->buffer + dest0->stride*(dest0->height-1);
  buf_br = dest0->buffer + dest0->stride*(dest0->height-1) + dest0->width-1;
  
  strider_short = dest0->stride - dest0->width/2;
  strider_long = dest0->stride + dest0->width/2;

  dh = 1.0 / (dest0->height/2.0);
  dw = ASPECT_RATIO / (dest0->width/2.0);
  
  for ( y = 0; y < dest0->height/2; y++ )
    {
      fy1 = dh * ( (float) y + 0.25 - dest0->height/2.0 );
      fy1 *= fy1;
      fy2 = dh * ( (float) y + 0.5 - dest0->height/2.0 );
      fy2 *= fy2;
      fy3 = dh * ( (float) y + 0.75 - dest0->height/2.0 );
      fy3 *= fy3;
      for ( x = 0; x < dest0->width/2; x++ )
	{
	  fx1 = dw * ( (float) x + 0.5 - 0.333 - dest0->width/2.0 );
	  fx1 *= fx1;
	  fx2 = dw * ( (float) x + 0.5 + 0.167- dest0->width/2.0 );
	  fx2 *= fx2;

	  i = ( (int) ( CIRCLE_SIZE * sqrt ( fx1 + fy1 ) ) & 3 ) << 4 |
	    ( (int) ( CIRCLE_SIZE * sqrt ( fx2 + fy2 ) ) & 3 ) << 2 |
	    ( (int) ( CIRCLE_SIZE * sqrt ( fx1 + fy3 ) ) & 3 );
	  
	  *buf_tl++ = i;
	  *buf_tr-- = i;
	  *buf_bl++ = i;
	  *buf_br-- = i;
	}
      buf_tl += strider_short;
      buf_tr += strider_long;
      buf_bl -= strider_long;
      buf_br -= strider_short;
    }
}

void
interference_draw ( Image* dest_image,
		    Image* src0, Image* src1,
		    int x0, int y0,
		    int x1, int y1,
		    int distort_counter,
		    float distort_amount)
{
  uint8* destbuf;
  int y;
  uint8* srcbuf0;
  uint8* srcbuf1;
  int width;

  uint32* src0_quadptr;
  uint32* src1_quadptr;
  uint32* dest_quadptr;
  
  int y_distort0 = 0;
  int y_distort1 = 0;

  destbuf = dest_image->buffer;
  
  srcbuf0 = src0->buffer + x0 + src0->stride * y0;
  srcbuf1 = src1->buffer + x1 + src1->stride * y1;
  
  for ( y = 0; y < dest_image->height; y++ )
    {
      y_distort0 = (int) ( ((1.0+sin(y/100.0+distort_counter/2.0))
			  *(float)DISPLACE_SINE_Y) * distort_amount );
      y_distort1 = (int) ( ((1.0-sin(y/30.0+distort_counter/2.0))
			  *(float)DISPLACE_SINE_Y) * distort_amount );

      dest_quadptr = (uint32*) destbuf;
      src0_quadptr = (uint32*) ( srcbuf0 + y_distort0 );
      src1_quadptr = (uint32*) ( srcbuf1 + y_distort1 );

      width = dest_image->width >> 2;
      while ( width-- )
	{
	  *dest_quadptr++ = *src0_quadptr++ ^ *src1_quadptr++;
	}
      
      destbuf += dest_image->stride;
      srcbuf0 += src0->stride;
      srcbuf1 += src1->stride;
    }
}

Interference_data* create_fx_interference ( Image* dest )
{
  Interference_data* data;
  int i;
  int c;
  
  data = (Interference_data*) malloc ( sizeof(Interference_data) );

  xsize = dest->width + 2*DISPLACEX + 2*DISPLACE_SINE_Y;
  ysize = dest->height + 2*DISPLACEY;
  
  interference_map = crap_image_create ( xsize, ysize );
  interference_precalc ( interference_map, 0 );

  data->palette.color = malloc ( sizeof(Color) * 256 );
  
  for (c=0;c<64;c++)
    {
      i = 4 * ( ((c>>6)&3) + ((c>>4)&3) + ((c>>2)&3) + (c&3) );
      data->palette.color[c].r = i*54.0/63.0;
      data->palette.color[c].g = i*59.0/63.0;
      data->palette.color[c].b = i;
    }
  
  return data;
}

void fx_interference ( Image* dest, Interference_data* data,
		       int distort, int bass, int go_away )
{
  static int go_away_counter = 0;
  
  static float counter0 = 0.0; 
  static float counter1 = 50.0;
  static float counter2 = 130.0;
  static float counter3 = 560.0;

  static float diff_counter0 = 1.0; 
  static float diff_counter1 = 1.0;
  static float diff_counter2 = 1.0;
  static float diff_counter3 = 1.0;
  
  static int first_time = 1;
  static int bass_toggle = 0;
  
  static float distort_amount = 0.0;
  static int distort_counter = 0;

  Image subimage;

  if ( first_time )
    {
      first_time = 0;
      crap_setpalette ( &data->palette, 0, 64 );
    }

  distort_counter++;
  if ( distort )
    {
      distort_counter = 0;
      distort_amount = 1.0;
    }

  /* 0.95, 0.01 is leuk */
  distort_amount *= 0.95;
  if ( distort_amount > 0.0 )
    distort_amount += 0.01;

  if ( bass )
    {
      if ( bass_toggle )
	{
	  diff_counter0 = -diff_counter0;
	  diff_counter1 = -diff_counter1;
	  diff_counter2 = -diff_counter2;
	  diff_counter3 = -diff_counter3;
	  bass_toggle = 0;
	}
    }
  else
    bass_toggle = 1;

  counter0 += diff_counter0;
  counter1 += diff_counter1;
  counter2 += diff_counter2;
  counter3 += diff_counter3;

  counter++;
  
  if ( go_away )
    {
      if ( go_away_counter < dest->height )
	go_away_counter+=2;
      if ( go_away_counter > dest->height )
	go_away_counter = dest->height;
    }
      
  crap_image_subimage ( dest, &subimage,
			0, 0,
			dest->width, dest->height - go_away_counter );

  crap_image_rect_fill ( dest, 0,
			 0, dest->height - go_away_counter,
			 dest->width, 2 );
  
  interference_draw ( &subimage, interference_map, interference_map,
		      
		      (1.0+0.5*cos ( counter0 / 50.0 )) * (float)DISPLACEX
		      + (0.5*sin ( counter / 60.0 )) * (float)DISPLACEX,
		      (1.0+0.5*sin ( counter1 / 50.0 )) * (float)DISPLACEY
		      + (0.5*cos ( counter / 60.0 )) * (float)DISPLACEY,
		      
		      (1.0+0.5*sin ( counter2 / 50.0 )) * (float)DISPLACEX
		      + (0.5*cos ( counter / 60.0 )) * (float)DISPLACEX,
		      (1.0+0.5*cos ( counter3 / 50.0 )) * (float)DISPLACEY
		      + (0.5*sin ( counter / 60.0 )) * (float)DISPLACEY,
		      
		      distort_counter,
		      -0.36 + 1.0 / ( 1.75 + sin ( 2.0*M_PI*(1-distort_amount) + 0.5*M_PI)));
}
