/* twistbar.c -

   Copyright (C) 2000 Tijs van Bakel and Jorik Blaas.
   Tijs van Bakel <smoke@casema.net>
   Jorik Blaas <jrk@panic.et.tudelft.nl>
 
 This file is part of a silly intro
 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with This program; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* 1) innerloop kan sneller door screen al ge-&'d te laten zijn
   2) zbuffering en colorbuffering stil laten staan ipv moven
   3) zbuffer op voeg-toe-kolom preciezer laten zijn (float ipv uint8) */

#include <stdlib.h>
#include <math.h>

#include "crap_lib.h"
#include "crap_video.h"
#include "twistbar.h"
#include "crap_mod.h"
#include "crap_font.h"
#include "block_font.h"

#define MAXB 4
float old_fy[MAXB];
float base_radius[MAXB];
int bar_visible[MAXB];
float bar_frame[MAXB];

int _timing = 0;

#define SHADOW 10
#define MAXCOL (320+SHADOW)

uint8 buf[64000+SHADOW*200];
uint8 depth[64000+SHADOW*200];

Image* text_image;

Twistbar_data* create_fx_twistbar ( Image* dest )
{
  int i;

  Twistbar_data* data;
  
  data = (Twistbar_data*) malloc ( sizeof(Twistbar_data) );
  
  memset( buf, 0, 64000 );

  text_image = crap_image_create ( 4096, 60 );
  crap_pfont_string ( block_font(), text_image, 320, 0, "another way to scroll" );

  data->palette.color = malloc ( sizeof(Color) * 256 );
  for (i=0;i<64;i++)
    {
      data->palette.color[i].r = range ( i-5, 0, 63);
      data->palette.color[i].g = range ( i-3, 0, 63);
      data->palette.color[i].b = i;
    }

  /* text colors reside at 64,65 */
  data->palette.color[64].r = 14;
  data->palette.color[64].g = 14;
  data->palette.color[64].b = 14;
  data->palette.color[65].r = 28;
  data->palette.color[65].g = 28;
  data->palette.color[65].b = 28;

  /* shadow |128 */
  data->palette.color[192].r = 14;
  data->palette.color[192].g = 6;
  data->palette.color[192].b = 6;
  data->palette.color[193].r = 27;
  data->palette.color[193].g = 18;
  data->palette.color[193].b = 18;

  for ( i = 0; i < MAXB; i++ )
    {
      base_radius[i] = 0.0;
      bar_visible[i] = 0;
      bar_frame[i] = 0.0;
    }
  return data;
}


void combinebuffers( uint8 * dest, int text_visible )
{
  int text_pos;
  static int frame_count = 0;
  int x,y;
  
  uint8* text_buf;
  uint8* text_bufp;
  
  uint8* depthp;
  uint8* destp;

  text_buf = text_image->buffer;
  for(y=0;y<200;y++)
  {
    memcpy( &dest[y*320], &buf[y*MAXCOL], 320 );
  }

  if ( text_visible == TWISTBAR_TEXT )
    {
      frame_count++;
      text_pos = frame_count * 2.5 + 100.0 * sin ( frame_count/50.0 );
    
      for (y=0;y<text_image->height;y++)
	{
	  text_bufp = text_buf + text_pos + y*text_image->stride;
	  
	  depthp = &depth[(y+80)*MAXCOL];
	  destp = &dest[(y+80)*320];
	  
	  for (x=0;x<319;x++)
	    {
	      uint8 col;
	      if (!*depthp++)
		{
		  if ( ( col = *text_bufp ) )
		    {
		      *destp = col | depthp[9]; 
		    }     
		}
	      destp++;
	      text_bufp++;
	    }
	}
    }
}

int first_run = 1;
#define COLBUFSIZE 400

void fx_twistbar ( Image* dest, Twistbar_data* data,
		   int state,
		   int visible_bars,
		   int text_visible )
{
  int bar;
  int y,count;
  float angle;
  float new_fy;

  float fz,fy;
  
  float depth_value;
  
  float diff_fx, diff_fy;
  float height;
  float radius;

  static int first_time = 1;

  uint8 colorbuf[COLBUFSIZE], depthbuf[COLBUFSIZE];

  if ( first_time )
    {
      first_time = 0;
      crap_setpalette ( &data->palette, 0, 194 );
    }

  if ( _timing )
    crap_video_setcolor(0,0,0,63);

  memset( colorbuf, 0, COLBUFSIZE );
  memset( depthbuf, 0, COLBUFSIZE );

  switch ( state )
    {
    case TWISTBAR_APPEAR:
      for ( bar = 0; bar < range(visible_bars,0,MAXB); bar++ )
	{
	  base_radius [ bar ] = frange ( base_radius[bar] + 1.0/80.0, 0.0, 1.0 );
	  bar_frame [ bar ] += 1.0;
	  bar_visible [ bar ] = 1;
	}
      break;
    case TWISTBAR_LEAVE:
      for ( bar = 0; bar < MAXB; bar++ )
	{
	  bar_frame [ bar ] += 1.0;
	}
      for ( bar = MAXB-1 - range(visible_bars,0,MAXB); bar >= 0; bar-- )
	{
	  base_radius [ bar ] = frange ( base_radius[bar] - 1.0/80.0, 0.0, 1.0 );
	}
      break;
    }

  for ( bar = 0; bar < MAXB; bar++ )
    {
      float frame = bar_frame [ bar ];

      angle = - frame / 40.0 * ( bar + 3.0 ) / ( MAXB + 3.0 ) + bar * 1.8;
      fz = 0.8 * sin ( angle ) + 0.2 * (2.0-bar) / (MAXB+2.0) * sin ( frame / 19.0 );
      fy = 0.8 * cos ( angle ) + 0.2 * (3.0-bar) / (MAXB+1.0) * cos ( frame / 17.0 );
      
/*        fz = cos( frame/40.0 * (bar+3.0)/(MAXB+2.0) + bar*1.3); */
/*        fy = 0.8 * sin( frame/40.0 * (bar+3.0)/(MAXB+2.0) + bar*1.3) */
/*  	+ 0.5 * (3.0-bar)/(MAXB+1.0) * cos(frame/37.0); */
      
      new_fy = COLBUFSIZE/2.0 + 80.0/200.0*COLBUFSIZE * fy;
      
      y = new_fy;
      
      if ( bar_visible[bar] )
	old_fy[bar] = new_fy;
      
      diff_fy = ( old_fy[bar] - new_fy ) / 2.0;
      diff_fx = 1.0;
      
      radius = 5.0 * ( 2.0 + fz );
      radius *= frange ( base_radius [ bar ] , 0.0, 1.0 );
      
      height = radius * sqrt(1.0 + (diff_fy*diff_fy) / (diff_fx*diff_fx));
      
      if ( height < 0.01 )
	continue;
      
      old_fy[bar] = new_fy;
      
      if ( height < 80.0 )
	{
	  for (count = new_fy-height; count<new_fy+height; count++)
	    {
	      depth_value = 127.0 + 90.0 * fz +
		sqrt ( (height+1.0)*(height+1.0) - (count-new_fy)*(count-new_fy) ) / 2.0;
	      
	      if ( depthbuf[count] >= depth_value )
		continue;
      
	      colorbuf[count] = frange ( cos( ((float)count-new_fy) / height*0.45*M_PI )*63.0 * (fz+2.0)/4.0 , 0.0, 63.0 );
	      depthbuf[count] = depth_value;
	    }
	}
    }
  
  first_run = 0;

  if ( _timing )
    crap_video_setcolor(0,0,63,63);

  for (y=0;y<dest->height;y++)
    {
      memcpy( &buf[MAXCOL*y], &buf[MAXCOL*y] +1 , MAXCOL-1 );
      memcpy( &depth[MAXCOL*y], &depth[MAXCOL*y] +1 , MAXCOL-1 );
      buf[MAXCOL*y+MAXCOL-1] = (colorbuf[y<<1] + colorbuf[(y<<1)+1])>>1;
      depth[MAXCOL*y+MAXCOL-1] = depthbuf[y<<1] & 128;
    }

  if ( _timing )
    crap_video_setcolor(0,0,63,0);
  combinebuffers( dest->buffer, text_visible );

  crap_video_setcolor(0,0,0,0);


}
  
