/* voxel.c - 
   Copyright (C) 2000 Tijs van Bakel and Jorik Blaas.
   Tijs van Bakel <smoke@casema.net>
   Jorik Blaas <jrk@panic.et.tudelft.nl>
 
 This file is part of a silly intro
 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with This program; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* FIXME -
   vwidth & vheight moeten dest->width & height worden */

#include <stdlib.h>
#include <math.h>

#include "voxel.h"
#include "crap_mod.h"
#include "crap_font.h"
#include "crap_video.h"

/* FIXME should use malloc() */
#define VWIDTH 320
#define VHEIGHT 200
#define MAX_WIDTH 1024
#define LAYERS 10
int layer_height[LAYERS + 1][MAX_WIDTH];

int _interpolate = 1;
uint8* vidbuf;

uint8 sine_table1[65536];
uint8 sine_table2[65536];
uint8 sine_table3[65536];

void precalc_sines()
{
    int i;
    for( i=0; i<65536; i++)
    {
        sine_table1[i]= 
	   10.0*cos(i/145.4)+
           15.0*sin( i / 365.4 * 2.0 * M_PI )+
           25.0*sin( i / 119.34 * 2.0 * M_PI )*cos(i/170.4)+
           60.0; 
        sine_table2[i]= 
	   10.0*cos(i/635.4)+
           15.0*sin( i / 235.4 * 2.0 * M_PI )+
           25.0*sin( i / 819.34 * 2.0 * M_PI )*cos(i/90.4)+
           60.0; 
        sine_table3[i]= 
	   10.0*cos(i/345.4)+
           15.0*sin( i / 265.4 * 2.0 * M_PI )+
           25.0*sin( i / 319.34 * 2.0 * M_PI )*cos(i/70.4)+
           60.0; 
    }
}

/* the color should be 8.8 fixed point */
void
fill ( int x, int y0, int y1, int color0, int color1)
{
  int y;
  int color = color0;
  int diff_color;
  uint8 *dest = &vidbuf[x + y0 * VWIDTH];
  int height;

  if ( y1 <= y0 )
    return;
  if (y0 > VHEIGHT-20)
    return;
  if (y1 > VHEIGHT-20)
    height = VHEIGHT-20 - y0;
  else
    height = y1 - y0;

  diff_color = (color1 - color0) / (y1 - y0);
//  diff_color = 100;

  if (_interpolate)
    {
//      y=height;
//      while(y--)
      while(height--)
	{
	  *dest = (color >> 8);
	  color += diff_color;
	  dest += VWIDTH;
	}
    }
  else
    for (y = 0; y < height; y++)
      {
	if (y0 + y >= VHEIGHT)
	  return;

	*dest = (color >> 8);
	dest += VWIDTH;
      }
}

void
calc_landscape (int frame, float distort, int distort_frame)
{
  int l, x;

  for (l = 0; l < LAYERS; l++)
    {
      int o1, o2, o3;
      uint8* sine1;
      uint8* sine2;
      uint8* sine3;
      int loff;

      loff = l*4000 - 35000;

      o1 = distort*(100.0+100.0*sin(distort_frame/240.1));
/*        o1 = 600.0+500.0*sin(l/5.0+frame/240.1); */
      o2 = 1400.0+800.0*sin(l/4.3+frame/223.2);
      o3 = 1900.0+900.0*sin(l/3.1+frame/289.4);
      
      sine1 = &sine_table1[ o1 ];
      sine2 = &sine_table2[ o2 ];
      sine3 = &sine_table3[ o3 ];
      for (x = 0; x < VWIDTH; x++)
	{
	  layer_height[l][x] = ((*sine1++ + *sine2++ +*sine3++)<<7) + loff;
	}
    }
}

uint8 oldheight[320];

void
draw_landscape (int frame)
{
  int x, l, h, c, y;
  int previous_height;
  int previous_color;
  int blanktilly;
  int maxheight;
  uint8 *dest;

  /* we draw from bottom to top,
     top has y = h = 0, bottom has y = h = VHEIGHT */
  
  for (x = 0; x < VWIDTH; x++)
    {
      previous_color = 0;
      previous_height = layer_height[0][x];
      for (l = 1; l < LAYERS; l++)
	{
	  h = layer_height[l][x];
	  c = 256 + ( (LAYERS-l)*4 ) * 128 + (h - previous_height)/8;
	  if (previous_height < h)
	    {
	      fill (x, VHEIGHT - (h/256), VHEIGHT - (previous_height/256), c, previous_color);
	      previous_height = h;
	    }
	  previous_color = c;
	}
      y = VHEIGHT - (previous_height/256);
      maxheight = y;
      blanktilly = oldheight[x];

      dest = &vidbuf[x+y*VWIDTH];
      while ( y > blanktilly )
	{
	  y--;
	  dest-=VWIDTH;
	  *dest = 0;
	}
      oldheight[x] = maxheight;
    }
}

Voxel_data* create_fx_voxel ( Image* dest )
{
  Voxel_data* data;
  int i;
  memset( oldheight, 0, 320 );
  data = (Voxel_data*) malloc ( sizeof(Voxel_data) );
  precalc_sines();

  data->palette.color = malloc ( sizeof(Color) * 256 );
  for (i=0;i<64;i++)
    {
      data->palette.color[i].r = i + 1;
      data->palette.color[i].g = i + 3;
      data->palette.color[i].b = i + 6;
    }
  
  return data;
}

void fx_voxel ( Image* dest, Voxel_data* data, int distort )
{
  static int counter = 0;
  static int first_time = 1;
  static float distort_amount = 0.0;
  static int distort_counter = 0;

  if ( first_time )
    {
      first_time = 0;
      crap_setpalette ( &data->palette, 0, 128 );
    }

  distort_counter++;
  if ( distort )
    {
      distort_counter = 0;
      distort_amount = 1.0;
    }
  distort_amount *= 0.95;
  
  counter++;
  vidbuf = dest->buffer;

  calc_landscape (counter,
		  -0.36 + 1.0 / ( 1.75 + sin ( 2.0*M_PI*(1-distort_amount) + 0.5*M_PI) ),
		  distort_counter);
  draw_landscape (counter);
}

