{$A+,B-,D-,E-,F-,G+,I-,L-,N-,O-,P-,Q-,R-,S-,T-,V-,X-}
{$M 1024,0,64768}
program Super_View;
uses Dos,Acp,Adp;

var mth: string;
    frm: string;
    nam: string;
    dir: SearchRec;

function UpChain(sn: string): string;
var x: Byte;
begin
  for x:=1 to Length(sn) do
    sn[x]:=UpCase(sn[x]);
  UpChain:=sn
end;

procedure Info;
begin
  WriteLn;
  WriteLn('SCONV Pictures Converter v1.0');
  WriteLn('    written by  Astra ');
  WriteLn;
  WriteLn('Usage: sconv name.[type] type');
  Writeln('Type is one of the following: PIC,AST,ACP,ADP,BMP');
  WriteLn;
  Halt
end;

procedure LoadBMP(name1: string);
Const
 MaxXScreen=320;
 MaxYScreen=200;
 Segment=$A000;

Type
 DWord=LongInt;
 BMP_File_Hdr=Record
  bfType      :Word;
  bfSize      :DWord;
  bfReserved1 :Word;
  bfReserved2 :Word;
  bfOffBits   :DWord;
 End;
 BMP_Info_Hdr=Record
  biSize          :DWord;
  biWidth         :DWord;
  biHeight        :DWord;
  biPlanes        :Word;
  biBitCount      :Word;
  biCompression   :DWord;
  biSizeImage     :Dword;
  biXPelsPerMeter :DWord;
  biYPelsPerMeter :DWord;
  biClrUsed       :DWord;
  biClrImportant  :DWord;
 End;
 RGB_Quad=Record
  Blue  :Byte;
  Green :Byte;
  Red   :Byte;
  Null  :Byte;
 End;
 Scr_RGB=Record
  Red   :Byte;
  Green :Byte;
  Blue  :Byte;
 End;

Var
 f: File;
 readed,MaxX,MaxY,x,y,g,LineLen :Word;
 LineBuffer :Array[0..4095] Of Byte;
 Memory :Pointer;
 regs :Registers;
 LenPalette :DWord;
 BMPFileHdr :BMP_File_Hdr;
 BMPInfoHdr :BMP_Info_Hdr;
 BMPPalette :Array[0..255] Of RGB_Quad;
 ScrPalette :Array[0..255] Of Scr_RGB;

Procedure SetPalette;
var l: LongInt;
Begin
 For l:=0 To LenPalette-1 Do
 Begin
  ScrPalette[l].Red:=BMPPalette[l].Red Shr 2;
  ScrPalette[l].Green:=BMPPalette[l].Green Shr 2;
  ScrPalette[l].Blue:=BMPPalette[l].Blue Shr 2;
 End;
 regs.ah:=$10;
 regs.al:=$12;
 regs.bx:=0;
 regs.cx:=LenPalette;
 regs.es:=Seg(ScrPalette);
 regs.dx:=Ofs(ScrPalette);
 Intr($10,regs)
End;

Procedure SetLineLen;
Begin
 LineLen:=BMPInfoHdr.biWidth;
 If (LineLen mod 4<>0) Then
  LineLen:=(LineLen+4) And $FFFC
End;

Procedure Display;
var y: Word;
Begin
 Asm
  mov ax,1201h
  mov bl,36h
  int 10h
 End;
 SetPalette;
 If (BMPInfoHdr.biWidth>MaxXScreen) Or
    (BMPInfoHdr.biHeight>MaxYScreen) Then Info;
 MaxX:=BMPInfoHdr.biWidth;
 MaxY:=BMPInfoHdr.biHeight;
 Seek(f,BMPFileHdr.bfOffBits);
 SetLineLen;
 For y:=0 To MaxY-1 Do
 Begin
  BlockRead(f,LineBuffer,LineLen,readed);
  If readed<LineLen Then Info;
  Memory:=Ptr(Segment,(MaxY-y-1)*MaxXScreen);
  Move(LineBuffer,Memory^,MaxX)
 End;
 Asm
  mov ax,1200h
  mov bl,36h
  int 10h
 End
End;

Begin
 Assign(f,name1);
 Reset(f,1);
 If IOResult<>0 Then Info;
 BlockRead(f,BMPFileHdr,SizeOf(BMPFileHdr),readed);
 If readed<SizeOf(BMPFileHdr) Then Info;
 If BMPFileHdr.bfType<>Ord('B')+256*Ord('M') Then Info;
 BlockRead(f,BMPInfoHdr,SizeOf(BMPInfoHdr),readed);
 If readed<SizeOf(BMPInfoHdr) Then Info;
 Seek(f,BMPInfoHdr.biSize+SizeOf(BMPFileHdr));
 If BMPInfoHdr.biClrUsed=0 Then
  LenPalette:=LongInt(1 shl BMPInfoHdr.biBitCount)
 Else LenPalette:=BMPInfoHdr.biClrUsed;
 BlockRead(f,BMPPalette,LenPalette*4,readed);
 If readed<LenPalette*4 Then Info;
 If BMPInfoHdr.biBitCount=8 Then
 Begin
  If BMPInfoHdr.biCompression=0 Then Display
  Else Info
 End
 Else Info;
 Close(f);
end;

procedure SaveBMP(n2: string);
type
 DWord=LongInt;
 BMP_File_Hdr=record
   bfType      :Word;
   bfSize      :DWord;
   bfReserved1 :Word;
   bfReserved2 :Word;
   bfOffBits   :DWord;
 end;
 BMP_Info_Hdr=record
   biSize          :DWord;
   biWidth         :DWord;
   biHeight        :DWord;
   biPlanes        :Word;
   biBitCount      :Word;
   biCompression   :DWord;
   biSizeImage     :Dword;
   biXPelsPerMeter :DWord;
   biYPelsPerMeter :DWord;
   biClrUsed       :DWord;
   biClrImportant  :DWord;
 end;
 RGB_Quad=record
   Blue  :Byte;
   Green :Byte;
   Red   :Byte;
   Null  :Byte;
 end;
 Scr_RGB=record
   Red   :Byte;
   Green :Byte;
   Blue  :Byte;
 end;

var
 FileHdr: BMP_File_Hdr;
 InfoHdr: BMP_Info_Hdr;
  BMPPal: array[0..255] Of RGB_Quad;
  ScrPal: array[0..255] Of Scr_RGB;
       p: Pointer;
       i: Byte;
       f: file;

procedure GetAllPalette(var pl);
var s,o: Word;
begin
  s:=Seg(pl);
  o:=Ofs(pl);
  asm
    mov ax,1017h
    xor bx,bx
    mov cx,256
    mov dx,s
    mov es,dx
    mov dx,o
    int 10h
  end
end;

procedure SetPal;
var i: Byte;
begin
  GetAllPalette(ScrPal);
  for i:=0 to 255 do
  begin
    BMPPal[i].red:=ScrPal[i].red shl 2;
    BMPPal[i].green:=ScrPal[i].green shl 2;
    BMPPal[i].blue:=ScrPal[i].blue shl 2
  end
end;

procedure Prepare;
begin
  FillChar(FileHdr,14,0);
  FillChar(InfoHdr,40,0);
  FillChar(BMPPal,1024,0);
  SetPal;
  with FileHdr,InfoHdr do
  begin
    bfType:=19778;
    bfSize:=64822;
    bfOffBits:=1078;
    biSize:=40;
    biWidth:=320;
    biHeight:=200;
    biBitCount:=8;
    biCompression:=0;
    biPlanes:=1;
    biSizeImage:=64000;
    biXPelsPerMeter:=320;
    biYPelsPerMeter:=200;
    biClrUsed:=256;
    biClrImportant:=256
  end
end;

begin
  Prepare;
  Assign(f,n2);
  Rewrite(f,1);
  BlockWrite(f,FileHdr,14);
  BlockWrite(f,InfoHdr,40);
  BlockWrite(f,BMPPal,1024);
  for i:=199 downto 0 do
  begin
    p:=Ptr($a000,i*320);
    BlockWrite(f,p^,320)
  end
end;

procedure LoadOld(st: string; ad: Word);
var fl: file;
    rs: Word;
begin
  asm
    mov ax,1201h
    mov bl,36h
    int 10h
  end;
  Assign(fl,st);
  Reset(fl,1);
  BlockRead(fl,Mem[$a000:$0000],$ffff,rs);
  Close(fl);
  asm
    mov ax,1012h
    xor bx,bx
    mov cx,256
    mov dx,$a000
    mov es,dx
    mov dx,ad
    int 10h
    mov ax,1200h
    mov bl,36h
    int 10h
  end
end;

procedure SaveAST(st: string);
var f: file;
    p: Pointer;
begin
  p:=Ptr($a000,$0000);
  asm
    mov ax,1017h
    xor bx,bx
    mov cx,256
    mov dx,$a000
    mov es,dx
    mov dx,$fa00
    int 10h
  end;
  Assign(f,st);
  ReWrite(f,1);
  BlockWrite(f,p^,$fd00);
  Close(f)
end;

procedure SavePIC(st: string);
var f: file;
    p: Pointer;
begin
  p:=Ptr($a000,$0000);
  asm
    mov ax,1017h
    xor bx,bx
    mov cx,256
    mov dx,$a000
    mov es,dx
    mov dx,$fc17
    int 10h
  end;
  Assign(f,st);
  ReWrite(f,1);
  BlockWrite(f,p^,$ffff);
  BlockWrite(f,p^,1);
  Close(f)
end;

procedure Conv;
var fl: file;
    sz: LongInt;
    nd: string;
begin
  nd:=Copy(nam,Pos('.',nam)+1,3);
  Assign(fl,nam);
  Reset(fl,1);
  sz:=FileSize(fl);
  Close(fl);
  if (IOResult<>0) then Exit;
  if (nd<>'PIC') and (nd<>'AST') and
     (nd<>'ACP') and (nd<>'ADP') and (nd<>'BMP') then Exit;
  if (nd='PIC') and (sz<>65536) then Info;
  if (nd='AST') and (sz<>64768) then Info;
  asm
    mov ax,13h
    int 10h
  end;
  if (nd='PIC') then LoadOld(nam,$fc17);
  if (nd='AST') then LoadOld(nam,$fa00);
  if (nd='ACP') then LoadACP(nam);
  if (nd='ADP') then LoadADP(nam);
  if (nd='BMP') then LoadBMP(nam);
  Delete(nam,Pos('.',nam),4);
  if frm='PIC' then SavePIC(nam+'.PIC');
  if frm='AST' then SaveAST(nam+'.AST');
  if frm='ACP' then SaveACP(nam+'.ACP');
  if frm='ADP' then SaveADP(nam+'.ADP');
  if frm='BMP' then SaveBMP(nam+'.BMP');
end;

begin
  if (ParamCount<1) or (ParamCount>2) then Info;
  frm:=UpChain(ParamStr(2));
  if (frm<>'PIC') and (frm<>'AST') and
     (frm<>'ACP') and (frm<>'ADP') and (frm<>'BMP') then Info;
  mth:='';
  if (Pos('*',ParamStr(1))<>0) then
    mth:=ParamStr(1);
  if (mth<>'') then
  begin
    FindFirst(mth,AnyFile,dir);
    if (DosError<>0) then Halt;
    while (DosError=0) do
      with dir do
      begin
        if (Attr and Directory=0) and (Attr and VolumeID=0) then
        begin
          nam:=Name;
          Conv
        end;
        FindNext(dir)
      end
  end
  else
  begin
    nam:=UpChain(ParamStr(1));
    Conv
  end;
  asm
    mov ax,3
    int 10h
  end
end.