;            ͻ
;                   USM_PLAY.INC        
;                                                               
;                           Useless Player V1.0zx               
;            ĺ
;               by Freddy Vtel (FreddyV/Useless)              
;                                                               
;               Code Starts .................. 13/03/1996       
;               Last Update .................. 12/04/1997       
;            ĺ
;                                                               
;              Easy EOS Update by Zoltar X/The Next Generation  
;               now it works only with E.O.S., but it is also   
;                             easier to use it!                 
;                                                               
;               Last Update .................. 26/04/1998       
;            ͼ

; ** Here are some .INC files linked in the _ONE_ include file!

;            ͻ
;                    SETUP.INC      
;                                                               
;                   Useless sound system compilation setup.     
;            ͼ

Yes Equ 1
No  Equ 0

;----------------------------- Sound drivers ---------------------------------

UseGUS   Equ Yes  ; Include GUS driver ?
UseSB    Equ Yes  ; Include Sound Blaster driver ?
UseHP    Equ Yes  ; Include PC Speaker driver ?
UseNoSnd Equ Yes  ; Include No Sound driver ?

;-------------------------------- Setup --------------------------------------
;
; Setup function needs MEMORY.ASM to run and is bigger than Autosetup function.
; If you use the sound system for a GUS only intro, use only AutoSetup.

UseSetup Equ Yes
UseAutoSetup Equ Yes

;------------------------------- Mixing --------------------------------------
;
; Default Amplification is a very important variable for the mixing
; routines as there is no sound clipping in useless player mixing routines
;
; It define how mutch channels can be mix together (if the samples are
; at full volume)
; a value of 256 is for One 'Full' volume channel
; With 2*256, it can mix 2 channels, ....
; The Lower is DefAmpli, the louder is the sound.
;
; You must try by yourself (In Mono AND Stereo Mode) to get the best sound
; quality.

;DefAmpli EQU 256*2    ; It's good for 4/6 channels files
DefAmpli EQU 256*3    ; 8 Channels files
;DefAmpli EQU 256*5
;DefAmpli EQU 256*8    ; If you play a 24 channels file like DOPE.MOD

FastStereoOversampling EQU Yes ; No, Slow Stereo oversampling (16 bit)
                               ; Yes, Fast Stereo oversampling (8 bit)

;------------------------------- Loaders -------------------------------------
;
; USMP_FreeModule function can only free the files loaded by the externals
; files loaders (USMLoad, MODLoad, XMLoad...)
; When you don't use external loaders, you must set UseFreeModule to No


UseFreeModule Equ Yes ; Use FreeModule function ?

;------------------------------- Timer ---------------------------------------
; Number of timer you can use.
; (If you use the GUS or PC speaker drivers, you must add 1 to max_timers)

max_timers  EQU 3
timer_error EQU No ; 1, timer errors stop the program (No Error number return)
                   ; You must include ERROR.ASM when this is on
                   ; So It should be 0 in intros.

;------------------------------- Memory --------------------------------------
;
;   When you use EOS and DOS32, the player allocates its own heap
; The player heap size is (free memory-NeededMem).
; NeededMem value will depends on which DOS extender you use.
;
;For DOS32:
;   NeededMem is the total amount of memory you allocate with the DOS32
; memory allocation functions.
;   If you use the useless memory functions, you can put NeededMem to 0
;
;For EOS:
;   As EOS internally allocates memory for the LoadInternalFile and debugger,
; NeededMem is the memory you will allocate with the EOS memory functions +
; internal EOS memory allocations.
;   As you can see, it's more difficult with EOS because the memory is
; shared between the player, EOS internal needs and EOS memory functions,
; you will have to try different values to find the optimal one.
;
; BTW: EOS load_internal_file error is file not found instead of out of memory

NeededMem Equ 32*1024

;            ͻ
;                 HARDWARE.INC      
;                                                               
;                       Hardware functions (DMA/IRQ)            
;            ͼ

DMAAutoinit   EQU 8+16+64
DMANoAutoinit EQU 8+64

; ** Hardware functions **

Global HardwareInit  :Near
Global HardwareEnd   :Near
Global IRQ_Enable    :Near
Global IRQ_Disable   :Near
Global GetEnvOffset  :Near
Global DMA_Setup     :Near

; ** Public var **

ZeroOffset EQU Zero_Addr
PSPOffset  EQU PSP_Addr
EnvOffset  EQU Environment_Addr

Global DMABuffer      :DWORD
Global DMARealAddress :DWORD

; IRQ MACROS

GetInt Macro Inter,_Ptr
        mov bl,Inter
        mov ah,Get_Int
        int_EOS

        mov DWORD PTR _Ptr,edx  ; Save Int offset
        mov WORD PTR _Ptr[4],cx ; Save Int selector
Endm

RestInt Macro Inter,_Ptr
        mov bl,Inter
        mov cx,WORD PTR _Ptr[4]
        mov edx,DWORD PTR _Ptr

        mov ah,Set_Int
        int_EOS
Endm

SetInt Macro Inter,Select,Offs
        mov bl,Inter
        mov cx,Select
        mov edx,Offset Offs

        mov ah,Set_Int
        int_EOS
Endm

GetIRQ Macro IRQ,_Ptr
        mov bl,IRQ
        mov ah,Get_Irq
        int_EOS

        mov DWORD PTR _Ptr,edx  ; Save IRQ offset
        mov WORD PTR _Ptr[4],cx ; Save IRQ selector
Endm

RestIRQ Macro IRQ,_Ptr
        mov bl,IRQ
        mov cx,WORD PTR _Ptr[4]
        mov edx,DWORD PTR _Ptr

        mov ah,Set_Irq
        int_EOS
Endm

SetIRQ Macro IRQ,Select,Offs
        mov bl,IRQ
        mov cx,Select
        mov edx,Offset Offs

        mov ah,Set_Irq
        int_EOS
Endm

;            ͻ
;                  USMLOAD.INC      
;                                                               
;                             Useless USM Loader                
;            ͼ

Global USM_Load   :Near

;            ͻ
;                  MODLOAD.INC      
;                                                               
;                       Useless MOD Loader (MOD->USM)           
;            ͼ

Global MOD_Load   :Near

MODSampleSize EQU MODSLoopLen+2

MODSample Struc
        MODSName      DB 22 DUP (?)
        MODSLength    DW ?
        MODSFine      DB ?
        MODSVolume    DB ?
        MODSLoop      DW ?
        MODSLoopLen   DW ?
MODSample EndS

;            ͻ
;                  XMLOAD.INC       
;                                                               
;                        Useless XM Loader (XM->USM)            
;            ͼ

Global XM_Load   :Near

XMHeaderLen EQU XMOrder+256

XMHeader Struc
         XMId       DB 17 DUP (0)
         XMName     DB 20 DUP (0)
         XMbyte     DB 0
         XMTracker  DB 20 DUP (0)
         XMVersion  DW 0
         XMHSize    DD 0
         XMSongLen  DW 0
         XMRestart  DW 0
         XMChannels DW 0
         XMPatterns DW 0
         XMInstr    DW 0
         XMFlags    DW 0
         XMTempo    DW 0
         XMBPM      DW 0
         XMOrder    DB 256 DUP (0)
XMHeader ENDS

XMInstrumentSize EQU XMIReserved+2

XMInstrument Struc
        XMISSize      DD 0
        XMISNumber    DB 96 DUP (0)
        XMIVEnvelope  DW 24 DUP (0)
        XMIPEnvelope  DW 24 DUP (0)
        XMIVPoints    DB 0
        XMIPPoints    DB 0
        XMIVSustain   DB 0
        XMIVLoopStart DB 0
        XMIVLoopEnd   DB 0
        XMIPSustain   DB 0
        XMIPLoopStart DB 0
        XMIPLoopEnd   DB 0
        XMIVType      DB 0
        XMIPType      DB 0
        XMIVibType    DB 0
        XMIVibSweep   DB 0
        XMIVibdepht   DB 0
        XMIVibrate    DB 0
        XMIVFadeout   DW 0
        XMIReserved   DW 0
XMInstrument EndS

;            ͻ
;                 USMPLAY.INC       
;                                                               
;                          Useless Module Player                
;            ͼ

Global USMP_LoadInternalModule :Near
Global USMP_FreeModule         :Near

Global USMP_StartPlay          :Near
Global USMP_StopPlay           :Near

Global USMP_PrevOrder          :Near
Global USMP_NextOrder          :Near
Global USMP_SetOrder           :Near

Global _SynchroCount :DWORD
Global _SynchroVal   :BYTE
Global _MusicEnd     :BYTE

;            ͻ
;                  USS.INC          
;                                                               
;                          Useless Sound System V1.0            
;            ͼ

Global USS_Setup           :Near
Global USS_AutoSetup       :Near

Global USS_StartOutput     :Near
Global USS_StopOutput      :Near
Global USS_UpdateOutput    :Near

Global USS_LoadSample      :Near
Global USS_FreeSample      :Near
Global USS_GetGlobalVolume :Near
Global USS_SetGlobalVolume :Near
Global USS_StartInstrument :Near
Global USS_InitInstrEnv    :Near
Global USS_GetInstrument   :Near
Global USS_GetSample       :Near
Global USS_SetSampleOffset :Near
Global USS_SetNote         :Near
Global USS_GetPeriod       :Near
Global USS_SetPeriod       :Near
Global USS_GetVolume       :Near
Global USS_SetVolume       :Near
Global USS_GetPanning      :Near
Global USS_SetPanning      :Near
Global USS_KeyOff          :Near
Global USS_UpdateInstr     :Near

; ** Some usefull functions for the player **

Global Get_NotePeriod      :Near
Global GetVibData          :Near

;            ͻ
;                 USSVAR.INC        
;                                                               
;                     Useless Sound System 'Variables'          
;            ͼ

; ** Devices var **

Global _DEV_Number      :WORD
Global _DEV_Name        :DWORD
Global _DEV_BasePort    :WORD
Global _DEV_IRQ         :BYTE
Global _DEV_DMA         :BYTE
Global _DEV_Freq        :WORD
Global _DEV_Mode        :WORD
Global _DEV_MaxChannels :WORD

; ** Devices Type Mask **

DM_8bit   EQU 1      ; 8 bit device
DM_16bit  EQU 2      ; 16 bit device
DM_Mono   EQU 4      ; Mono Device
DM_Stereo EQU 8      ; Stereo Device
DM_Signed EQU 16     ; Need a signed or an unsigned buffer (used in mix.asm)
DM_Interp EQU 32     ; 16 bit interpolation and 32 bit mixing...

DM_Mixed  EQU 256    ; Software mixed or hardware mixed device
DM_DRAM   EQU 512
DM_MIDI   EQU 1024   ; MIDI Device (Not used yet)
DM_FM     EQU 2048   ; FM Device (Adlib, Not used yet)

; ** Global var **

Global SSSampleOffsetT  :DWORD
Global SSInstrOffsetT   :DWORD
Global SSLinearPeriode  :BYTE
Global SSInstrumentMode :BYTE
Global SSGlobalVol      :BYTE
Global SSActiveChannels :DWORD

; ** Channels var **

Global VChControl    :WORD

Global VChInsAdress  :DWORD
Global VChPeriod     :WORD
Global VChFreq       :DWORD
Global VChannelVol   :BYTE
Global VChVolume     :BYTE
Global VChFVolume    :BYTE
Global VChPanning    :BYTE
Global VChFPanning   :BYTE

Global VChSmpAdress  :DWORD
Global VChSmpOffset  :DWORD

Global VChFadeoutVol   :WORD

Global VChVolEnvPos    :WORD
Global VChVolEnvSegPos :WORD
Global VChEnvVol       :BYTE

Global VChPanEnvPos    :WORD
Global VChPanEnvSegPos :WORD
Global VChEnvPan       :BYTE

Global VChAVibPos      :BYTE
Global VChAVibSwpPos   :BYTE
Global VChAVibPitch    :WORD

Global Period_Table :WORD

; ** Channel Control masques **

CC_Playing   EQU 1
CC_StopVoice EQU 2
CC_FadeVol   EQU 4

CC_ChSample  EQU 16
CC_ChPeriod  EQU 32
CC_ChVolume  EQU 64
CC_ChPanning EQU 128

CC_Backgrnd  EQU 256
CC_Active    EQU 512

CNNA_Stop    EQU 1024
CNNA_Fade    EQU 2048

; ** Instrument and sample definition **

USSInstrSize EQU IVFadeout+2

USSInstr Struc
        IId         DD 0                ;'INST'
        ILen        DD 0
        IName       DB 32  DUP (0)
        INbSmp      DW 0
        INNA        DB 0
        IDNC        DB 0
        ISNumber    DB 120 DUP (0)      ;Sample number for all notes
        IVEnvelope  DW 24  DUP (0)
        IPEnvelope  DW 24  DUP (0)
        IVPoints    DB 0
        IPPoints    DB 0
        IVSustain   DB 0
        IVLoopStart DB 0
        IVLoopEnd   DB 0
        IPSustain   DB 0
        IPLoopStart DB 0
        IPLoopEnd   DB 0
        IVType      DB 0
        IPType      DB 0
        IVibType    DB 0
        IVibSweep   DB 0
        IVibdepth   DB 0
        IVibrate    DB 0
        IVFadeout   DW 0
USSInstr Ends

; Envelope Type Mask

E_On      EQU 1
E_Sustain EQU 2
E_Loop    EQU 4

USSSampleSize EQU SPointer+4            ; ! Can't be >255 !

USSSample Struc
        SId         DD 0                ; 'SMPL'
        SLen        DD 0
        SName       DB 32 DUP (0)
        SLength     DD 0
        SLoop       DD 0
        SLoopEnd    DD 0
        SType       DB 0
        SVolume     DB 0
        SPanning    DB 0
        SRelNote    DB 0
        SFine       DW 0
        SPointer    DD 0
USSSample Ends

; Sample Type Mask

SM_Adlib  EQU 1
SM_NSigne EQU 2
SM_16bit  EQU 4
SM_Loop   EQU 8
SM_Bidi   EQU 16
SM_Delta  EQU 32
SM_Loaded EQU 128

