;*****************************************************************************
; PACMAN4K source code - released first in HUGI diskmag issue #20
; 8th at ASM2K on 03/08/2000 - all code by KOZMIK/NEXTEMPIRE
; Thanks to other people like Franky and Shiva for also releasing their srcs 
; "A fully playable pacMan level in 4089"
; TASM  /la /kh1024   PACMAN4K.ASM
; TLINK /3 /m3 PACMAN4K.OBJ
; APACK   -ST  PACMAN4K.EXE
; MOVE         OUT.EXE PACMAN4K.COM
; DEL          PACMAN4K.EXE
; DEL          PACMAN4K.MAP
; DEL          PACMAN4K.OBJ
; DIR          PACMAN4K.COM
;-----------------------------------------------------------------------------
; Assembler directives
;-----------------------------------------------------------------------------
.486P
;-----------------------------------------------------------------------------
; Structures
;-----------------------------------------------------------------------------
Descriptor       STRUC 
 Seg_limit       DW  4*(4*1+2*2)       ;segment limit
 Base_A15_A00    DW  ?                 ;A00..A15 of base address
 Base_A23_A16    DB  ?                 ;A16..A23 of base address
 Access_rights   DB  ?                 ;segment access rights
 GDLimit_A19_A16 DB  ?                 ;granularity, Op-size, Limit A16..A19
 Base_A31_A24    DB  ?                 ;A24..A31 of base address
Descriptor       ENDS
;-----------------------------------------------------------------------------
; Equates & macros
;-----------------------------------------------------------------------------
MAZEHEIGHT       EQU 31 
MAZEWIDTH        EQU 28
SPRIHEIGHT       EQU 12
SPRIWIDTH        EQU 24   
CHARMAX          EQU 05
;164=3000/18.207 3khz sound
NEWRATE          EQU 164;  280;  140;365;120;240;80                ; number of times to increase
SPEED            EQU  4
G1               EQU 800*32
BPTR             EQU BYTE  PTR
WPTR             EQU WORD  PTR
DPTR             EQU DWORD PTR
QPTR             EQU QWORD PTR
;-----------------------------------------------------------------------------
; .DAT
;-----------------------------------------------------------------------------
_DATA   SEGMENT PARA PUBLIC USE16 'DATA'
GDT386  Descriptor <>
SELCS4G equ        $-GDT386
GDTCS4G Descriptor <-1,,,9bh,8fh,>         ; CS Descriptor
SELDS4G equ        $-GDT386
GDTDS4G Descriptor <-1h,0,0h,93h,8fh,0h>   ; 4G Descriptor
SELSS4G equ        $-GDT386
GDTSS4G Descriptor <-1h,0,0h,93h,8fh,0h>   ; 4G Descriptor
GDTSIZ  equ        ($-GDT386) - 1


marqueecol      dw       1
lifecnt         dw       4
                dw      12
                dw      -2
                dw      14
ADPCMTTL        DB      10000000B
                DB      01000000B
                DB      00100000B
                DB      00010000B
                DB      00001000B
                DB      00000100B
                DB      00000010B
                DB      00000001B
                DB      00000000B
ghostnum        dd      0    ; blue ghost number eaten
ghosttime       dd      0    ; blue ghost countdown timer
ghoststate      dd      0    ; blue ghost flag
cherrytime      dd      0    ; cherrycountdown timer
cherrystate     dd      0    ; cherry state
democount       dw      0
bytecnt         dw      0
bitcnt          dw      0
oneeveryfour    dd      0                                               ;
score_num       dd      0
pillstate       dw      0
score_str2      db      0
score_str3      db      15 dup (0)
countdown       dw      0; NEWRATE    ; countdown timer
INT08H          DD      0           ;INT08H=ROMFONTS-BANKINFSIZ
BANKINFSIZ EQU ($-offset INT08H)
romfonts        DD      0     ;+000; #5. 8x8 ROM fonts ptr (0-128-255)
                DD      0     ;+004; #4. 8x8 ROM fonts ptr (0-255)
                DD      0     ;+008; #3. 8x14 ROM fonts ptr (0-255)
                DD      0     ;+012; #2. int 43h ptr
                DD      0     ;+016; #1. int 1fh ptr
PHYSCR          DD      0
LOGSCR          DD      0
SAMPNUM         DD      1     ;PHYSCR=SOUND1-SAMPINFSIZ
SAMPINFSIZ EQU ($-offset PHYSCR)
;         bank beg  size
;----     ---- ---- ----
;         +000 +004 +008
                           
SOUND1 DD 0002,0355,0050 ; back
SOUND2 DD 0002,0355-13,0050 ; ghost back
SOUND3 DD 0002,0355-13,0050 ; dot
SOUND4 DD 0002,0355-13-13,0050 ; ghost dot


;SOUND1 DD 0001,0355,0050 ; back
;SOUND2 DD 0001,0355,0050 ; ghost back
;SOUND3 DD 0001,0655,0054 ; dot
;SOUND4 DD 0001,0355,0050 ; ghost dot


;SOUND5 DD 0005,0620,0055 ; ghost dot           done nodots
;SOUND6 DD 0002,0655,0055 ; ghost eat           
;SOUND7 DD 0002,0655,0055 ; prize               done
;SOUND8 DD 0002,0655,0055 ; death






pal_state1 DB  8,255,255,255;powerpill white
           DB 11,191,  0,  0;ghost #1  red
           DB  4,  0,250,255;ghost #2  turquoise
           DB  9,255, 79,191;ghost #3  pink
           DB 13, 63, 47, 15;ghost #4  orange
           DB  7,255,255,255;dots      white
           DB  8,  0,  0,  0;powerpill black
pal_state2 DB  8,255,255,255;powerpill white
           DB 11,  0,  0,255;ghost #1  blue
           DB  4,  0,  0,255;ghost #2  blue
           DB 13,  0,  0,255;ghost #3  blue
           DB  9,  0,  0,255;ghost #4  blue
           DB  7,255,255,255;dots      white
           DB  8,  0,  0,  0;powerpill black

pal_state3 DB  8,255,255,255;powerpill white
           DB 11,255,255,255;ghost #1  blue
           DB  4,255,255,255;ghost #2  blue
           DB 13,255,255,255;ghost #3  blue
           DB  9,255,255,255;ghost #4  blue
           DB  7,255,255,255;dots      white
           DB  8,  0,  0,  0;powerpill black



pacpal     db       14 ; PACMAN ;index 14
           db       11 ; GHOST1 
           db        4 ; GHOST2
           db       13 ; GHOST3
           db        9 ; GHOST4
           db       12 ; CHERRY


;below are fixed indexed "strucs" per character to be addressed through ebp
;
;-------------- character 0 = pacman -----------------------------------;----
paccordx        dd      (800*(35+24*16)+160+14*16+8-800*60-176)+800*2+6-4 ;+000
pacmazex        dd      ((MAZEWIDTH/02)*1)                              ;+004
pacmazey        dd      ((MAZEWIDTH*23)*1);24                           ;+008
pacstart        dd      OFFSET S3          ; base offset of pacindex    ;+012
pacstartprev    dd      0                                               ;+016
paccount        dd      0          ; pacindex count                     ;+020
pacoldkey       dd      0                                               ;+024
pacflag         dd      1                                               ;+028
packeytab       dd      offset KEYTAB                                   ;+032
pacresoff       dd      0                                               ;+036
pactile         dd      0                                               ;+040
pacprevcoord    dd      0                                               ;+044
pacprevtile     dd      0                                               ;+048
charstructsiz   equ     ($-offset paccordx)
;-------------- character 1 = ghost1 -----------------------------------;----
paccordx1       dd      (800*(35+12*16)+160+14*16+8-800*60-176)+800*2+6-4 ;+000
pacmazex1       dd      ((MAZEWIDTH/02)*1)                              ;+004
pacmazey1       dd      ((MAZEWIDTH*11)*1);24                           ;+008
pacstart1       dd      OFFSET T3          ; base offset of pacindex    ;+012
pacstartprev1   dd      0                                               ;+016
paccount1       dd      0          ; pacindex count                     ;+020
pacoldkey1      dd      0                                               ;+024
pacflag1        dd      0     ; 0 =cpu 1=usr                            ;+028
packeytab1      dd      offset KEYTAB1                                  ;+032
pacresoff1      dd      0                                               ;+036
pactile1        dd      0                                               ;+040
pacprevcoord1   dd      0                                               ;+044
pacprevtile1    dd      0                                               ;+048
;-------------- character 2 = ghost2 -----------------------------------;----
paccordx2       dd      (800*(35+12*16)+160+14*16+8-800*60-176)+800*2+6-4 ;+000
pacmazex2       dd      ((MAZEWIDTH/02)*1)                              ;+004
pacmazey2       dd      ((MAZEWIDTH*11)*1);24                           ;+008
pacstart2       dd      OFFSET U2          ; base offset of pacindex    ;+012
pacstartprev2   dd      0                                               ;+016
paccount2       dd      0          ; pacindex count                     ;+020
pacoldkey2      dd      0                                               ;+024
pacflag2        dd      0     ; 0 =cpu 1=usr                            ;+028
packeytab2      dd      offset KEYTAB2                                  ;+032
pacresoff2      dd      0                                               ;+036
pactile2        dd      0                                               ;+040
pacprevcoord2   dd      0                                               ;+044
pacprevtile2    dd      0                                               ;+048
;-------------- character 3 = ghost3 -----------------------------------;----
paccordx3       dd      (800*(35+12*16)+160+14*16+8-800*60-176)+800*2+6-4 ;+000
pacmazex3       dd      ((MAZEWIDTH/02)*1)                              ;+004
pacmazey3       dd      ((MAZEWIDTH*11)*1);24                           ;+008
pacstart3       dd      OFFSET V3          ; base offset of pacindex    ;+012
pacstartprev3   dd      0                                               ;+016
paccount3       dd      0          ; pacindex count                     ;+020
pacoldkey3      dd      0                                               ;+024
pacflag3        dd      0     ; 0 =cpu 1=usr                            ;+028
packeytab3      dd      offset KEYTAB3                                  ;+032
pacresoff3      dd      0                                               ;+036
pactile3        dd      0                                               ;+040
pacprevcoord3   dd      0                                               ;+044
pacprevtile3    dd      0                                               ;+048
;-------------- character 4 = ghost4 -----------------------------------;----
paccordx4       dd      (800*(35+14*16)+160+14*16+8-800*60-176)+800*2+6-4 ;+000
pacmazex4       dd      ((MAZEWIDTH/02)*1)                              ;+004
pacmazey4       dd      ((MAZEWIDTH*13)*1);24                           ;+008
pacstart4       dd      OFFSET W4          ; base offset of pacindex    ;+012
pacstartprev4   dd      0                                               ;+016
paccount4       dd      0          ; pacindex count                     ;+020
pacoldkey4      dd      0                                               ;+024
pacflag4        dd      0     ; 0 =cpu 1=usr                            ;+028
packeytab4      dd      offset KEYTAB4                                  ;+032
pacresoff4      dd      0                                               ;+036
pactile4        dd      0                                               ;+040
pacprevcoord4   dd      0                                               ;+044
pacprevtile4    dd      0                                               ;+048
;-------------- usr key table-------------------------------------------;----
KEYTAB          DB      72,0
                DD      OFFSET S1  ;up
                DB      80,0
                DD      OFFSET S2  ;down
                DB      75,0
                DD      OFFSET S3  ;left
                DB      77,0
                DD      OFFSET S4  ;right
;-------------- cpu key table-1-----------------------------------------;----
KEYTAB1         DB      0,1
                DD      OFFSET T1  ;up
                DB      1,0
                DD      OFFSET T2  ;down
                DB      2,3
                DD      OFFSET T3  ;left
                DB      3,2
                DD      OFFSET T4  ;right
;-------------- cpu key table-2-----------------------------------------;----
KEYTAB2         DB      0,1
                DD      OFFSET U1  ;up
                DB      1,0
                DD      OFFSET U2  ;down
                DB      2,3
                DD      OFFSET U3  ;left
                DB      3,2
                DD      OFFSET U4  ;right
;-------------- cpu key table-3-----------------------------------------;----
KEYTAB3         DB      0,1
                DD      OFFSET V1  ;up
                DB      1,0
                DD      OFFSET V2  ;down
                DB      2,3
                DD      OFFSET V3  ;left
                DB      3,2
                DD      OFFSET V4  ;right
;-------------- cpu key table-4-----------------------------------------;----
KEYTAB4         DB      0,1
                DD      OFFSET W1  ;up
                DB      1,0
                DD      OFFSET W2  ;down
                DB      2,3
                DD      OFFSET W3  ;left
                DB      3,2
                DD      OFFSET W4  ;right





charnum         dd      0

DOTNUMS         db      0
;S1=up S2=down S3=left S4=right
;         sprite#1/4         ;sprite#2/4         ;sprite#3/4         ;sprite#4/4         ;phy. off. ;log. x;log. y    
;         +00                ;+04                ;+08                ;+12                ;+16       ;+20   ;+24       
;------------- PACMAN
S1     DD 448+96*0+32*2+2+800+G1*0,448+96*2+32*0+2+800+G1*0,448+96*2+32*1+2+800+G1*0,448+96*2+32*0+2+800+G1*0,-800*SPEED,     0,-(MAZEWIDTH*1)
S2     DD 448+96*0+32*2+2+800+G1*0,448+96*3+32*0+2+800+G1*0,448+96*3+32*1+2+800+G1*0,448+96*3+32*0+2+800+G1*0,+800*SPEED,     0,+(MAZEWIDTH*1)
S3     DD 448+96*0+32*2+2+800+G1*0,448+96*1+32*0+2+800+G1*0,448+96*1+32*1+2+800+G1*0,448+96*1+32*0+2+800+G1*0,-001*SPEED,    -1,     0
S4     DD 448+96*0+32*2+2+800+G1*0,448+96*0+32*0+2+800+G1*0,448+96*0+32*1+2+800+G1*0,448+96*0+32*0+2+800+G1*0,+001*SPEED,    +1,     0    
;------------- GHOST1
T1     DD 448+96*0+32*2+2+800+G1*1,448+96*2+32*0+2+800+G1*1,448+96*2+32*1+2+800+G1*1,448+96*2+32*0+2+800+G1*1,-800*SPEED,     0,-(MAZEWIDTH*1)
T2     DD 448+96*0+32*2+2+800+G1*1,448+96*3+32*0+2+800+G1*1,448+96*3+32*1+2+800+G1*1,448+96*3+32*0+2+800+G1*1,+800*SPEED,     0,+(MAZEWIDTH*1)
T3     DD 448+96*0+32*2+2+800+G1*1,448+96*1+32*0+2+800+G1*1,448+96*1+32*1+2+800+G1*1,448+96*1+32*0+2+800+G1*1,-001*SPEED,    -1,     0
T4     DD 448+96*0+32*2+2+800+G1*1,448+96*0+32*0+2+800+G1*1,448+96*0+32*1+2+800+G1*1,448+96*0+32*0+2+800+G1*1,+001*SPEED,    +1,     0    
;------------- GHOST2
U1     DD 448+96*0+32*2+2+800+G1*2,448+96*2+32*0+2+800+G1*2,448+96*2+32*1+2+800+G1*2,448+96*2+32*0+2+800+G1*2,-800*SPEED,     0,-(MAZEWIDTH*1)
U2     DD 448+96*0+32*2+2+800+G1*2,448+96*3+32*0+2+800+G1*2,448+96*3+32*1+2+800+G1*2,448+96*3+32*0+2+800+G1*2,+800*SPEED,     0,+(MAZEWIDTH*1)
U3     DD 448+96*0+32*2+2+800+G1*2,448+96*1+32*0+2+800+G1*2,448+96*1+32*1+2+800+G1*2,448+96*1+32*0+2+800+G1*2,-001*SPEED,    -1,     0
U4     DD 448+96*0+32*2+2+800+G1*2,448+96*0+32*0+2+800+G1*2,448+96*0+32*1+2+800+G1*2,448+96*0+32*0+2+800+G1*2,+001*SPEED,    +1,     0    
;------------- GHOST3
V1     DD 448+96*0+32*2+2+800+G1*3,448+96*2+32*0+2+800+G1*3,448+96*2+32*1+2+800+G1*3,448+96*2+32*0+2+800+G1*3,-800*SPEED,     0,-(MAZEWIDTH*1)
V2     DD 448+96*0+32*2+2+800+G1*3,448+96*3+32*0+2+800+G1*3,448+96*3+32*1+2+800+G1*3,448+96*3+32*0+2+800+G1*3,+800*SPEED,     0,+(MAZEWIDTH*1)
V3     DD 448+96*0+32*2+2+800+G1*3,448+96*1+32*0+2+800+G1*3,448+96*1+32*1+2+800+G1*3,448+96*1+32*0+2+800+G1*3,-001*SPEED,    -1,     0
V4     DD 448+96*0+32*2+2+800+G1*3,448+96*0+32*0+2+800+G1*3,448+96*0+32*1+2+800+G1*3,448+96*0+32*0+2+800+G1*3,+001*SPEED,    +1,     0    
;------------- GHOST4
W1     DD 448+96*0+32*2+2+800+G1*4,448+96*2+32*0+2+800+G1*4,448+96*2+32*1+2+800+G1*4,448+96*2+32*0+2+800+G1*4,-800*SPEED,     0,-(MAZEWIDTH*1)
W2     DD 448+96*0+32*2+2+800+G1*4,448+96*3+32*0+2+800+G1*4,448+96*3+32*1+2+800+G1*4,448+96*3+32*0+2+800+G1*4,+800*SPEED,     0,+(MAZEWIDTH*1)
W3     DD 448+96*0+32*2+2+800+G1*4,448+96*1+32*0+2+800+G1*4,448+96*1+32*1+2+800+G1*4,448+96*1+32*0+2+800+G1*4,-001*SPEED,    -1,     0
W4     DD 448+96*0+32*2+2+800+G1*4,448+96*0+32*0+2+800+G1*4,448+96*0+32*1+2+800+G1*4,448+96*0+32*0+2+800+G1*4,+001*SPEED,    +1,     0    

credits          db      13,10
                 db      " PACMAN 4 KILOBYTES";                                               PLAYER 1  ",13,10;CRLF$
                 db      47 dup (' ')
                 db      "PLAYER 1  ",13,10," a NEXTEMPIRE intro"
                 db      13,10
                 db      " ASM'2000 demoparty",13,10,13,10
                 DB      "                      0   1   2   3   4   5   6   7   8   9   00",24h

;to test bare code size
INCLUDE PACMAN4K.INC ; all data
_DATA   ENDS
;-----------------------------------------------------------------------------
; .COD (REAL MODE)
;-----------------------------------------------------------------------------
_TEXT   SEGMENT PARA PUBLIC USE16 'CODE'
ASSUME  CS:_TEXT, DS:_DATA, ES:_DATA, SS:_TEXT, FS:0

start:  MOV     SP,OFFSET _STACK       ; 1 byte smaller
        mov     eax,ds                 ; make pointer to GDT table
                                       ; note above line can be stripped but
                                       ;then it will only work once 
        shl     eax,4             ; have physical address of segment
        add     eax,offset GDT386      ; now have physical addr of table
        mov     GDT386.Base_A15_A00,ax
	shr	eax,10h 		; get other address bits
        mov     GDT386.Base_A23_A16,al
        mov     GDT386.Access_rights,ah

	mov	eax,cs			; get CS
	shl	eax,4			; now have physical address
        mov     GDTCS4G.Base_A15_A00,ax
	shr	eax,10h 		; get other address bits
        mov     GDTCS4G.Base_A23_A16,al
        mov     GDTCS4G.Base_A31_A24,ah
	mov	eax,ds			; get DS
	shl	eax,4			; now have physical address
        mov     GDTDS4G.Base_A15_A00,ax
        shr     eax,10h                 ; get other address bits
        mov     GDTDS4G.Base_A23_A16,al
        mov     GDTDS4G.Base_A31_A24,ah
        mov     eax,ss                  ; get SS
	shl	eax,4			; now have physical address
        mov     GDTSS4G.Base_A15_A00,ax
	shr	eax,10h 		; get other address bits
        mov     GDTSS4G.Base_A23_A16,al
        mov     GDTSS4G.Base_A31_A24,ah

        lgdt    GDT386
        mov     eax,cr0                 ; get control register
        or      ax,1
        mov     cr0,eax

        push    cs                      ;push return selector on stack
        push    offset PMRET            ;set return offset
        DB      0EAH                    ;jmp instruction
        DW      OFFSET $+2              ;jumpfar offset word
        DW      SELCS4G                 ;jumpfar segment selector word
        mov     ax,SELDS4G              ;set all selectors to 4GB limits
	mov	ds,ax
	mov	es,ax
        mov     ax,SELSS4G
	mov	ss,ax
        mov     ebx,cr0                 ;get 386 control register
        and     ebx,not 80000001h       ;clear paging bit
        mov     cr0,ebx                 ;and store in CR0
        retf                            ;return to caller
;-----------------------------------------------------------------------------
; .COD (UNREAL MODE)
;-----------------------------------------------------------------------------
PMRET:    MOV   AX,SEG _DATA
          MOV   DS,AX
          MOV   ES,AX
          MOV   GS,AX
          MOV   SS,AX
;-UNCOMPRESS-DATA----------------------;--------------------------------------
          CALL  UNCTIL000              ;uncompress maze   tiles passes 1 and 2
          CALL  UNCTIL000              ;uncompress maze   tiles passes 3 and 4
          CALL  UNCTIL001              ;uncompress sprite tiles passes 1 and 2
          CALL  UNCTIL001              ;uncompress sprite tiles passes 3 and 4
;**************************************;**************************************
; INTRO STARTS HERE
;**************************************;**************************************
;-INITIALIZE-HIRES-VIDEO-MODE----------;--------------------------------------
          MOV   AX,4F01H               ;get vesa vbe 2.0 mode information
          MOV   CX,100H                ;size of vbe information is 256 bytes
          MOV   DI,OFFSET ModeInfoBlockPtr;es:di points to buffer
          INT   10H                    ;bios video system call
          MOV   AX,4F02H               ;set vesa vbe 2.0 mode
          MOV   BX,0C103H              ;mode 800x600x08 (256 colors)
          INT   10H                    ;bios video system call
;-DRAW-MAZEBOARD-----------------------;--------------------------------------
          MOV   EDI,DWORD PTR ES:DI[28H];ModeInfoBlock[28h] = 'PhysBasePtr'
          XOR   AX,AX                  ;ax=0
          MOV   GS,AX                  ;gs=0
          MOV   ES,AX                  ;es:edi=1st add.of 256KB video buffer
          MOV   DS:[PHYSCR],EDI        ;save start of physical screen
          MOV   ECX,240000             ;240000=800*600/2
          REP   STOS WPTR ES:[EDI]     ;clear 256kb video buffer
          MOV   DS:[LOGSCR],EDI        ;save start of logical screen
          ADD   EDI,448-32             ;edi=offset of sprites in logical scr.
          MOV   ESI,OFFSET SPRT        ;esi=offset of map
          MOV   EBX,OFFSET sprites_raw ;ebx=offset of tiles
          MOV   ECX,SPRIHEIGHT         ;ecx=map height
          MOV   EDX,SPRIWIDTH          ;edx=map width       ;12416=800*16
          MOV   EAX,800*16-SPRIWIDTH*16;eax=column alignment
          MOV   EBP,((49-1)*16)        ;ebp=tilemap alignment
          CALL  SETMAZ000              ;draw maze in logical screen
;-INITIALIZE-GFX-FONTS-----------------;--------------------------------------
          MOV   DX,OFFSET CREDITS      ;dx=offset of credits+digit string
          MOV   AH,9                   ;print message
          INT   21H                    ;call dos
          MOV   ESI,DS:[PHYSCR]        ;esi=offset of physical screen
          ADD   ESI,800*(64-4-4)+176   ;esi=offset of printed digit string
          MOV   EDI,DS:[LOGSCR]        ;edi=offset of logical screen
          ADD   EDI,800*500            ;edi=offset of score fonts
          MOV   CX,10                  ;10=0....9 sprites
NUMERIC:  CALL  PUTSPRITE              ;put prize on screen
          ADD   ESI,32                 ;align on shl5 boundaries
          ADD   EDI,32                 ;align on shl5 boundaries
          LOOP  NUMERIC                ;repeat for all digits
;-DO-EYES------------------------------;--------------------------------------
;         SUB   ESI,800*4              ;esi points to ->"00"
          MOV   EDI,DS:[LOGSCR]        ;address of logical screen
          ADD   EDI,455+800*22         ;sub edi,356665
          MOV   BX,4                   ;number of ghosts
EYES1:    MOV   CX,11                  ;11=0....10 sprites
EYES2:    CALL  PUTSPRITE2             ;put prize on screen
          ADD   EDI,32                 ;align on shl5 boundaries
          LOOP  EYES2                  ;repeat for all moves of 1 ghost 
          ADD   EDI,25248              ;25248=800*32-32*11
          DEC   BX                     ;decrement number of ghosts left
          JNZ   EYES1                  ;repeat for all ghosts
;-INITIALIZE-RTC-----------------------;--------------------------------------
          PUSH  ES                     ;save es register
          PUSH  DS                     ;save ds register
          MOV   AX,3508H               ;read rtc vector in ivt
          INT   21H                    ;dos call (raw ivt fails)
          MOV   AX,2508H               ;read rtc vector in ivt
          MOV   WPTR DS:[INT08H+00],BX ;save    handler offset
          MOV   WPTR DS:[INT08H+02],ES ;restore handler offset
          PUSH  CS                     ;set new handler segment
          POP   DS                     ;set new handler segment
          MOV   DX,OFFSET SNDDRV000    ;set new handler offset
          INT   21H                    ;dos call (raw ivt fails) 
          POP   DS                     ;restore ds register
          MOV   BX,65532/NEWRATE       ;new frequency
          CALL  SETHTZ000              ;set new frequency
;-INITIALIZE-CONSTANTS-----------------;--------------------------------------
          MOV   ESI,OFFSET PACCORDX    ;here we save the original structures
          MOV   EDI,OFFSET SAVESTRUCT  ;because contrary to start of code we
          CALL  COPYBLK                ;will need them again
;-INITIALIZE-SOUNDS--------------------;--------------------------------------
          MOV   ECX,5                  ;random data of sound (5 banks)
          MOV   EDI,OFFSET ROMFONTS    ;store in array sequentially
GETDATA:  MOV   AX,1130H               ;"return font pointer" bios call 
          MOV   BH,CL                  ;bh=font number requested
          PUSH  CX                     ;save cx register
          INT   10H                    ;video bios call
          POP   CX                     ;restore cx register
          MOV   WPTR DS:[DI+2],ES      ;es=segment of requested font
          MOV   WPTR DS:[DI+0],BP      ;bp=offset of requested font
          ADD   DI,4                   ;add fontinfo array entry size
          LOOP  GETDATA                ;repeat for all fonts (aka sound banks)
          POP   ES                     ;restore es register
;-DISPLAY-UPPER-BAR--------------------;--------------------------------------
          mov   cx,3                   ;
          MOV   EDI,DS:[PHYSCR]        ;edi=offset of screen
          mov   ebx,offset marqueecol  ;
tricol:   mov   dx,wptr ds:[ebx]       ;
          pushad                       ;
          MOV   ESI,OFFSET MARQUEE     ;  ;length =984 bytes
          add   edi,288+800*13         ;
          mov   ecx,33                 ;height in pixel
marquee0: push  cx                     ;
          mov   ecx,28                 ;
marquee1: mov   ax,ds:[esi]            ;
          mov   bx,8                   ;
marquee2: test  al,BPTR DS:[ADPCMTTL+BX-1]
          jz    marquee3               ;
          jmp   short marquee4         ;
marquee3: mov   bptr es:[edi],dl       ;
marquee4: inc   edi                    ;
          DEC   bx                     ;
          jnz    marquee2              ;
          dec   esi                    ;
          loop  marquee1               ;
          pop   cx                     ;
          add   edi,576                ;
          loop  marquee0               ;
          popad                        ;
          add   di,wptr ds:[ebx+2]     ;
          add   ebx,4                  ;
          loop  tricol                 ;
;-ONE-LIFE-----------------------------;--------------------------------------
; everytime a player loses a life we   ;
; come back here, which redraws the    ;
; whole maze                           ;
;-ONE-LIFE-----------------------------;--------------------------------------
ONELIFE:  MOV   EDI,DS:[LOGSCR]        ;edi=offset of screen
          MOV   ESI,OFFSET MAZE        ;esi=offset of map
          MOV   EBX,OFFSET TILES001_RAW;ebx=offset of tiles
          MOV   ECX,MAZEHEIGHT         ;ecx=map height
          MOV   EDX,MAZEWIDTH          ;edx=map width
          MOV   EAX,800*16-MAZEWIDTH*16;eax=column alignment
          MOV   EBP,((38-1)*16)        ;ebp=tilemap alignment
          CALL  SETMAZ000              ;draw maze in logical screen
          CALL  SETPAL000              ;color tiles
;-- SAVE A DOT AND A POWERPIL          ;we copy a dot and a power
          MOV   CX,2                   ;since only tiles need play restoring
          MOV   ESI,DS:[LOGSCR]        ;esi=offset of screen
          ADD   ESI,(23*16-7)*800+10   ;esi=offset of src powerpill-dot
          MOV   EDI,DS:[LOGSCR]        ;edi=offset of screen
          ADD   EDI,(159*800+448+32)+32;esi=offset of dst powerpill-dot
DOBOTH:   CALL  PUTSPRITE              ;put prize on screen
          ADD   ESI,32                 ;add size of tile
          ADD   EDI,32                 ;add size of tile
          LOOP  DOBOTH                 ;repeat for all tiles
;-DISPLAY-LOWER-BAR--------------------;--------------------------------------
;display bottom status bar ie : LIVES qnd FRUIT level
          MOV   ESI,DS:[LOGSCR]        ;edi=offset of screen
          ADD   ESI,(175*800+448+32-800*16-32)  
          MOV   EDI,DS:[PHYSCR]        ;edi=offset of screen
          ADD   EDI,800*560+592
          CALL  PUTSPRITE              ;put prize on screen
          DEC   WPTR DS:[lifecnt]
          JZ    GAMEEXIT
;show lives
          MOV   ESI,DS:[LOGSCR]        ;edi=offset of screen
          ADD   ESI,448+96*1+32*0+2+800+G1*0
          MOV   CX,WPTR DS:[lifecnt]
          MOV   EDI,DS:[PHYSCR]        ;edi=offset of screen
          ADD   EDI,800*560+176+32*2
ONELIFEL: CALL  PUTSPRITE              ;put prize on screen
          SUB   EDI,32
          LOOP  ONELIFEL
; clear the taken life away at bottom
          MOV   ESI,(175*800+448+32-800*16)+96   ; we CLEAR it
          ADD   ESI,DS:[LOGSCR]        ;edi=offset of screen
          MOV   EDI,DS:[PHYSCR]        ;edi=offset of screen
          MOV   DX,32
          MOV   CX,WPTR DS:[lifecnt]
          sub   cx,2
          shl   dx,cl
          add   edi,800*560+176+32*2
          sub   EDi,edx
          CALL  PUTSPRITE              ;put prize on screen
          MOV   ESI,OFFSET SAVESTRUCT    ;base of all CSTs
          MOV   EDI,OFFSET PACCORDX
          CALL  COPYBLK               
ghoststd1:MOV   EDI,OFFSET pal_state1  ;
          CALL  SETSTATE               ;
          mov   dptr ds:[ghoststate],0
;-----------------------------------------------------------------------------
; INTRO ENDS HERE
;-----------------------------------------------------------------------------
ALIGN 4                                ;align for fastest branching
GAMELOOP: test  dptr ds:[ghoststate],1
          jz    ghoststd2
          CMP   dptr ds:[ghosttime],16
          JNC   NOFLASH
          MOV   EDI,OFFSET pal_state3  ;
          TEST  dptr ds:[ghosttime],2
          JZ    WHITE
          MOV   EDI,OFFSET pal_state2  ;
WHITE:    CALL  SETSTATE               ;
NOFLASH:  dec   dptr ds:[ghosttime]
          jnz   ghoststd2
          jmp   short ghoststd1
ghoststd2:CALL  SWPSCR000              ;copy logical to physical screen
          MOV   EBP,OFFSET PACCORDX4   ;process ghost number 4
          CALL  GETKBD000              ;read keyboard
          MOV   EBP,OFFSET PACCORDX3   ;process ghost number 3
          CALL  GETKBD000              ;read keyboard
          MOV   EBP,OFFSET PACCORDX2   ;process ghost number 2
          CALL  GETKBD000              ;read keyboard
          MOV   EBP,OFFSET PACCORDX1   ;process ghost number 1
          CALL  GETKBD000              ;read keyboard
          MOV   EBP,OFFSET PACCORDX    ;process ghost number 
          CALL  GETKBD000              ;read keyboard
          CMP   DS:[DOTNUMS],244       ;if board cleared
          JZ    GAMEEXIT               ;continue gameloop
          CMP   AX,011BH               ;if esc key not pressed
;         CMP   AL,1BH                 ;if esc key not pressed
          JNZ   GAMELOOP               ;continue gameloop
;**************************************;***********************************************
; GAME EXIT
;**************************************;***********************************************
GAMEEXIT: MOV   AX,2508H               ;write rtc vector in ivt
          MOV   DX,WPTR DS:[INT08H+00] ;set old handler offset
          PUSH  WPTR DS:[INT08H+02]    ;set old handler segment
          POP   DS                     ;set old handler segment
          INT   21H                    ;dos call (raw ivt fails)
          MOV   BX,65532               ;old frequency
          CALL  SETHTZ000              ;set old frequency
          IN    AL,61H                 ;read speaker state
          AND   AX,0FCH                ;set speaker off
          OUT   61H,AL                 ;output command
          MOV   AX,3                   ;else set tty mode co80
          INT   10H                    ;bios video system call
          MOV   AX,4C00H               ;set error code
          INT   21H                    ;return to dos shell
;**************************************;***********************************************
;SET COLORS
;**************************************;***********************************************
SETPAL000:MOV   ESI,DS:[LOGSCR]        ;edi=offset of screen
          add   esi,mazewidth*16
          mov   bx,offset pacpal
          mov   cx,6
dobands:  push  cx
          mov   cx,32
          mov   ah,bptr ds:[bx]
SETPAL001:push  cx
          mov   cx,176*2;800-592;((38-1)*16)        ;ebp=tilemap alignment
setpal002:mov   al,bptr es:[esi]
          test  al,al
          jz    setpal003
          mov   bptr es:[esi],ah
setpal003:inc   esi
          loop  setpal002
          add   esi,(800-176*2);592
          pop   cx
          loop  setpal001
          inc   bx
          pop   cx
          loop  dobands
          RET                          ;return to caller
;--------------------------------------;--------------------------------------
;                                      ;
; Do maze collision test (part #1)     ;out: a) DS:[EBP+36] is displacement
;                                      ;     b) a!=0 =>EDX=ydelta ECX=xdelta
;                                      ;     c) a!=0 =>AL=tile value
;                                      ;
;--------------------------------------;--------------------------------------
TSTCOLXXX:MOV   EDI,DS:[EBP+12]        ;start of pac index
          MOV   EAX,DS:[EBP+04]        ;refresh pacman maze x position
          MOV   EBX,DS:[EBP+08]        ;refresh pacman maze y position
          MOV   EDX,DS:[EDI+24]        ;pacman maze position y delta
          MOV   ECX,DS:[EDI+20]        ;pacman maze position x delta
          ADD   EBX,EDX                ;absolute maze index
          ADD   EAX,ECX                ;absolute maze index
          ADD   EBX,EAX                ;absolute maze index
          MOV   AL,BPTR DS:[MAZE+EBX]  ;dl=read tile value
          RET                          ;return to caller
TSTCOL000:CALL  TSTCOLXXX              ;get current maze tile value
          MOV   EDI,DS:[EDI+16]        ;potential screen offset diplacement
          TEST  AL,AL                  ;test if empty previously dot tile
          JZ    TSTCOL555              ;if so validate move
          TEST  AL,0C0H                ;test if dot/energizer or intersection
          JNZ   TSTCOL555              ;if so validate move
          XOR   EDI,EDI                ;else displacement is zero
TSTCOL555:CMP   DPTR DS:[EBP+04],27    ;test if tunnel right
          JNZ   TSTCOL666              ;else test if tunnel left
          CMP   BPTR DS:[EBP+24],77    ;and test if key right
          JNZ   TSTCOL666              ;else test if tunnel left
          CALL  CLRBLK000              ;clear block at this postion
          MOV   DPTR DS:[EBP+04],0     ;refresh pacman maze x position
          SUB   DPTR DS:[EBP+00],2*(176+32+8)     ;refresh pacman maze x position
          JMP   SHORT TSTCOL999        ;exit
TSTCOL666:CMP   DPTR DS:[EBP+04],0     ;test if tunnel left
          JNZ   TSTCOL999              ;else exit
          CMP   BPTR DS:[EBP+24],75    ;and test if key left
          JNZ   TSTCOL999              ;else test if tunnel left
          CALL  CLRBLK000              ;clear block at this postion
          MOV   DPTR DS:[EBP+04],27     ;refresh pacman maze x position
          ADD   DPTR DS:[EBP+00],2*(176+32+8)     ;refresh pacman maze x position
TSTCOL999:MOV   DPTR DS:[EBP+36],EDI   ;save *this* potential screen offset
;--------------------------------------;--------------------------------------
;CLEAR BLOCK                           ;
;--------------------------------------;--------------------------------------
CLRBLK000:PUSH  EDI
          PUSH  DPTR DS:[EBP+00]
          POP   DPTR DS:[EBP+44]
          MOV   ESI,(175*800+448+32-800*16)+96 ;else is pill
          CALL  RESTX
          POP   EDI
          RET
;--------------------------------------;--------------------------------------
;                                      ;
;SWAP SCREEN                           ;
;                                      ;
;--------------------------------------;--------------------------------------
ALIGN 4                                ;align for fastest branching
SWPSCR000:MOV   EBP,OFFSET paccordx    ;base of all CSTs
;-FOR-EACH-CHARACTER-------------------;-BEGIN--------------------------------
          PUSHAD                       ;save all registers
          MOV   DPTR DS:[CHARNUM],CHARMAX    ;start with character 0
onecharx: CALL  TSTCOL000              ;test collision
          TEST  DPTR DS:[EBP+36],0FFFFH;test if displacement granted
          JZ    BADMOVE                ;if not then do not test for events
;################ DIFFERENCIATES PACMAN FROM OTHER CHARACTERS
          TEST  DPTR DS:[EBP+28],1     ;1=user (key) 0=computer (auto)
          JZ    AUTOCHAR               ;if user then querry keyboard
;################ PACMAN TESTS EXCLUSIVELY
          PUSHAD
          PUSH  EBP
          MOV   EAX,DS:[EBP+0004]       ;EAX= pacman maze x position
          MOV   EBX,DS:[EBP+0008]       ;EBX= pacman maze y position
;--------- begin CHERRY TEST-----------;--------------------------------------
          CMP   DPTR DS:[CHERRYSTATE],1
          JZ    SHOWIT
          CMP   DPTR DS:[CHERRYSTATE],0
          JZ    DONEIT
TIMEIT:   DEC   DPTR DS:[CHERRYTIME]   ;else CHERRYSTATE= 2
          JNZ   SHOWIT
          MOV   ESI,(175*800+448+32-800*16)+96   ; we CLEAR it
          MOV   DPTR DS:[CHERRYSTATE],0
          JMP   SHORT WIPEIT
SHOWIT:   MOV   ESI,(175*800+448+32-800*16-32)   ; we SHOW it
WIPEIT:   ADD   ESI,DS:[LOGSCR]        ;edi=offset of screen
          MOV   EDI,DS:[LOGSCR]        ;edi=offset of screen
          ADD   EDI,(800*(35+24*16)+160+14*16-170-800*(60+64+32))
          CALL  PUTSPRITE              ;put prize on screen
TESTIT:   CMP   EAX,((MAZEWIDTH/02)*1)
          JNZ   NOCHERRY
          CMP   EBX,((MAZEWIDTH*17)*1)
          JNZ   NOCHERRY
          ADD   DS:[SCORE_NUM],10      ;add 100 for cherry
          MOV   DPTR DS:[CHERRYSTATE],0
NOCHERRY:
DONEIT:
;--------- begin GHOSTs TEST-----------;--------------------------------------
          MOV  ECX,4
NOGHOSTS: ADD  EBP,CHARSTRUCTSIZ
          CMP  EAX,DS:[EBP+0004]      ;refresh pacman maze x position
          JNZ  NOGHOST
          CMP  EBX,DS:[EBP+0008]      ;refresh pacman maze y position
          JNZ  NOGHOST
;-------------- ghost collision
          TEST DPTR DS:[GHOSTSTATE],1
          JNZ  BLUESTATE
;-------------- pac dies
NOPSEC000:XOR   DX,DX                  ;number of milliseconds=0 5 DONTCARE
          MOV   AH,86H                 ;function wait
          INT   15H                    ;bios function call
          POP   EBP
          POPAD
          JMP   ONELIFE
BLUESTATE:INC   dptr ds:[ghostnum]      ;increment number of eaten ghosts
          mov   ebx,10                  ;1=200 2=400 3=800 4=1600 pts
          mov   ecx,dptr ds:[ghostnum]  ;ghostnum is at least 1 therefore
          shl   ebx,cl                  ;cl=1=200 cl=2=400 cl=3=800 cl=4=1600
          ADD   dptr DS:[SCORE_NUM],ebx ;update player's score
          MOV   DPTR DS:[EBP+0000],(800*(35+14*16)+160+14*16+8-800*60-176)+800*2+6-4      ;refresh pacman maze phy offset
          MOV   DPTR DS:[EBP+0004],((MAZEWIDTH/02)*1)      ;refresh pacman maze x position
          MOV   DPTR DS:[EBP+0008],((MAZEWIDTH*13)*1)      ;refresh pacman maze y position
NOGHOST:  LOOP  NOGHOSTS
GHOSTSEND:POP   EBP
          POPAD
;--------- begin DOTs TEST-------------;--------------------------------------
          MOV   WPTR DS:[SAMPNUM],1    ;default back sound
          test  WPTR DS:[ghoststate],1
          jz    sound1ok
          INC   WPTR DS:[SAMPNUM]      ;ghost back sound
sound1ok: TEST  AL,080H                ;test if dot/powerpill present
          JZ    AUTOCHAR               ;if not then do not test for events
          MOV   WPTR DS:[SAMPNUM],3    ;dot chomp sound
          test  WPTR DS:[ghoststate],1
          jz    sound2ok
          INC   WPTR DS:[SAMPNUM]      ;ghost dot chomp sound
sound2ok: INC   DS:[DOTNUMS]
          INC   DS:[SCORE_NUM]         ;add 10 to score per dot       
          CMP   DS:[DOTNUMS],70        ;test if 70 dots passed
          JNZ   NOCHERRY0
          JMP   SHORT CHERRY3
NOCHERRY0:CMP   DS:[DOTNUMS],170        ;test if 70 dots passed
          JNZ   CHERRY0
CHERRY3:  MOV   DPTR DS:[CHERRYSTATE],2
          MOV   DPTR DS:[CHERRYTIME],50
CHERRY0:  CMP   BPTR DS:[MAZE+EBX],08AH;test if powepill
          JNZ   yof
          jmp   SHORT yaf
yof:      CMP   BPTR DS:[MAZE+EBX],0CAH;test if powepill
          JNZ   NOPOWER
yaf:      ADD   DS:[SCORE_NUM],4       ;add 40 to score per dot so total = 50
          MOV   EDI,OFFSET pal_state2  ;
          pushad
          CALL  SETSTATE               ;
          popad
          mov   dptr ds:[ghostnum],0   ;reset number of eaten ghosts
          mov   dptr ds:[ghosttime],50 ;set time of counter-attack
          mov   dptr ds:[ghoststate],1 ;set state of ghost to blue
NOPOWER:  AND   BPTR DS:[MAZE+EBX],40H ;dl=clear tile value
;-UPDATE-MAZE-POS----------------------;--------------------------------------
AUTOCHAR: ADD   DS:[EBP+0004],ECX      ;we end up here if not pacman
          ADD   DS:[EBP+0008],EDX      ;refresh pacman maze x & y positions
          PUSH  DPTR DS:[EBP+0040]
          POP   DPTR DS:[EBP+0048]
          MOV   DS:[EBP+0040],EAX      ;save- the tile to restore 
          PUSH  DPTR DS:[EBP+0000]     ;get base offset of tile
          POP   DPTR DS:[EBP+0044]     ;save- the offset where to restore tile
BADMOVE:  ADD   EBP,CHARSTRUCTSIZ        ;we end  up here if displacement was refused
          dec   DPTR DS:[CHARNUM]      ;next character data off is+=structsiz
          JNZ   onecharx               ;repeat for all characters
          POPAD                        ;restore all registers
;-FOR-EACH-ANIM-FRAME------------------;--------------------------------------
          MOV   EBP,OFFSET paccordx    ;base of all CSTs
          MOV   DS:[oneeveryfour],4    ;repeat for all 4 comp pac anim frames
onemove:PUSHAD                       ;save all registers
;-FOR-EACH-CHARACTER-------------------;-BEGIN--------------------------------
          MOV   DPTR DS:[CHARNUM],CHARMAX    ;start with character 0
;-CLEAR-PREVIOUS-POS-BLOCK-------------;--------------------------------------
onechar:  CMP  DPTR DS:[CHARNUM],CHARMAX ;start with character 0
          JZ    NORESTORE
;-RESTORE-BACKGROUND-OF-OLD-SPRITE-----;--------------------------------------
          MOV   EAX,DPTR DS:[EBP+0048] ;get old tile number
REST1:    CMP   AL,85H                 ;is it dot
          JNZ   REST2
          JMP   SHORT REST3
REST2:    CMP   AL,0C5H                 ;is it dot
          JNZ   REST4
REST3:    MOV   ESI,(175*800+448+32-800*16)+64
          JMP   SHORT REST9
REST4:    CMP   AL,8AH                 ;is it dot
          JNZ   REST5
          JMP   SHORT REST6
REST5:    CMP   AL,0CAH                 ;is it dot
          JNZ   REST7
REST6:    MOV   ESI,(175*800+448+32-800*16)+32 ;else is pill
          JMP   SHORT REST9
REST7:    MOV   ESI,(175*800+448+32-800*16)    
REST9:    call  restx
          JMP   SHORT RESTORED
NORESTORE:MOV   ESI,(175*800+448+32-800*16)+96 ;else is pill
          call  restx
;-LOAD-THIS-INSTANCE'S-VALS-AND-ALIGN--;--------------------------------------
RESTORED: MOV   EDI,DS:[EBP+12]        ;start of pac index
          MOV   EAX,DS:[EBP+36]        ;pacman screen position pixel delta
          ADD   EDI,DS:[EBP+20]        ;get animated pac sprite number value
          MOV   ESI,DS:[LOGSCR]        ;edi=offset of screen
          ADD   ESI,DS:[EDI]           ;get animated pac sprite offset value
          MOV   EDI,DS:[LOGSCR]        ;edi=offset of screen
;-UPDATE-SPRITE-POS-AND-DOUBLE-BUFFER--;--------------------------------------
          ADD   DS:[EBP+00],EAX        ;update sprite position
          ADD   EDI,DS:[EBP+00]        ;also set new position this frame
          CALL  PUTSPRITE              ;put character on screen
;-TEST-ANIM-OVERLAP--------------------;--------------------------------------
          ADD   WPTR DS:[EBP+20],4     ;get next of four chomp positions
          TEST  WPTR DS:[EBP+20],0FFF0H;test if less than 4 position
          JZ    getnexta               ;if so keep going
          MOV   WPTR DS:[EBP+20],0     ;else reset count to position 0
;-SET-SCORE----------------------------;--------------------------------------
          xor     dx,dx
          mov     ax,wptr ds:[score_num]
          add     ax,10000             ;artificial align digits
          mov     di,offset score_str2
          mov     si,dx                ;Save high word in SI as well
          mov     bx,10                ;Divisor
          mov     cx,sp                ;Remember stack location
          STC
SETSCO001:div     bx                   ;Divide, result stays in AX, remainder in DX
          push    dx                   ;Save remainder
          xor     dx,dx                ;Prepare for next round
          test    ax,ax                ;Any more digits?
          jnz     SETSCO001
store:    POP     WPTR DS:[DI]
          INC     DI
          cmp     cx,sp
          jne     store
          MOV     ESI,DS:[LOGSCR]        ;edi=offset of screen
          add     ESI,509*800
          MOV     EDI,DS:[PHYSCR]        ;edi=offset of screen
          ADD     EDI,800*29+448+104-8-8
          MOV     eCX,5
          MOV     EBX,offset score_str3
PUTDIGITS:MOV     AL,BPTR DS:[EBX]
          AND     EAX,0FFH
          SHL     EAX,5
          ADD     ESI,EAX
          CALL    PUTSPRITE              ;put prize on screen
          ADD     EDI,8
          INC     EBX
          SUB     ESI,EAX
          LOOP    PUTDIGITS
;-FOR-EACH-CHARACTER-------------------;-END----------------------------------
getnexta: ADD   EBP,CHARSTRUCTSIZ      ;next character data off is+=structsiz
          dec   DPTR DS:[CHARNUM]      ;start with character 0
          JNZ   onechar                ;repeat for all characters
;-BLIT-SCREEN--------------------------;--------------------------------------
          MOV   EDI,DS:[PHYSCR]        ;set physical screen as destination
          MOV   ESI,DS:[LOGSCR]        ;set logical screen as source
          ADD   EDI,176+800*60         ;
          MOV   BX,495                 ;
swpscr00x:MOV   CX,112                 ;112=448/4
SWPSCR001:LODS  DPTR ES:[ESI]          ;read 4 bytes from source
          STOS  DPTR ES:[EDI]          ;write 4 pixels to destination
          LOOP  SWPSCR001              ;repeat n times
          ADD   ESI,800-448            ;
          ADD   EDI,800-448            ;
          DEC   BX                     ;decrement counter
          JNZ   SWPSCR00x              ;repeat n times
;-FOR-EACH-ANIM-FRAME------------------;-END----------------------------------
          POPAD                        ;restore al registers
          DEC   DS:[oneeveryfour]      ;decrement  anim count
          JNZ   onemove                ;repeat for all 4 positions
          RET                          ;return to caller
;**************************************;***********************************************
;GENERIC 32x32 PUTSPRITE 
;**************************************;***********************************************
PUTSPRITE:pushAd
          MOV   BX,28                 ;
swpscr00y:MOV   CX,7                 ;112=448/4
SWPSCR00z:LODS  DPTR ES:[ESI]          ;read 4 bytes from source
          STOS  DPTR ES:[EDI]          ;write 4 pixels to destination
          LOOP  SWPSCR00z              ;repeat n times
          ADD   ESI,800-28            ;
          ADD   EDI,800-28            ;
          DEC   BX                     ;decrement counter
          JNZ   SWPSCR00y              ;repeat n times
          popAd
          RET                          ;return to caller

PUTSPRITE2:pushAd
          MOV   BX,28                  ;
swpscr01y:MOV   CX,7                  ;112=448/4
SWPSCR01z:LODS  DPTR ES:[ESI]          ;read 4 bytes from source
          OR    EAX,DPTR ES:[EDI]
          STOS  DPTR ES:[EDI]          ;write 4 pixels to destination
          LOOP  SWPSCR01z              ;repeat n times
          ADD   ESI,800-28            ;
          ADD   EDI,800-28            ;
          DEC   BX                     ;decrement counter
          JNZ   SWPSCR01y              ;repeat n times
          popAd
          RET                          ;return to caller

;**************************************;***********************************************
;GENERIC TILE DECOMPRESSION
;UNCOMPRESS TILES
;**************************************;***********************************************
UNCTIL000:                             ;decompresses maze tiles
;first we do HORIZONTAL PASS
          MOV   ESI,(38-1)*16          ;reposition line or column source 
          MOV   EDI,OFFSET tiles001_raw+(16-1);get ptr to raw pixel data
          MOV   EDX,-1                 ;pixel destination position delta
          MOV   EBP,(38+1)*16          ;line destination position delta
          MOV   EAX,OFFSET tiles001_raw;data source offset
          MOV   EBX,OFFSET TILE        ;get ptr to decompressing table
          MOV   ECX,0F000026H          ;ecx = 00 15 00 38 d =# 8x8 tiles
          PUSHAD                       ;save ebx ecx registers
          CALL  UNCTIL002              ;uncompress tiles horizontally
;second we do HORIZONTAL PASS
          POPAD                        ;restore ebx ecx registers 
          MOV   EDI,OFFSET tiles001_raw+38*16*14;
trythis:  NEG   EDX                    ;pixel destination position delta
          NEG   EBP                    ;column destination position delta    
          CALL  UNCTIL002              ;uncompress tiles vertically
          RET
;- - - - - - - - - - - - - - - - - -
UNCTIL001:;decompresses sprite tiles
;first we do HORIZONTAL PASS
          MOV   ESI,(49-1)*16          ;reposition line or column source 
          MOV   EDI,OFFSET sprites_raw+(16-1);get ptr to raw pixel data
          MOV   EDX,-1                 ;pixel destination position delta
          MOV   EBP,(49+1)*16          ;line destination position delta
          MOV   EAX,OFFSET sprites_raw;data source offset
          MOV   EBX,OFFSET SPRI        ;get ptr to decompressing table
          MOV   ECX,10000031H          ;ecx = 00 16 00 49 d =# 8x8 tiles
          PUSHAD                       ;save ebx ecx registers
          CALL  UNCTIL002              ;uncompress tiles horizontally
;second we do HORIZONTAL PASS
          POPAD                        ;restore ebx ecx registers 
          MOV   EDI,OFFSET sprites_raw+49*16*15
          call  trythis
          RET                          ;return to caller
UNCTIL002:PUSHAD                       ;save number of 8x8 tiles to decompress
          MOV   BL,BYTE PTR DS:[EBX]   ;read tile
          TEST  BL,BL                  ;is this still uncompressed already
          JZ    UNCTIL999              ;if so then skip uncompressing
          TEST  BL,40H                 ;test for horizontal code
          JZ    UNCTIL003              ;if so the process horizontally
          TEST  EBP,80000000H          ;test for vertical decompression pass
          JNZ   UNCTIL004              ;if so process this tile
          JMP   SHORT UNCTIL999        ;else skip this tile
UNCTIL003:TEST  EBP,80000000H          ;test for vertical decompression pass
          JNZ   UNCTIL999              ;if not then skip this tile
UNCTIL004:AND   EBX,0000003FH          ;get source tile number
          SHL   BX,4                   ;get source offset
          ADD   eBX,EAX                ;tasm warning vs. saves one byte
          bswap ecx
UNCTIL005:PUSH  CX                     ;save number of colums or lines
          MOV   CX,16                  ;number of pixels per colums or lines
UNCTIL006:MOV   AL,BYTE PTR DS:[EBX]   ;get source pixel value
          MOV   BYTE PTR DS:[EDI],AL   ;set destination pixel value
          INC   EBX                    ;inc source
          ADD   EDI,EDX                ;reposition pixel destination 
          LOOP  UNCTIL006              ;process next pixel
          ADD   EBX,ESI                ;reposition line or column source
          ADD   EDI,EBP                ;reposition line or column destination
          POP   CX                     ;restore number of colums or lines
          LOOP  UNCTIL005              ;process next line or column
UNCTIL999:POPAD                        ;restore bx cx edi
          INC    eBX                   ;point to next tile in uncompress table
          ADD    EDI,16                ;keep edi=ebx*16
          LOOP   UNCTIL002             ;process next tile
          RET                          ;return to caller
;**************************************;***********************************************
;GENERIC  TILEMAPPING (tiles are 8x8)  ;
;1.draws  the maze tilemap             ;
;2.draws  the sprites tilemap          ;
;INPUT:   ESI=offset of map            ;
;         EDI=offset of screen         ;
;         EBX=offset of tiles          ;
;         ECX=map height(ie:MAZEHEIGHT);
;         EDX=map width (ie:MAZEWIDTH) ;
;         EAX=edi add  (12352)
;         EBP=innerloop ADD ESI,592 (tilemap width)
;         16 is constant 784=800-16 is constant 48176
;**************************************;***********************************************
SETMAZ000:
DOROWS:   PUSH  CX                    ;save number or rows
          MOV   ECX,EDX                ;get mapwidth
DO1ROW:   PUSHAD                       ;push esi/push edi/push ecx
READTILE: XOR   EAX,EAX                ;clear ah
          PUSHAD                       ;push esi/push edi/push ecx
          LODSB                        ;al=ds:[esi]
          MOV   DX,AX                  ;mov dl,al
          AND   AL,3FH                 ;remove 3rd color mask
          MOV   ESI,EBX                ;esi=offset of tiles
          SHL   EAX,4                  ;get indexed tile displacement
          ADD   ESI,EAX                ;get raw tile offset
          MOV   CX,16                 ;tileheight rows
COPYBITMAP:PUSH CX                    ;save number of rows
          MOV   CX,16                  ;mov cl,16 tilewidth columns
copypix:  LODSB                        ;load value
          TEST  AL,AL                  ;test if visible
          JZ    nocolortst             ;if not skip
          TEST  DL,80h;DL                  ;test if NOT 3rd color case
          JZ    nocolortst             ;if so skip
          MOV   AL,7                   ;else 3rd color=7 (pale white)
          TEST  DL,0AH                 ;test if power pill
          JZ    nocolortst             ;if not keep palette index 7
          INC   AL                     ;if so asign palette index 8
nocolortst:STOS BPTR ES:[EDI]          ;write color byte to screen
          LOOP  copypix                ;repeat for all the tilewidth columns
          ADD   ESI,EBP                ;realign src with next data column 
          ADD   EDI,(800-16)           ;realign dst with next screen column 
          POP   CX                    ;restore number of rows
          LOOP  COPYBITMAP             ;repeat for mapheight rows
          POPAD                        ;pop ecx/pop edi/pop esi
          LOOP  READTILE               ;repeat for number of tiles
          POPAD                        ;pop ecx/pop edi/pop esi
          INC   ESI                    ;esi++
          ADD   EDI,16                 ;edi=edi+16
          LOOP  DO1ROW                 ;and do one mapcolumns
          ADD   EDI,EAX                ;edi=edi+maprow sourcewidth in pixel
          POP   CX                    ;restore number of maprows
          LOOP  DOROWS                 ;repeat for mapheight rows
          RET                          ;return to caller
;**************************************;***********************************************
;INSTALL SOUND DRIVER                  ; 
;**************************************;***********************************************
;    at frequency higher than the normal 18 times a second, by
;    speeding up system timer 0.  In this example, interrupts 
;    occur at 50 times normal, or 910 times per second.
SETHTZ000:
;         CLI                          ;disable interrupts
          MOV   AL,36H                 ;command for 16-bit,
          OUT   43H,AL                 ;mode 3, binary operation
;         JMP   $+2                    ;hardware wait
;         JMP   $+2                    ;hardware wait
          MOV   AX,BX                  ;counter value
          OUT   40H,AL                 ;load timer 0 count LSB
;         JMP   $+2                    ;hardware wait
;         JMP   $+2                    ;hardware wait
          MOV   AL,AH                  ;get most significant byte
          OUT   40H,AL                 ;load timer 0 count MSB
;         STI                          ;enable interrupts
          RET                          ;return to caller
;**************************************;***********************************************
;PLAY SOUND                            ; 
;**************************************;***********************************************
SNDDRV000:cli
          PUSHFd
          pushad
;xor ecx,ecx
          MOV     CX,WPTR DS:[SAMPNUM]
;and cx,7
          MOV     ESI,OFFSET PHYSCR;   ;load off. of snd. data
GETSAMP:  ADD     ESI,SAMPINFSIZ    ;PHYSCR=SOUND1-SAMPINFSIZ
          LOOP    GETSAMP              ;repeat till selected sample
          MOV     EBX,OFFSET INT08H    ;load off.of bank data
          MOV     ECX,DPTR DS:[ESI+0]  ;load bank num.
GETBANK:  ADD     EBX,BANKINFSIZ       ;INT08H=ROMFONTS-BANKINFSIZ
          LOOP    GETBANK
          LGS     DI,DPTR DS:[EBX]     ;load seg./off. of bank
          ADD     EDI,DPTR DS:[ESI+4]  ;load beg. off. of sample
          CALL    SNDSPK000            ;play sample
          popad
          DEC   DS:[countdown]
          JNZ   int8_exit         
          MOV   DS:[countdown],NEWRATE ; reload counter
          POPFd
          jmp   dword ptr DS:[INT08H+0]     ; process old interrupt 8
int8_exit:CLI                        ; disable interrupts
          PUSH  AX
          MOV   AL,20H            ; end-of-interrupt command
          OUT   20H,AL            ; issue command to controller
          POP   AX
          POPFd
          IRET
;**************************************;***********************************************
;SOUND SPEAKER                         ; 1BIT TTL LOGIC ADPCM
;**************************************;***********************************************
SNDSPK000:MOV   BX,WPTR DS:[BITCNT]
          INC   WPTR DS:[BITCNT]
          MOV   CL,BPTR DS:[ADPCMTTL+BX]
          TEST  CL,CL
          JNZ   BITOK
          MOV   WPTR DS:[BITCNT],0
          MOV   CL,128
          INC   WPTR DS:[BYTECNT]
          MOV   EDX,DPTR DS:[ESI+8]    ; Load siz. of sample
          CMP   WPTR DS:[BYTECNT],DX
          JC    BITOK
          MOV   WPTR DS:[BYTECNT],0
BITOK:    MOV   BX,WPTR DS:[BYTECNT]
          IN    AL,61H                 ;read speaker state
          TEST  BPTR GS:[DI+BX],CL        ;EDI=SOUND
          JZ    SPKOFF
          OR    AL,3                   ;set speaker on BRUIT
          JMP   SHORT SPKOK
SPKOFF:   AND   AL,0FCH                ;set speaker off
SPKOK:    OUT   61H,AL                 ;set speaker state
          INC   DS:[democount]
          CMP   wptr DS:[democount],182*(NEWRATE/10) ; 1 second elapsed ?
          JB    demo3              ; jump if not
          MOV   DS:[democount],0  ; reset democount
;;******** end code that executes every second         
demo3:    RET
;**************************************;***********************************************
;READ KEYBOARD GAME CONTROL ADAPTER    ; -> GCAI holds commands
;**************************************;***********************************************
GETKBD000: push  dptr DS:[EBP+12]      ;push pacstart
           pop   dptr DS:[EBP+16]      ;restore pacstart as pacstartprev
;-CPU-OR-USER-?------------------------;--------------------------------------
GETKBDXXX:TEST  DPTR DS:[EBP+28],1     ;1=user (key) 0=computer (auto)
          JNZ   GETKBDYYY              ;if user then querry keyboard
;-------- only executed for ghosts
          CALL  TSTCOLXXX
          TEST  AL,40H
          JnZ   aga2
          MOV   EBX,DS:[EBP+32]        ;get key table values as base (KEYTABs)
          db    0fh,31h                ;Reqd time Stamp Counter opcode
          bswap edx
          xor   eax,edx
;agan:    dec   ah
;         AND   AH,3                   ;normalize to [0...3] for index
;         CMP   AH,BPTR DS:[EBX+01]
;         JZ    agan
;         mov   BPTR DS:[EBX+01],ah
          mov   al,1
          cmp   dptr ds:[pacmazey],((MAZEWIDTH*23)*1)
          jc    agan
          neg   al
          test  dptr ds:[ghoststate],0ffh
          jz    agan
          neg   al
agan:     sub   ah,al
          AND   AH,3                   ;normalize to [0...3] for index
          mov   BPTR DS:[EBX+01],ah
;----------- only executed for ghosts
          JMP   SHORT aga              ;and skip keyboard querry
GETKBDYYY:MOV   AH,1                   ;non blocking read keyboard function
          INT   16H                    ;bios kbd call
          JNZ   qhoq                   ;if new key in buffer then retrieve it
aga2:     MOV   AH,BPTR DS:[EBP+24]    ;else key <= old key
          JMP   SHORT aga              ;and skip kbd new key retrieval
qhoq:     XOR   AX,AX                  ;blocking read keyboard function
          INT   16H                    ;bios kbd call
aga:      MOV   BPTR DS:[EBP+24],AH    ;save oldkey <= this key
          MOV   ECX,4                  ;4 directions/keys to test in all
          MOV   EBX,DS:[EBP+32]        ;get key table values as base (KEYTABs)
GETKBDBBB:PUSHAD                       ;save all registers
          CALL  GETKBDAAA              ;test all keys
          POPAD                        ;restore all registers
          mov   edx,dptr DS:[EBP+16]
          cmp   edx,dptr DS:[EBP+12]
          jnz   GETKBD999
          ADD   EBX,6                  ;entries are 6 bytes per call in tab
          LOOP  GETKBDBBB              ;repeat for all four key/directions
GETKBD999:RET                          ;return to caller
;--------------------------------------;--------------------------------------
GETKBDAAA:CMP   AH,DS:[EBX+00]         ;test if this direction key pressed
          JNZ   GETKBDqqq              ;cycle comparaison with all cases
          MOV   EDX,DS:[EBX+02]        ;else get anim offset in tab
          MOV   DS:[EBP+12],EDX        ;get that sequence as base
GETKBDOOO:CALL  TSTCOLXXX              ;do collision detection
          TEST  AL,AL                  ;test if empty previous dotted element
          JZ    GETKBD999              ;if so then keep pactstart value
          TEST  AL,0C0H                ;test if dotted or intersection element
          JNZ   GETKBD999              ;if so then keep pactstart value
          push  dptr DS:[EBP+16]       ;push pacstart prev
          pop   dptr DS:[EBP+12]       ;restore as pacstart
GETKBDQQQ:RET                          ;return to caller
;--------------------------------------;--------------------------------------
;----------------------------------------------------------------------------
COPYBLK:  MOV   CX,CHARMAX*charstructsiz            ;for each characters
xetstruct:LODS  BPTR DS:[ESI]          ;read 4 bytes from source
          MOV   BPTR DS:[EDI],AL
          INC   EDI
          LOOP  xetstruct
          RET
;----------------------------------------------------------------------------
; set palette to palette pointed by edi
;----------------------------------------------------------------------------
SETSTATE: test  word ptr DS:[pillstate],1
          jz    SETSTATE1
          add   edi,4
SETSTATE1:mov   cx,6
palloop0: mov   dx,3C8H
          mov   ax,wptr ds:[di+0]
          out   dx,ax
          inc   dx
          mov   ax,wptr ds:[di+2]
          out   dx,al
          mov   al,ah
          out   dx,al
          add   di,4
          loop  palloop0
          ret
RESTX:    ADD   ESI,DS:[LOGSCR]        ;edi=offset of screen
          MOV   EDI,DS:[LOGSCR]        ;edi=offset of screen
          ADD   EDI,DPTR DS:[EBP+0044]
          CALL  PUTSPRITE              ;put prize on screen
          RET
;**************************************;***********************************************
;ORG       2043                         ;high score 0-->2047-4=2043
;HIGHSCOR  LABEL WORD                   ;saved in last dword of compressed file
;-----------------------------------------------------------------------------
; .STACK
;-----------------------------------------------------------------------------
;ORG       0FFFCH                       ; 1 byte smaller
;_STACK    LABEL WORD                   ; 1 byte smaller
_STACK   EQU   0FFFCH
;-----------------------------------------------------------------------------
_TEXT     ENDS                         ;end of code segment
;-----------------------------------------------------------------------------
; PROGRAM END
;-----------------------------------------------------------------------------
          END   START                  ;end of program
