REM 2D Animated Blobs
REM By Michael Rye Sorensen <ms@cool.dk>

DEFINT A-Z
DECLARE SUB SetPalette ()
DECLARE SUB BlobMove ()
DECLARE SUB SetBlobInfo ()
SCREEN 13

TYPE Blob
        X AS INTEGER
        Y AS INTEGER
        radius AS INTEGER
        strength AS SINGLE
        dx AS INTEGER
        dy AS INTEGER
END TYPE

DIM SHARED MaxBlobs AS INTEGER

MaxBlobs = 9

DIM SHARED Blobs(MaxBlobs) AS Blob
DIM SHARED threshold AS SINGLE

threshold = .1

ScreenxMax = 320
ScreenxMin = 0
ScreenyMax = 200
ScreenyMin = 0

REDIM ScreenBuffer%(32001)
GET (0, 0)-(319, 199), ScreenBuffer%

BufferSEG% = VARSEG(ScreenBuffer%(0))

SetBlobInfo
SetPalette

DO
FOR j% = 0 TO MaxBlobs

ScreenxMax = (Blobs(j%).X + Blobs(j%).radius)
ScreenxMin = (Blobs(j%).X - Blobs(j%).radius)
ScreenyMax = (Blobs(j%).Y + Blobs(j%).radius)
ScreenyMin = (Blobs(j%).Y - Blobs(j%).radius)
IF ScreenxMax > 319 THEN ScreenxMax = 319
IF ScreenyMax > 199 THEN ScreenyMax = 199
IF ScreenxMin < 0 THEN ScreenxMin = 0
IF ScreenyMin < 0 THEN ScreenyMin = 0



        FOR Y% = ScreenyMin TO ScreenyMax

        DEF SEG = BufferSEG% + (20 * Y%)
         
        
                FOR X% = ScreenxMin TO ScreenxMax

                fieldd! = 0
               
                        FOR k% = 0 TO MaxBlobs

                        dx1& = X% - Blobs(k%).X
                        dy1& = Y% - Blobs(k%).Y
                        
                        r! = SQR((dx1& * dx1&) + (dy1& * dy1&))
                        
                        IF r! <= Blobs(k%).radius THEN
                        
                        
                        p! = r! / Blobs(k%).radius
                        p! = 1 - p! * p!
                       
                        fieldd! = fieldd! + (Blobs(k%).strength * p! * p!)
                        
                        END IF

                        NEXT

                        IF fieldd! > threshold THEN
                        c% = 255 * fieldd!
               
                                IF c% > 255 THEN c% = 255
                        
                         POKE 4 + X%, c%
                        ELSE
                         POKE 4 + X%, 0
                        END IF

                NEXT
       
        NEXT

NEXT

PUT (0, 0), ScreenBuffer%, PSET

frame% = frame% + 1
LOCATE 1, 1: COLOR 255: PRINT "Frame"; frame%

BlobMove

LOOP UNTIL INKEY$ = CHR$(27)

BlobData:
DATA 100,50,10,1,0,0
DATA 130,60,10,1,0,0
DATA 160,50,10,1,0,0
DATA 190,60,10,1,0,0
DATA 220,50,10,1,0,0
DATA 250,60,10,1,0,0
DATA 280,50,10,1,0,0

DATA 310,60,10,1,-2,0
DATA 103,53,10,1,2,0
DATA 100,57,10,1,1,0

DEFSNG A-Z
SUB BlobMove

FOR k% = 0 TO MaxBlobs
Blobs(k%).X = Blobs(k%).X + Blobs(k%).dx
Blobs(k%).Y = Blobs(k%).Y + Blobs(k%).dy
NEXT

END SUB

SUB SetBlobInfo

FOR k% = 0 TO MaxBlobs
READ a%, b%, c%, d%, e%, f%
Blobs(k%).X = a%
Blobs(k%).Y = b%
Blobs(k%).radius = c%
Blobs(k%).strength = d%
Blobs(k%).dx = e%
Blobs(k%).dy = f%
NEXT


END SUB

SUB SetPalette

OUT &H3C8, 0
FOR I% = 0 TO 255
IF I% > 192 THEN e% = e% + 2
OUT &H3C9, e% \ 4
OUT &H3C9, e% \ 4
OUT &H3C9, I% \ 4
NEXT

END SUB

