;Ŀ
; MBR-Code for BootfiRe v1.2 (c) 1997 by Sebastian Kienzl aka Zap/RiOT 
;you may not use this or any part of the source in your own productions
;                 all rights reserved to the author                    
;   *if this piece is published it's for educational purposes only*    
;
; - last modified on 25th of may 1997
; - assembled with A86 v4.01
; - A86 creates a huge file (with 7c00h ? bytes in front) and just the bytes
;   7c00h -> filesize of the .BIN-file should be written into the boot-sector

ORG   0h
        execpoint       db 7c00h dup(?) ;when executed, the code is loaded
                                        ;to 0000:7c000 and started there

        jmp             @entrypoint     ;a jump, cause we're not keen on
                                        ;executing the bpb

        bpb             db 1bh dup(?)   ;the bpb itself (the old bpb of
                                        ;a disk should be saved!!)
        ;ͻ
        ;this is where our code really starts
        ;ͼ
       @entrypoint:

        ;Ŀ
        ;set instruments
        ;
        mov     cx, 5                   ;do it 5 times (20h, 40h, 60h, 80h, e0h)
        mov     si, offset instr        ;instruments
        mov     bl, 20h                 ;first register modulator (1st chan)
       @instr:
        mov     bh, [si]                ;get value
        call    writeadlib              ;set it (register=bl, value=bh)
        inc     bl                      ;second channel modulator (1st +1)
        call    writeadlib
        add     bl, 2h                  ;this is the carrier of the 1st chan
        mov     bh, [si+5]              ;get value
        call    writeadlib
        inc     bl                      ;second channel, carrier
        call    writeadlib
        add     bl, 1ch                 ;the value we need to reach the next
        cmp     bl, 0a0h                ;is it a0h? if yes we need to....
        jne     @over
        mov     bl, 0e0h                ;....set it to e0h - there is no a0h
       @over:
        inc     si                      ;next register
        dec     cx
        jnz     @instr
        mov     bx, 0cc0h               ;connection between mod and carr:
        call    writeadlib              ;1st chan and 2nd chan value 0ch
        inc     bl
        call    writeadlib

        ;Ŀ
        ;set gfx-mode
        ;
        mov     ax, 13h
        int     10h                     ;set vga-mode 320x200x256

        ;Ŀ
        ;prepare palette
        ;
        mov     dx, 3c8h                ;dac-port
        xor     al, al        
        out     dx, al                  ;start with color 0
        inc     dx                      ;3c9h -> rgb-vals there
        xor     si, si                  ;we store RED in SI
        mov     bx, si                  ;GREEN in bx
        mov     cx, si                  ;BLUE IN CX

        mov     di, 64                  ;0..63 -> should be around red
       @red:    
        add     si, 255                 ;we wanna get closer to white
        add     bx, 95                  ;but up to 64 the colors should
        add     cx, 16                  ;have a red touch
        mov     ax, si
        mov     al, ah
        out     dx, al
        mov     al, bh
        out     dx, al
        mov     al, ch
        out     dx, al                  ;always write the hi-byte
        dec     di
        jnz     @red                    ;do it

        mov     di, 64                  ;64..127 -> yellow would be cool
       @yellow: 
        add     bx, 160
        add     cx, 16
        mov     al, 63                  ;same as in the upper loop,
        out     dx, al                  ;just other values
        mov     al, bh
        out     dx, al 
        mov     al, ch
        out     dx, al
        dec     di
        jnz     @yellow                 ;do it again =)
       
        mov     di, 128                 ;ok, let's become white now
       @white:
        add     cx, 16                  ;RED and GREEN is already
        mov     al, bh                  ;ffffh, just BLUE is left
        out     dx, al
        out     dx, al
        mov     al, ch
        out     dx, al
        dec     di
        jnz     @white                  ;ok, palette is finished

        ;Ŀ
        ;clear firebuffer
        ;
        mov     ax, 1000h               ;yo, we use 1000:0000 - 1000:ffff
        mov     es, ax                  ;(noone takes care of this memory
        xor     ax, ax                  ;at this point of booting)
        mov     di, ax
        mov     cx, (203*320)/2
        rep     stosw                   ;clear 64960 bytes (203 lines)

        ;ķ
        ;ok, this is our mainloop!!
        ;Ľ
       @mainloop:
        dec     byte ptr tick
        jnz    @nonewtone               ;Is it time to play a tone?

        ;͸
        ;do the sound
        ;;
        ;Ŀ
        ;first channel
        ;
        mov     byte ptr tick, 5        ;yep it is, and make sure we'll
                                        ;also wait 5 times next time here
        mov     si, offset chnl2        ;channel 2 "pattern"data
        add     si, word ptr count      ;counter

        mov     cl, [si]                ;get data
        xor     ch, ch                  ;clear ch
                                        ;i decreased the data so i was able
        add     cx, 114                 ;to store the data in bytes
        or      ch, 34h                 ;5th octave, attack tone

        mov     bl, 0a1h
        mov     bh, cl                  ;freq bits 0-8 channel 2
        call    writeadlib              ;write it

        mov     bx, 0b1h                ;bl=high freq port, octave, enabled
        call    writeadlib              ;bh=0 -> tone is halted

        mov     bh, ch                  ;ok, now write the real freq
        call    writeadlib              ;do it!

        mov     ax, word ptr count
        mov     cl, 8
        div     cl                      ;rest stored in ah

        or      ah, ah                  ;every 8th chan2-tone a chan1-tone
        jnz    @nofirst                 ;if it's not zero then don't play
                                        ;anything on the 1st channel
        ;Ŀ
        ;second channel
        ;
        xor     ah, ah
        mov     si, ax                  ;we still stored COUNT
        shl     si, 1                   ;we have 16-bit values on this chan!
        add     si, offset chnl1        ;here it is
        mov     cx, [si]                ;get data

        mov     bl, 0a0h                ;low freq-port for channel 1
        mov     bh, cl
        call    writeadlib

        mov     bx, 0b0h
        call    writeadlib              ;stop tone (bh=0)

        mov     bh, ch
        call    writeadlib

       @nofirst:                        ;jump here if nothing on first chan

        inc     word ptr count          ;increase of course
        and     word ptr count, 31      ;make sure we don't exceed

       @nonewtone:                      ;don't play a tone at all

        ;͸
        ;proceed fire
        ;;
        mov     ax, 1000h               
        mov     es, ax                  ;this is where our buffer is

        ;Ŀ
        ;add randomlines
        ;
        mov     di, 64000 + 320         ;we do them in lines 201 and 202
        mov     ax, word ptr rand       ;our old random-value
        mov     bx, 6969                ;value for random
        mov     si, 320                 ;one line
        mov     cl, ah                  ;in CL <- randomval
       @createrand:                          
        mul     bx                      ;randomvalue ;)
        inc     ax                         
        cmp     al, 64                  ;it shouldn't be greater than 64
        jnb    @toogreat
        mov     cl, ah                  ;if it is take the old value
       @toogreat:        
        mov     es:[ di ], cl
        mov     es:[ di + 320 ], cl     ;same colors in both lines
        inc     di                      ;next x-point
        dec     si                      ;we wanted to do it 320 times
        jnz    @createrand              ;finished yet?
        mov     word ptr rand, ax       ;save value for next random

        ;Ŀ
        ;interpolate
        ;
        ;remember: the reason the fire is so ;) fast is that
        ;the values aren't read out of the vga-ram and written back -
        ;it's done in a buffer which is located in the ordinary ram
        ;which is of course much faster!

        mov     di, 320                 ;we don't care about the first line
        mov     cx, 202 * 320           ;202 lines to interpolate
                                      
       @interpolate:
        xor     bh, bh          
        xor     ah, ah                  ;clear ah and bh
        mov     al, es:[ di + 640 ]     ;(x,y+2)
        mov     bl, es:[ di ]           ;(x,y)
        add     ax, bx                  ;add it
        mov     bl, es:[ di + 321 ]     ;(x+1,y+1)
        add     ax, bx              
        mov     bl, es:[ di + 319 ]     ;(x-1,y+1)
        add     ax, bx              
        shr     ax, 2                   ;4 values -> divide by 4
        jz     @null                    ;is it zero?
        dec     ax                      ;the fire shouldn't get too high
       @null:                       
        mov     es:[ di - 320 ], al     ;write it back
        inc     di                      ;next point
        loop    @interpolate            ;go ahead

        ;Ŀ
        ;wait for retrace
        ;
        mov     dx, 3dah                ;input status reg 1
       @wait:           
        in      al, dx
        test    al, 08h                 ;is vertical retrace active?
        jz      @wait                   ;if not then wait till it is!!

        ;Ŀ
        ;copy buffer
        ;
        mov     ax, 0a000h
        mov     es, ax                 
        xor     di, di                  ;ES:SI points to 0a000:0000

        mov     ax, 1000h
        mov     ds, ax
        xor     si, si                  ;our buffer (at 1000:0000)
        mov     cx, 32000
        rep     movsw                   ;copy 32000 dword (64000 bytes)
        xor     ax, ax
        mov     ds, ax                  ;we need to access to our vars later!

        ;Ŀ
        ;key pressed?
        ;
        mov     ah, 1
        int     16h
        jnz     @finished               ;key pressed?
        jmp     @mainloop               ;no...continue

       @finished:                       ;yes!!

        ;Ŀ
        ;end
        ;
        xor     ax, ax
        int     16h                     ;remove pressed key

        mov     bx, 0b1h
        call    writeadlib
        dec     bx
        call    writeadlib              ;stop both channels

        mov     ax, 3h
        int     10h                     ;set back to textmode

        int     19h                     ;call bootstrap-loader

        ;ͻ
        ;end of maincode
        ;ͼ
        ;͸
        ;procs
        ;;
WRITEADLIB PROC
;Ŀ
; parms: bl - register 
;        bh - value    
; mod:   dx, al        
;
        mov     dx, 388h                ;adlibport
        mov     al, bl
        out     dx, al                  ;write register
        in      al, dx
        in      al, dx
        in      al, dx                  ;wait a bit
        inc     dx                      ;dataport
        mov     al, bh
        out     dx, al                  ;write val
        in      al, dx
        in      al, dx
        in      al, dx
        in      al, dx
        in      al, dx
        in      al, dx
        in      al, dx                  ;wait again
       ret                              ;return
ENDP

        ;͸
        ;variables and data
        ;;
        instr   db 0e1h, 11h, 11h, 22h, 0h, 021h, 80h, 13h, 22h, 0h
                                        ;instrument-data

        chnl1   dw 10583, 9760, 9674, 9760
                                        ;channel 1 (16-bit vals)

        chnl2   db  57,  78,  90,  57, 143,  57,  90,  78
                db  22,  57,  90,  57, 158,  22,  57,  90
                db   0,  22,  57,  22, 158,  22,  57,  22
                db  22,  57,  90,  57, 229, 158, 143, 158
                                        ;channel 2 (8-bit vals)

        tick    db 1                    ;music-tick-counter

        count   dw 0                    ;"pattern"-counter
        rand    dw 0                    ;randomval
                             
END
;*** End of File ***
