; code for the 3rd and the 4th thread. This code is executed twice in 
; parallel. So we cannot use global variables for storage here. Since
; only one dword of data needs to be stored, it is just pushed onto the
; stack.


   thread34:

   ;get a semi-random value and store it on the stack
   ;requires at least a .586 cpu. It is the startup position of
   ;the sprite

   db 0Fh,31h ;rdtsc
   and eax,07fff0h
   add eax,640*210*4

   push eax

	thread34loop:

	call drawboat

	cmp [thread34exit],0
	jz thread34loop

   add esp,4    ;remove data from stack 
   xor eax,eax  ;return code
   ret


.data

thread34exit   dd 0

thread3id     dd 0
thread3handle dd 0
thread4id     dd 0
thread4handle dd 0

.code


;this just draws the gfx acording to the system time

drawboat:

;maybe you wonder why the call of timeGetTime occurs here and not at
;the time after the background is erased, when it is actually needed.
;the answer is that function calls are a good place to switch between
;the threads, so it will happen very often that the thread execution
;is interrupted while the call is happening. This would cause the 
;following most the time:
;
; 1. draw sprite
; 2. erase sprite
; 3. thread switch -> display the result : sprite is not visible
; 4. jmp 1
;
; while now it looks like this:
;
; 1. thread switch -> display the result : sprite is visible
; 2. erase sprite
; 3. draw sprite
; 4. jmp 1
;

call timeGetTime
shr eax,2    ;4 sec = 1 pass through the screen

mov esi,[esp+4] ;+4 due to the stacked EIP

push eax
 mov ebx,esi
 add esi,640*480*4
 call redrawbackground
pop eax

xor edx,edx
mov ecx,1000
div ecx       ;extract fractional part of the time in seconds
mov eax,edx
imul eax,640
xor edx,edx
div ecx       ;eax=position in x
shl eax,2
mov ebx,eax

mov eax,[esp+4]
xor edx,edx
 mov ecx,640*4
 div ecx        ;extract y*640
 imul eax,640*4
 add ebx,eax    ;add x

mov [esp+4],ebx

mov esi,640*480*4*2 + 64*64*4*2
mov ecx,64*64
call drawsprite

ret