;
;
;                               "GIF.INC"
;                       by TAD ( tad_uk@bigfoot.com )
;
; This contains the GIF file data structures used in GIF16.ASM & GIF32.ASM
;
;


;
; GIF header
;
gifhdr STRUC
  Signature     db      3 dup (?)               ; = "GIF"
  DateVersion   db      3 dup (?)               ; = "87a" or "89a" 
gifhdr ENDS

;
; LSD - Logical Screen Descriptor
;
giflsd STRUC
  LogicalScreenWidth    dw      ?
  LogicalScreenHeight   dw      ?
  LsdFlags              db      ?
        GCT_FLAG        equ     10000000b       ; Global-Color-Table present
        COLOR_REZ_MASK  equ     01110000b       ; Color resolution (BPP-1)
        GCT_SORT_FLAG   equ     00001000b       ; GCT is sorted
        GCT_SIZE_MASK   equ     00000111b       ; GCT size

  Background            db      ?
  PixelRatio            db      ?
giflsd ENDS

;
; GCE - Graphic Control Extension
;
gifgcehdr STRUC
  ExtensionIntroducer   db      ?               ; = 021 hex
  GraphicControlLabel   db      ?               ; = 0F9 hex
gifgcehdr ENDS

gifgceblk STRUC
  BlockSize             db      ?
  GceFlags              db      ?
  DelayTime             dw      ?
  Transparent           db      ?
gifgceblk ENDS

;
; CEX - Comment Extension
;
gifcex STRUC
  ExtensionIntroducer   db      ?               ; = 021 hex
  CommentLabel          db      ?               ; = 0FE hex
gifcex ENDS

;
; PTX - Plain Text Extension
;
gifptx STRUC
  ExtensionIntroducer   db      ?               ; = 021 hex
  PlainTextLabel        db      ?               ; = 001 hex
gifptx ENDS

gifptxblk STRUC
  BlockSize             db      ?               ; 00 = end
  TextGridLeftPos       dw      ?
  TextGridTopPos        dw      ?
  TextGridWidth         dw      ?
  TextGridHeight        dw      ?
  CharacterWidth        db      ?
  CharacterHeigth       db      ?
  TextForegroundColor   db      ?
  TextBackgroundColor   db      ?
gifptxblk ENDS

;
; AEX - Application Extension
;
gifaex STRUC
  ExtensionIntroducer   db      ?               ; = 021 hex
  ExtensionLabel        db      ?               ; = 0FF hex
gifaex ENDS

gifaexblk STRUC
  BlockSize             db      ?
  ApplicationIndentifer db      8 dup (?)
  AuthenticationCode    db      3 dup (?)
gifaexblk ENDS


;
; TID - The Image Descriptor
;
giftid STRUC
  Separator             db      ?               ; = 02C hex
  ImageLeftPos          dw      ?
  ImageTopPos           dw      ?
  ImageWidth            dw      ?
  ImageHeight           dw      ?
  TidFlags              db      ?
        LCT_FLAG        equ     10000000b       ; LCT present
        INTERLACE_FLAG  equ     01000000b       ; Image is interlaced
        LCT_SORT_FLAG   equ     00100000b       ; LCT is sorted
        RESERVED_MASK   equ     00011000b
        LCT_SIZE_MASK   equ     00000111b       ; LCT size
giftid ENDS
