
//
// Listing #3
// (c) 2001 by Turms/.exiLe
// This is an console aplication. Add winmm.lib to project.
//

#include <windows.h>
#include <mmsystem.h>
#include <iostream.h>
#include <conio.h>


#define TIMER_RESOLUTION 2         // 2-millisecond target resolution

//
// global var.
//
volatile DWORD dwFrames;


//
// our "frame counter"
//
void CALLBACK FrameCounter( UINT wTimerID, UINT msg, 
						     DWORD dwUser, DWORD dw1, DWORD dw2 ) 
{ 	
	++dwFrames;
	
	// of course in real app. you shouldn't write like this:
	cout << dwFrames << endl;
} 


//
// - MAIN -
//
int main( void )
{
	UINT		wTimerRes;	// timer resolturion
	UINT		wTimerID;	// timer ID
	TIMECAPS	timecaps;	// needed by timeGetDevCaps

	// get max & min of sys timer
	if ( timeGetDevCaps( &timecaps, sizeof( TIMECAPS ) ) != TIMERR_NOERROR ) 
	{
		cout << "Error, application can't continue" << endl;
		return 0;
	}

	// get optimal resolution
	wTimerRes = max( timecaps.wPeriodMin, TIMER_RESOLUTION );

	// set minimal res for our timer
	if( timeBeginPeriod( wTimerRes ) != TIMERR_NOERROR )
	{
		// error goes here
	}


	// Now, run the timer
    wTimerID = timeSetEvent(
		500,                     // delay in milis. - half a sec.
        wTimerRes,               // resolution 
        FrameCounter,            // callback function
        NULL,					 // user data
		TIME_PERIODIC );         // periodic timer event

    if( wTimerID == NULL )
    {
 		 // error
    }

	// do nothing in the main thread
	while( !kbhit() );	

	// kill the timer
	timeKillEvent( wTimerID );
	wTimerID = 0;

	timeEndPeriod( wTimerRes );		// return previous setings

return 0;
}