;Here all the GFX stuff is processed:
;reading the capture buffer, writing the waveform to the back buffer
;and blitting it to the primary surface

		MainDrawingProcedure:

;a simple flag protects us from using unitialized data

		cmp dword [DDrawIsInitialized],0
		je near NoBlit

		DoTheBlit:


;define some data and buffers here

		segment .data USE32

		pixelcolour dd 1 ;used for colour cycling of the drawn waveform

;buffer for the structure describing the blit
		BlitDescription:
		times DDBLTFX_size db 0

;we can limit blits to a certain rectangle
		BlitRect:
		dd 0
		dd 0
		dd 0
		dd 0

;this explains itself and is just used for convenience
		BlitRectPtr dd BlitRect


		segment .code USE32

;clear the offscreen surface with a monochrome blit 

		mov dword [BlitDescription+DDBLTFX.dwSize], DDBLTFX_size		
		mov dword [BlitDescription+DDBLTFX.dwFillColor], 0
 
		push dword BlitDescription
		push dword DDBLT_WAIT + DDBLT_COLORFILL 
		push dword 0 ;the blitting source is uninteresting
		push dword 0 ;in a blit used for color filling
		push dword 0
		DXfunction OurOffscreenSurface, DDSBLT, "OurOffscreenSurface", "DDSBLT colorfill"

;write to offscreen surface 
;1.lock the offscreen surface so that we can write to it

		mov dword [SurfaceDescription+DDSURFACEDESC.dwsurfFlags ],DDSD_LPSURFACE + DDSD_PIXELFORMAT 
		mov dword [SurfaceDescription+DDSURFACEDESC.ddpfPixelFormat+DDPIXELFORMAT.dwpixFlags],DDPF_RGB 

		push dword 0
		push dword DDLOCK_WAIT
		push dword SurfaceDescription
		push dword 0
		DXfunction_ OurOffscreenSurface,DDSLOCK
		or eax,eax
		jnz near nosurflock

;2. lock the sound capture buffer so that we can read it
		

		segment .data USE32

;some data used for locking the capture buffer
		CapturePos  dd 0
		CaptureLen  dd 0
		CapturePos2 dd 0
		CaptureLen2 dd 0
		CaptureReadPos dd 0

		BlitFlags dd DDBLT_WAIT + DDBLT_DDFX + DDBLT_ASYNC + DDBLT_KEYSRCOVERRIDE

		segment .code USE32

;some constants for DirectSound
		DSCBGETCURRENTPOSITION equ 16
		DSCBLOCK equ 32
		DSCBUNLOCK equ 44
		DSCBLOCK_ENTIREBUFFER equ 1

;reading the capture buffer should follow the recording position
;for a better capture quality
		push dword CaptureReadPos
		push dword 0
		DXfunction_ OurDSoundCaptureBuffer, DSCBGETCURRENTPOSITION

		push dword 0
		push dword CaptureLen2
		push dword CapturePos2
		push dword CaptureLen
		push dword CapturePos
		push dword 256 ;we lock 256 samples
		push dword [CaptureReadPos]
		DXfunction_ OurDSoundCaptureBuffer, DSCBLOCK
;in case of a locking failure accessing the buffer will cause a #GP 
;or other nice things, so one has to check if the lock was succesful:
		or eax,eax
		jnz near nolock

;now the drawing of the waveform:
;obtain a pointer to display memory
		mov edi,[SurfaceDescription+DDSURFACEDESC.lpSurface]

 ;just some color cycling for the visual appearance
		mov eax,[pixelcolour]
		add dword [pixelcolour],469
		xor ebx,ebx

 ;since the sound buffer is used in a circular way it is possible that
 ;the locked part is split into two memory areas
 ;so that we may have to do it twice
		mov edx, [CaptureLen]
		mov esi, [CapturePos]

		Drawloop:
		 mov [edi+4*ebx],eax ;designed for 32 bit gfx mode
		 mov bh, [esi] ;COOL,eh ? this is directly the y-coord
		 inc esi
		 inc bl ;and this is the x-coord :-)
		 dec dl
		jnz Drawloop

;do it again as described above
		mov edx, [CaptureLen2]
		or edx,edx
		jz AllDrawn
		mov esi, [CapturePos2]

		Drawloop2:
		 mov [edi+4*ebx],eax
		 mov bh, [esi]
		 inc esi
		 inc bl
		 dec dl  ;x
		jnz Drawloop2

		AllDrawn:

;unlock capture buffer
		push dword [CaptureLen2]
		push dword [CapturePos2]
		push dword [CaptureLen]
		push dword [CapturePos]
		DXfunction_ OurDSoundCaptureBuffer, DSCBUNLOCK

		nolock:

;unlock surface
		push dword 0
		DXfunction_ OurOffscreenSurface,DDSUNLOCK
		
		nosurflock:

;set some blitting flags for the Offscreen to Primary blit
		mov dword [BlitDescription+DDBLTFX.dwDDFX], DDBLTFX_NOTEARING
		mov dword [BlitDescription+DDBLTFX.ddckSrcColorkey+DDCOLORKEY.dwColorSpaceLowValue], 0
		mov dword [BlitDescription+DDBLTFX.ddckSrcColorkey+DDCOLORKEY.dwColorSpaceHighValue], 0

;do the blit
		push dword BlitDescription
		push dword [BlitFlags]
		push dword 0
		push dword [OurOffscreenSurface]
		push dword [BlitRectPtr]
		DXfunction OurPrimarySurface, DDSBLT, "OurPrimarySurface", "DDSBLT to primary surface"

NoBlit:
ret