TTEST		=	0

; What this code expects :
; General computation coefficients
FRACBITS	=	10
FRACMUL		=	(1 shl FRACBITS)
FRACMASK	=	FRACMUL-1

; Bitmap side sizes
IF	TTEST
BMPXBITS	=	3
ELSE
BMPXBITS	=	7	; Bits in X side
ENDIF
BMPXMUL		=	(1 shl BMPXBITS)
IF	TTEST
BMPYBITS	=	3
ELSE
BMPYBITS	=	7	; Bits in Y side
ENDIF
BMPYMUL		=	(1 shl BMPYBITS)

; Usual or special VGA mode
USUALVGA	=	1	; 320x200x256, 1 page, else --//--, 4 pages
IF	USUALVGA
NEXTROWO	=	320
ELSE
NEXTROWO	=	80
ENDIF

		ideal
		p386
		model	large,pascal
		codeseg
MACRO	udat
		ufardata	ROT_PSEG
ENDM

; -- set_rotate_texture ----------------------------------------
;
@rotps	dw	ROT_PSEG
		udat
textureseg	dw	?
		codeseg
public		set_rotate_texture
proc		set_rotate_texture
	push	ds
	mov	ds,[@rotps]
	assume	ds:ROT_PSEG
	mov	[textureseg],ax
	pop	ds
	assume	ds:NOTHING
	ret
endp		set_rotate_texture

; -- set_rotate_params -----------------------------------------
; EAX,EBX-rotation coefs,ECX-coords zoom coef.
		udat
rot_xcoef	dd	?
_rot_xcoef	dd	?
rot_ycoef	dd	?
_rot_ycoef	dd	?
		codeseg
public		set_rotate_params
proc		set_rotate_params	far
	push	ds
	mov	ds,[@rotps]
	assume	ds:ROT_PSEG
;;;
neg	eax
;neg	ebx
	xchg	eax,ebx
	imul	ecx
	shrd	eax,edx,FRACBITS
	mov	[rot_xcoef],eax
	shl	eax,32-FRACBITS-BMPXBITS
	mov	[_rot_xcoef],eax
	xchg	eax,ebx
	imul	ecx
	shrd	eax,edx,FRACBITS
	mov	[rot_ycoef],eax
	shl	eax,32-FRACBITS-BMPYBITS
	mov	[_rot_ycoef],eax
	pop	ds
	assume	ds:NOTHING
	ret
endp		set_rotate_params

; -- set_rotate_center -----------------------------------------
; AX,BX-center coordinates
		udat
centerx	dw	?
centery	dw	?
		codeseg
public		set_rotate_center
proc		set_rotate_center	far
	push	ds
	mov	ds,[@rotps]
	assume	ds:ROT_PSEG
	mov	[centerx],ax
	mov	[centery],bx
	pop	ds
	assume	ds:NOTHING
	ret
endp		set_rotate_center

; -- rot_draw_page ---------------------------------------------
;
		udat
rot_dpage	dw	?
		codeseg
public		rot_draw_page
proc		rot_draw_page	far
	push	ds
	mov	ds,[@rotps]
	assume	ds:ROT_PSEG
	mov	[rot_dpage],ax
	pop	ds
	assume	ds:NOTHING
	ret
endp		rot_draw_page

; -- rot_draw_column -------------------------------------------
; AX,BX-column screen coords(x,y), CX-end y
; No bounds checking is performed.
public		rot_draw_column
proc		rot_draw_column	far	uses	esi edi edx ebp ds es fs
	mov	ds,[@rotps]
	assume	ds:ROT_PSEG
	mov	dx,ax
	sub	cx,bx	; Number of dots to draw
	inc	cx
	imul	di,bx,NEXTROWO
	IF	USUALVGA eq 0
	shr	dx,2	; Strip pixel mask bits
	ENDIF
	add	di,dx
	mov	es,[rot_dpage]
	sub	ax,[centerx]
neg	ax
	movsx	eax,ax
	mov	esi,eax
	imul	[rot_xcoef]
	mov	ebp,eax
	sub	bx,[centery]
	neg	bx
	movsx	ebx,bx
	mov	eax,ebx
	imul	[rot_ycoef]
	sub	ebp,eax
	shl	ebp,32-FRACBITS-BMPXBITS
	xor	ebp,80000000h	; These XORs to put rotation center and picture center into one point
	mov	eax,esi
	imul	[rot_ycoef]
	mov	esi,eax
	movsx	eax,bx
	imul	[rot_xcoef]
	mov	edx,eax
	add	edx,esi
	shl	edx,32-FRACBITS-BMPYBITS
	xor	edx,80000000h
	mov	eax,[_rot_xcoef]
	neg	eax
	mov	esi,[_rot_ycoef]
	mov	ds,[textureseg]
	assume	ds:NOTHING
@@test:
	test	cl,3
	jz	@@shift
	MACRO	moveb	step,isend
	xor	bx,bx
	shld	ebx,edx,BMPYBITS
	shld	ebx,ebp,BMPXBITS
	mov	bl,[bx]
	mov	[es:di+(step)*NEXTROWO],bl
	add	edx,eax
	add	ebp,esi
	IFNB	<isend>
	add	di,(isend)*NEXTROWO
	ENDIF
	ENDM
	moveb	0,1
	dec	cx
	jnz	@@test
@@shift:
	shr	cx,2
	jz	@@end
@@loop:
	moveb	0
	moveb	1
	moveb	2
	moveb	3,4
	dec	cx
	jnz	@@loop
@@end:
	assume	ds:NOTHING
	ret
endp		rot_draw_column

		end