// -----------------------------------------------------------------------------
//
//      Mimic Engine
//      Copyright (C) 1997-1999 by Maciej Sinilo
//
//      MODULE  : VL_VEC4.CPP - 4D Vector/Point
//      CREATED : 24-03-99
//
// -----------------------------------------------------------------------------

#include <iomanip.h>

#include "vl_vec4.h"

// -----------------------------------------------------------------------------
// Cross product of three 4D vectors
// Taken from codes by Andrew Wilmott.
vlVec4 Cross(const vlVec4& a, const vlVec4& b, const vlVec4& c)
{
        vlVec4 result;

#define ROW(i)          a[i], b[i], c[i]
#define DET(i,j,k)      vlVec3(ROW(i)) * Cross(vlVec3(ROW(j)),vlVec3(ROW(k)))
        result[0] =  DET(1,2,3);
        result[1] = -DET(0,2,3);
        result[2] =  DET(0,1,3);
        result[3] = -DET(0,1,2);
#undef ROW
#undef DET

        return result;
}


// -----------------------------------------------------------------------------

ostream& operator << (ostream& s, const vlBase4& a)
{
        int w = s.width();
        s << '[' << setw(w) << a[0] << " " << setw(w) << a[1] << " " << setw(w) << a[2] <<
                     " " << setw(w) << a[3] << setw(w) << ']';
        return s;
}

// -----------------------------------------------------------------------------
//      VL_VEC4.CPP - MODULE END
// -----------------------------------------------------------------------------

