/*
 *  Nieuchronna ewolucja, czyli jak przejsc z vesy na direct x
 *
 *  Autor           : Bogdan Modzelewski a.k.a Motzel of Cryogen
 *  Data utworzenia : 99.07.31
 *
 */

 #include <windows.h>
 #include <ddraw.h>
 #include <string.h>
 #include "evolutn.h"

 HINSTANCE Instance = NULL;
 HWND      OurWnd;

 LPDIRECTDRAW        lpDD;
 LPDIRECTDRAWSURFACE lpDDSPrimary;
 LPDIRECTDRAWSURFACE lpDDSBack;

 UDWORD Width=0;
 UDWORD Height=0;
 UDWORD Pitch=0;

 HRESULT DxError = DD_OK;
 BOOL    WeShouldExit = FALSE;


 // procedura obslugi glownego okna
 LRESULT CALLBACK MainWndProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam) {
   switch (msg) {
     // nacisnieto klawisz
     case WM_KEYDOWN:
       switch(wParam) {
         case VK_ESCAPE:
           WeShouldExit = TRUE;
           PostMessage(hwnd,WM_CLOSE,0,0);
           break;
         }
       break;

     // proba zamkniecia programu
     case WM_CLOSE:
       // zapobiegniecie zamknieciu okna jesli user nacisnal ALT+F4, teraz mozna wyjsc tylko gdy WeShouldExit == TRUE
       if(WeShouldExit == TRUE) PostQuitMessage(0);
       break;

     // nie chcemy, zeby podczas demcia wlaczyl nam sie screen saver albo wylaczyl monitor (oszczedzanie energii)
     case WM_SYSCOMMAND:
       if((wParam&0xFFF0)==SC_SCREENSAVE || (wParam&0xFFF0)==SC_MONITORPOWER) return 0;
       else return DefWindowProc(hwnd, msg, wParam, lParam);
       break;

     // reszta komunikatow zajmuje sie windows
     default:
       return DefWindowProc(hwnd,msg,wParam,lParam);
   }
   return 0;
 }


 // utworzenie okienka i zwrot jego handle'a
 HWND CreateWnd(void) {
   WNDCLASS wc;

   // najpierw musimy stworzyc klase okna
   memset(&wc,0,sizeof(WNDCLASS));
   wc.lpfnWndProc = (WNDPROC)MainWndProc; // adres procedury obslugi okna
   wc.hInstance = Instance; // handle naszego zadania
   wc.lpszClassName = "Evolution"; // nazwa naszej klasy
   wc.hIcon = LoadIcon(NULL,IDI_APPLICATION); // ikonka okna - standardowa
   if (!RegisterClass(&wc)) return 0;

   return CreateWindowEx(
            // tworzymy okno aplikacji "zawsze na wierzchu"
            WS_EX_APPWINDOW | WS_EX_TOPMOST,
            // nazwa klasy, ktora utworzylismy pare linijek wyzej
            "Evolution",
            "", // nazwa okienka, zreszta i tak nie bedzie widoczna ;)
            // okno bedzie widoczne i nie ma belki tytulowej
            WS_VISIBLE|WS_POPUP,
            // wspolrzedne (x,y) lewego rogu okna
            0, 0,
            // szerokosc i wysokosc okna - tutaj rowne wielkosci ekranu
            GetSystemMetrics(SM_CXSCREEN), GetSystemMetrics(SM_CYSCREEN),
            NULL, // okno "rodzic" - nie uzywane przez nas
            NULL, // menu okna - jw.
            Instance, // handle naszego zadania
            NULL); // dana do wykorzystania - my jej nie chcemy uzywac ;)
 }


 // inicjalizacja dx i wlaczenie trybu
 UDWORD Init(UWORD resx, UWORD resy, UWORD bpp) {
   DDSURFACEDESC  ddsd;

   // utworzenie okienka
   if ((OurWnd = CreateWnd()) == (HWND)0) return ERR_CANT_CREATE_WINDOW;

   // pokazanie okienka
   ShowWindow(OurWnd,SW_SHOW);

   // utworzenie obiektu Direct Draw
   DxError = DirectDrawCreate(NULL,&lpDD,NULL);
   if(DxError != DD_OK) return ERR_CANT_CREATE_DDRAW;

   // ustawienie "cooperative level"
   DxError = IDirectDraw_SetCooperativeLevel(lpDD, OurWnd, DDSCL_EXCLUSIVE | DDSCL_FULLSCREEN);
   if(DxError != DD_OK) return ERR_CANT_SET_COOPERATIVE_LEVEL;

   // ustawienie zadanego trybu
   DxError = IDirectDraw_SetDisplayMode(lpDD,resx,resy,bpp);
   if(DxError != DD_OK) return ERR_CANT_SET_MODE;

   // utworzenie primary surface'a
   ddsd.dwSize = sizeof(ddsd);
   ddsd.dwFlags = DDSD_CAPS;
   ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE;
   DxError = IDirectDraw_CreateSurface(lpDD,&ddsd,&lpDDSPrimary,NULL);
   if(DxError != DD_OK) return ERR_CANT_CREATE_PRIMARY_SURFACE;

   // utworzenie offscreen surface'a w pamieci systemowej
   memset(&ddsd, 0, sizeof(ddsd));
   ddsd.dwSize = sizeof(ddsd);
   ddsd.dwFlags = DDSD_CAPS | DDSD_WIDTH | DDSD_HEIGHT | DDSD_PIXELFORMAT;
   ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN | DDSCAPS_SYSTEMMEMORY;
   ddsd.dwWidth = resx;
   ddsd.dwHeight = resy;
   // okreslenie formatu pixela dla offscreen surface'a - tutaj 32bit ARGB
   ddsd.ddpfPixelFormat.dwSize = sizeof(DDPIXELFORMAT);
   ddsd.ddpfPixelFormat.dwFlags = DDPF_RGB;
   ddsd.ddpfPixelFormat.dwRGBBitCount = 32;
   ddsd.ddpfPixelFormat.dwRBitMask = 0x00ff0000;
   ddsd.ddpfPixelFormat.dwGBitMask = 0x0000ff00;
   ddsd.ddpfPixelFormat.dwBBitMask = 0x000000ff;
   ddsd.ddpfPixelFormat.dwRGBAlphaBitMask = 0;
   DxError = IDirectDraw_CreateSurface(lpDD,&ddsd,&lpDDSBack,NULL);
   if(DxError != DD_OK) return ERR_CANT_CREATE_PRIMARY_SURFACE;

   // wywalenie kursora myszki
   ShowCursor(FALSE);

   WeShouldExit= FALSE;
   Width = resx; Height = resy;

   return NO_ERROR;
 }


 // deinicjalizacja direct x
 void Deinit() {
   // deinicjalizacja ddraw
   if(lpDD!=NULL) {
     if(lpDDSPrimary!=NULL) {
       IDirectDrawSurface_Release(lpDDSPrimary);
       lpDDSPrimary=NULL;
     }
     if(lpDDSBack!=NULL) {
       IDirectDrawSurface_Release(lpDDSBack);
       lpDDSBack=NULL;
     }
     IDirectDraw_Release(lpDD);
     lpDD=NULL;
   }

   // pokazanie kursora myszki
   ShowCursor(TRUE);
 }


 // zablokowanie virtualnego ekranu i pobranie adresu lfb
 void* LockScreen() {
   DDSURFACEDESC  ddsd;

   memset(&ddsd, 0, sizeof(ddsd));
   ddsd.dwSize = sizeof(ddsd);

   while(1) {
     DxError = IDirectDrawSurface_Lock(lpDDSBack, NULL, &ddsd, DDLOCK_WAIT, NULL);
     if(DxError == DD_OK) break;

     if(DxError == DDERR_SURFACELOST) {
       DxError = IDirectDrawSurface_Restore(lpDDSBack);
       if(DxError != DD_OK) return NULL;
     } else return NULL;
   }
   Pitch = ddsd.lPitch;
   return ddsd.lpSurface;
 }


 // odblokowanie virtualnego ekranu
 UDWORD UnlockScreen() {
   while(1) {
     DxError = IDirectDrawSurface_Unlock(lpDDSBack, NULL);

     if(DxError == DD_OK) break;
     if(DxError == DDERR_SURFACELOST) {
       DxError = IDirectDrawSurface_Restore(lpDDSBack);
       if(DxError != DD_OK) return ERR_CANT_RESTORE_SURFACE;
     } else return ERR_CANT_UNLOCK_SURFACE;
   }
   Pitch = 0;
   return NO_ERROR;
 }


 // kopiowanie virtualnego ekranu (32bit) z konwersja formatu pixela
 UDWORD SwapPages(void) {
   // pobieramy kontekst urzadzenia dla naszego okna
   HDC hdc = GetDC(OurWnd);
   HDC hdc_back;

   if(hdc == NULL) return ERR_CANT_GET_DC;

   // ustawiamy logiczne jednostki na pixele
   SetMapMode(hdc, MM_TEXT );

   // pobieramy kontekst urzadzenia dla offscreen surface'a
   DxError = IDirectDrawSurface_GetDC(lpDDSBack, &hdc_back);
   if(DxError != DD_OK) {
     ReleaseDC(OurWnd, hdc);
     return ERR_CANT_GET_DC;
   }

   // blitujemy nasz offscreen surface na ekran
   if(BitBlt(hdc, 0, 0, Width, Height, hdc_back, 0, 0, SRCCOPY ) == 0) {
     ReleaseDC(OurWnd, hdc);
     IDirectDrawSurface_ReleaseDC(lpDDSBack, hdc_back);
     return ERR_CANT_BLIT;
   }

   // zwalniamy kontekst urzadzenia dla offscreen surface'a
   DxError = IDirectDrawSurface_ReleaseDC(lpDDSBack, hdc_back);
   if(DxError != DD_OK) {
     ReleaseDC(OurWnd, hdc);
     return ERR_CANT_RELEASE_DC;
   }

   // zwalniamy kontekst urzadzenia dla okna
   if(!ReleaseDC(OurWnd, hdc)) return ERR_CANT_RELEASE_DC;

   return NO_ERROR;
 }

 // przetworzenie kolejki komunikatow
 void GetInputs() {
   MSG msg;

   while(PeekMessage(&msg, NULL, 0, 0, PM_REMOVE)) {
     TranslateMessage(&msg);
     DispatchMessage(&msg);
   }
 }

 void PrintError(UDWORD err) {
   char buf1[256];

   switch( err ) {
     case NO_ERROR:
       strcpy(buf1, "Nie bylo zadnego bledu ;)");
       break;
     case ERR_CANT_CREATE_WINDOW:
       strcpy(buf1, "Nie moge utworzyc okna dla programu !");
       break;
     case ERR_CANT_CREATE_DDRAW:
       strcpy(buf1, "Nie moge utworzyc obiektu Direct Draw !");
       break;
     case ERR_CANT_SET_COOPERATIVE_LEVEL:
       strcpy(buf1, "Nie moge ustawic trybu \"exclusive cooperative level\" !");
       break;
     case ERR_CANT_SET_MODE:
       strcpy(buf1, "Nie moge ustawic zadanego trybu video !");
       break;
     case ERR_CANT_CREATE_PRIMARY_SURFACE:
       strcpy(buf1, "Nie moge utworzyc surface'ow dla programu !");
       break;
     case ERR_CANT_RESTORE_SURFACE:
       strcpy(buf1, "Nie moge odtworzyc surface'a !");
       break;
     case ERR_CANT_LOCK_SURFACE:
       strcpy(buf1, "Nie moge zablokowac surface'a !");
       break;
     case ERR_CANT_UNLOCK_SURFACE:
       strcpy(buf1, "Nie moge odblokowac surface'a !");
       break;
     case ERR_CANT_RELEASE_DC:
       strcpy(buf1, "Nie moge zwolnic kontekstu urzadzenia !");
       break;
     case ERR_CANT_GET_DC:
       strcpy(buf1, "Nie moge pobrac kontekstu urzadzenia !");
       break;
     case ERR_CANT_BLIT:
       strcpy(buf1, "Nie moge skopiowac virtualnego ekranu na fizyczny !");
       break;
   }
   Deinit();
   MessageBox(OurWnd, buf1, NULL, MB_OK | MB_ICONEXCLAMATION);
   DestroyWindow(OurWnd);
   ExitProcess(1);
 }


 // glowna procka programu
 int APIENTRY WinMain(HINSTANCE hinst, HINSTANCE hinstPrev, LPSTR lpCmdLine, int nCmdShow) {
   UDWORD  error;
   UDWORD  *screen;
   UDWORD  i, j;

   Instance = hinst;

   // inicjalizacja trybu 640x480x16bit
   error = Init(640, 480, 16);
   if( error != NO_ERROR ) PrintError(error);

   // glowna petla
   while(!WeShouldExit) {
     // przetworzenie kolejki zdarzen
     GetInputs();

     // pobranie adresu virtualnego screena (32bit)
     if((screen = (UDWORD*) LockScreen()) == NULL) PrintError(ERR_CANT_LOCK_SURFACE);

     // narysowanie przejsc kolorow
     for(i=0; i<50; i++)
       for(j=0; j<256; j++) {
         *(screen + j + ((i*Pitch) >> 2)) = (j<<16) + (j<<8) + j;
         *(screen + j + (((i+50)*Pitch) >> 2)) = (j<<16);
         *(screen + j + (((i+100)*Pitch) >> 2)) = (j<<8);
         *(screen + j + (((i+150)*Pitch) >> 2)) = j;
       }

     // unlock surface'a
     if((error = UnlockScreen()) != NO_ERROR) PrintError(error);

     // skopiowanie virtualnego screena z konwersja formatu pixela
     if((error = SwapPages()) != NO_ERROR) PrintError(error);
   }

   // deinicjalizacja
   Deinit();

   return 0;
 }
