//________________________________________________________________________________________________________________________________________________________________________
//
//	Shine Archive handling class
//  (c) Shine, 2000
//
//	Revision
//	2000-09-09	Jerker Olofsson
//
//________________________________________________________________________________________________________________________________________________________________________

#include <conio.h>
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <setjmp.h>

#include "pslib.h"

//________________________________________________________________________________________________________________________________________________________________________

shineLibrary::shineLibrary()
{
	opened = false;
	file = NULL;
}

//________________________________________________________________________________________________________________________________________________________________________

void shineLibrary::openArchive( char* filename )
{
	strcpy( libname, filename );
	if( (file=fopen(filename, "rb"))==NULL )
	{
	}
	else
	{
		opened = true;
	}
}

//________________________________________________________________________________________________________________________________________________________________________

void shineLibrary::closeArchive()
{
	if( opened )
	{
		fclose( file );
	}
}

//________________________________________________________________________________________________________________________________________________________________________

void shineLibrary::rew()
{
	if( opened )
	{
		rewind(file);
	}
}

//________________________________________________________________________________________________________________________________________________________________________

void shineLibrary::seekFile( char* filename )
{
	char string[170];
	char c=0;
	char r=0;

	if( !opened )
	{
		return;
	}

	rew();

	do 
	{
		for( c=0,string[c]=fgetc(file); string[c]!='\0';)
		{
			if( 0 != feof(file) ) 
			{
				return;
			}
			string[++c] = fgetc( file );
		}

		fread( &fileSize, 4, 1, file);
		if ( strcmp( string, filename ) ) 
		{
			fseek( file, fileSize, SEEK_CUR );
		}
	} while( strcmp( string, filename ) );
}


//________________________________________________________________________________________________________________________________________________________________________

bool shineLibrary::isOpened()
{
	return opened;
}

//________________________________________________________________________________________________________________________________________________________________________

int shineLibrary::getFileSize()
{
	return fileSize;
}

//________________________________________________________________________________________________________________________________________________________________________

FILE* shineLibrary::getFile()
{
	return file;
}

//________________________________________________________________________________________________________________________________________________________________________

char* shineLibrary::getLibraryName()
{
	return libname;
}

//________________________________________________________________________________________________________________________________________________________________________

void shineLibrary::getPCXSize( FILE *f, int *x, int *y )
{
  unsigned char   tmp[128];
  unsigned short  xmin,ymin,xmax,ymax;

  fread(tmp,4,1,f);
  fread(&xmin,2,1,f);
  fread(&ymin,2,1,f);
  fread(&xmax,2,1,f);
  fread(&ymax,2,1,f);

  *x=xmax-xmin+1; 
  *y=ymax-ymin+1;
}

//________________________________________________________________________________________________________________________________________________________________________

void shineLibrary::readPCX( FILE *f, long *dest )
{
  int i;
  unsigned char tmp[128];
  unsigned char pal[768];
  unsigned char c;
  unsigned short xmin,ymin,xmax,ymax;
  unsigned char NPlanes;
  unsigned short BytesPerLine;
  unsigned char col;
  int TotalBytes,xsize,ysize;
  int offs=0;
  int r=0,g=0,b=0;

   // read header
    fread(tmp,4,1,f);
    if (tmp[0]!=10||tmp[1]<5||tmp[3]!=8) 
	{ 
		return; 
	}
    
	fread(&xmin,2,1,f);
    fread(&ymin,2,1,f);
    fread(&xmax,2,1,f);
    fread(&ymax,2,1,f);
    fread(tmp,53,1,f);
    fread(&NPlanes,1,1,f);
    
	if (!(NPlanes==3 || NPlanes==1)) 
	{ 
		return; 
	}
    fread(&BytesPerLine,2,1,f);
    fread(tmp,60,1,f);

   // decompress the data
    TotalBytes=NPlanes*BytesPerLine;
    xsize=xmax-xmin+1; ysize=ymax-ymin+1;

	memset( dest, 0, xsize*ysize*4 );

    if(NPlanes==1)
    {
       for (i=0;i<TotalBytes*ysize;) {
         fread(&c,1,1,f);
         if (((c&0x80)==0)||((c&0x40)==0)) { col=c; c=1; } else { c=(c&0x3f); fread(&col,1,1,f); }
         for (;c>0;c--,i++)
           dest[offs++] = col;
       }

      i=fgetc(f);

      for(i=0; i<768; i++) pal[i] = fgetc(f);

      for(i=0; i<xsize*ysize; i++)
      {
			long val = dest[i];
			dest[i] |= pal[val*3+2];
			dest[i] |= pal[val*3+1]<<8;
			dest[i] |= pal[val*3]<<16;
      }
    }

    if(NPlanes==3)
     {
       for (i=0;i<TotalBytes*ysize;) {
         fread(&c,1,1,f);
         if (((c&0x80)==0)||((c&0x40)==0)) { col=c; c=1; } else { c=(c&0x3f); fread(&col,1,1,f); }
         for (;c>0;c--) {
           if (r<BytesPerLine) {
             dest[offs+r] |= col<<16;
             r++;
           } else if (g<BytesPerLine) {
             dest[offs+g] |= col<<8;
             g++;
           } else if (b<BytesPerLine) {
             dest[offs++] |= col;
             b++;
             if (b==BytesPerLine) { r=0; g=0; b=0; }
           }
           i++;
         }
       }
     }

}

//________________________________________________________________________________________________________________________________________________________________________
