/*
		An example GIF encoder
		links to assembly language module
*/

#include "stdio.h"
#include "alloc.h"
#include "dos.h"

/* struct of information for assembly language function */
typedef struct {	unsigned int screenwide;
			unsigned int screendeep;
			unsigned int imageleft;
			unsigned int imagetop;
			unsigned int imagewide;
			unsigned int imagedeep;
			unsigned int background;
			unsigned int bits;
			unsigned long imagesize;
			char *palette;
			char *image;
			char *path;
		} GIFDATA;

main(argc,argv)
	int argc;
	char *argv[];
{
	GIFDATA gd;
	FILE *BIN,*PAL;
	char binFile[65],palFile[65],gifFile[65];
	unsigned long size;
	char *p,*farPtr();
	unsigned int n;

	if(argc > 1) {
		/* make file names */
		strmfe(binFile,argv[1],"BIN");
		strmfe(palFile,argv[1],"PAL");
		strmfe(gifFile,argv[1],"GIF");

		/* fill in struct */
		gd.screenwide=640;
		gd.screendeep=350;
		gd.imageleft=0;
		gd.imagetop=0;
		gd.imagewide=640;
		gd.imagedeep=350;
		gd.background=0;
        	gd.bits=4;
		gd.path=gifFile;

		if((BIN=fopen(binFile,"rb")) != NULL) {
			fseek(BIN,0L,SEEK_END);
			size=gd.imagesize=ftell(BIN);
			rewind(BIN);
			
			/* load binary image */
			if((gd.image=farmalloc(size)) == NULL) {
                        	puts("Error allocating image memory");
				exit(1);
			}
			p=gd.image;

			/* get one 64K block at a gulp */
			do {
				if(size > 0xff00L) n= 0xff00;
				else n=(unsigned int)size;
				fread(p,n,1,BIN);
				p=farPtr(p,(long)n);
				size -= (long)n;
			} while(size > 0L);
			fclose(BIN);
			puts("Image loaded");
		}
		else {
			puts("Error opening binary file");
			exit(1);
		}

		/* load the palette file */
		if((PAL=fopen(palFile,"rb")) != NULL) {
                	fseek(PAL,0L,SEEK_END);
			size=ftell(PAL);
			rewind(PAL);
			if((gd.palette=malloc((unsigned int)size)) == NULL) {
                                puts("Error allocating palette memory");
				exit(1);
			}
                        fread(gd.palette,1,(unsigned int)size,PAL);
			fclose(PAL);
			puts("Palette loaded");
		}
		else {
			puts("Error opening palette file");
			exit(1);
		}

		/* pack the beast */
		if((n=PackGIF(&gd)) != 0) 
		    printf("Error %d writing GIF file",n);
		farfree(gd.image);
		free(gd.palette);
	}
}

strmfe(new,old,ext)		/* make file name with specific extension */
	char *new,*old,*ext;
{
	while(*old != 0 && *old != '.') *new++=*old++;
	*new++='.';
	while(*ext) *new++=*ext++;
	*new=0;
}

char *farPtr(p,l)	/* return a far pointer p + l */
	char *p;
	long l;
{
        unsigned int seg,off;

	seg=FP_SEG(p);
	off=FP_OFF(p);
	seg+=(off / 16);
	off += (unsigned int)(l & 0x000fL);
	seg += (l / 16L);
	p=MK_FP(seg,off);
	return(p);
}
