//ANIMEXAM.C  / EXAMPLE FOR SIMPLE ANIMATION //
//WRITING BY THE KING IN 01/02/96            //
#include "kmagunit.c"
#include <alloc.h>
#include <stdlib.h>
//This is the IMAGE "HELLO" That I Type on the screen.
const char Image[24*5] =
                             {15,0,0,15,0,15,15,15,15,0,15,0,0,0,0,15,0,0,0,0,15,15,15,15,
                              15,0,0,15,0,15,0,0,0,0,15,0,0,0,0,15,0,0,0,0,15,0,0,15,
                              15,15,15,15,0,15,15,15,15,0,15,0,0,0,0,15,0,0,0,0,15,0,0,15,
                              15,0,0,15,0,15,0,0,0,0,15,0,0,0,0,15,0,0,0,0,15,0,0,15,
                              15,0,0,15,0,15,15,15,15,0,15,15,15,15,0,15,15,15,15,0,15,15,15,15};


unsigned char *virtualscreen;
unsigned char *virtualscreen1;

//------------------------------------------------//
//Put A Pixel On Any Kind Of Page.                //
//------------------------------------------------//

void PutPixel1(int X,int Y,unsigned char Col,unsigned char *Where)
{
    asm {
    LEs Di,Where
    Mov Ax,Y             //Ax = Y
    Mov Bx,Ax            //Bx = Y
    Shl Ax,8             //Ax = Ax * 256
    Shl Bx,6             //Bx = Bx * 64
    Add Ax,Bx            //Ax = (256*64=320))
    Add Ax,X             //Ax = Vline + Hline = Offset
    Add Di,Ax            //Di = Offset
    Mov Al,Col           //Al = Color
    StoSb                //[0A000h:Offset] = Color
    }
}

void ShowVirtualScreen(unsigned char *VScreen)
{
    asm {
    Push Ds                 //Saving Ds
    lds si,VScreen
//  Mov Ax,Word(VScreen+2)  //Ax = Segment Vscreen
//  Mov Ds,Ax               //Ds = Ax
    Mov Ax,0xA000           //Ax = Screen Segment
    Mov Es,AX               //Es = Ax
    Xor Di,Di               //Di = 0
//  Xor Si,Si               //Si = 0
    Mov Cx,32000            //Cx = 32000
    Rep MovSw               //Move 32000*2 Bytes
                            //From [Ds:Si],[Es:Di]
    Pop Ds                  //Restore Ds
    }
}

//-----------------------------------//
//            Flip Pages             //
//-----------------------------------//
void FlipScreens(unsigned char *Vfrom,unsigned char *Vto)
{
    asm {
    Push Ds               //Save Ds
    Lds si,Vfrom          //Ax = Segment Vfrom
    Les di,Vto            //Ax = Segment Vto
    Mov Cx,32000          //Cx = 32000
    Rep MovSw             //Move 32000*2 Bytes
                          //From [Ds:Si],[Es:Di]
    Pop Ds                //Restore Ds
    }
}

//----------------//
//Paint The BitMap//
//----------------//
void Paint_BitMap(int X,int Y)
{
char T,T1;
    for(T=0;T<5;T++)    {
        for(T1=0;T1<24;T1++)        {
            if (Image[T*24+T1] != 0) {
                PutPixel1(X+T1,Y+T,Image[T*24+T1],virtualscreen);
            }
        }
    }
}

void main() {

int x,y;
unsigned int t;
int ran;

    virtualscreen = (char *)malloc(64000);
    virtualscreen1 = (char *)malloc(64000);
    randomize();
    memset(virtualscreen,0,64000);
    for(t=0;t<65000;t++)
        PutPixel1(rand() % 320,rand() % 200,rand() % 255,virtualscreen);
    FlipScreens(virtualscreen,virtualscreen1);
    SetMode();
    t = 0;
    x = 160;
    y = 100;
    do  {
        ran = (rand() % 3) - 1;
        if (x + ran >= 320 - 24) ran = 0;
        if (x + ran <= 0) ran = 0;
        x = x + ran;
        ran = (rand() % 3) - 1;
        if (y + ran >= 200 - 5) ran = 0;
        if (y + ran <= 0) ran = 0;
        y = y + ran;

        Paint_BitMap(x,y);
        ShowVirtualScreen(virtualscreen);
       FlipScreens(virtualscreen1,virtualscreen);
    } while (!kbhit());
    free(virtualscreen);
    free(virtualscreen1);
}
