#include <conio.h>
#include <memory.h>
#include <stdio.h>
#include "flat.h"
#include "ptc"

using namespace ptc;

int main(int argc, char * argv[]) {
  const unsigned short width = 640;
  const unsigned short height = 480;

  const unsigned short benchwidth = 80;
  const unsigned short benchheight = 60;

  try {
    Console console;
    console.open("triangle", width, height, Format(32, 0x00FF0000, 0x0000FF00, 0x000000FF));
    g_framebuffer = (long *)console.lock();
    memset(g_framebuffer, 0, width * height * 4);
    console.unlock();

	  g_screenWidth = width;

    Vertex v[3];

    Face f;
    f.v[0] = &v[0];
    f.v[1] = &v[1];
    f.v[2] = &v[2];
  
    while (!console.key()) {
      v[0].sx = float(rand() % width);
      v[0].sy = float(rand() % height);
      v[1].sx = float(rand() % width);
      v[1].sy = float(rand() % height);
      v[2].sx = float(rand() % width);
      v[2].sy = float(rand() % height);

      int r = rand() & 255;
      int g = rand() & 255;
      int b = rand() & 255;
      f.color = (r << 16) | (g << 8) | b;

      g_framebuffer = (long *)console.lock();
      renderFlatTriangle(f);
      console.unlock();
      console.update();
    }

    console.close();

    printf("benchmarking...");
    fflush(stdout);

    int num_triangles = 0;
    g_framebuffer = new long[benchwidth * benchheight];
    g_screenWidth = benchwidth;
    Timer timer;
    timer.start();

    int r = rand() & 255;
    int g = rand() & 255;
    int b = rand() & 255;
    f.color = (r << 16) | (g << 8) | b;
    
    while (num_triangles < 100000) {
      v[0].sx = float(rand() % benchwidth);
      v[0].sy = float(rand() % benchheight);
      v[1].sx = float(rand() % benchwidth);
      v[1].sy = float(rand() % benchheight);
      v[2].sx = float(rand() % benchwidth);
      v[2].sy = float(rand() % benchheight);

      renderFlatTriangle(f);
      num_triangles++;
    }

    double time = timer.time();
    timer.stop();

    delete g_framebuffer;

    printf("\n%1.0f triangles/second", num_triangles / time);
    fflush(stdout);
    getchar();
  }
  catch (Error & e) {
    e.report();
    return -1;
  }

  return 0;
}
