comment %

   Title : Ansi.asm
  Author : Dark Fiber [NuKE]
 Purpose : A runtime ansi viewer
           Written before i got acidview, so...... i know it sucks....
MacroLib : No
    Date :
Compiler : A86

%

JMP START

YBUF: DB ?
XBUF: DB 100 DUP (?)
XCOLORS: DB 0,4,2,6,1,5,3,7
XCOLOR: DB 07h
XATTRIB: DB ?                   ;       0 = NORM COLORS
                                ;       1 = BRIGHT COLORS
XCUR: DW ?

RUN_ANSI:
PUSHF
PUSHA
PUSH ES,DS
MOV BX,CS
MOV DS,BX
MOV ES,BX
CALL IS_CODE
POP DS,ES
POPA
POPF
RET


IS_CODE:
CMP AL,01B
JNE >L1
CMP B[YBUF],0
JNE >L1

MOV B[XBUF],AL
INC B[YBUF]
RET

L1:
CMP AL,"["
JNE >L1

CMP B[YBUF],0
JE >L1

XOR BX,BX
MOV BL,B[YBUF]
MOV B[BX+XBUF],AL
INC B[YBUF]
RET

L1:
CMP B[YBUF],0
JNE >L1

CMP AL,07
JNE >L2

MOV AH,0E
;INT 10H
RET

L2:
CMP AL,0D
JNE >L2

CALL ANSI_LF
RET

L2:
CMP AL,0A
JNE >L2
CALL ANSI_CR
RET

L2:
CALL DRAW_IT
RET


L1:
XOR BX,BX
MOV BL,B[YBUF]
MOV B[BX+XBUF],AL
INC B[YBUF]

CMP AL,"m"
JNE >L1
JMP _RUNCOLORCODE

L1:
CMP AL,"J"
JNE >L1
JMP _ERASEDISPLAY

L1:
CMP AL,"H"
JNE >L1

JMP _SETCURPOS

L1:
CMP AL,"F"
JNE >L1
JMP _SETCURPOS

L1:
CMP AL,"A"
JNE >L1
JMP _CURSORUP

L1:
CMP AL,"B"
JNE >L1
JMP _CURSORDOWN

L1:
CMP AL,"C"
JNE >L1
JMP _CURSORFORWARD

L1:
CMP AL,"D"
JNE >L1
JMP _CURSORBACKWARD

L1:
CMP AL,"s"
JNE >L1
JMP _CURSORSAVE

L1:
CMP AL,"u"
JNE >L1
JMP _CURSORRESTORE

L1:
CMP AL,"K"
JNE >L1
JMP _ERASEEOL

L1:
CMP AL,"!"
JNE >L1
JMP UNKNOWN_CODE

L1:
RET

UNKNOWN_CODE:
MOV B[YBUF],0
RET


_ERASEEOL:
MOV AH,3
XOR BX,BX
INT 10H

MOV CX,DX
MOV BX,160
XOR AX,AX
MOV AL,CH
IMUL BX
MOV DI,AX
MOV CH,0
SHL CX,1
ADD DI,CX

MOV CH,79
SUB CH,CL
MOV CL,CH
MOV CH,0
MOV ES,0B800
MOV AH,B[XCOLOR]
MOV AL,020
REP STOSW
MOV B[YBUF],0
RET

_CURSORSAVE:
MOV AH,3
XOR BX,BX
INT 10H
MOV W[XCUR],DX
MOV B[YBUF],0
RET

_CURSORRESTORE:
MOV DX,W[XCUR]
MOV AH,2
XOR BX,BX
INT 10H
MOV B[YBUF],0
RET

RUNDEC:
XOR BX,BX
XOR AX,AX

L1:
LODSB
CMP AL,030
JB >L2
CMP AL,039
JA >L2

SUB AL,030
MOV CX,BX
SHL BX,2
ADD BX,CX
SHL BX,1
ADD BX,AX
JMP L1

L2:
MOV AX,BX
RET


_CURSORBACKWARD:
MOV SI,OFFSET XBUF+2

CALL RUNDEC
MOV SI,AX

OR SI,SI
JNE >L1
INC SI

L1:
MOV AH,03
XOR BX,BX
INT 10H

MOV DI,DX
AND DI,0FF

PUSH AX
MOV AX,040
MOV ES,AX
ES: MOV BX,W[04A]
DEC BX
POP AX

SUB DI,SI
JNC >L1
MOV DI,0
L1:
AND DX,0FF00
OR DX,DI

MOV AH,2
XOR BX,BX
INT 10H

MOV B[YBUF],0
RET


_CURSORFORWARD:
MOV SI,OFFSET XBUF+2

CALL RUNDEC
MOV SI,AX

OR SI,SI
JNE >L1
INC SI
L1:

MOV AH,03
XOR BX,BX
INT 10H

MOV DI,DX
AND DI,0FF

PUSH AX
MOV AX,040
MOV ES,AX

ES: MOV BX,W[04A]
DEC BX

POP AX

ADD DI,SI

CMP DI,BX
JBE >L1

MOV DI,BX

L1:
AND DX,0FF00
OR DX,DI

MOV AH,2
XOR BX,BX
INT 10H

MOV B[YBUF],0
RET


_CURSORDOWN:
MOV SI,OFFSET XBUF+2

CALL RUNDEC
MOV SI,AX

OR SI,SI
JNE >L1
INC SI
L1:

MOV AH,03
XOR BX,BX
INT 10H

MOV DI,DX
AND DX,0FF

SHR DI,8

PUSH AX
MOV AX,040
MOV ES,AX
ES: MOV BL,B[084]
POP AX
MOV BH,0

ADD DI,SI
CMP DI,BX
JBE >L1

MOV DI,BX

L1:
SHL DI,8
OR DX,DI

MOV AH,2
XOR BX,BX
INT 10H

MOV B[YBUF],0
RET


_CURSORUP:
MOV SI,OFFSET XBUF+2

CALL RUNDEC
MOV SI,AX

OR SI,SI
JNE >L1
INC SI
L1:

MOV AH,03
XOR BX,BX
INT 10H

MOV DI,DX
AND DX,0FF

SHR DI,8

SUB DI,SI
JNC >L1
MOV DI,0
L1:
SHL DI,8
OR DX,DI

MOV AH,2
XOR BX,BX
INT 10H

MOV B[YBUF],0
RET




_SETCURPOS:
MOV SI,OFFSET XBUF+2

MOV BX,1
MOV DI,1

CMP B[SI],"H"
JE >L1
CMP B[SI],"F"
JE >L1

CALL RUNDEC

MOV DI,AX
MOV BX,1

CMP B[SI-1],";"
JNE >L1

CALL RUNDEC
MOV BX,AX

L1:
;DI = LINE
;BX = COLUMN
DEC BX
DEC DI

SHL DI,8

MOV DX,DI
MOV DL,BL

MOV AH,2
XOR BX,BX
INT 10H

MOV B[YBUF],0
RET



_ERASEDISPLAY:
MOV SI,OFFSET XBUF+2
LODSB
CMP AL,"2"
JNE >L1

MOV AX,040
MOV ES,AX

MOV AH,06
MOV BH,B[XCOLOR]
TEST B[XATTRIB],1
JE >L1
ADD BH,8
L1:
XOR CX,CX
ES: MOV DX,W[04A]               ;NUM CHARS PER LINE
ES: MOV DH,B[084]               ;NUM LINES PER SCREEN
MOV AL,DH
DEC DL
INT 10H

MOV AH,2
XOR DX,DX
XOR BX,BX
INT 10H

PUSH CS
POP ES
MOV B[YBUF],0
RET

L1:
DEC SI

L1:
LODSB
CALL DRAW_IT
CMP AL,"J"
JNE L1
RET


_RUNCOLORCODE:
MOV SI,OFFSET XBUF+2

L1:
LODSB
CMP AL,";"
JE L1

CMP AL,"m"
JNE >W1

MOV B[YBUF],0
RET

W1:
CMP AL,"0"
JNE >W1
MOV B[XATTRIB],0                        ;ALL ATTRIBS OFF
MOV B[XCOLOR],7                         ;RESET COLOR TO WHITE
JMP L1

W1:
CMP AL,"1"
JNE >W1
OR B[XATTRIB],00000001xb                ;BOLD ON
JMP L1

W1:
CMP AL,"3"
JNE >W1
CMP B[SI],030
JB >W1
CMP B[SI],037
JA >W1
LODSB
SUB AL,030
XOR CX,CX
MOV CL,AL
INC CX
PUSH SI
MOV SI,OFFSET XCOLORS
CS: REP LODSB
POP SI

AND B[XCOLOR],11110000xb
OR B[XCOLOR],AL
JMP L1

W1:
CMP AL,"4"
JNE >W1
CMP B[SI],030
JB >W1
CMP B[SI],037
JA >W1
LODSB
SUB AL,030
AND B[XCOLOR],00001111xb
XOR CX,CX
MOV CL,AL
INC CX
PUSH SI
MOV SI,OFFSET XCOLORS
CS: REP LODSB
POP SI
SHL AL,4
OR B[XCOLOR],AL
JMP L1

W1:
CMP AL,"4"
JNE >W1
;UNDERLINE????? IN COLOR????
JMP L1

W1:
CMP AL,"5"
JNE >W1
OR B[XATTRIB],00000010xb
JMP L1

W1:
CMP AL,"7"
JNE >W1
OR B[XATTRIB],00000100xb
JMP L1

W1:
JMP L1


DRAW_IT:
PUSH AX

MOV AH,3
XOR BX,BX
INT 10H

PUSH DX

MOV CX,DX
XOR AX,AX
MOV AL,DH
MOV BX,160
IMUL BX

MOV CH,0
SHL CX,1
ADD AX,CX

MOV DI,AX

MOV AX,0B800
MOV ES,AX

POP DX,AX

MOV AH,B[XCOLOR]

TEST B[XATTRIB],00000001xb
JE >L1

;BOLD COLOR
ADD AH,8

L1:
TEST B[XATTRIB],00000010xb
JE >L1

;BLINK
OR AH,080

L1:
TEST B[XATTRIB],00000100xb
JE >L1

AND AH,10001111xb
OR AH,01110000xb

L1:
STOSW

;INC DL
;MOV AX,040
;MOV ES,AX
;ES: CMP DL,B[04A]
;JB >L1
;MOV DL,0
;INC DH
;ES: CMP DH,B[084]
;JBE >L1
;MOV AX,0601
;XOR CX,CX
;ES: MOV DX,W[04A]               ;NUM CHARS PER LINE
;ES: MOV DH,B[084]               ;NUM LINES PER SCREEN
;DEC DL
;INT 10H
;ES: MOV DH,B[084]
;MOV DL,0
;L1:

MOV AX,DI
MOV BX,160
XOR DX,DX
IDIV BX
SHR DX,1
MOV DH,AL

MOV AX,040
MOV ES,AX

ES: MOV AX,W[04A]
DEC AX
ES:MOV AH,B[084]

;CMP DL,AL
;JBE >L1
;MOV DL,AL

L1:
CMP DH,AH
JBE >L1

PUSH AX
CALL ANSI_LF
CALL ANSI_CR
POP DX
MOV DL,0

L1:
MOV AH,02
XOR BX,BX
INT 10H
RET

ANSI_LF:
PUSHA
MOV AH,3
XOR BX,BX
INT 10H
MOV DL,0
MOV AH,2
XOR BX,BX
INT 10H
POPA
RET

ANSI_CR:
PUSHA
PUSH ES,DS

MOV AX,0300
XOR BX,BX
INT 10H

;INCREMENT LINES
INC DH

MOV AX,040
MOV ES,AX

ES: CMP DH,B[084]
JBE >L1

MOV AX,0601
XOR CX,CX
CS: MOV BH,B[XCOLOR]
ES: MOV DX,W[04A]               ;NUM CHARS PER LINE
ES: MOV DH,B[084]               ;NUM LINES PER SCREEN
DEC DL
INT 10H

ES: MOV DH,B[084]
MOV DL,0

L1:
MOV AH,02
XOR BX,BX
INT 10H

POP ES,DS
POPA
RET



START:
MOV SI,080
XOR AX,AX
LODSB
ADD SI,AX
MOV B[SI],0

MOV AX,03D00
MOV DX,OFFSET 082
INT 21H
JNC >L1

MOV AH,04C
INT 21H

L1:
MOV BX,AX

MOV AH,03F
MOV DX,OFFSET TEXX
MOV CX,SP
SUB CX,DX
SUB CX,100
INT 21H

mov bp,ax

MOV SI,DX
ADD SI,AX
MOV W[SI],0

MOV AH,03E
INT 21H

LEA SI,[TEXX + BP-130]
CMP W[SI],01A1A
JNE >L1
CMP W[SI+2],"AS"
JNE >L1
CMP W[SI+4],"CU"
JNE >L1

SUB BP,130

L1:
MOV SI,OFFSET TEXX

L1:
LODSB
CALL RUN_ANSI
DEC BP
JNE L1

L2:
MOV AH,04C
INT 21H

TEXX:
