{$IFDEF VER70}{$M 1024,0,0}{$A+}{$D-}{$E-}{$R-}{$S-}{$I-}{$N-}{$Q-}{$X+}{$Y-}{$ENDIF}
{$IFDEF VER60}{$M 4096,0,0}{$A+}{$D-}{$E-}{$R-}{$S-}{$I-}{$N-}{$X+}{$ENDIF}

{
  Name Of Program : Sprited (SPRITED.PAS)                                  
  Version Number  : 0.6 (14/12/96)                                         
  Compiler Needed : Written in Turbo Pascal v7.0                           
                    Also tested to work in v6.0                            
  Description     : A 32*32 Sprite Editor which outputs as Pascal code.    
                    Now w/ mouse support!                                  
  Author          : Karma, based on original code by Phobos                
 }

USES SPRLIB; (* Hooray!!! No CRT! *)

VAR F         : Text;
    Filename  : String[8+4];
    Bitmap    : ARRAY[1..32*32] Of Byte;     (* Could be the sprite        *)
    Colour    : Byte;                        (* The colour we are using    *)
    SavePAL   : Boolean;                     (* Do we want to save the PAL *)
    OutMode   : Boolean;                     (* Output in hex or decimal?  *)
    R, G, B   : Byte;                        (* Used to adjust the palette *)

PROCEDURE EraseBitmap;
(* Get rid of any garbage contained in the sprite *)
VAR Lp : Integer;
BEGIN
   For Lp := 1 To 1024 Do
    Bitmap[Lp] := 0;
END;

PROCEDURE DrawGridBitmap;
(* This displays the grid version of the sprite *)
VAR Lp1, Lp2, Lp3 : Integer;
    X, Y          : Integer;
BEGIN
   X := 127;   (* Position *)
   Y := 7;        (* of grid *)
   For Lp1 := 1 To 1024 Do
   BEGIN
      For Lp2 := 0 To 4 Do
       For Lp3 := 0 To 4 Do
        PutPixel(X + Lp2, Y + Lp3, Bitmap[Lp1]);
        Inc(X, 6);
        If X >= 319 Then
        BEGIN
           X := 127;
           Y := Y + 6;
        END;
   END;
END;

PROCEDURE DrawPreview;
(* This draws the actual sized sprite *)
VAR Lp, X, Y : Integer;
BEGIN
   X := 5;
   Y := 10; (* Position on screen *)
   For Lp := 1 To 1024 Do
   BEGIN
      PutPixel(X, Y, Bitmap[Lp]);
      Inc(X);          (* Lets do it *)
      If X = 37 Then
      BEGIN
         X := 5;
         Inc(Y);
      END;
   END;
END;

PROCEDURE DrawPalette;
(* Display palette selection, boy that 2nd half looks ugly! *)
VAR Lp1, Lp2, Lp3, X, Y : Integer;
BEGIN
   X := 0;
   Y := 50;
   For Lp1 := 1 To 255 Do
   BEGIN
      For Lp2 := 1 To 5 Do
       For Lp3 := 1 To 5 Do
         PutPixel(X + Lp2, Y + Lp3, Lp1);
         Inc(X, 5);
         If X = 120 Then
         BEGIN
            X := 0;
            Inc(Y, 5);
         END;   (* Ugh, I feel sick *)
    END; (* Guess I'll have to add a pal-edit feature ;-) *)
END;

PROCEDURE ColourBox;
(* Draw present colour being used *)
BEGIN
   FilledBox(60, 40, 120, 20, Colour);
END;

PROCEDURE DrawSave;
(* Draws Save to Pascal button *)
BEGIN
   FilledBox(15, 183, 48, 192, 15);
   GotoXY(3,24);MyWrite('Save', 14);
END;

PROCEDURE DrawQuit;
(* Draws Quit button *)
BEGIN
   FilledBox(15, 167, 48, 176, 15);
   GotoXY(3,22);MyWrite('Quit', 14);
END;

PROCEDURE DrawClear;
(* Draws Clear button *)
BEGIN
   FilledBox(55, 167, 96, 176, 15);
   GotoXY(8,22);MyWrite('Clear', 14);
END;

PROCEDURE DrawSavePal;
(* Draws Save Palette button *)
BEGIN
   FilledBox(55, 183, 120, 192, 15);
   GotoXY(8,24);
   If SavePAL Then MyWrite('Save Pal', 10) Else MyWrite('Save Pal', 15);
END;

PROCEDURE DrawHexDec;
(* Draws Hex/Dec button *)
(* Pascal output can either be in hex or decimal, great huh? *)
BEGIN
   FilledBox(103, 167, 120, 176, 15);
   If OutMode Then
   BEGIN
     GotoXY(14,22);MyWrite('D', 15);
     GotoXY(15,22);MyWrite('H', 10);
   END Else
   BEGIN
     GotoXY(14,22);MyWrite('D', 10);
     GotoXY(15,22);MyWrite('H', 15);
   END;
END;

PROCEDURE DrawRedBar;
(* Draws red scroll bar so palette can be edited *)
BEGIN
   GotoXY(1,15);MyWrite('Red', 40);
   FilledBox(32, 115, 102, 116, 14);
END;

PROCEDURE DrawGreenBar;
(* Draws the green scroll bar *)
BEGIN
   GotoXY(1,16);MyWrite('Gre', 10);
   FilledBox(32, 123, 102, 124, 14);
END;

PROCEDURE DrawBlueBar;
(* Draws the blue scroll bar *)
BEGIN
   GotoXY(1,17);MyWrite('Blu', 1);
   FilledBox(32, 131, 102, 132, 14);
END;

PROCEDURE SetScrollBars;
(* Set the scroll bars *)
BEGIN
   GetPalette(Colour, R, G, B); (* Get current values *)
   HideMouse;
   FilledBox(32, 113, 117, 134, 0);
   DrawRedBar; DrawGreenBar; DrawBlueBar;
   FilledBox(33 + R, 113, 33 + R + 4, 118, 15);
   FilledBox(33 + G, 121, 33 + G + 4, 126, 15);
   FilledBox(33 + B, 129, 33 + B + 4, 134, 15);
   ShowMouse; (* Set bars *)
END;

PROCEDURE WaitforButtonUp;
(* Waits for user releasing mouse button *)
BEGIN
   REPEAT
      MouseStatus;
   UNTIL (Button = 0);
END;

PROCEDURE SavePascalSource;
(* And as it was by magic, saves the Pascal file *)
VAR Lp           : ShortInt;
    Lp1, Lp2     : Integer;
    PALCount     : Integer;
BEGIN
   HideMouse;
   GotoXY(1,19);MyWrite('Filename:', 14); (* 14=Yellow *)
   GotoXY(1,20);Readln(Filename); (* Get Filename *)
   (* No Validation, also requires .PAS on end (saves renaming) *)
   (* Will add this later, ie. check if filename already exists etc. *)
   FilledBox(0, 143, 124, 159, 0); (* Cleanup the mess we made! *)
   GotoXY(1,20);MyWrite('Saving...', 14); (* 14=Yellow *)
   Assign(F, Filename);
   ReWrite(F);
   Writeln(F, 'USES CRT, GFX3;');
   Writeln(F);
   Writeln(F, '(* GFX3.PAS Is Denthors Unit *)');
   Writeln(F);
   If SavePAL Then
    BEGIN
       Writeln(F, 'PROCEDURE SetupPalette;');
       Writeln(F, 'CONST SprPAL : ARRAY[0..255,0..2] Of Byte = (');;
       PALCount := 0;
       Lp := 1;
       REPEAT
       GetPalette(PALCount, R, G, B);
       If OutMode Then
        Write(F, '(' + Convert2Hex(R) + ',' + Convert2Hex(G) +
                     ',' + Convert2Hex(B) + ')')
         Else Write(F, '(', R, ',', G, ',', B, ')');
       If PALCount < 255 Then
       BEGIN
          If Lp < 7 Then Write(F, ',') Else Writeln(F, ',');
          If Lp = 7 Then Lp := 0; (* This makes out palette output alittle *)
          Inc(Lp); (* more tidy, instead of 256 rows of values. *)
       END;
       If PALCount = 255 Then Writeln(F, ');');
       Inc(PALCount);
       UNTIL PALCount > 255;
       Writeln(F, 'VAR Loop : Integer;');
       Writeln(F, 'BEGIN');
       Writeln(F, '   For Loop := 0 To 255 Do (* Load our custom palette *)');
       Writeln(F, '    Pal(Loop, SprPAL[Loop, 0], SprPAL[Loop, 1],SprPAL[Loop, 2]);');
       Writeln(F, 'END;');
       Writeln(F);
    END;
    Writeln(F, 'PROCEDURE DrawSprite;');
    Writeln(F, 'CONST Sprite : ARRAY[1..32,1..32] Of Byte = (');
    For Lp := 6 To 37 Do
     BEGIN
        Lp1 := (Lp - 6) * 32;
        If Lp = 6 Then
         BEGIN
            Write(F, '(');
            For Lp2:=1 To 31 Do
             If OutMode Then Write(F, Convert2Hex(Bitmap[Lp2+Lp1]), ',') Else
              Write(F, Bitmap[Lp2+Lp1], ',');
               Writeln(F, Bitmap[32+Lp1], '),');
         END;
         If (Lp > 6) AND (Lp < 37) Then
          BEGIN
            Write(F, '(');
            For Lp2:= 1 To 31 Do
             If OutMode Then Write(F, Convert2Hex(Bitmap[Lp2+Lp1]), ',') Else
              Write(F, Bitmap[Lp2+Lp1], ',');
               Writeln(F, Bitmap[32+Lp1], '),');
          END;
          If Lp = 37 Then
           BEGIN
            Write(F, '(');
             For Lp2:=1 To 31 Do
              If OutMode Then Write(F, Convert2Hex(Bitmap[Lp2+Lp1]), ',') Else
               Write(F, Bitmap[Lp2+Lp1], ',');
                Writeln(F, Bitmap[32+Lp1], '));');
           END;
     END;
     Writeln(F, 'VAR Loop1, Loop2 : Integer;');
     Writeln(F, 'BEGIN');
     Writeln(F, '  For Loop1 := 1 To 32 Do');
     Writeln(F, '   For Loop2 := 1 To 32 Do');
     Writeln(F, '      PutPixel(Loop1, Loop2, Sprite[Loop2, Loop1], VGA);');
     Writeln(F, 'END;');
     Writeln(F);
     Writeln(F, 'BEGIN');
     Writeln(F, '   SetMCGA;');
     If SavePAL Then
      Writeln(F, '   SetupPalette;');
     Writeln(F, '   DrawSprite;');
     Writeln(F, '   Readln;');
     Writeln(F, '   SetText;');
     Writeln(F, 'END.');
     Close(F);
     GotoXY(1,20);MyWrite('Saving...', 0); (* 0=Black, cleanup old one *)
     ShowMouse; (* Phew! Glad thats over. *)
END;

PROCEDURE MainProg;
(* This is where all the action is, Now I got you all excited, I lied *)
VAR Quit    : Boolean;
    X, Y    : Integer;
    Redraw  : Boolean;
BEGIN
   Quit := FALSE;
   SavePAL := FALSE;
   {$IFNDEF VER70}
   EraseBitmap; (* Not need if using TP 7.0 *)
   OutMode := FALSE;
   {$ENDIF}
   FilledBox(126, 6, 318, 198, 15);
   DrawGridBitmap;
   FilledBox(59, 41, 121, 19, 15);
   DrawPalette;
   ColourBox;
   DrawSave;                    (* Draw The Screen *)
   DrawClear;
   DrawSavePal;       (* Hardly a picture of a thousand words *)
   DrawQuit;
   DrawHexDec;
   SetScrollBars;
   GotoXY(1,1);MyWrite('Sprited v0.6', 14); (* Ain't that something *)
   ShowMouse;    (* Show mouse after screen has been drawn *)
   REPEAT            (* Else we have a chunk missing from the screen *)
      MouseStatus; (* What is that rodent doing? *)
      If (Button = 1) OR (Button = 2) Then
       BEGIN
          If ((MouseX > 1) AND (MouseX <= 120)) AND (* If pointer over palette *)
             ((MouseY > 51) AND (MouseY <= 105)) Then
           BEGIN            (* Select colour *)
             If (MouseY > 100) AND (MouseX > 75) Then Colour := Colour Else
             BEGIN
               Colour := GetPixel(MouseX-1, MouseY-1);
               ColourBox;
               SetScrollBars; (* We also need to adjust the scroll bars *)
             END;
        (* The Minus-1 stops getpixel from grabing the value from the *)
           END;                       (* hot-spot of the mouse cursor *)
          If ((MouseX >= 127) AND (MouseX <= 317)) AND
             ((MouseY >= 7) AND (MouseY <= 197)) Then
           BEGIN (* If mouse pointer over grid *)
             CASE MouseX Of 127..131:X:=1;133..137:X:=2;139..143:X:=3;145..149:X:=4;151..155:X:=5;157..161:X:=6;163..167:X:=7;
             169..173:X:=8;175..179:X:=9;181..185:X:=10;187..191:X:=11;193..197:X:=12;199..203:X:=13;205..209:X:=14;
             211..215:X:=15;217..221:X:=16;223..227:X:=17;229..233:X:=18;235..239:X:=19;241..245:X:=20;247..251:X:=21;
             253..257:X:=22;259..263:X:=23;265..269:X:=24;271..275:X:=25;277..281:X:=26;283..287:X:=27;289..293:X:=28;
             295..299:X:=29;301..305:X:=30;307..311:X:=31;313..317:X:=32; Else X:= 999; END;
             CASE MouseY Of 7..11:Y:=1;13..17:Y:=33;19..23:Y:=65;25..29:Y:=97;31..35:Y:=129;37..41:Y:=161;43..47:Y:=193;
             49..53:Y:=225;55..59:Y:=257;61..65:Y:=289;67..71:Y:=321;73..77:Y:=353;79..83:Y:=385;85..89:Y:=417;91..95:Y:=449;
             97..101:Y:=481;103..107:Y:=513;109..113:Y:=545;115..119:Y:=577;121..125:Y:=609;127..131:Y:=641;133..137:Y:=673;
             139..143:Y:=705;145..149:Y:=737;151..155:Y:=769;157..161:Y:=801;163..167:Y:=833;169..173:Y:=865;175..179:Y:=897;
             181..185:Y:=929;187..191:Y:=961;193..197:Y:=993; Else Y:= 999; END;
             (* X, Y is set to 999 if the mouse position doesn't fall in *)
                          (* between the grid references. *)
                        (* My fingers are starting to ache *)
             (* I was joking really, I made a little table generator ;-) *)
             If ((X <> 999) AND (Y <> 999)) Then
             BEGIN (* If X, Y = 999, OR colour already there then don't draw *)
                If (Button = 1) AND (Colour <> Bitmap[X+Y-1]) Then
                BEGIN
                   Bitmap[X+Y-1] := Colour; (* New colour *)
                   Redraw := TRUE;
                END Else
                If (Button = 2) AND (0 <> Bitmap[X+Y-1]) Then
                BEGIN
                   Bitmap[X+Y-1] := 0; (* Remove colour *)
                   Redraw := TRUE;
                END;
                (* Why did I do this? Well if the same colour is already
                there, we simply don't redraw everything, which gets rid
                of that terrible flicker I had before. *)
                If Redraw Then
                BEGIN
                   HideMouse; (* We need to hide the mouse pointer before we draw *)
                   DrawGridBitmap; (* Re-draw grid *)
                   ShowMouse; (* Else there is little blocks left on the screen *)
                   DrawPreview; (* Time to update our preview of the sprite *)
                   Redraw := FALSE;
                END;
               (* If left button pressed, draw colour *)
               (* If right button pressed, make it black *)
             END;
           END;
          If ((MouseX >= 55) AND (MouseX <= 95)) AND
             ((MouseY >= 167) AND (MouseY <= 176)) Then
             BEGIN (* If Button is pressed while on clear button *)
                EraseBitmap; (* Erase Sprite from memory *)
                DrawGridBitmap;
                DrawPreview;
             END;
          If ((MouseX >= 15) AND (MouseX <= 48)) AND   (* Save sprite *)
             ((MouseY >= 183) AND (MouseY <= 192)) Then SavePascalSource;
          If ((MouseX >= 55) AND (MouseX <= 120)) AND   (* Save Pal flag *)
             ((MouseY >= 183) AND (MouseY <= 192)) Then
             BEGIN
               WaitForButtonUp; (* Waits for user releasing button *)
               If SavePAL = FALSE Then SavePAL := TRUE Else
               If SavePAL = TRUE Then SavePAL := FALSE;
               HideMouse; (* Change savepal button state *)
               DrawSavePal;
               ShowMouse;
             END;
          If ((MouseX >= 103) AND (MouseX <= 120)) AND
             ((MouseY >= 167) AND (MouseY <= 176)) Then
             BEGIN  (* Change Hex/Dec mode *)
               WaitForButtonUp;
               If OutMode = FALSE Then OutMode := TRUE Else
               If OutMode = TRUE Then OutMode := FALSE;
               HideMouse; (* Change Hex/Dec button state *)
               DrawHexDec;
               ShowMouse;
             END;
          If ((MouseX >= 33) AND (MouseX <= 96)) AND
             ((MouseY >= 113) AND (MouseY <= 118)) Then
             BEGIN (* This takes care of the red scroll bar *)
               HideMouse;
               GetPalette(Colour, R, G, B);
               FilledBox(32, 113, 117, 118, 0);
               DrawRedBar;
               FilledBox(MouseX, 113, MouseX + 4, 118, 15);
               R := MouseX - 33;
               SetPalette(Colour, R, G, B);
               ShowMouse;
             END;
          If ((MouseX >= 33) AND (MouseX <= 96)) AND
             ((MouseY >= 121) AND (MouseY <= 126)) Then
             BEGIN (* This takes care of the green scroll bar *)
               HideMouse;
               GetPalette(Colour, R, G, B);
               FilledBox(32, 121, 117, 126, 0);
               DrawGreenBar;
               FilledBox(MouseX, 121, MouseX + 4, 126, 15);
               G := MouseX - 33;
               SetPalette(Colour, R, G, B);
               ShowMouse;
             END;
          If ((MouseX >= 33) AND (MouseX <= 96)) AND
             ((MouseY >= 129) AND (MouseY <= 134)) Then
             BEGIN (* This takes care of the blue scroll bar *)
               HideMouse;
               GetPalette(Colour, R, G, B);
               FilledBox(32, 129, 117, 134, 0);
               DrawBlueBar;
               FilledBox(MouseX, 129, MouseX + 4, 134, 15);
               B := MouseX - 33;
               SetPalette(Colour, R, G, B);
               ShowMouse;
             END;
          If ((MouseX >= 15) AND (MouseX <= 48)) AND  (* Wanna quit? *)
             ((MouseY >= 167) AND (MouseY <= 176)) Then Quit := TRUE;
       END;
   UNTIL Quit; (* Time to go home *)
END;

PROCEDURE Initialize;
BEGIN
   Writeln('Sprite Editor, v0.6');
   Writeln('Coded by Karma, based on original code by Phobos aka Tim Jewell.');
   TurnMouseOn;  (* Let there be a mouse *)
   If NOT MouseFnd Then
   BEGIN
      Writeln;
      Writeln('Mouse Not Found!');
      Halt(1); (* No Mouse No fun *)
   END;
   SetMode($13); (* Into Graphics Mode *)
   CalcScreenY(320); (* Pre-Calculate Y values for putpixel etc. *)
   Width := 320;     (* Set the screen width we are using *)
   VGASeg := Ptr($A000, 0); (* Point Buffer to VGA Segment *)
   Colour := 1; (* Start @ Blue *)
END;

BEGIN (* Main Code *)
  Initialize; (* Setup Sprited *)
  MainProg; (* Lets Rock! *)
  SetMode($03); (* Oh well, back to good ol' DOS. *)
  Writeln('Thankyou for using Sprited v0.6'); (* Applause! Well maybe not *)
END.
