{$G+}
program Mode_X;

uses crt;

var x,y,dirx,diry : word;

procedure SetModeX;assembler;
asm
  mov     ax,13h        { Zuerst den normalen Modus 13h per BIOS aktivieren }
  int     10h
  mov     dx,3C4h
  mov     al,4                         { TS-Register 4 anwhlen }
  out     dx,al
  inc     dx
  in      al,dx                        { Aktuellen Registerinhalt holen }
  and     al,0F7h                      { Bit 2 setzen, Bit 3 lschen }
  or      al,4
  out     dx,al                        { Werte zurckschreiben }
  dec     dx
  mov     ax,0F02h
  out     dx,ax                        { Alle Planes selektieren }
  mov     ax,0A000h                    { VGA-Segment nach ES }
  mov     es,ax
  xor     di,di
  xor     ax,ax
  mov     cx,0FFFFh
  cld
  rep     stosw                        { Bildschirm lschen }
  mov     dx,3D4h
  mov     al,14h                       { CRTC-Register 14h anwhlen }
  out     dx,al
  inc     dx
  in      al,dx                        { Aktuellen Registerinhalt holen }
  and     al,0BFh                      { Bit 6 lschen }
  out     dx,al
  dec     dx
  mov     al,17h                       { CRTC-Register 17h anwhlen }
  out     dx,al
  inc     dx
  in      al,dx
  or      al,40h                       { Bit 6 setzen }
  out     dx,al
end;

procedure XPutPixel(x,y:integer;col:byte);assembler;
asm
  mov     ax,0A000h                    { VGA-Segment nach ES }
  mov     es,ax
  mov     cx,x                         { X-Koord nach CX }
  and     cx,3                         { Plane bestimmen }
  mov     ax,1
  shl     ax,cl                        { Entsprechendes Bit setzen }
  mov     ah,al
  mov     dx,03C4h
  mov     al,2                         { Timing-Sequencer Reg. 2 anwhlen }
  out     dx,ax                        { Plane setzen }
  mov     ax,80                        { Pixel-Offset bestimmen }
  mul     y                            { Offset = y * 80 + x div 4 }
  mov     di,ax                        { y * 80 nach DI }
  mov     ax,x
  shr     ax,2                         { entspricht AX div 4 }
  add     di,ax                        { x div 4 dazuzhlen }
  mov     al,col                       { Farbe nach AL }
  mov     es:[di],al                   { Pixel setzen }
end;

procedure XSetStart(Adr:word);assembler;
asm
  mov     dx,3D4h
  mov     al,0Ch                       { CRTC-Register 0Ch }
  mov     ah,byte ptr Adr + 1          { Bits 15-8 abschicken }
  out     dx,ax
  mov     al,0Dh                       { CRTC-Register 0Dh }
  mov     ah,byte ptr Adr              { Bits 7-0 abschicken }
  out     dx,ax
end;

procedure XDouble;assembler;
asm
  mov     dx,3D4h                      { CRTC-Register 13h anwhlen }
  mov     ax,5013h                     { auf 80 setzen (doppelte Breite) }
  out     dx,ax
end;

procedure WaitRetrace;assembler;
asm
  mov     dx,3DAh
@l1:
  in      al,dx
  and     al,08h
  jz      @l1
@l2:
  in      al,dx
  and     al,08h
  jz      @l2
end;


begin
  setmodex;                            { Mode-X setzen }
  xdouble;                             { 160-Byte Modus einschalten }
  for x := 0 to 319 do                 { Alle 4 Pages mit Mll fllen }
    for y := 0 to 799 do xputpixel(x,y,random(256));
  x := 1;                              { Startposition }
  y := 160;
  dirx := 1;
  diry := 160;
  repeat
    inc(x,dirx);                       { Bildausschnitt weiterbewegen }
    inc(y,diry);
    delay(10);
    WaitRetrace;
    XSetStart(y+x);                    { Neue Startadresse setzen }
    if (x = 80) or (x = 1) then dirx := -dirx;
    if (y = 32000) or (y = 160) then diry := -diry;
    { Richtung umkehren, wenn am Rand angekommen }
  until keypressed;
  readkey;
  asm mov ax,3; int 10h end;
end.
