{$G+}{$N+}
UNIT PCX;

INTERFACE

USES dos;

CONST
	PalSize = 768;

TYPE
	pcxheader = RECORD
		manufacturer,version,encoding,bits_per_pixel : byte;
		xmin,ymin,xmax,ymax,hres,vres : word;
		palette : ARRAY[0..47] of byte;
		reserved : byte;
		color_planes : byte;
		bytes_per_line : word;
		palette_type : word;
		filler : ARRAY[0..57] of byte;
	END;

VAR
	pcxfile 		: FILE;
	header 			: pcxheader;
	DirInfo			: SearchRec;
	c, b, n			: word;
	scankey			: byte;
	ChangeDir,
	Selected		: boolean;

PROCEDURE setpcxpal(VAR pcxfile:file);
PROCEDURE unpackpcx(VAR pcxfile:file; outseg:word);
PROCEDURE LoadPcx(filename : string; seg : word; vbe:byte);

IMPLEMENTATION

FUNCTION validpcx : boolean;
{ Checks if file is a valid 256 color pcx image }
BEGIN
	seek(pcxfile,0);
	blockread(pcxfile,header,sizeof(header));
	WITH header do validpcx := (manufacturer = 10) AND (version = 5) AND
		(bits_per_pixel = 8) AND (color_planes = 1);
END;

FUNCTION validpal : boolean;
{ Checks if the pallette is valid }
VAR v : byte;
BEGIN
	seek(pcxfile,filesize(pcxfile)-Succ(PalSize));
	blockread(pcxfile,v,1);
	validpal := v = $0c;
END;

PROCEDURE setpcxpal(VAR pcxfile:file);
TYPE
	PalArray = ARRAY[0..767] of byte;
VAR pal : PalArray;
BEGIN
	seek(pcxfile,filesize(pcxfile)-PalSize); { Move to last 768 bytes of file }
	blockread(pcxfile,pal,PalSize); 				 { Read entire pallette }
	ASM
		cld
		xor di,di
		xor bx,bx
	 @L1:
		mov dx,03c8h
		mov ax,bx
		out dx,al
		inc dx
		mov cx,3
	 @L2:
		mov al,byte ptr pal[di] { Read in color from pal array }
		shr al,2
		out dx,al							  { Output pal array to computer Pallette }
		inc di
		loop @L2
		inc bx
		cmp bx,256
		jne @L1
	END;
END;

PROCEDURE unpackpcx(VAR pcxfile:file; outseg:word);
TYPE
	pic					= ARRAY[1..64000] OF byte;
VAR
	bytes_per_line,
	pic_length,
	image_length,
	dimx, dimy	: word;
	picptr			: ^pic;
	picaddr			: word;
	header 			: pcxheader;
BEGIN
	seek(pcxfile,0);
	blockread(pcxfile,header,sizeof(header));
	GetMem (picptr,64000);
	picaddr := seg (picptr^);
	seek(pcxfile,128);
	image_length := Filesize(pcxfile)-PalSize-sizeof(header);
	dimx := header.xmax - header.xmin + 1;
	dimy := header.ymax - header.ymin + 1;
	bytes_per_line := header.bytes_per_line;
	pic_length := dimy * dimx;
	blockread(pcxfile,mem[picaddr:0],image_length);
{	This bit does the unencoding of pcx's runlength compression. }
	ASM
		push	ds
		cld
		mov		ds, picaddr
		mov		es, outseg
		mov		bx, pic_length
		mov		dx, dimx
		mov		cx, dx
		mov		si, 0
		mov		di, 0

@Continue_Display:
		lodsb

		mov		ah, 0C0h
		and		ah, al
		cmp		ah, 0C0h
		jne		@Single_Pixel

		mov		ah, 3Fh
		and		ah, al
		lodsb

@Put_Next_Pixel:
		stosb

		dec		cx
		jz		@Test_End_of_Line

@EndLine_During_repeat:
		dec		ah
		jz		@Test_End_of_Line

		jmp		@Put_Next_Pixel

@Single_Pixel:
		stosb
		dec		cx
		xor		ah, ah

@Test_End_of_Line:
		cmp		cx, 0
		jnz		@Continue_Display

		cmp		dx, bytes_per_line
		je		@x_matches_line_length

		inc		si

@x_matches_line_length:
		add		di, 320
		sub		di, dx
		sub		bx, dx
		mov		cx, dx

@Test_End_of_pic:
		cmp		bx, 0
		je		@End_of_pic

		cmp		ah, 0
		jne		@EndLine_During_repeat

		jmp		@Continue_Display

@End_of_pic:
		pop		ds
	END;
	freemem(picptr,64000);
END;


PROCEDURE PrintError(Msg : string);
VAR
	SaveVidMode : word;
BEGIN
	ASM
		mov		ax, 0Fh
		int		10h
		mov		SaveVidMode, ax
		mov		ax, 03h
		int		10h

	END;
	writeln(Msg);
	ASM
		mov		ax, SaveVidMode
		int		10h
	END;
END;

PROCEDURE LoadPcx(FileName : string; seg : word; vbe:byte);
BEGIN
	assign(pcxfile,FileName);
	reset(pcxfile,1); { reset pcxfile with 1 signifying byte reads }
	IF NOT validpcx THEN
		PrintError(FileName+' not a valid 256 color PCX file.')
	ELSE IF NOT validpal THEN
		PrintError(FileName+#39+'s is palette invalid.')
	ELSE
		BEGIN
			setpcxpal(pcxfile);			{ Load pallette from pcx file }
			unpackpcx(pcxfile,seg)     { Put pcx image to screen }
		END;
	close(pcxfile);
END;

BEGIN
END.
