{$M 20000,0,0} {don't forget to reduce the heap!}
uses sds, sds_det, crt, alloc, esb, strings, dos;

{
  Sound Deluxe System 5, a Maple Leaf production, 1996-1997
  Module + FX player simultaneously
}

var module   : pointer;
    services : pointer;

    fx_c1, fx_c2 : byte;    {two fx-channels numbers}

function choosecard:word;
var c:char; crd:word;
begin
  writeln('Choose soundcard :');
  writeln(' 1.Sound Blaster 1.0 or 2.0');
  writeln(' 2.Sound Blaster Pro (DSP 3.x)');
  writeln(' 3.Sound Blaster 16 ASP or AWE 32 (DSP 4.0)');
  writeln(' 4.Gravis UltraSound');
  writeln(' 5.Pro Audio Spectrum Plus/16');
  writeln(' 6.Crystal/Analog CODEC (WSS/AudioTrix Pro/GUS MAX CODEC)');
  writeln(' 7.Aria (Sierra SC18025/SC18026 DSP)');
  writeln(' 8.UltraSilence!(tm) (no sound)');
  repeat
    repeat c:=readkey until c in ['1'..'8'];
    crd:=byte(c)-byte('0');
    c:='Y';
    case crd of
      1: if not DetectSB(Base, Irq, Dma) then c:='N';
      2: if not DetectSBPro(Base, Irq, Dma) then c:='N';
      3: if not DetectSB16(Base, Irq, Dma) then c:='N';
      4: if not DetectGUS(Base, Irq, Dma) then c:='N';
      5: if not DetectPAS(Base, Irq, Dma) then c:='N';
      6: if not DetectWSS(Base, Irq, Dma) then c:='N';
      7: if not DetectARIA(Base, Irq, Dma) then c:='N';
    end;
    if c<>'Y' then begin
      write(#13'Card not found, try again');
      sound(1000); delay(20); nosound
    end;
  until c='Y';
  write(#13); clreol;
  choosecard:=crd;
end;

procedure MyFuckinRoutine;far;
begin
  asm mov ax,seg @DATA; mov ds,ax end;
  write(#13,'Loading ');
  case Action of
    1 : write ('header');
    2 : write ('pattern ',actionPARA);
    3 : write ('sample ',actionPARA);
    4 : write ('channel ',actionPARA);
    5 : write ('text');
    6 : write ('descriptor #',actionPARA);
    else write('something (unknown)');
  end;
  write(', Available mem: ',sds_mavail div 1024,' kb');
  clreol;
end;

procedure play_with_fx_shit;
{ THIS ROUTINE DEMONSTRATES HOW TO CHAT WITH THE FX FEATURES IN SDS }
var my_fx_channel:byte;
    fx1, fx2 : fx_type;
    c:char;
begin

   {in this moment the song (s3m,mod,whatever) is playing in background,
    and two (or more/less) FX channels have previously been open before
    starting the module (see below). This routine loads two waves (samples)
    from disk and waits for a keypress. If '1' is pressed, then the first
    FX-sample is shot, otherwise the second FX-sample is shot. Note that
    two FX channels will be used, in order to demonstrate that you may
    "combine" the FXs on as many FX channels as possible (eg: 32-chn_song)
    Sort of "DOOM", if you know what I mean...}

    { LOAD FX SAMPLES. ALSO A LOADING ERROR TEST CAN BE DONE, BUT I'M LAZY... }

    sds_fx_load_fx('example1.sam', 0{flags, see doc}, fx1);
    sds_fx_load_fx('example2.sam', 0{flags, see doc}, fx2);
    { I've used above the 8-bit signed form, but you may specify either
      16bit/8bit, signed/unsigned, delta/normal. SEE DOCS! }

    { SETUP THESE TWO FX: THEIR VOLUME, PANNING and PITCH (rate) }
    sds_fx_setup_fx(fx1, {pitch:}200, {vol:}64, {panning:}PAN_LEFT);
    sds_fx_setup_fx(fx2, {pitch:}300, {vol:}64, {panning:}PAN_RIGHT);

    { OTHER SHIT }
    ClrScr;
    Writeln('SDS 5, by Maple Leaf, 1996-1997.'#13#10'MUSIC AND FX PLAYER v1.1'#13#10);
    Writeln('Press "1" or "2" to hear the FXs, <ESC> to exit...'#13#10);
    my_fx_channel:=1;

    repeat
      my_fx_channel:=1-my_fx_channel;  {permanently exchange it!}
      c:=readkey;
      case c of
        '1' : begin write('Playing FX #1'); sds_fx_shoot(my_fx_channel, fx1); end;
        '2' : begin write('Playing FX #2'); sds_fx_shoot(my_fx_channel, fx2); end;
      end;
      if c in ['1','2'] then writeln(' on FX-channel #',my_fx_channel,' (real channel=',Channels+my_fx_channel,')...');
    until c = #27;

    { DEALLOCATION. _ALL_ ALLOCATED FX SAMPLES _MUST_ BE DEALLOCATED! }

    sds_fx_free_fx(fx1);
    sds_fx_free_fx(fx2);

end;

begin
  writeln('Ŀ');
  writeln('  Sound Deluxe System 5, a Maple Leaf production, 1996-1997      ');
  writeln('  Module and FX player, v1.0 (example program)                   ');
  writeln('    ');
  writeln('  For problems/questions concerning this program or any other    ');
  writeln('  part of Sound Deluxe System, please contact me.                ');
  writeln('');
  writeln;

  if paramcount=0 then begin
    writeln(#13#10'Usage: PLY_FX <module_name>');
    halt;
  end;

  card:=choosecard;

  writeln('Init sound system (using port ',dec2Hex(base),', IRQ',irq,', DMA #',Dma,') ...');
  sds_init(Card{Card#},Base{BasePort},Irq{IRQ},DMA{DMA#});

  write('Loading module ...');
  UseEMS:=true;
  UseUMB:=true;

  UserRoutine:=@MyFuckinRoutine;
  module:=sds_load(ParamStr(1),(card<>Silence){load samples only if card is NOT UltraSilence});

  if loaderror<>0 then begin
    writeln(#13#10'Error loading module (errorcode=',loaderror,')');
    sds_done; {don't forget to close SDS before exit!}
    halt
  end;

  services:=pointer(GetESBdword(44));

  { COMMON SDS INITIALIZATIONS, WHICH, IN FACT, CAN EVEN BE SKIPPED... }

  sds_setsurround(on);
  sds_setpollmix(off);

  { IF WE WANT TO USE SDS's FX FEATURES, WE MUST INITIALIZE FX _BEFORE_
    STARTING THE MODULE PLAYBACK! OTHERWISE SDS WON'T WORK CORRECTLY IN
    FX MODE! SO, HERE THE FX INIT GOES: }

  fx_c1 := sds_fx_openchannel;    {this will be our first fx channel}
  fx_c2 := sds_fx_openchannel;    {this will be our second fx channel}
                                  {more FX channels can be opened, but this
                                   is just a poor example :)...}

  { NOW WE CAN START THE SONG AS USUAL: }

  sds_startplay(module, 0{InitSpeed(0=auto)}, 44000{MixSpeed}, NTSC{1=Pal,0=NTSC});

  { AND NOW LET'S HAVE SOME FUN: }

  play_with_fx_shit; { :-) }

  { AND WE MUST STOP THE PLAYBACK AND SHUT DOWN EVERYTHING BEFORE EXIT! }

  sds_stopplay;
  sds_done;
  sds_unload(module);

end.