;     Ŀ
;        Sound Deluxe System 5, a Maple Leaf production               
;        1996-1997                                                    
;           
;        8/16 bit DMA routines                                        
;     

dmAutoInit db    1           ; 1=autoinit mode, 0=single cycle mode
dmModesOR  db    48h, 58h

nproc   dmStartDMA8   ; AX = DMA counter's init value
        push     bx  ; AX & DX are already saved somewhere out
        push     ax
        mov      al,cs:mxDMA
        mov      ah,al    ; store it for future usage
        or       al,4
        out      0Ah,al   ; Mask channel
        xor      al,al
        out      0Ch,al   ; Clear Flip-flop
        mov      al,ah
        movzx    bx,cs:dmAutoInit
        or       al,cs:dmModesOR[bx]
        out      0Bh,al   ; Setup dma channel
        movzx    bx,ah    ; bx:=dma channel
        add      bx,bx
        mov      dx,cs:DmaPageReg[bx]
        mov      ax,cs:mxDMABuf1
        shr      ax,4+8
        out      dx,al    ; Send page register (bits 16..23 of address)
        mov      dx,bx    ; dx:=dma_chn*2
        mov      ax,cs:mxDMABuf1
        shl      ax,4
;       add      ax,0     ; Offset is always 0 !
        out      dx,al    ; Send bits 0..7 of address
        mov      al,ah
        out      dx,al    ; Send bits 8..15 of address
        inc      dx       ; dx:=dma_chn*2+1
        pop      ax
        out      dx,al    ; Send bits 0..7 of size
        mov      al,ah
        out      dx,al    ; Send bits 8..15 of size
        mov      al,cs:mxDMA
        out      0ah,al   ; Enable channel
        pop      bx
        retn
nendp   dmStartDMA8

nproc   dmStopDMA8
        push     ax bx dx
        mov      al,cs:mxDMA
        or       al,4
        out      0Ah,al         ; mask channel
        or       al,48h
        out      0Bh,al         ; deactivate autoinit
        xor      al,al
        out      0Ch,al         ; set flip-flop
        movzx    dx,cs:mxDMA
        add      dx,dx
        out      dx,al          ; 16-bit offset in page
        out      dx,al          ;
        inc      dx
        out      dx,al          ; 16-bit size
        out      dx,al          ;
        mov      bx,dx
        dec      bx
        mov      dx,cs:DMAPageReg[bx]
        out      dx,al          ; 4-bit page
        mov      al,cs:mxDMA
        out      0Ah,al         ; enable channel
        pop      dx bx ax
        retn
nendp   dmStopDMA8

nproc   dmStartDMA16 ; AX = DMA counter init value
        push     bx ax   ; AX & DX are already saved somewhere out
        mov      al,cs:mxDMA
        sub      al,4
        mov      ah,al    ; store it for future usage
        or       al,4
        out      0D4h,al   ; Mask channel
        xor      al,al
        out      0D8h,al   ; Clear Flip-flop
        mov      al,ah

        movzx    bx,cs:dmAutoInit
        or       al,cs:dmModesOr[bx]
        out      0D6h,al   ; Setup dma mode

        movzx    bx,ah
        add      bl,4
        add      bx,bx
        mov      dx,cs:DmaPageReg[bx]
        mov      ax,cs:mxDMABuf1
        shr      ax,4+8
        out      dx,al    ; Send page register (bits 16..23 of address)

        mov      dx,ax    ; keep page
        mov      ax,cs:mxDMABuf1
        shl      ax,4
;       add      ax,0     ; Offset is always 0 !
        shrd     ax,dx,1  ; convert to 16-bit-DMA address

        movzx    dx,cs:mxDMA
        sub      dx,4
        shl      dx,2     ;
        add      dx,0C0h  ; C0h+(channel-4)*4
        out      dx,al    ; Send bits 0..7 of address
        mov      al,ah
        out      dx,al    ; Send bits 8..15 of address

        add      dx,2     ; dx:=C2h+(channel-4)*4
        pop      ax
        out      dx,al    ; Send bits 0..7 of size
        mov      al,ah
        out      dx,al    ; Send bits 8..15 of size

        mov      al,cs:mxDMA
        sub      al,4
        out      0D4h,al   ; Enable channel
        pop      bx
nendp   dmStartDMA16

nproc   dmStopDMA16
        push     ax dx si
        mov      al,cs:mxDMA
        sub      al,4
        mov      ah,al
        or       al,4
        out      0D4h,al      ; mask 16-bit channel
        or       al,48h
        out      0D6h,al      ; deactivate autoinit, set mode #3 = unused
        xor      al,al
        out      0D8h,al      ; set flip-flop ptr
        movzx    dx,cs:mxDMA
        shl      dx,2
        add      dx,0C0h
        out      dx,al          ; 16-bit offset in page
        out      dx,al          ;
        add      dx,2
        out      dx,al          ; 16-bit size
        out      dx,al          ;
        movzx    si,cs:mxDMA
        add      si,si
        mov      dx,cs:DMAPageReg[si]
        out      dx,al          ; 4-bit page
        mov      al,ah
        out      0D4h,al      ; enable channel
        pop      si dx ax
        retn
nendp   dmStopDMA16

nproc   dmStartDMA
        push     ax dx
        cmp      cs:mxDMA,4
        sjb      dmo1
        mov      ax,DMABufSize*8-1  ; SIZE IS GIVEN IN WORDS !!!
        call     dmStartDMA16       ; start 16-bit DMA channel
        jmp      short dmo2
dmo1:   mov      ax,DMABufSize*16-1 ;
        call     dmStartDMA8        ; start 8-bit DMA channel
dmo2:   pop      dx ax
        retn
nendp   dmStartDMA

nproc   dmStopDMA
        push     ax
        cmp      cs:mxDMA,3
        sja      dmo9
        call     dmStopDMA8
        jmp      short dmo10
dmo9:   call     dmStopDMA16
dmo10:  pop      ax
        retn
nendp   dmStopDMA
