;     Ŀ
;        Sound Deluxe System 5, a Maple Leaf production               
;        1996-1997                                                    
;           
;        Software mixers (mono/stereo), v1.99                         
;           
;       New for this version: optimizations, TickAwaited() test      
;       Vol0_Optimization for both mono/stereo mixers                
;       code alignments                                              
;       some poll-compatibility changes                              
;     

; Mixers' internal data 

mxPort                  dw     378h     ; Default base port
mxIrq                   db     7        ; Default IRQ used
mxDma                   db     1        ; Default DMA channel used

mxMixSpd                dd     22050    ; default sucks...
mxVoices                dw     4        ; # of voices (# of channels)

mxPerc                  dw     100      ; Amplif. percent for Post-Processing Table (temporary used)

mxMaxMix                dw     0        ; How much should be mixed once (in bytes)

mxLastDmaPositionUsed   dw     0        ; fuck around the clock tonight
mxDmaOffset             dw     0

mxDMABuf1               dw     0        ; DMA buffer segment. Used for playing. Offset always equals 0.
mxAhead                 dw     0        ; mix-ahead buffer. Offset = 0

mxVoicesPerChannel_st   dw     2


mxLastDistance dw 0


;
;
;                                 MONO MIXER
;
;



;
;          DoPoll_mono: this routine performs a mix-ahead process.
;

        align_para

nproc   mx_DoPoll_mono

        push     eax ebx cx edx si di ebp ds es

mx_sm1: mov      si,1234h          ; mov si,(voices-1)*4

        call     mx_InitGlobal

mx_L1:
        call     mx_InitChannel    ; initialize the channel parameters
        call     mx_MixChannel     ; mix the current channel
        call     mx_DoneChannel    ; "collect" actual parameters

        sub      si,4
        sjge     mx_L1

        call     mx_UpdateDmaBuf   ; postprocess the mix-ahead buffer

        pop      es ds ebp di si edx cx ebx eax

        retn
nendp   mx_DoPoll_mono


;
;  Mix channel in MONO mode 
;
; This routine performs a mix-ahead process on a single specified channel,
; by adding the results (bytes) to a 16-bit mix-ahead buffer.
;
; In: SI=voice*4, DS=sample seg, ES:DI=mix-ahead addr
;     EBP=position(bits 0-15)/carry(16-31), EDX=sample's frequency (addendum/carry)
;     all the 'mx_sm?:' SMCODES must be initialized
;
;

        align_para

nproc   mx_MixChannel

        mov      bh,0                 ; MUST remain zero during the loop !!!
        mov      ax,2                 ; start with increment 2
mx_sm9: mov      cx,1234h             ; MaxMix

IF Vol0Optimization ne 0
; This is ST3's Vol0 optimization and, normally, it "accelerates" the
; routine by 10%-40%
        cmp      byte ptr VoiceVol[si],0     ; is channel clear ?
        je       mx_ClrChannel               ; yes, don't mix (speedup)
ENDIF

        xchg     esi,ebp  ; esi will be used here as counter+position

        jmp      short mx_ML

        align_para

;--- the main loop --------------------------------------------------------
mx_ML:   ; each time in this point, the AX register MUST BE equal to 2

        mov      bl,[si]              ; load a byte from sample
mx_sm4: mov      bl,cs:[bx+1234h]     ; volume scaling, remember that bh=0 !
mx_sm5: add      es:[di],bx           ; store/add sample in mix-ahead buffer
        add      di,ax                ; advance one word in mix-ahead buffer (faster than add di,2)

        rol      esi,16               ; position in bits 16-31
        add      esi,edx              ; add freq/carry (EDX) to position/carry (EBP)
        ror      esi,16               ; position back in bits 0-15

mx_sm8: cmp      si,1234h             ; cmp si,size   (end reached ?)
        sjae     mxe30

        dec      cx                   ; faster than LOOP instruction
        sjnz     mx_ML                ;

        jmp      short mxe31          ; go do the final things

;--- end of the main loop ------------------------------------------------

mxe30:  ; position has reached the end of the sample. Check if must loop.

mx_sma: mov      ax,1234h             ; loopend
        cmp      ax,0FFFFh            ; must loop ?
        sje      mxe28                ; no, go shut down the voice

   ; when in this point, the sample must loop.
   ; init parameters for looping :

mx_smb: mov      ax,1234h             ; loopstart
        movzx    esi,ax               ; position=loopstart, carry=0
        mov      ax,2     ; AX=2, and loop
        dec      cx
        sjnz     mx_ML
        jmp      short mxe31

mxe28:  mov      word ptr cs:mx_sm4+3,offset VolTab   ; SMCODE INIT - set volume to 0
        mov      ax,2     ; AX=2 (used as addendum for position (DI))
        dec      cx
        sjnz     mx_ML                ; next byte...

mxe31:

        xchg     esi,ebp

        retn

IF Vol0Optimization ne 0
mx_ClrChannel:    ; when in this point, the channel is clear (volume=0)
                  ; and mixing is useless, so let's do a faster update
                  ; of the mix-ahead buffer...

        mov      ax,word ptr cs:mx_sm5      ;
        mov      word ptr cs:mx_smg,ax      ; SMCODE INIT
        jmp      $+2                        ; reinit CPU queue
        mov      ax,80h                     ; null signal

        xchg     esi,ebp                    ;*
        rol      esi,16                     ;*

        jmp      short mx_smg

        align_para

mx_smg: add      es:[di],ax                 ;
        add      esi,edx                    ;* update position
        add      di,2                       ;  update the mix-ahead buf pos
        dec      cx                         ;
        sjnz     mx_smg

        ror      esi,16                     ;*
        xchg     esi,ebp                    ;*

        ; what is marked with ;* is quite dangerous

        retn
ENDIF

nendp   mx_MixChannel



;
;  Init channel 
;
; The following routine prepares the specified channel (SI shr 2) for a new
; mix-ahead process (see above). All the SMCODE must be initialized.
;
; In: SI = channel*4, DS=CS
; Out: DS=sample's seg, ES=mix-ahead buffer's seg,
;      DI=0, EBP=sample's actual position and collector (32 bit),
;      EDX=sample's frequency (addendum and collector)
;      If sample on this channel is in EMS, the routine first maps its
;      logical pages in the first 1-4 physical pages and returns the
;      sample's segment address as C800h (EMS frame page address).
;
;  It also initializes all the tick-dependant SMCODE.
;
;

        align_para

nproc   mx_InitChannel

        mov      ax,0126h     ; "add es:[di],bx" - first two bytes
mx_sm2: cmp      si,1234h     ; first channel ((voice-1)*4) ?  ; cmp si,firstVoice=(voices-1)*4
        sjne     mx_e2
        mov      ah,89h       ; 8926h = "mov es:[di],bx" - first two bytes

mx_e2:  mov      word ptr mx_sm5,ax             ; SMCODE INIT

        mov      ax,offset VolTab
        add      ah,byte ptr VoiceVol[si]
        mov      word ptr mx_sm4+3,ax           ; SMCODE INIT  - volume

        mov      edx,VoiceFreq[si]              ; NEW19 : init frequency

        mov      eax,VoiceSize[si]
        mov      word ptr mx_sm8+2,ax           ; SMCODE INIT  - size

        mov      ebp,VoicePos[si]
        ror      ebp,16                         ; SMCODE INIT  - position (full)

        mov      eax,VoiceLoopEnd[si]
        mov      word ptr mx_sma+1,ax           ; SMCODE INIT  - loop end

        mov      eax,VoiceLoopStart[si]
        mov      word ptr mx_smb+1,ax           ; SMCODE INIT  - loop start

        mov      ax,word ptr VoiceSeg[si]
        cmp      ax,0F000h
        jb       mx_e3

    ; When in this point, the sample is into EMS, and it has to
    ; be "downloaded" from there. In order to do this, we compute
    ; the handle associated to the sample, then we map ems logical pages
    ; to the first 1-4 physical pages (starting at 0C800:0h)

        and      ax,0FFFh             ; compute handle
        call     mx_emsMap            ; map pages
        mov      ax,cs:emsFrameSeg    ; Frame Page segment (usually 0C800h)

mx_e3:  mov      ds,ax   ; sample segment in DS
        mov      di,0    ; to mix-ahead offset 0
        retn
nendp   mx_InitChannel



;
;  "close" channel 
;
; This routine is called after a channel has been "mixed". It collects all
; the data which has changed during the channel's mixing (position,collector,
; volume) and restores EMS mapping context (if the sample was mapped by the
; previous routine).
;
;   In: SI=voice*4, DS=CS (!!!), EDX=sample's freq., EBP=actual pos/carry
;
;

        align_para

nproc   mx_DoneChannel

        mov      ax,cs
        mov      ds,ax

        mov      ax,word ptr mx_sm4+3
        sub      ax,offset VolTab            ; AH:=actual volume
        mov      byte ptr VoiceVol[si],ah    ; save it

        rol      ebp,16   ; position back into bits 16-31
        mov      VoicePos[si],ebp            ; actual position/carry : save it

    ; LOOPSTART/LOOPEND do not change during a single tick mixing,
    ; so reading them again from mx_sma and mx_smb is useless.
    ; The same shit with SIZE and FREQUENCY.

        mov      ax,word ptr VoiceSeg[si]
        cmp      ax,0F000h    ; is sample in EMS ?
        jb       mx_e9
        mov      ax,emsHandle            ;  if yes, restore mapping for
        call     emsRestoreMapping       ;  its handle
mx_e9:
        retn
nendp   mx_DoneChannel


;
;  Update DMA buffer (mono mode) 
;
; This routine is called when all the jobs were finished for all channels,
; and the 16-bit mix-ahead buffer is completely updated. The routine takes
; each entry on the mix-ahead buffer (16 bit), converts it to 8 bit, amplifies
; it and scales it with the global volume, then writes it down into the DMA
; buffer. The last position encountered in writing the DMA buffer is stored
; into mxLastDmaPositionUsed, for a later usage.
;
;  In:  nothing
;
;

        align_para

nproc   mx_UpdateDmaBuf

        mov      ds,cs:mxAhead
        mov      es,cs:mxDMAbuf1
        mov      si,0
        mov      di,cs:mxLastDmaPositionUsed

mx_smc: mov      cx,1234h          ; MaxMix
        mov      bp,2  ; fixed, MUST NOT change during the loop

        jmp      short mx_ML2

        align_para

mx_ML2: mov      bx,[si]            ; extract a 16-bit sample
        add      si,bp              ; bp=2. (faster than lodsw/mov bx,ax)

        movzx    bx,cs:[bx+offset PostTab]    ; postprocess (16bit->8bit)
        mov      bl,cs:[bx+offset AmplifTab]  ; amplify
mx_smd: mov      al,cs:[bx+1234h]             ; global volume scale
        mov      es:[di],al                   ; update DMA buffer

        inc      di
        and      di,3FFFh                     ; !!! valid only if buffer size is 16 Kb !!!

        dec      cx
        sjnz     mx_ML2

        mov      dx,cs:mxDmaOffset
        mov      cs:mxLastDmaPositionUsed,di

; -- Used for debugging purposes ------------------------------------------
        mov      ax,di
        sub      ax,dx
        sjge     mx_e12
        add      ax,DMABufSize*16
mx_e12: mov      cs:MixAheadDistance,ax

IF AutoCorrection ne 0

        cmp      cs:PollMod,0          ; no auto-correction in poll mode !!!
        sjne     acm_o1

        mov      dx,ax
        cmp      cs:mxLastDistance,0   ; first/reset ?
        sje      acm_ok

acm_nr: sub      ax,cs:mxLastDistance
        sje      acm_ok
        sjl      acm_l

acm_g:  sub      cs:mxMaxMix,ax
        jmp      short acm_ok

acm_l:  neg      ax

                    ; this is a fuckin bullshit, but I really don't have
        inc      ax ; any other fuckin idea how the fuck should I avoid
                    ; the decreasing of the fuckin distance...

        add      cs:mxMaxMix,ax

acm_ok: mov      cs:mxLastDistance,dx  ; set new value
acm_o1:

ENDIF


; -------------------------------------------------------------------------

        retn
nendp   mx_UpdateDmaBuf



;
;  Init global things 
;
; This routine initializes some of the SMCODE, used in what follows by
; MixChannel and UpdateDmaBuf routines.
;
;  Out: DS=CS !
;
;

nproc   mx_InitGlobal
        push     ax cx dx
        mov      ax,cs
        mov      ds,ax
        mov      ax,mxMaxMix
        mov      word ptr mx_sm9+1,ax          ; SMCODE INIT
        mov      word ptr mx_smc+1,ax          ; SMCODE INIT
        mov      ah,cs:GlobalVolume
        mov      al,0
        add      ax,offset VolTab
        mov      word ptr mx_smd+3,ax          ; SMCODE INIT
        mov      es,mxAhead        ; ES = mix-ahead buffer's segment
        pop      dx cx ax
        retn
nendp   mx_InitGlobal




;
;  This routine sets the initial values of some SDS's internal variables
;  and initializes some of the SMCODE
;

nproc   mxInitVars_mono

        push     eax ecx edx

     ; initialize some variables and also some of the SMCODE

        mov      cs:StereoMode,0    ; Works in MONO from now on !!!!!

        mov      ax,cs:mxVoices
        dec      ax
        shl      ax,2                             ; ax=(voices-1)*4
        mov      word ptr cs:mx_sm1+1,ax          ; SMCODE INIT
        mov      word ptr cs:mx_sm2+2,ax          ; SMCODE INIT

        mov      ax,cs:BPM
        add      ax,ax
        mov      cl,5
        div      cl                ; ax=BPM*2/5=TicksPerSecond
        movzx    ecx,al
        mov      eax,cs:mxMixSpd
        xor      edx,edx
        div      ecx               ; ax = Frequency/TicksPerSecond = MaxMix
;       inc      eax  ; ????
        mov      cs:mxMaxMix,ax  ; a word is enough

mxiv2:  cmp      ax,DMABufSize*16-1   ; protection:  if user is so stupid
        jbe      mxiv1                ; and sets the value of DMABufSize
        sub      ax,DMABufSize*16     ; too small... (as I did, for example:)
        jmp      short mxiv2          ;
mxiv1:                                ;

        mov      cs:mxLastDmaPositionUsed,ax

IF AutoCorrection ne 0
        mov      cs:mxLastDistance,0  ; reset last distance
ENDIF

    ; ---- initializes the dma buffer ----

        cmp      word ptr cs:mxDMAbuf1[2],0
        je       mxivme1
        push     es di
        mov      es,cs:mxDMABuf1
        mov      di,0
        mov      cx,DMABufSize*8-1
        mov      ax,8080h
        rep stosw
        pop      di es
mxivme1:

        pop      edx ecx eax

        retn
nendp   mxInitVars_mono



;
;        This routine builds the frequencies (carry-addendum) for
;        each period (0 to 1800), since the mixer doesn't work with
;        periods directly, but with such "frequencies".
;

nproc   mxBuildPeriods_mono         ; Build all the periods.
                            ; For mono   : SDS_period = (3579545.25 / amiga_period) * (65536 / mix_frequency)
                            ; For stereo : SDS_period = (3579545.25 / amiga_period) * (65536 / (mix_frequency/2))
        push     es eax ebx ecx edx si di
        mov      bx,cs:FreqMod ; PAL(0) or NTSC(1)
        shl      bx,2
        mov      eax,cs:FMod[bx]
        mov      dword ptr cs:FreqTab[0],0  ; for period 0
        mov      si,1
        mov      di,4
mxe4:   push     eax
        xor      edx,edx
        shld     edx,eax,16               ;
        shl      eax,16                   ;  eax:=eax * 65536
        movzx    ecx,cs:cmixspd           ;  already "Normalized"
        div      ecx
        xor      edx,edx                  ;  eax := (edx:eax) div MixFreq
        movzx    ecx,si
        div      ecx                      ;  eax := (edx:eax) div AmigaPeriod
        mov      cs:FreqTab[di],eax       ;  store it
        pop      eax
        inc      si
        add      di,4
        cmp      si,1800
        jb       mxe4
        pop      di si edx ecx ebx eax es
        retn
nendp   mxBuildPeriods_mono


;
;              This routine builds the post-processing table.
;

nproc   mxBuildProcTab_mono       ; Builds the Post-Processing Table
        push     si di ax bx cx dx
        mov      cx,cs:mxVoices
        shl      cx,8         ; loop mxVoices*256 times
        sub      si,si
        mov      di,cx
        dec      di           ; di:=(channels*256-1)
mxe7:   mov      ax,si
        mov      bx,255
        mul      bx
        div      di           ; al:=si*255/(channels*256-1), si=0..channels*256-1
        mov      cs:PostTab[si],al ; Store it to PostTab table
        inc      si
        loop     mxe7
mxe8:   cmp      si,32*256-1
        ja       mxe9
        mov      cs:PostTab[si],0FFh
        inc      si
        jmp      short mxe8   ; Fill the rest of the table w/ 0FFh bytes
mxe9:   mov      ax,cs:mxVoices
        sub      ax,4         ; Compute the level of amplification
        mov      cl,30        ; for the post-processing table.
        mul      cl           ;
        add      ax,100       ; Percent = 100+(voices-4)*30 = 30% gain for each new channel
        mov      cs:mxPerc,ax ; Store it for calculations
        sub      si,si
        mov      cx,cs:mxVoices
        shl      cx,8         ; loop mxVoices*256 times
mxe10:  mov      al,PostTab[si]
        xor      al,80h
        cbw                         ; al:=integer(posttab[si] xor 80h)
        mov      di,cs:mxPerc
        imul     di                 ; ax:=integer(posttab[si] xor 80h) * Percent
        mov      di,100
        idiv     di                 ; ax:=integer(posttab[si] xor 80h) * Percent / 100
        cmp      ax,-128            ; if ax<-128 then ax:=-128
        jge      mxe11
        mov      ax,-128
mxe11:  cmp      ax,127             ; if ax>127 then ax:=127
        jle      mxe12
        mov      ax,127
mxe12:  xor      al,80h             ; al:=al xor 80h (convert it back)
        mov      cs:PostTab[si],al  ; Store it back (amplified)
        inc      si
        loop     mxe10
        pop      dx cx bx ax di si
        retn
nendp   mxBuildProcTab_mono




;
;
;                                STEREO MIXER
;
;



;
;         DoPoll_stereo: this routine performs a mix-ahead process and
;               can be called by the user as well as the INT 8h
;

        align_para

nproc   mx_DoPoll_stereo

        push     eax ebx cx edx si di ebp ds es

mxs_sm1:mov      si,1234h          ; mov si,(voices-1)*4

        call     mxs_InitGlobal

mxs_L1: call     mxs_InitChannel    ; initialize the channel parameters
        call     mxs_MixChannel     ; mix the current channel
        call     mxs_DoneChannel    ; "collect" actual parameters
        sub      si,4
        sjge     mxs_L1

        call     mxs_UpdateDmaBuf   ; postprocess the mix-ahead buffer

        pop      es ds ebp di si edx cx ebx eax

        retn
nendp   mx_DoPoll_stereo



;
;  Mix channel in Stereo mode 
;
; This routine performs a mix-ahead process on a single specified channel,
; by adding the results (bytes) to a 16-bit mix-ahead buffer.
;
; In: SI=voice*4, DS=sample seg, ES:DI=mix-ahead addr
;     EBP=position/carry, EDX=sample's frequency (addendum/carry)
;     all the 'mxs_sm?:' SMCODES must be initialized
;
;

        align_para

nproc   mxs_MixChannel

        mov      bh,0                 ; MUST remain zero during the loop !!!
mxs_sm9:mov      cx,1234h             ; MaxMix/2 -> here in WORDS !!!

IF Vol0Optimization ne 0
; This is ST3's Vol0 optimization and, normally, it "accelerates" the
; routine by 10%-40%  :
        cmp      byte ptr VoiceVol[si],0
        je       mxs_ClrChannel
ENDIF

        push     esi
        mov      esi,ebp              ; esi is used here as counter+position
        mov      bp,2                 ; used as addendum for position (DI)

        jmp      short mxs_ML

        align_para

;--- the main loop --------------------------------------------------------
mxs_ML:

        mov      bl,[si]              ; load a byte from sample
mxs_sm4:mov      bl,cs:[bx+1234h]     ; volume scaling

mxs_sm6:movzx    ax,cs:[bx+1234h]     ; 1234h=offset VriTab+(VRI shl 8) -> const. during the tick !
mxs_sm5:add      es:[di],ax           ; store/add 16-bit left sample
        add      di,bp                ; bp=2 (faster than add di,2)

mxs_sm7:mov      al,cs:[bx+1234h]     ; 1234h=offset VriTab+((15-VRI) shl 8)
mxs_smh:add      es:[di],ax           ; store/add 16-bit right sample
        add      di,bp                ; bp=2 (faster than add di,2)

        rol      esi,16
        add      esi,edx              ; add freq/carry (EDX) to position/carry (EBP)
        ror      esi,16

mxs_sm8:cmp      si,1234h             ; cmp bp,size   (end reached ?)
        sjae     mxse30
        dec      cx
        sjnz     mxs_ML
        jmp      short mxse31         ; go do the final things

;--- end of the main loop ------------------------------------------------

mxse30: ; position has reached the end of the sample. Check if must loop.

mxs_sma:mov      ax,1234h             ; loopend
        cmp      ax,0FFFFh            ; must loop ?
        sje      mxse28               ; no, go shut down the voice

   ; when in this point, the sample must loop.
   ; init parameters for looping :

mxs_smb:mov      ax,1234h                 ; loopstart
        movzx    esi,ax                   ; position=loopstart, carry=0
        dec      cx
        sjnz     mxs_ML
        jmp      short mxse31

mxse28: mov      word ptr cs:mxs_sm4+3,offset VolTab   ; SMCODE INIT - set volume to 0
        dec      cx
        sjnz     mxs_ML                ; next byte...

mxse31:
        mov      ebp,esi
        pop      esi   ; restore SI register

        retn

IF Vol0Optimization ne 0

mxs_ClrChannel:   ; when in this point, the channel is clear (volume=0)
                  ; and mixing is useless, so let's do a faster update
                  ; of the mix-ahead buffer...

        mov      ax,word ptr cs:mxs_sm5+1   ;
        mov      word ptr cs:mxs_smg+1,ax   ; SMCODE INIT
        mov      ah,1Dh  ; BX instead of AX !
        mov      word ptr cs:mxs_smx+1,ax   ; SMCODE INIT
        jmp      $+2                        ; reinit CPU queue

mxs_smy:mov      ax,0                       ; null signal (SMCODE)
mxs_smz:mov      bx,0                       ; null signal (SMCODE)

        push     esi                     ;*
        mov      esi,ebp                 ;*
        rol      esi,16                  ;*

        jmp      short mxs_smg

        align_para

mxs_smg:add      es:[di],ax              ;
        add      di,2                    ; quickly update the mix-ahead buf
mxs_smx:add      es:[di],bx              ;
        add      di,2                    ; quickly update the mix-ahead buf
        add      esi,edx                 ;* update voice position
        dec      cx                      ;
        sjnz     mxs_smg

        ror      esi,16                  ;*
        mov      ebp,esi                 ;*
        pop      esi                     ;*

  ; the code marked with ;* is used to update the voice position even
  ; if its volume is zero, so a sample is still played in silence even
  ; after its volume has been turned down to zero.
  ; !dangerous!

        retn
ENDIF

nendp   mxs_MixChannel



;
;  Init channel 
;
; The following routine prepares the specified channel (SI shr 2) for a new
; mix-ahead process (see above). All the SMCODE must be initialized.
;
; In: SI = channel*4
; Out: DS=sample's seg, ES=mix-ahead buffer's seg,
;      DI=0, EBP=sample's actual position and collector (32 bit),
;      EDX=sample's frequency (addendum and collector)
;      If sample on this channel is in EMS, the routine first maps its
;      logical pages into the first 1-4 physical pages and returns the
;      sample's segment address as C800h (EMS frame page address).
;
;  It also initializes all the tick-dependant SMCODE.
;
;

        align_para

nproc   mxs_InitChannel

        mov      ax,cs
        mov      ds,ax

mxs_sm2:cmp      si,1234h     ; first channel ((voice-1)*4) ?  ; cmp si,firstVoice=(voices-1)*4
        sje      mxs_e1
        mov      ax,0126h     ; "add es:[di],ax" - first two bytes
        jmp      short mxs_e2
mxs_e1: mov      ax,8926h     ; "mov es:[di],ax" - first two bytes

mxs_e2: mov      word ptr mxs_sm5,ax            ; SMCODE INIT
        mov      word ptr mxs_smh,ax            ; SMCODE INIT

        mov      ah,byte ptr VoiceVol[si]
        mov      al,0
        add      ax,offset VolTab
        mov      word ptr mxs_sm4+3,ax          ; SMCODE INIT  - volume

        mov      edx,VoiceFreq[si]              ; NEW19 : init frequency

        mov      eax,VoiceSize[si]
        mov      word ptr mxs_sm8+2,ax          ; SMCODE INIT  - size

        mov      ebp,VoicePos[si]
        rol      ebp,16                         ; SMCODE INIT  - position (full)

        mov      eax,VoiceLoopEnd[si]
        mov      word ptr mxs_sma+1,ax          ; SMCODE INIT  - loop end

        mov      eax,VoiceLoopStart[si]
        mov      word ptr mxs_smb+1,ax          ; SMCODE INIT  - loop start

        shr      si,2
        mov      ah,byte ptr VRI[si]
        shl      si,2
        mov      ch,15
        sub      ch,ah
        mov      al,0
        mov      cl,al
        add      ax,offset VriTab      ; ax:=(ofs VriTab)+(VRI shl 8)
        add      cx,offset VriTab      ; cs:=(ofs VriTab)+((15-VRI) shl 8)
        mov      word ptr mxs_sm6+4,ax     ; SMCODE INIT  - panning left
        mov      word ptr mxs_sm7+3,cx     ; SMCODE INIT  - panning right

IF Vol0Optimization ne 0

   ; compute null signal for specified VRI (both channels):
   ; LEFT:
        mov      bx,ax
        add      bx,80h  ; real null signal
        movzx    ax,[bx]
        mov      word ptr mxs_smy+1,ax     ; SMCODE INIT - null signal left
   ; RIGHT:
        mov      bx,cx
        add      bx,80h  ; real null signal
        movzx    ax,[bx]
        mov      word ptr mxs_smz+1,ax     ; SMCODE INIT - null signal right

ENDIF


        mov      ax,word ptr VoiceSeg[si]
        cmp      ax,0F000h
        jb       mxs_e3

    ; When in this point, the sample is into EMS, and it has to
    ; be "downloaded" from there. In order to do this, we compute
    ; the handle associated to the sample, then we map ems logical pages
    ; to the first 1-4 physical pages (starting at 0C800:0h)

        and      ax,0FFFh             ; compute handle
        call     mx_emsMap            ; map pages
        mov      ax,cs:emsFrameSeg    ; Frame Page segment (usually 0C800h)

mxs_e3: mov      ds,ax   ; sample segment in DS
        mov      di,0    ; to mix-ahead offset 0
        retn
nendp   mxs_InitChannel



;
;  "close" channel 
;
; This routine is called after a channel has been "mixed". It collects all
; the data which has changed during the channel's mixing (position,collector,
; volume) and restores EMS mapping context (if the sample was mapped by the
; previous routine).
;
;   In: SI=voice*4, DS=CS (!!!), EDX=sample's freq., EBP=actual pos/carry
;
;

        align_para

nproc   mxs_DoneChannel

        mov      ax,cs
        mov      ds,ax

        mov      ax,word ptr mxs_sm4+3
        sub      ax,offset VolTab            ; AH:=actual volume
        mov      byte ptr VoiceVol[si],ah    ; save it

        rol      ebp,16
        mov      VoicePos[si],ebp            ; actual position/carry : save it

    ; loopstart/loopend do not change during a single tick mixing,
    ; so reading them again from mxs_sma and mxs_smb is useless.

        mov      ax,word ptr VoiceSeg[si]
        cmp      ax,0F000h    ; is sample in EMS ?
        jb       mxs_e9
        mov      ax,emsHandle            ;  if yes, restore mapping for
        call     emsRestoreMapping       ;  its handle

mxs_e9: retn

nendp   mxs_DoneChannel


;
;  Update DMA buffer 
;
; This routine is called when all the jobs were finished for all channels,
; and the 16-bit mix-ahead buffer is completely updated. The routine takes
; each entry on the mix-ahead buffer (16 bit), converts it to 8 bit, amplifies
; it and scales it with the global volume, then writes it down into the DMA
; buffer. The last position encountered in writing the DMA buffer is stored
; into mxLastDmaPositionUsed, for a later usage.
;
;  In:  DS=CS
;
;

        align_para

nproc   mxs_UpdateDmaBuf       ; DS=CS

        mov      ds,cs:mxAhead
        mov      es,cs:mxDMAbuf1
        mov      si,0
        mov      di,cs:mxLastDmaPositionUsed

mxs_smc:mov      cx,1234h        ; MaxMix/2 (number of WORDS mixed)
        mov      dx,cs:mxDmaOffset
        mov      bp,2  ; fixed, MUST NOT change during the loop

        jmp      short mxs_ML2

        align_para

mxs_ML2:

   ;******************
   ;*  Left channel  *
   ;******************

        mov      bx,[si]         ; extract a 16-bit sample
        add      si,bp

        movzx    bx,cs:[bx+offset PostTab]    ; postprocess
        mov      bl,cs:[bx+offset AmplifTab]  ; amplify

mxs_smd:mov      al,cs:[bx+1234h]             ; global volume scale

        mov      es:[di],al                   ; update DMA channel
        inc      di

   ;*******************
   ;*  Right channel  *
   ;*******************

        mov      bx,[si]         ; extract a 16-bit sample
        add      si,bp

        movzx    bx,cs:[bx+offset PostTab]    ; postprocess
        mov      bl,cs:[bx+offset AmplifTab]  ; amplify
mxs_smj:mov      al,cs:[bx+1234h]             ; global volume scale

mxs_smk:not      al                           ; SURROUND (if enabled)

        mov      es:[di],al                   ; update DMA buffer
        inc      di

        and      di,3FFFh  ; !!! valid only if buffer size is 16 Kb !!!

        dec      cx
        sjnz     mxs_ML2

        mov      cs:mxLastDmaPositionUsed,di

; -- Used for debugging purposes (this beta version only) -----------------

        mov      ax,di
        sub      ax,dx
        jge      mxs_e12
        add      ax,DMABufSize*16
mxs_e12:mov      cs:MixAheadDistance,ax

IF AutoCorrection ne 0

        cmp      cs:PollMod,0
        sjne     acs_o1

        mov      dx,ax
        cmp      cs:mxLastDistance,0   ; first/reset ?
        sje      acs_ok

acs_nr: sub      ax,cs:mxLastDistance
        sje      acs_ok
        sjl      acs_l

acs_g:  sub      cs:mxMaxMix,ax
        jmp      short acs_ok

acs_l:  neg      ax
        inc      ax      ; shit. see comment at the mono-mixer.
                         ; this increment could have two weird unwanted effects:
                         ;   a small decreasing of the general tone (I don't
                         ;    sense it, but probably a professional will)
                         ;   some unwanted things at a very big BPM change
                         ;    (let's say from 125 BPM to 50 BPM)
        add      cs:mxMaxMix,ax

acs_ok: mov      cs:mxLastDistance,dx  ; set new value
acs_o1:

ENDIF
; -------------------------------------------------------------------------

        retn
nendp   mxs_UpdateDmaBuf



;
;         This routine sets the initial values of some SDS's internal
;                  variables and initializes the SMCODE
;

nproc   mxInitVars_stereo
        push     eax ecx edx

     ; initialize some variables and also some of the SMCODE

        mov      cs:StereoMode,1    ; Works in STEREO from now on !!!!!

        mov      ax,cs:mxVoices
        dec      ax
        shl      ax,2                              ; ax=(voices-1)*4
        mov      word ptr cs:mxs_sm1+1,ax          ; SMCODE INIT
        mov      word ptr cs:mxs_sm2+2,ax          ; SMCODE INIT

        mov      ax,cs:BPM
        add      ax,ax
        mov      cl,5
        div      cl                ; ax=BPM*2/5=TicksPerSecond
        movzx    ecx,al
        mov      eax,cs:mxMixSpd
        xor      edx,edx
        div      ecx               ; eax = Frequency/TicksPerSecond = MaxMix
        mov      cs:mxMaxMix,ax    ; one word is enough

mxsiv2: cmp      ax,DMABufSize*16-1   ; protection:  if user is so stupid
        jbe      mxsiv1               ; and sets the value of DMABufSize
        sub      ax,DMABufSize*16     ; too small... (as I did, for example:)
        jmp      short mxsiv2         ;
mxsiv1:                               ;

    ; The next two instructions are what ST3 does not have... If the
    ; software mixing starts at an odd offset in the DMA buffer, then
    ; the SB Pro will play the channels reversed UNTIL the end of DMA buffer,
    ; and only after that it will start to play them correctly. If you
    ; start a song with ScreamTracker 3, you will surely notice this bug.
    ; It plays Left/Right in the correct order for about half a second,
    ; then it starts playing them in the reversed order until you stop it
    ; and shout "what the fuck are you doing, shithead ???" ...

        inc      ax         ; increment and ...
        and      ax,0FFFEh  ; make it even

        mov      cs:mxLastDmaPositionUsed,ax    ; store starting position

IF AutoCorrection ne 0
        mov      cs:mxLastDistance,0  ; reset last distance
ENDIF

    ; ---- initializes the dma buffer ----

        cmp      word ptr cs:mxDMAbuf1[2],0
        je       mxivse1
        push     es di
        mov      es,cs:mxDMABuf1
        mov      di,0
        mov      cx,DMABufSize*8-1
        mov      ax,8080h
        rep stosw
        pop      di es
mxivse1:

        pop      edx ecx eax
        retn
nendp   mxInitVars_stereo



;
;  Init global things 
;
; This routine initializes some of the SMCODE, used in what follows by
; MixChannel and UpdateDmaBuf routines.
;
;  In:  DS=CS
;
;

nproc   mxs_InitGlobal
        push     ax cx dx

        mov      ax,cs
        mov      ds,ax

        mov      ax,mxMaxMix
        shr      ax,1
        mov      word ptr mxs_sm9+1,ax          ; SMCODE INIT
        mov      word ptr mxs_smc+1,ax          ; SMCODE INIT

        mov      ah,cs:GlobalVolume
        mov      al,0
        add      ax,offset VolTab
        mov      word ptr mxs_smd+3,ax          ; SMCODE INIT
        mov      word ptr mxs_smj+3,ax          ; SMCODE INIT

        mov      ax,0C084h  ; 'TEST AL,AL'
        cmp      byte ptr SurroundMode,1       ; is SURROUND mode ?
        jne      mxs_e19
        mov      ax,0D0F6h  ; 'NOT AL'
mxs_e19:mov      word ptr mxs_smk,ax           ; SMCODE INIT  - SURROUND

        mov      es,mxAhead        ; ES = mix-ahead buffer's segment
        pop      dx cx ax
        retn
nendp   mxs_InitGlobal


;
;        This routine builds the frequencies (carry-addendum) for
;        each period (0 to 1800), since the mixer doesn't work with
;        periods directly, but with such "frequencies".
;

nproc   mxBuildPeriods_stereo         ; Build all the periods.
                             ; For mono   : SDS_period = (3579545.25 / amiga_period) * (65536 / mix_frequency)
                             ; For stereo : SDS_period = (3579545.25 / amiga_period) * (65536 / (mix_frequency/2))
        push     es eax ebx ecx edx si di
        mov      bx,cs:FreqMod ; PAL(0) or NTSC(1)
        shl      bx,2
        mov      eax,cs:FMod[bx]
        mov      dword ptr cs:FreqTab[0],0  ; for period 0
        mov      si,1
        mov      di,4
mxse4:  push     eax
        xor      edx,edx
        shld     edx,eax,16               ;
        shl      eax,16                   ;  eax:=eax * 65536
        movzx    ecx,cs:cmixspd           ;  already "Normalized"
        div      ecx
        xor      edx,edx                  ;  eax := (edx:eax) div MixFreq
        movzx    ecx,si
        div      ecx                      ;  eax := (edx:eax) div AmigaPeriod
        mov      cs:FreqTab[di],eax       ;  store it
        pop      eax
        inc      si
        add      di,4
        cmp      si,1800
        jb       mxse4
        pop      di si edx ecx ebx eax es
        retn
nendp   mxBuildPeriods_stereo



;
;        This routine builds the post-processing table, used during
;        the mixing process by the MixAgain routine. Called only at
;        the beginning (init).
;

nproc   mxBuildProcTab_stereo       ; Build the Post-Processing Table
        push     si di ax bx cx dx
        mov      cx,cs:mxVoices
        shr      cx,1
        jnc      mxse70
        inc      cx
mxse70: mov      cs:mxVoicesPerChannel_st,cx
        shl      cx,8         ; loop Voices*256 times
        sub      si,si
        mov      di,cx
        dec      di           ; di:=(channels*256-1)
mxse7:  mov      ax,si
        mov      bx,255
        mul      bx
        div      di           ; al:=si*255/(channels*256-1), si=0..channels*256-1
        mov      cs:PostTab[si],al ; Store it to PostTab table
        inc      si
        loop     mxse7
mxse8:  cmp      si,32*256-1
        ja       mxse9
        mov      cs:PostTab[si],0FFh
        inc      si
        jmp      short mxse8   ; Fill the rest of the table w/ 0FFh bytes
mxse9:  mov      ax,cs:mxVoicesPerChannel_st
        sub      ax,2         ; Compute the level of amplification
        mov      cl,30        ; for the post-processing table.
        mul      cl           ;
        add      ax,100       ; Percent = 100+(voices-4)*60 = 60% gain for each new channel more
        mov      cs:mxPerc,ax ; Store it for calculations
        sub      si,si
        mov      cx,cs:mxVoicesPerChannel_st
        shl      cx,8         ; loop mxVoicesPerChannel*256 times
mxse10: mov      al,PostTab[si]
        xor      al,80h
        cbw                         ; al:=integer(posttab[si] xor 80h)
        mov      di,cs:mxPerc
        imul     di                 ; ax:=integer(posttab[si] xor 80h) * Percent
        mov      di,100
        idiv     di                 ; ax:=integer(posttab[si] xor 80h) * Percent / 100
        cmp      ax,-128            ; if ax<-128 then ax:=-128
        jge      mxse11
        mov      ax,-128
mxse11: cmp      ax,127             ; if ax>127 then ax:=127
        jle      mxse12
        mov      ax,127
mxse12: xor      al,80h             ; al:=al xor 80h (convert it back)
        mov      cs:PostTab[si],al  ; Store it back (amplified)
        inc      si
        loop     mxse10
        pop      dx cx bx ax di si
        retn
nendp   mxBuildProcTab_stereo


;
;
;   Common routines for both mono and stereo drivers
;
;


;
;   SetVoiceVolume (AH=voice, AL=volume)
;

nproc   mx_SetVoiceVolume
        push     si
        movzx    si,ah
        shl      si,2
        mov      byte ptr cs:VoiceVol[si],al
        pop      si
        retn
nendp   mx_SetVoiceVolume


;
;   AL = GetVoiceVolume (AH=voice)
;

nproc   mx_GetVoiceVolume
        push     si
        movzx    si,ah
        shl      si,2
        mov      al,byte ptr cs:VoiceVol[si]
        pop      si
        retn
nendp   mx_GetVoiceVolume


;
;   SetVoicePanning (AH=voice, AL=balance)
;

nproc   mx_SetVoicePanning
        push     si
        movzx    si,ah
        mov      cs:VRI[si],al
        pop      si
        retn
nendp   mx_SetVoicePanning

;
;   AL = GetVoicePanning (AH=voice)
;

nproc   mx_GetVoicePanning
        push     si
        movzx    si,ah
        mov      al,cs:VRI[si]
        pop      si
        retn
nendp   mx_GetVoicePanning


;
;   SetVoiceFreq (AH=voice, CX=period)
;

nproc   mx_SetVoiceFreq
        push     si di ecx
        movzx    si,ah
        shl      si,2
        mov      word ptr cs:VoicePeriod[si],cx
        mov      di,cx
        shl      di,2
        mov      ecx,cs:FreqTab[di]
        mov      cs:VoiceFreq[si],ecx
        pop      ecx di si
        retn
nendp   mx_SetVoiceFreq


;
;   CX = GetVoiceFreq (AH=voice)  - returns the Amiga period, not the freq.!
;

nproc   mx_GetVoiceFreq
        push     si
        movzx    si,ah
        shl      si,2
        mov      cx,word ptr cs:VoicePeriod[si]
        pop      si
        retn
nendp   mx_GetVoiceFreq


;
;   PlayVoice (AH=voice, CX=size, DX=LoopStart, SI=LoopEnd, EDI=address,
;              AL=(Relative Start Position)/256)
;     Note  :
;    For GUS:     EDI = physical GUS address
;    For EMS:     DI  = 0Fxxxh where sample is in EMS under handle xxx (LIM EMS 4.0 claims 0xx only)
;    For others:  DI  = Sample's segment in conventional memory
;

nproc   mx_PlayVoice
        push     bx ax
        movzx    bx,ah
        shl      bx,2
        cmp      si,0FFFFh   ; no loop ?
        je       mxe80       ;
        mov      cx,si       ; if loop, size=loopend
mxe80:  mov      word ptr cs:VoiceSize[bx],cx       ; Set size
        mov      word ptr cs:VoiceLoopStart[bx],dx  ; Set loop start
        mov      word ptr cs:VoiceLoopEnd[bx],si    ; Set loop end
        mov      word ptr cs:VoiceSeg[bx],di        ; Set address - see SDS_GUS for gus implementation
        shl      eax,8+16
        mov      cs:VoicePos[bx],eax                ; Init position and carry-flag (for "set sample offset" command)
        pop      ax bx
        retn
nendp   mx_PlayVoice


;
;   StopVoice (AH=voice)
;

nproc   mx_StopVoice
        push    si
        movzx   si,ah
        shl     si,2
        mov     byte ptr cs:VoiceVol[si],0      ; Set volume down
        pop     si
        retn
nendp   mx_StopVoice endp


;
;   SetGlobalVolume (AL=volume)
;

nproc   mx_SetGlobalVolume
        mov      cs:GlobalVolume,al
        retn
nendp   mx_SetGlobalVolume


;
;   SetAmplification (AX=percent)
;   -----------------------------
;   This routine shouldn't be called too often, because it recalculates the
;   whole internal amplification table each time it is called. Call it when
;   you really want to CHANGE the actual amplification status.
;   ... yes, I know there is a 'set amplification level' effect in SDS...
;   just don't spread it everywhere, okay ?  :>>>
;

nproc   mx_SetAmplification
        push     ax bx cx dx si di
        mov      di,ax
        mov      bx,100
        mov      si,offset AmplifTab
        sub      ax,ax
        mov      cx,256
mx_L50: push     ax
        xor      al,80h
        cbw
        imul     di
        idiv     bx
        cmp      ax,-128
        sjge     mx_ok8
        mov      ax,-128
mx_ok8: cmp      ax,127
        sjle     mx_ok9
        mov      ax,127
mx_ok9: mov      cs:[si],al
        inc      si
        pop      ax
        inc      al
        dec      cx
        sjg      mx_L50
        pop      di si dx cx bx ax
        retn
nendp   mx_SetAmplification



;
;
; Others
;
;



;
;         This routine allocates a DMA buffer and one mix-ahead buffer
;        in the conventional memory. The MemAlloc routine automatically
;        takes care about not crossing 64k page boundary. No UMB is used.
;

nproc   mxAllocDMABuf

        push     es di cx bx ax

        mov      bx,DMABufSize+1     ; Fixed by the coder before assembling
        call     MemAlloc            ; Allocate a memory block using INT21
        mov      cs:mxDMABuf1,ax     ; Set DMA buffer address (segment)

        mov      es,ax               ;
        xor      di,di               ;
        mov      cx,DMABufSize*16    ;
        mov      al,80h              ;
        cld                          ;
        rep stosb                    ; Clear DMA buffer (null signal)

        mov      bx,708+64;(paragraphs) ; 48000/(minTicksPerSec-1) + something, each entry has 2 bytes (a word); two channels
        call     MemAlloc            ; Allocate a mix-ahead buffer
        mov      cs:mxAhead,ax       ; Set mix-ahead buf addr

        pop      ax bx cx di es

        retn
nendp   mxAllocDMABuf


;
;  This routine deallocates the buffers allocated by the previous routine.
;

nproc   mx_DeallocDMABuf

        push     ax bx

        mov      bx,cs:mxDMABuf1     ;
        call     MemFree             ; Deallocate the temporary DMA buffer

        mov      bx,cs:mxAhead       ;
        call     MemFree             ; Deallocate the mix-ahead buffer

        pop      bx ax

        retn
nendp   mx_DeallocDMABuf


;
;  Test if another tick/poll is really necessarry 
;
; This routine is used from outside, directly by SDS's INT8 handler, to test
; whether a new tick is awaited or not. Must let all the registers untouched.
;
; usage:
;              call   mx_TickAwaited
;              jc     @@skip
;                ; tick awaited
;          @skip:
;                ; tick not awaited
;
;

        align_para

nproc   mx_TickAwaited
        push     ds ax

        mov      ax,cs
        mov      ds,ax

        call     mx_FindDmaPos

        mov      ax,mxLastDmaPositionUsed
        sub      ax,mxDmaOffset
        sjge     mxta1
        add      ax,DMABufSize*16

mxta1:  cmp      cs:PollMod,0
        sje      mxta3

        shr      ax,3          ; in poll mode: distance<=maxmix*8
        jmp      short mxta4

mxta3:  shr      ax,2          ; in timer mode: distance<=maxmix*4

mxta4:  cmp      ax,mxMaxMix   ; let the user decide...
        pop      ax ds

        sjae     mxta2
        clc  ; awaited !
        retn

mxta2:  mov      cs:mxLastDistance,0 ; reset auto-correction flag
        stc  ; not awaited !
        retn
nendp   mx_TickAwaited



;
;  ems mapping 
;
; The routine is called when the sample is in EMS memory and we want to
; "download" it from there.
;
;  In:  AX=sample's handle in EMS  (bits 0-11 of the segment)
;       SI=channel*4, DS=CS
;
;

nproc   mx_emsMap

        mov      emsHandle,ax       ; save handle
        call     emsSaveMapping     ; save actual mapping for this handle

    ; compute the number of pages occupied by this sample:
    ; pages = 1 + (size-1) shr 14

        mov      ax,word ptr VoiceSize[si]
        dec      ax
        shr      ax,14

    ; map ems pages ( max 4 pages (64k) per instrument )

        mov      emsLogicalPage,ax   ; start with logical page #(pages-1) into physical page #(pages-1)
        mov      emsPhysicalPage,al  ; (going backward: 3-2-1-0)

mx_e5:  call     emsMap              ; map emsLogicalPage to emsPhysicalPage
        dec      emsLogicalPage
        dec      emsPhysicalPage
        sjge     mx_e5               ; repeat until all pages are mapped

        retn
nendp   mx_emsMap



;
;  find DMA offset in buffer 
;
; This routine finds the value of the DMA counter and, substracting this
; number from the size of DMA buffer, it returns the actual "position"
; (or "offset") of the DMA within the buffer (position of the byte/word
; which is actually read by the DMA controller and sent to the soundcard)
;
;  In:  Requires DS=CS !
;  Returns in mxDmaOffset the offset in the DMA buffer
;  Must let all the registers untouched.
;
;

        align_para

nproc   mx_FindDMAPos
        push     ax dx

        movzx    dx,mxDMA
        cmp      dx,3
        sja      mxd16

        add      dx,dx
        inc      dx                   ; counter_port = #DMA * 2 + 1
        in       al,dx                ; read LOW byte
        mov      ah,al                ;
        in       al,dx                ; read HIGH byte
        xchg     al,ah                ; counter in AX
        sub      ax,DMABufSize*16-1
        neg      ax
        jmp      short mxo1

mxd16:  sub      dx,4
        shl      dx,2
        add      dx,00C2h             ; counter_port = (#DMA-4) * 4 + 0C2h
        in       al,dx                ; read LOW byte
        mov      ah,al                ;
        in       al,dx                ; read HIGH byte
        xchg     al,ah                ; counter in AX (in WORDS!)
        sub      ax,DMABufSize*8-1    ;\
        neg      ax                   ; Is this part correct ?
        shl      ax,1                 ;/

mxo1:   cmp      ax,DMABufSize*16-1
        sjbe     mxo2
        mov      ax,DMABufSize*16-1

mxo2:   mov      mxDmaOffset,ax

        pop      dx ax
        retn
nendp   mx_FindDMAPos

;-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-